/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.IMachine;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.factory.TileMachine;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class TileMiningWell
extends TileMachine
implements IMachine,
IPowerReceptor,
IPipeConnection {
    boolean isDigging = true;
    IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileMiningWell() {
        this.powerProvider.configure(50, 1, 25, 25, 1000);
    }

    @Override
    public void doWork() {
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        yc world = this.k;
        int depth = this.m - 1;
        while (world.a(this.l, depth, this.n) == BuildCraftFactory.plainPipeBlock.cm) {
            --depth;
        }
        if (depth < 0 || !BlockUtil.canChangeBlock(world, this.l, depth, this.n)) {
            this.isDigging = false;
            return;
        }
        int blockId = world.a(this.l, depth, this.n);
        List stacks = BlockUtil.getItemStackFromBlock(this.k, this.l, depth, this.n);
        world.e(this.l, depth, this.n, BuildCraftFactory.plainPipeBlock.cm);
        if (blockId == 0) {
            return;
        }
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        for (ur stack : stacks) {
            ur added = Utils.addToRandomInventory(stack, this.k, this.l, this.m, this.n, ForgeDirection.UNKNOWN);
            stack.a -= added.a;
            if (stack.a <= 0) continue;
            if (Utils.addToRandomPipeEntry(this, ForgeDirection.UNKNOWN, stack) && stack.a <= 0) {
                return;
            }
            float f = world.t.nextFloat() * 0.8f + 0.1f;
            float f1 = world.t.nextFloat() * 0.8f + 0.1f;
            float f2 = world.t.nextFloat() * 0.8f + 0.1f;
            px entityitem = new px(world, (double)((float)this.l + f), (double)((float)this.m + f1 + 0.5f), (double)((float)this.n + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.b = 10;
            float f3 = 0.05f;
            entityitem.w = (float)world.t.nextGaussian() * f3;
            entityitem.x = (float)world.t.nextGaussian() * f3 + 1.0f;
            entityitem.y = (float)world.t.nextGaussian() * f3;
            world.d((lq)entityitem);
        }
    }

    @Override
    public boolean isActive() {
        return this.isDigging;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    @Override
    public boolean allowActions() {
        return false;
    }
}

