/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.core.DefaultProps;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class EngineWood
extends Engine {
    public EngineWood(TileEngine engine) {
        super(engine);
        this.maxEnergy = 1000;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_PATH_BLOCKS + "/base_wood.png";
    }

    @Override
    public int explosionRange() {
        return 1;
    }

    @Override
    public int minEnergyReceived() {
        return 1;
    }

    @Override
    public int maxEnergyReceived() {
        return 50;
    }

    @Override
    public float getPistonSpeed() {
        switch (this.getEnergyStage()) {
            case Blue: {
                return 0.01f;
            }
            case Green: {
                return 0.02f;
            }
            case Yellow: {
                return 0.04f;
            }
            case Red: {
                return 0.08f;
            }
        }
        return 0.0f;
    }

    @Override
    public void update() {
        super.update();
        if (this.tile.isRedstonePowered && this.tile.k.G() % 20L == 0L) {
            this.energy += 1.0f;
        }
    }

    @Override
    public boolean isBurning() {
        return this.tile.isRedstonePowered;
    }

    @Override
    public int getScaledBurnTime(int i) {
        return 0;
    }

    @Override
    public void delete() {
    }

    @Override
    public void burn() {
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }
}

