/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.core.DefaultProps;
import buildcraft.core.utils.Utils;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import buildcraft.energy.gui.ContainerEngine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class EngineIron
extends Engine {
    public static int MAX_LIQUID = 10000;
    public static int MAX_HEAT = 100000;
    public static int COOLANT_THRESHOLD = 49000;
    private ur itemInInventory;
    int burnTime = 0;
    int heat = 0;
    private LiquidTank fuelTank;
    private LiquidTank coolantTank;
    private IronEngineFuel currentFuel = null;
    public int penaltyCooling = 0;
    boolean lastPowered = false;

    public EngineIron(TileEngine engine) {
        super(engine);
        this.maxEnergy = 100000;
        this.maxEnergyExtracted = 500;
        this.fuelTank = new LiquidTank(MAX_LIQUID);
        this.coolantTank = new LiquidTank(MAX_LIQUID);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_PATH_BLOCKS + "/base_iron.png";
    }

    @Override
    public int explosionRange() {
        return 8;
    }

    @Override
    public int maxEnergyReceived() {
        return 2000;
    }

    @Override
    public float getPistonSpeed() {
        switch (this.getEnergyStage()) {
            case Blue: {
                return 0.04f;
            }
            case Green: {
                return 0.05f;
            }
            case Yellow: {
                return 0.06f;
            }
            case Red: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        LiquidStack fuel = this.fuelTank.getLiquid();
        return fuel != null && fuel.amount > 0 && this.penaltyCooling == 0 && this.tile.isRedstonePowered;
    }

    @Override
    public void burn() {
        this.currentOutput = 0.0f;
        LiquidStack fuel = this.fuelTank.getLiquid();
        if (this.currentFuel == null) {
            this.currentFuel = IronEngineFuel.getFuelForLiquid(fuel);
        }
        if (this.currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0 && this.tile.isRedstonePowered) {
            this.lastPowered = true;
            if (this.burnTime > 0 || fuel.amount > 0) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                }
                if (this.burnTime <= 0) {
                    if (fuel != null) {
                        if (--fuel.amount <= 0) {
                            this.fuelTank.setLiquid(null);
                        }
                        this.burnTime = this.currentFuel.totalBurningTime / 1000;
                    } else {
                        this.currentFuel = null;
                        return;
                    }
                }
                this.currentOutput = this.currentFuel.powerPerCycle;
                this.addEnergy(this.currentFuel.powerPerCycle);
                this.heat = (int)((float)this.heat + this.currentFuel.powerPerCycle);
            }
        } else if (this.penaltyCooling <= 0 && this.lastPowered) {
            this.lastPowered = false;
            this.penaltyCooling = 600;
        }
    }

    @Override
    public void update() {
        LiquidStack liquid;
        super.update();
        if (this.itemInInventory != null && (liquid = amq.aW.cm == this.itemInInventory.c && this.heat > COOLANT_THRESHOLD ? LiquidContainerRegistry.getLiquidForFilledItem((ur)new ur(up.ax)) : LiquidContainerRegistry.getLiquidForFilledItem((ur)this.itemInInventory)) != null && this.fill(ForgeDirection.UNKNOWN, liquid, false) == liquid.amount) {
            this.fill(ForgeDirection.UNKNOWN, liquid, true);
            this.tile.a(0, Utils.consumeItem(this.itemInInventory));
        }
        if (this.heat > COOLANT_THRESHOLD) {
            int extraHeat = this.heat - COOLANT_THRESHOLD;
            LiquidStack coolant = this.coolantTank.getLiquid();
            IronEngineCoolant currentCoolant = IronEngineCoolant.getCoolantForLiquid(coolant);
            if (currentCoolant != null) {
                if ((float)coolant.amount * currentCoolant.coolingPerUnit > (float)extraHeat) {
                    coolant.amount -= Math.round((float)extraHeat / currentCoolant.coolingPerUnit);
                    this.heat = COOLANT_THRESHOLD;
                } else {
                    this.heat = (int)((float)this.heat - (float)coolant.amount * currentCoolant.coolingPerUnit);
                    this.coolantTank.setLiquid(null);
                }
            }
        }
        if (!(this.heat <= 0 || this.penaltyCooling <= 0 && this.tile.isRedstonePowered)) {
            this.heat -= 10;
        }
        if (this.heat <= 0) {
            this.heat = 0;
        }
        if (this.heat == 0 && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
    }

    @Override
    public void computeEnergyStage() {
        this.energyStage = this.heat <= MAX_HEAT / 4 ? Engine.EnergyStage.Blue : (this.heat <= MAX_HEAT / 2 ? Engine.EnergyStage.Green : ((float)this.heat <= (float)MAX_HEAT * 3.0f / 4.0f ? Engine.EnergyStage.Yellow : (this.heat <= MAX_HEAT ? Engine.EnergyStage.Red : Engine.EnergyStage.Explosion)));
    }

    @Override
    public int getScaledBurnTime(int i) {
        return this.fuelTank.getLiquid() != null ? (int)((float)this.fuelTank.getLiquid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("liquidId")) {
            this.fuelTank.setLiquid(new LiquidStack(nbttagcompound.e("liquidId"), nbttagcompound.e("liquidQty"), nbttagcompound.e("liquidMeta")));
        } else if (nbttagcompound.b("fuelTank")) {
            this.fuelTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("fuelTank")));
        }
        this.burnTime = nbttagcompound.e("burnTime");
        if (nbttagcompound.b("coolantId")) {
            this.coolantTank.setLiquid(new LiquidStack(nbttagcompound.e("coolantId"), nbttagcompound.e("coolantQty"), nbttagcompound.e("coolantMeta")));
        } else if (nbttagcompound.b("coolantTank")) {
            this.coolantTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("coolantTank")));
        }
        this.heat = nbttagcompound.e("heat");
        this.penaltyCooling = nbttagcompound.e("penaltyCooling");
        if (nbttagcompound.b("itemInInventory")) {
            bq cpt = nbttagcompound.l("itemInInventory");
            this.itemInInventory = ur.a((bq)cpt);
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        if (this.fuelTank.getLiquid() != null) {
            nbttagcompound.a("fuelTank", (cd)this.fuelTank.getLiquid().writeToNBT(new bq()));
        }
        if (this.coolantTank.getLiquid() != null) {
            nbttagcompound.a("coolantTank", (cd)this.coolantTank.getLiquid().writeToNBT(new bq()));
        }
        nbttagcompound.a("burnTime", this.burnTime);
        nbttagcompound.a("heat", this.heat);
        nbttagcompound.a("penaltyCooling", this.penaltyCooling);
        if (this.itemInInventory != null) {
            bq cpt = new bq();
            this.itemInInventory.b(cpt);
            nbttagcompound.a("itemInInventory", (cd)cpt);
        }
    }

    public int getScaledCoolant(int i) {
        return this.coolantTank.getLiquid() != null ? (int)((float)this.coolantTank.getLiquid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void delete() {
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                int iEnergy = Math.round(this.energy * 10.0f);
                iEnergy = iEnergy & 0xFFFF0000 | j & 0xFFFF;
                this.energy = iEnergy / 10;
                break;
            }
            case 1: {
                int iEnergy = Math.round(this.energy * 10.0f);
                iEnergy = iEnergy & 0xFFFF | (j & 0xFFFF) << 16;
                this.energy = iEnergy / 10;
                break;
            }
            case 2: {
                this.currentOutput = j / 10;
                break;
            }
            case 3: {
                this.heat = this.heat & 0xFFFF0000 | j & 0xFFFF;
                break;
            }
            case 4: {
                this.heat = this.heat & 0xFFFF | (j & 0xFFFF) << 16;
                break;
            }
            case 5: {
                if (this.fuelTank.getLiquid() == null) {
                    this.fuelTank.setLiquid(new LiquidStack(0, j));
                    break;
                }
                this.fuelTank.getLiquid().amount = j;
                break;
            }
            case 6: {
                if (this.fuelTank.getLiquid() == null) {
                    this.fuelTank.setLiquid(new LiquidStack(j, 0));
                    break;
                }
                this.fuelTank.getLiquid().itemID = j;
                break;
            }
            case 7: {
                if (this.coolantTank.getLiquid() == null) {
                    this.coolantTank.setLiquid(new LiquidStack(0, j));
                    break;
                }
                this.coolantTank.getLiquid().amount = j;
                break;
            }
            case 8: {
                if (this.coolantTank.getLiquid() == null) {
                    this.coolantTank.setLiquid(new LiquidStack(j, 0));
                    break;
                }
                this.coolantTank.getLiquid().itemID = j;
                break;
            }
            case 9: {
                if (this.fuelTank.getLiquid() == null) {
                    this.fuelTank.setLiquid(new LiquidStack(0, 0, j));
                    break;
                }
                this.fuelTank.getLiquid().itemMeta = j;
                break;
            }
            case 10: {
                if (this.coolantTank.getLiquid() == null) {
                    this.coolantTank.setLiquid(new LiquidStack(0, 0, j));
                    break;
                }
                this.coolantTank.getLiquid().itemMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, rw iCrafting) {
        iCrafting.a((rq)containerEngine, 0, Math.round(this.energy * 10.0f) & 0xFFFF);
        iCrafting.a((rq)containerEngine, 1, (Math.round(this.energy * 10.0f) & 0xFFFF0000) >> 16);
        iCrafting.a((rq)containerEngine, 2, Math.round(this.currentOutput * 10.0f));
        iCrafting.a((rq)containerEngine, 3, this.heat & 0xFFFF);
        iCrafting.a((rq)containerEngine, 4, (this.heat & 0xFFFF0000) >> 16);
        iCrafting.a((rq)containerEngine, 5, this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().amount : 0);
        iCrafting.a((rq)containerEngine, 6, this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().itemID : 0);
        iCrafting.a((rq)containerEngine, 7, this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().amount : 0);
        iCrafting.a((rq)containerEngine, 8, this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().itemID : 0);
        iCrafting.a((rq)containerEngine, 9, this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().itemMeta : 0);
        iCrafting.a((rq)containerEngine, 10, this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().itemMeta : 0);
    }

    @Override
    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (IronEngineCoolant.getCoolantForLiquid(resource) != null) {
            return this.fillCoolant(from, resource, doFill);
        }
        if (IronEngineFuel.getFuelForLiquid(resource) != null) {
            return this.fuelTank.fill(resource, doFill);
        }
        return 0;
    }

    private int fillCoolant(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.coolantTank.fill(resource, doFill);
    }

    @Override
    public LiquidTank[] getLiquidSlots() {
        return new LiquidTank[]{this.fuelTank, this.coolantTank};
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ur getStackInSlot(int i) {
        return this.itemInInventory;
    }

    @Override
    public void setInventorySlotContents(int i, ur itemstack) {
        this.itemInInventory = itemstack;
    }

    @Override
    public ur decrStackSize(int slot, int amount) {
        if (this.itemInInventory != null) {
            if (this.itemInInventory.a <= 0) {
                this.itemInInventory = null;
                return null;
            }
            ur newStack = this.itemInInventory;
            if (amount >= newStack.a) {
                this.itemInInventory = null;
            } else {
                newStack = this.itemInInventory.a(amount);
            }
            return newStack;
        }
        return null;
    }

    @Override
    public ur getStackInSlotOnClosing(int var1) {
        if (this.itemInInventory == null) {
            return null;
        }
        ur toReturn = this.itemInInventory;
        this.itemInInventory = null;
        return toReturn;
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        switch (direction) {
            case UP: {
                return this.fuelTank;
            }
            case DOWN: {
                return this.coolantTank;
            }
        }
        return null;
    }

    public int getFuelId() {
        return this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().itemID : 0;
    }

    public int getFuelMeta() {
        return this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().itemMeta : 0;
    }

    public int getCoolantId() {
        return this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().itemID : 0;
    }

    public int getCoolantMeta() {
        return this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().itemMeta : 0;
    }
}

