/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.gates.Action;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.Trigger;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.transport.IExtractionHandler;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.GuiHandler;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGate;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.blueprints.BptBlockPipe;
import buildcraft.transport.blueprints.BptItemPipeDiamond;
import buildcraft.transport.blueprints.BptItemPipeEmerald;
import buildcraft.transport.blueprints.BptItemPipeIron;
import buildcraft.transport.blueprints.BptItemPipeWooden;
import buildcraft.transport.network.PacketHandlerTransport;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLiquidsCobblestone;
import buildcraft.transport.pipes.PipeLiquidsEmerald;
import buildcraft.transport.pipes.PipeLiquidsGold;
import buildcraft.transport.pipes.PipeLiquidsIron;
import buildcraft.transport.pipes.PipeLiquidsSandstone;
import buildcraft.transport.pipes.PipeLiquidsStone;
import buildcraft.transport.pipes.PipeLiquidsVoid;
import buildcraft.transport.pipes.PipeLiquidsWood;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.triggers.ActionEnergyPulser;
import buildcraft.transport.triggers.ActionSignalOutput;
import buildcraft.transport.triggers.TriggerPipeContents;
import buildcraft.transport.triggers.TriggerPipeSignal;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.common.Property;

@Mod(version="3.4.3", modid="BuildCraft|Transport", name="Buildcraft Transport", dependencies="required-after:BuildCraft|Core@3.4.3")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerTransport.class)
public class BuildCraftTransport {
    public static BlockGenericPipe genericPipeBlock;
    public static int[] diamondTextures;
    public static boolean alwaysConnectPipes;
    public static boolean usePipeLoss;
    public static int maxItemsInPipes;
    public static float pipeDurability;
    public static up pipeWaterproof;
    public static up pipeGate;
    public static up pipeGateAutarchic;
    public static up redPipeWire;
    public static up bluePipeWire;
    public static up greenPipeWire;
    public static up yellowPipeWire;
    public static up pipeItemsWood;
    public static up pipeItemsEmerald;
    public static up pipeItemsStone;
    public static up pipeItemsCobblestone;
    public static up pipeItemsIron;
    public static up pipeItemsGold;
    public static up pipeItemsDiamond;
    public static up pipeItemsObsidian;
    public static up pipeItemsVoid;
    public static up pipeItemsSandstone;
    public static up pipeLiquidsWood;
    public static up pipeLiquidsCobblestone;
    public static up pipeLiquidsStone;
    public static up pipeLiquidsIron;
    public static up pipeLiquidsGold;
    public static up pipeLiquidsVoid;
    public static up pipeLiquidsSandstone;
    public static up pipeLiquidsEmerald;
    public static up pipePowerWood;
    public static up pipePowerStone;
    public static up pipePowerGold;
    public static up facadeItem;
    public static up pipeStructureCobblestone;
    public static int groupItemsTrigger;
    public static Trigger triggerPipeEmpty;
    public static Trigger triggerPipeItems;
    public static Trigger triggerPipeLiquids;
    public static Trigger triggerPipeEnergy;
    public static Trigger triggerRedSignalActive;
    public static Trigger triggerRedSignalInactive;
    public static Trigger triggerBlueSignalActive;
    public static Trigger triggerBlueSignalInactive;
    public static Trigger triggerGreenSignalActive;
    public static Trigger triggerGreenSignalInactive;
    public static Trigger triggerYellowSignalActive;
    public static Trigger triggerYellowSignalInactive;
    public static Action actionRedSignal;
    public static Action actionBlueSignal;
    public static Action actionGreenSignal;
    public static Action actionYellowSignal;
    public static Action actionEnergyPulser;
    @Mod.Instance(value="BuildCraft|Transport")
    public static BuildCraftTransport instance;
    private static LinkedList pipeRecipes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInitialize(FMLPreInitializationEvent evt) {
        try {
            Property alwaysConnect = BuildCraftCore.mainConfiguration.get("general", "pipes.alwaysConnect", DefaultProps.PIPES_ALWAYS_CONNECT);
            alwaysConnect.comment = "set to false to deactivate pipe connection rules, true by default";
            alwaysConnectPipes = alwaysConnect.getBoolean(DefaultProps.PIPES_ALWAYS_CONNECT);
            Property pipeLoss = BuildCraftCore.mainConfiguration.get("general", "power.usePipeLoss", DefaultProps.USE_PIPELOSS);
            pipeLoss.comment = "Set to false to turn off energy loss over distance on all power pipes";
            usePipeLoss = pipeLoss.getBoolean(DefaultProps.USE_PIPELOSS);
            Property durability = BuildCraftCore.mainConfiguration.get("general", "pipes.durability", DefaultProps.PIPES_DURABILITY);
            durability.comment = "How long a pipe will take to break";
            pipeDurability = (float)durability.getDouble(DefaultProps.PIPES_DURABILITY);
            Property exclusionItemList = BuildCraftCore.mainConfiguration.get("block", "woodenPipe.item.exclusion", "");
            String[] excludedItemBlocks = exclusionItemList.value.split(",");
            for (int j = 0; j < excludedItemBlocks.length; ++j) {
                excludedItemBlocks[j] = excludedItemBlocks[j].trim();
            }
            Property exclusionLiquidList = BuildCraftCore.mainConfiguration.get("block", "woodenPipe.liquid.exclusion", "");
            String[] excludedLiquidBlocks = exclusionLiquidList.value.split(",");
            for (int j = 0; j < excludedLiquidBlocks.length; ++j) {
                excludedLiquidBlocks[j] = excludedLiquidBlocks[j].trim();
            }
            PipeManager.registerExtractionHandler(new ExtractionHandler(excludedItemBlocks, excludedLiquidBlocks));
            Property maxItemInPipesProp = BuildCraftCore.mainConfiguration.get("general", "pipes.maxItems", 100);
            maxItemInPipesProp.comment = "pipes containing more than this amount of items will explode, not dropping any item";
            maxItemsInPipes = Integer.parseInt(maxItemInPipesProp.value);
            Property groupItemsTriggerProp = BuildCraftCore.mainConfiguration.get("general", "pipes.groupItemsTrigger", 32);
            groupItemsTriggerProp.comment = "when reaching this amount of objects in a pipes, items will be automatically grouped";
            groupItemsTrigger = Integer.parseInt(groupItemsTriggerProp.value);
            Property genericPipeId = BuildCraftCore.mainConfiguration.getBlock("pipe.id", DefaultProps.GENERIC_PIPE_ID);
            Property pipeWaterproofId = BuildCraftCore.mainConfiguration.getItem("pipeWaterproof.id", DefaultProps.PIPE_WATERPROOF_ID);
            pipeWaterproof = new ItemBuildCraft(Integer.parseInt(pipeWaterproofId.value)).c(33);
            pipeWaterproof.b("pipeWaterproof");
            pipeWaterproof.a(tj.l);
            LanguageRegistry.addName((Object)pipeWaterproof, (String)"Pipe Waterproof");
            genericPipeBlock = new BlockGenericPipe(Integer.parseInt(genericPipeId.value));
            GameRegistry.registerBlock((amq)genericPipeBlock);
            pipeItemsWood = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_WOOD_ID, PipeItemsWood.class, "Wooden Transport Pipe", "plankWood", amq.P, "plankWood");
            pipeItemsEmerald = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_EMERALD_ID, PipeItemsEmerald.class, "Emerald Transport Pipe", up.bH, amq.P, up.bH);
            pipeItemsCobblestone = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_COBBLESTONE_ID, PipeItemsCobblestone.class, "Cobblestone Transport Pipe", amq.z, amq.P, amq.z);
            pipeItemsStone = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_STONE_ID, PipeItemsStone.class, "Stone Transport Pipe", amq.w, amq.P, amq.w);
            pipeItemsIron = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_IRON_ID, PipeItemsIron.class, "Iron Transport Pipe", up.o, amq.P, up.o);
            pipeItemsGold = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_GOLD_ID, PipeItemsGold.class, "Golden Transport Pipe", up.p, amq.P, up.p);
            pipeItemsDiamond = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_DIAMOND_ID, PipeItemsDiamond.class, "Diamond Transport Pipe", up.n, amq.P, up.n);
            pipeItemsObsidian = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_OBSIDIAN_ID, PipeItemsObsidian.class, "Obsidian Transport Pipe", amq.as, amq.P, amq.as);
            pipeLiquidsWood = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_WOOD_ID, PipeLiquidsWood.class, "Wooden Waterproof Pipe", pipeWaterproof, pipeItemsWood, null);
            pipeLiquidsCobblestone = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_COBBLESTONE_ID, PipeLiquidsCobblestone.class, "Cobblestone Waterproof Pipe", pipeWaterproof, pipeItemsCobblestone, null);
            pipeLiquidsStone = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_STONE_ID, PipeLiquidsStone.class, "Stone Waterproof Pipe", pipeWaterproof, pipeItemsStone, null);
            pipeLiquidsIron = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_IRON_ID, PipeLiquidsIron.class, "Iron Waterproof Pipe", pipeWaterproof, pipeItemsIron, null);
            pipeLiquidsGold = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_GOLD_ID, PipeLiquidsGold.class, "Golden Waterproof Pipe", pipeWaterproof, pipeItemsGold, null);
            pipeLiquidsEmerald = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_EMERALD_ID, PipeLiquidsEmerald.class, "Emerald Waterproof Pipe", pipeWaterproof, pipeItemsEmerald, null);
            pipePowerWood = BuildCraftTransport.createPipe(DefaultProps.PIPE_POWER_WOOD_ID, PipePowerWood.class, "Wooden Conductive Pipe", up.aC, pipeItemsWood, null);
            pipePowerStone = BuildCraftTransport.createPipe(DefaultProps.PIPE_POWER_STONE_ID, PipePowerStone.class, "Stone Conductive Pipe", up.aC, pipeItemsStone, null);
            pipePowerGold = BuildCraftTransport.createPipe(DefaultProps.PIPE_POWER_GOLD_ID, PipePowerGold.class, "Golden Conductive Pipe", up.aC, pipeItemsGold, null);
            pipeStructureCobblestone = BuildCraftTransport.createPipe(DefaultProps.PIPE_STRUCTURE_COBBLESTONE_ID, PipeStructureCobblestone.class, "Cobblestone Structure Pipe", amq.I, pipeItemsCobblestone, null);
            pipeItemsVoid = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_VOID_ID, PipeItemsVoid.class, "Void Transport Pipe", new ur(up.aW, 1, 0), amq.P, up.aC);
            pipeLiquidsVoid = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_VOID_ID, PipeLiquidsVoid.class, "Void Waterproof Pipe", pipeWaterproof, pipeItemsVoid, null);
            pipeItemsSandstone = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_SANDSTONE_ID, PipeItemsSandstone.class, "Sandstone Transport Pipe", amq.T, amq.P, amq.T);
            pipeLiquidsSandstone = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_SANDSTONE_ID, PipeLiquidsSandstone.class, "Sandstone Waterproof Pipe", pipeWaterproof, pipeItemsSandstone, null);
            Property redPipeWireId = BuildCraftCore.mainConfiguration.get("item", "redPipeWire.id", DefaultProps.RED_PIPE_WIRE);
            redPipeWire = new ItemBuildCraft(Integer.parseInt(redPipeWireId.value)).c(64);
            redPipeWire.b("redPipeWire");
            LanguageRegistry.addName((Object)redPipeWire, (String)"Red Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aW, 1, 1), new ur(up.aC, 1), new ur(up.o, 1)}, 500, new ur(redPipeWire, 8)));
            Property bluePipeWireId = BuildCraftCore.mainConfiguration.get("item", "bluePipeWire.id", DefaultProps.BLUE_PIPE_WIRE);
            bluePipeWire = new ItemBuildCraft(Integer.parseInt(bluePipeWireId.value)).c(65);
            bluePipeWire.b("bluePipeWire");
            LanguageRegistry.addName((Object)bluePipeWire, (String)"Blue Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aW, 1, 4), new ur(up.aC, 1), new ur(up.o, 1)}, 500, new ur(bluePipeWire, 8)));
            Property greenPipeWireId = BuildCraftCore.mainConfiguration.get("item", "greenPipeWire.id", DefaultProps.GREEN_PIPE_WIRE);
            greenPipeWire = new ItemBuildCraft(Integer.parseInt(greenPipeWireId.value)).c(66);
            greenPipeWire.b("greenPipeWire");
            LanguageRegistry.addName((Object)greenPipeWire, (String)"Green Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aW, 1, 2), new ur(up.aC, 1), new ur(up.o, 1)}, 500, new ur(greenPipeWire, 8)));
            Property yellowPipeWireId = BuildCraftCore.mainConfiguration.get("item", "yellowPipeWire.id", DefaultProps.YELLOW_PIPE_WIRE);
            yellowPipeWire = new ItemBuildCraft(Integer.parseInt(yellowPipeWireId.value)).c(67);
            yellowPipeWire.b("yellowPipeWire");
            LanguageRegistry.addName((Object)yellowPipeWire, (String)"Yellow Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aW, 1, 11), new ur(up.aC, 1), new ur(up.o, 1)}, 500, new ur(yellowPipeWire, 8)));
            Property pipeGateId = BuildCraftCore.mainConfiguration.get("item", "pipeGate.id", DefaultProps.GATE_ID);
            pipeGate = new ItemGate(Integer.parseInt(pipeGateId.value), 0).c(35);
            pipeGate.b("pipeGate");
            Property pipeGateAutarchicId = BuildCraftCore.mainConfiguration.get("item", "pipeGateAutarchic.id", DefaultProps.GATE_AUTARCHIC_ID);
            pipeGateAutarchic = new ItemGate(Integer.parseInt(pipeGateAutarchicId.value), 1).c(35);
            pipeGateAutarchic.b("pipeGateAutarchic");
            Property pipeFacadeId = BuildCraftCore.mainConfiguration.get("item", "pipeFacade.id", DefaultProps.PIPE_FACADE_ID);
            facadeItem = new ItemFacade(Integer.parseInt(pipeFacadeId.value));
            facadeItem.b("pipeFacade");
        }
        finally {
            BuildCraftCore.mainConfiguration.save();
        }
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        TransportProxy.proxy.registerTileEntities();
        for (int j = 0; j < 6; ++j) {
            BuildCraftTransport.diamondTextures[j] = 22 + j;
        }
        new BptBlockPipe(BuildCraftTransport.genericPipeBlock.cm);
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsWood.cj] = new BptItemPipeWooden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeLiquidsWood.cj] = new BptItemPipeWooden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsIron.cj] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeLiquidsIron.cj] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsDiamond.cj] = new BptItemPipeDiamond();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsEmerald.cj] = new BptItemPipeEmerald();
        ActionManager.registerTriggerProvider(new PipeTriggerProvider());
        if (BuildCraftCore.loadDefaultRecipes) {
            this.loadRecipes();
        }
        TransportProxy.proxy.registerRenderers();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
        ItemFacade.initialize();
    }

    public void loadRecipes() {
        GameRegistry.addShapelessRecipe((ur)new ur(pipeWaterproof, 1), (Object[])new Object[]{new ur(up.aW, 1, 2)});
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                GameRegistry.addShapelessRecipe((ur)pipe.result, (Object[])pipe.input);
                continue;
            }
            CoreProxy.proxy.addCraftingRecipe(pipe.result, pipe.input);
        }
    }

    @Mod.IMCCallback
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        Splitter splitter = Splitter.on((String)"@").trimResults();
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (!"add-facade".equals(m.key)) continue;
            String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
            if (array.length != 2) {
                Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                continue;
            }
            Integer blId = Ints.tryParse((String)array[0]);
            Integer metaId = Ints.tryParse((String)array[1]);
            if (blId == null || metaId == null) {
                Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                continue;
            }
            ItemFacade.addFacade(new ur(blId.intValue(), 1, metaId.intValue()));
        }
    }

    public static up createPipe(int defaultID, Class clas, String descr, Object ingredient1, Object ingredient2, Object ingredient3) {
        String name = Character.toLowerCase(clas.getSimpleName().charAt(0)) + clas.getSimpleName().substring(1);
        Property prop = BuildCraftCore.mainConfiguration.getItem(name + ".id", defaultID);
        int id = prop.getInt(defaultID);
        ItemPipe res = BlockGenericPipe.registerPipe(id, clas);
        res.b(clas.getSimpleName());
        LanguageRegistry.addName((Object)res, (String)descr);
        PipeRecipe recipe = new PipeRecipe();
        if (ingredient1 != null && ingredient2 != null && ingredient3 != null) {
            recipe.result = new ur((up)res, 8);
            recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredient1, Character.valueOf('B'), ingredient2, Character.valueOf('C'), ingredient3};
            pipeRecipes.add(recipe);
        } else if (ingredient1 != null && ingredient2 != null) {
            recipe.isShapeless = true;
            recipe.result = new ur((up)res, 1);
            recipe.input = new Object[]{ingredient1, ingredient2};
            pipeRecipes.add(recipe);
        }
        return res;
    }

    static {
        diamondTextures = new int[6];
        triggerPipeEmpty = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_EMPTY, TriggerPipeContents.Kind.Empty);
        triggerPipeItems = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_ITEMS, TriggerPipeContents.Kind.ContainsItems);
        triggerPipeLiquids = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_LIQUIDS, TriggerPipeContents.Kind.ContainsLiquids);
        triggerPipeEnergy = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_ENERGY, TriggerPipeContents.Kind.ContainsEnergy);
        triggerRedSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_ACTIVE, true, IPipe.WireColor.Red);
        triggerRedSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_INACTIVE, false, IPipe.WireColor.Red);
        triggerBlueSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_ACTIVE, true, IPipe.WireColor.Blue);
        triggerBlueSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_INACTIVE, false, IPipe.WireColor.Blue);
        triggerGreenSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_ACTIVE, true, IPipe.WireColor.Green);
        triggerGreenSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_INACTIVE, false, IPipe.WireColor.Green);
        triggerYellowSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_ACTIVE, true, IPipe.WireColor.Yellow);
        triggerYellowSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_INACTIVE, false, IPipe.WireColor.Yellow);
        actionRedSignal = new ActionSignalOutput(DefaultProps.ACTION_RED_SIGNAL, IPipe.WireColor.Red);
        actionBlueSignal = new ActionSignalOutput(DefaultProps.ACTION_BLUE_SIGNAL, IPipe.WireColor.Blue);
        actionGreenSignal = new ActionSignalOutput(DefaultProps.ACTION_GREEN_SIGNAL, IPipe.WireColor.Green);
        actionYellowSignal = new ActionSignalOutput(DefaultProps.ACTION_YELLOW_SIGNAL, IPipe.WireColor.Yellow);
        actionEnergyPulser = new ActionEnergyPulser(DefaultProps.ACTION_ENERGY_PULSER);
        pipeRecipes = new LinkedList();
    }

    private static class ExtractionHandler
    implements IExtractionHandler {
        private final String[] items;
        private final String[] liquids;

        public ExtractionHandler(String[] items, String[] liquids) {
            this.items = items;
            this.liquids = liquids;
        }

        @Override
        public boolean canExtractItems(IPipe pipe, yc world, int i, int j, int k) {
            return this.testStrings(this.items, world, i, j, k);
        }

        @Override
        public boolean canExtractLiquids(IPipe pipe, yc world, int i, int j, int k) {
            return this.testStrings(this.liquids, world, i, j, k);
        }

        private boolean testStrings(String[] excludedBlocks, yc world, int i, int j, int k) {
            int id = world.a(i, j, k);
            amq block = amq.p[id];
            if (block == null) {
                return false;
            }
            int meta = world.h(i, j, k);
            for (String excluded : excludedBlocks) {
                if (excluded.equals(block.a())) {
                    return false;
                }
                String[] tokens = excluded.split(":");
                if (!tokens[0].equals(Integer.toString(id)) || tokens.length != 1 && !tokens[1].equals(Integer.toString(meta))) continue;
                return false;
            }
            return true;
        }
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        ur result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

