/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.main.utils;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.logging.Logger;
import thaumicbees.main.ThaumicBees;
import thaumicbees.main.utils.TickHandlerVersion;
import thaumicbees.main.utils.VersionInfo;

public class VersionInfo {
    public static final String Version = "1.4.4a";
    public static final String Build = "152";
    public static final String MCVersion = "1.4.7";
    public static final String VersionURL = "http://bit.ly/thaumicbeeversion";
    public static final String Logo = "/gfx/thaumicbees/logo.png";
    public static final String Depends = "required-after:Forestry;after:Thaumcraft@[3.0.3,);after:ExtraBees";
    boolean criticalUpdate;
    boolean newVersion;
    boolean newMinecraftVersion;
    boolean versionCheckComplete;
    String latestModVersion;
    String latestMCVersion = "1.4.7";
    String description = "";
    String modName;
    String modVersion;
    String releaseURL;
    Logger modLogger = FMLLog.getLogger();

    public static int[] parseVersion(String rawVersion) {
        ArrayList<Integer> versionTokens = new ArrayList<Integer>();
        String[] tokens = rawVersion.trim().split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            if (tokens[i].matches("[0-9]+")) {
                versionTokens.add(Integer.valueOf(tokens[i]));
                continue;
            }
            if (!tokens[i].matches("[0-9]+[a-z]")) continue;
            String numberString = tokens[i].substring(0, tokens[i].length() - 1);
            versionTokens.add(Integer.valueOf(numberString));
            versionTokens.add(Character.getNumericValue(tokens[i].charAt(tokens[i].length() - 1)));
        }
        int[] value = new int[versionTokens.size()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (Integer)versionTokens.get(i);
        }
        return value;
    }

    public static boolean beforeTargetVersion(String version, String target) {
        boolean result = false;
        int[] versionTokens = VersionInfo.parseVersion(version);
        int[] targetTokens = VersionInfo.parseVersion(target);
        for (int i = 0; i < versionTokens.length && i < targetTokens.length; ++i) {
            if (versionTokens[i] < targetTokens[i]) {
                result = true;
                break;
            }
            if (versionTokens[i] > targetTokens[i]) {
                result = false;
                break;
            }
            if (i != versionTokens.length - 1 || versionTokens.length >= targetTokens.length) continue;
            result = true;
        }
        return result;
    }

    public static boolean afterTargetVersion(String version, String target) {
        boolean result = false;
        int[] versionTokens = VersionInfo.parseVersion(version);
        int[] targetTokens = VersionInfo.parseVersion(target);
        for (int i = 0; i < versionTokens.length && i < targetTokens.length; ++i) {
            if (versionTokens[i] <= targetTokens[i]) continue;
            result = true;
            break;
        }
        return result;
    }

    public VersionInfo(String name, String version, String url) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
    }

    public VersionInfo(String name, String version, String url, Logger logger) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
        this.modLogger = logger;
    }

    public void checkForNewVersion() {
        VersionCheckThread versionCheckThread = new VersionCheckThread(this, null);
        versionCheckThread.start();
    }

    public String getCurrentVersion() {
        return this.modVersion;
    }

    public String getLatestVersion() {
        return this.latestModVersion;
    }

    public String getLatestMCVersion() {
        return this.latestMCVersion;
    }

    public String getVersionDescription() {
        return this.description;
    }

    public boolean isCriticalUpdate() {
        return this.criticalUpdate;
    }

    public boolean isNewVersionAvailable() {
        return this.newVersion;
    }

    public boolean isMinecraftOutdated() {
        return this.newMinecraftVersion;
    }

    public boolean isVersionCheckComplete() {
        return this.versionCheckComplete;
    }

    public static void doVersionCheck() {
        if (!ThaumicBees.getConfig().SkipUpdateCheck) {
            VersionInfo main = new VersionInfo("ThaumicBees", Version, VersionURL);
            TickHandlerVersion.registerModVersionInfo(main);
            TickHandlerVersion.initialize();
            TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)TickHandlerVersion.instance, (Side)Side.CLIENT);
            VersionInfo versionInfo = main;
            versionInfo.getClass();
            VersionCheckThread thread = new VersionCheckThread(versionInfo, null);
            thread.start();
        }
    }
}

