/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.main.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.BlockInterface;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thaumcraft.api.EnumTag;
import thaumicbees.item.ItemCapsule;
import thaumicbees.item.types.CombType;
import thaumicbees.item.types.DropType;
import thaumicbees.item.types.LiquidType;
import thaumicbees.item.types.NuggetType;
import thaumicbees.item.types.PlankType;
import thaumicbees.item.types.PropolisType;
import thaumicbees.item.types.ResourceType;
import thaumicbees.item.types.WaxType;
import thaumicbees.main.Config;
import thaumicbees.main.utils.compat.ForestryHelper;
import thaumicbees.main.utils.compat.ThaumcraftHelper;

public class CraftingManager {
    public static void setupCrafting() {
        CraftingManager.setupVanillaCrafting();
        CraftingManager.setupCentrifugeRecipes();
        CraftingManager.setupSqueezerRecipes();
        CraftingManager.setupCarpenterRecipes();
        if (ThaumcraftHelper.isActive()) {
            ThaumcraftHelper.setupThaumcraftCrafting();
        } else {
            CraftingManager.setupThaumcraftAlternativeCrafting();
        }
        CraftingManager.registerLiquidContainer(Config.magicCapsule);
        CraftingManager.registerLiquidContainer(Config.voidCapsule);
    }

    private static void setupVanillaCrafting() {
        ur output = new ur((up)Config.magicCapsule);
        output.a = 4;
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"WWW", Character.valueOf('W'), Config.wax.getStackForType(WaxType.MAGIC)});
        ur input = Config.miscResources.getStackForType(ResourceType.EXTENDED_FERTILIZER);
        output = ItemInterface.getItem((String)"fertilizerCompound");
        output.a = 6;
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{" S ", " F ", " S ", Character.valueOf('F'), input, Character.valueOf('S'), amq.H});
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"   ", "SFS", "   ", Character.valueOf('F'), input, Character.valueOf('S'), amq.H});
        output = output.l();
        output.a = 12;
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"aaa", "aFa", "aaa", Character.valueOf('F'), input, Character.valueOf('a'), ItemInterface.getItem((String)"ash")});
        GameRegistry.addRecipe((ur)new ur(up.bD), (Object[])new Object[]{"DDD", "DBD", "DDD", Character.valueOf('D'), Config.drops.getStackForType(DropType.INTELLECT), Character.valueOf('B'), up.bt});
        GameRegistry.addRecipe((ur)new ur(amq.bf, 0, 4), (Object[])new Object[]{"SwS", "wDw", "SwS", Character.valueOf('S'), amq.H, Character.valueOf('D'), amq.y, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL)});
        GameRegistry.addRecipe((ur)new ur(amq.bf, 0, 4), (Object[])new Object[]{"wSw", "SDS", "wSw", Character.valueOf('S'), amq.H, Character.valueOf('D'), amq.y, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL)});
        if (OreDictionary.getOres((String)"ingotCopper").size() <= 0) {
            NuggetType.COPPER.setActive(false);
        }
        if (OreDictionary.getOres((String)"ingotTin").size() <= 0) {
            NuggetType.TIN.setActive(false);
        }
        if (OreDictionary.getOres((String)"ingotSilver").size() <= 0) {
            NuggetType.SILVER.setActive(false);
        }
        if (OreDictionary.getOres((String)"ingotLead").size() <= 0) {
            NuggetType.LEAD.setActive(false);
        }
        if (NuggetType.COPPER.isActive()) {
            GameRegistry.addRecipe((wp)new ShapedOreRecipe((ur)OreDictionary.getOres((String)"ingotCopper").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetCopper"}));
        }
        if (NuggetType.TIN.isActive()) {
            GameRegistry.addRecipe((wp)new ShapedOreRecipe((ur)OreDictionary.getOres((String)"ingotTin").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetTin"}));
        }
        if (NuggetType.SILVER.isActive()) {
            GameRegistry.addRecipe((wp)new ShapedOreRecipe((ur)OreDictionary.getOres((String)"ingotSilver").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetSilver"}));
        }
        if (NuggetType.LEAD.isActive()) {
            GameRegistry.addRecipe((wp)new ShapedOreRecipe((ur)OreDictionary.getOres((String)"ingotLead").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetLead"}));
        }
        GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur(up.o), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetIron"}));
        GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur(up.n), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "shardDiamond"}));
        GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur(up.bH), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "shardEmerald"}));
        if (ThaumcraftHelper.isActive()) {
            for (int i = 0; i < PlankType.values().length; ++i) {
                input = new ur((amq)Config.planksWood, 1, i);
                output = new ur((amq)Config.slabWoodHalf, 6, i);
                GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"PPP", Character.valueOf('P'), input});
            }
            output = new ur(Config.tcEssentiaBottle);
            output.a = 8;
            GameRegistry.addRecipe((ur)output, (Object[])new Object[]{" C ", "GPG", "PGP", Character.valueOf('G'), Config.wax, Character.valueOf('C'), up.aI, Character.valueOf('P'), amq.bt});
            output = new ur(Config.tcEssentiaBottle);
            output.a = 4;
            GameRegistry.addRecipe((ur)output, (Object[])new Object[]{" W ", "W W", " W ", Character.valueOf('W'), Config.wax});
            output = new ur(Config.tcMiscResource, 1, ThaumcraftHelper.MiscResource.KNOWLEDGE_FRAGMENT.ordinal());
            GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"FF", "FF", Character.valueOf('F'), Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT)});
            GameRegistry.addRecipe((ur)new ur(Config.thaumaturgeBackpackT1), (Object[])new Object[]{"SWS", "NCN", "SWS", Character.valueOf('S'), up.K, Character.valueOf('W'), amq.ae, Character.valueOf('N'), new ur(Config.tcMiscResource.cj, 1, ThaumcraftHelper.MiscResource.AMBER.ordinal()), Character.valueOf('C'), amq.ax});
            for (EnumTag tag : EnumTag.values()) {
                if (tag == EnumTag.UNKNOWN) continue;
                output = new ur(Config.tcEssentiaBottle, 1, tag.id + 1);
                GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"ccc", "cxc", "ccc", Character.valueOf('c'), new ur((up)Config.solidFlux, 1, tag.id), Character.valueOf('x'), Config.tcEssentiaBottle});
            }
        }
    }

    private static void setupCentrifugeRecipes() {
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.OCCULT), new ur[]{Config.wax.getStackForType(WaxType.MAGIC), ItemInterface.getItem((String)"honeyDrop")}, new int[]{100, 60});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.OTHERWORLDLY), new ur[]{ItemInterface.getItem((String)"beeswax"), Config.wax.getStackForType(WaxType.MAGIC), ItemInterface.getItem((String)"honeyDrop")}, new int[]{50, 20, 100});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.PAPERY), new ur[]{ItemInterface.getItem((String)"beeswax"), Config.wax.getStackForType(WaxType.MAGIC), new ur(up.aK)}, new int[]{80, 20, 5});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.INTELLECT), new ur[]{Config.wax.getStackForType(WaxType.MAGIC), ItemInterface.getItem((String)"honeydew"), Config.drops.getStackForType(DropType.INTELLECT)}, new int[]{90, 40, 10});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.SKULKING), new ur[]{ItemInterface.getItem((String)"beeswax"), ItemInterface.getItem((String)"propolis"), ItemInterface.getItem((String)"honeydew")}, new int[]{90, 20, 35});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.SOUL), new ur[]{Config.wax.getStackForType(WaxType.SOUL), ItemInterface.getItem((String)"honeydew")}, new int[]{95, 26});
        if (ThaumcraftHelper.isActive()) {
            RecipeManagers.centrifugeManager.addRecipe(25, Config.combs.getStackForType(CombType.STARK), new ur[]{ItemInterface.getItem((String)"beeswax"), Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.STARK)}, new int[]{10, 95, 15});
            RecipeManagers.centrifugeManager.addRecipe(25, Config.combs.getStackForType(CombType.AIRY), new ur[]{Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.AIR)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(25, Config.combs.getStackForType(CombType.FIREY), new ur[]{Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.FIRE)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(25, Config.combs.getStackForType(CombType.WATERY), new ur[]{Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.WATER)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(25, Config.combs.getStackForType(CombType.EARTHY), new ur[]{Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.EARTH)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(25, Config.combs.getStackForType(CombType.INFUSED), new ur[]{Config.wax.getStackForType(WaxType.MAGIC), Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.INFUSED)}, new int[]{100, 50, 65});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.STARK), new ur[]{new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.DULL.ordinal())}, new int[]{10});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.AIR), new ur[]{new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.AIR.ordinal())}, new int[]{10});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.FIRE), new ur[]{new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.FIRE.ordinal())}, new int[]{10});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.WATER), new ur[]{new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.WATER.ordinal())}, new int[]{10});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.EARTH), new ur[]{new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.EARTH.ordinal())}, new int[]{10});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.INFUSED), new ur[]{new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.MAGIC.ordinal())}, new int[]{10});
        }
    }

    private static void setupSqueezerRecipes() {
        if (ThaumcraftHelper.isActive()) {
            RecipeManagers.squeezerManager.addRecipe(20, new ur[]{Config.propolis.getStackForType(PropolisType.FIRE)}, new LiquidStack(amq.G, 250), new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.FIRE.ordinal()), 10);
            RecipeManagers.squeezerManager.addRecipe(20, new ur[]{Config.propolis.getStackForType(PropolisType.WATER)}, new LiquidStack(amq.E, 500), new ur(Config.tcShard, 1, ThaumcraftHelper.ShardType.WATER.ordinal()), 10);
        }
    }

    private static void setupCarpenterRecipes() {
        ur output = BlockInterface.getBlock((String)"candle");
        output.a = 24;
        RecipeManagers.carpenterManager.addRecipe(30, new LiquidStack(amq.E, 600), null, output, new Object[]{" S ", "WWW", "WWW", Character.valueOf('W'), Config.wax, Character.valueOf('S'), up.K});
        output = BlockInterface.getBlock((String)"candle");
        output.a = 6;
        ur input = ItemInterface.getItem((String)"craftingMaterial");
        input.b(ForestryHelper.CraftingMaterial.SILK_WISP.ordinal());
        RecipeManagers.carpenterManager.addRecipe(30, new LiquidStack(amq.E, 600), null, output, new Object[]{"WSW", Character.valueOf('W'), Config.wax, Character.valueOf('S'), input});
        output = Config.miscResources.getStackForType(ResourceType.AROMATIC_LUMP, 2);
        RecipeManagers.carpenterManager.addRecipe(30, new LiquidStack(ItemInterface.getItem((String)"liquidHoney").c, 1000), null, output, new Object[]{" P ", "JDJ", " P ", Character.valueOf('P'), ItemInterface.getItem((String)"pollen"), Character.valueOf('J'), ItemInterface.getItem((String)"royalJelly"), Character.valueOf('D'), Config.drops.getStackForType(DropType.ENCHANTED)});
        RecipeManagers.carpenterManager.addRecipe(30, new LiquidStack(ItemInterface.getItem((String)"liquidHoney").c, 1000), null, output, new Object[]{" J ", "PDP", " J ", Character.valueOf('P'), ItemInterface.getItem((String)"pollen"), Character.valueOf('J'), ItemInterface.getItem((String)"royalJelly"), Character.valueOf('D'), Config.drops.getStackForType(DropType.ENCHANTED)});
        if (ThaumcraftHelper.isActive()) {
            input = ItemInterface.getItem((String)"craftingMaterial");
            input.b(3);
            output = new ur(Config.thaumaturgeBackpackT2);
            RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), up.n, Character.valueOf('W'), input, Character.valueOf('T'), new ur(Config.thaumaturgeBackpackT1)});
            output = new ur((amq)Config.planksWood, 4, 0);
            RecipeManagers.carpenterManager.addRecipe(8, new LiquidStack(amq.E, 500), null, output, new Object[]{"B", Character.valueOf('B'), new ur(Config.tcLog, 1, 0)});
            output = new ur((amq)Config.planksWood, 6, 1);
            RecipeManagers.carpenterManager.addRecipe(8, new LiquidStack(amq.E, 500), null, output, new Object[]{"B", Character.valueOf('B'), new ur(Config.tcLog, 1, 1)});
        }
    }

    private static void registerLiquidContainer(ItemCapsule baseCapsule) {
        ur empty = new ur((up)baseCapsule, 1, 0);
        LiquidStack liquid = null;
        for (LiquidType liquidType : LiquidType.values()) {
            switch (liquidType) {
                case EMPTY: {
                    liquid = null;
                    break;
                }
                case WATER: {
                    liquid = new LiquidStack(amq.E, baseCapsule.getType().capacity);
                    break;
                }
                case LAVA: {
                    liquid = new LiquidStack(amq.G, baseCapsule.getType().capacity);
                    break;
                }
                default: {
                    liquid = LiquidDictionary.getLiquid((String)liquidType.liquidID, (int)baseCapsule.getType().capacity);
                }
            }
            if (liquid == null) continue;
            ur filled = new ur((up)baseCapsule, 1, liquidType.ordinal());
            LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(liquid, filled, empty));
            RecipeManagers.bottlerManager.addRecipe(5, liquid, empty, filled);
            RecipeManagers.squeezerManager.addRecipe(10, new ur[]{filled}, liquid, Config.wax.getStackForType(WaxType.MAGIC), 20);
            liquidType.available = true;
        }
        LiquidType.EMPTY.available = true;
    }

    private static void setupThaumcraftAlternativeCrafting() {
        ur output = new ur((up)Config.hiveFrameMagic);
        ur input = ItemInterface.getItem((String)"frameUntreated");
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"www", "wfw", "www", Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC), Character.valueOf('f'), input});
        output = new ur((up)Config.hiveFrameResilient);
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"wiw", "ifi", "wiw", Character.valueOf('f'), Config.hiveFrameMagic, Character.valueOf('i'), up.o, Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC)});
        output = new ur((up)Config.hiveFrameGentle);
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"WwW", "wFw", "WwW", Character.valueOf('F'), input, Character.valueOf('w'), ItemInterface.getItem((String)"beeswax"), Character.valueOf('W'), Config.wax.getStackForType(WaxType.MAGIC)});
        output = new ur((up)Config.hiveFrameMetabolic);
        GameRegistry.addShapelessRecipe((ur)output, (Object[])new Object[]{up.bx, input, Config.wax.getStackForType(WaxType.MAGIC), Config.wax.getStackForType(WaxType.MAGIC), Config.wax.getStackForType(WaxType.MAGIC), Config.wax.getStackForType(WaxType.MAGIC)});
        output = new ur((up)Config.hiveFrameNecrotic);
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"wSw", "SFS", "wSw", Character.valueOf('S'), up.bm, Character.valueOf('F'), input, Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC)});
        output = new ur((up)Config.hiveFrameTemporal);
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"wSt", "wFw", "tSw", Character.valueOf('t'), up.D, Character.valueOf('S'), amq.H, Character.valueOf('F'), input, Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC)});
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"tSw", "wFw", "wSt", Character.valueOf('t'), up.D, Character.valueOf('S'), amq.H, Character.valueOf('F'), input, Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC)});
        output = Config.voidCapsule.getCapsuleForLiquid(LiquidType.EMPTY);
        output.a = 4;
        GameRegistry.addRecipe((ur)output, (Object[])new Object[]{"wDw", "GPG", "TwT", Character.valueOf('G'), amq.P, Character.valueOf('D'), up.n, Character.valueOf('P'), up.bA, Character.valueOf('T'), up.p, Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC)});
    }
}

