/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.HashMap;
import net.minecraftforge.oredict.OreDictionary;
import thaumicbees.bees.BeeClassification;
import thaumicbees.bees.BeeGenomeManager;
import thaumicbees.item.types.CombType;
import thaumicbees.item.types.DropType;
import thaumicbees.item.types.NuggetType;
import thaumicbees.item.types.PollenType;
import thaumicbees.item.types.ResourceType;
import thaumicbees.main.Config;
import thaumicbees.main.utils.LocalizationManager;
import thaumicbees.main.utils.compat.EquivalentExchangeHelper;
import thaumicbees.main.utils.compat.ForestryHelper;
import thaumicbees.main.utils.compat.ThaumcraftHelper;

public enum BeeSpecies implements IAlleleBeeSpecies
{
    ESOTERIC("Esoteric", "secretiore", (IClassification)BeeClassification.ARCANE, 4249, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    MYSTERIOUS("Mysterious", "mysticus", (IClassification)BeeClassification.ARCANE, 7744450, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ARCANE("Arcane", "arcanus", (IClassification)BeeClassification.ARCANE, 13779679, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    CHARMED("Charmed", "larvatus", (IClassification)BeeClassification.SUPERNATURAL, 4779756, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ENCHANTED("Enchanted", "cantatus", (IClassification)BeeClassification.SUPERNATURAL, 1632038, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SUPERNATURAL("Supernatural", "coeleste", (IClassification)BeeClassification.SUPERNATURAL, 22036, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    PUPIL("Pupil", "disciplina", (IClassification)BeeClassification.SCHOLARLY, 0xFFFF00, EnumTemperature.NORMAL, EnumHumidity.ARID, false, true),
    SCHOLARLY("Scholarly", "studiosis", (IClassification)BeeClassification.SCHOLARLY, 0x6E0000, EnumTemperature.NORMAL, EnumHumidity.ARID, false, false),
    SAVANT("Savant", "philologus", (IClassification)BeeClassification.SCHOLARLY, 7216237, EnumTemperature.NORMAL, EnumHumidity.ARID, true, false),
    STARK("Stark", "torridae", (IClassification)BeeClassification.THAUMIC, 0xCCCCCC, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    AIR("Aura", "ventosa", (IClassification)BeeClassification.THAUMIC, 14276150, 10591760, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    FIRE("Ignis", "praefervidus", (IClassification)BeeClassification.THAUMIC, 15010571, 9769775, EnumTemperature.HOT, EnumHumidity.ARID, true, true),
    WATER("Aqua", "umidus", (IClassification)BeeClassification.THAUMIC, 3592153, 1070241, EnumTemperature.NORMAL, EnumHumidity.DAMP, true, true),
    EARTH("Solum", "sordida", (IClassification)BeeClassification.THAUMIC, 20736, 40960, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    INFUSED("Praecantatio", "azanorius", (IClassification)BeeClassification.THAUMIC, 11154172, 8013982, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    AWARE("Aware", "sensibilis", (IClassification)BeeClassification.VIS, 184586985, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    VIS("Vis", "arcanus saecula", (IClassification)BeeClassification.VIS, 19609, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    PURE("Pure", "arcanus puritatem", (IClassification)BeeClassification.VIS, 184586985, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    FLUX("Flux", "arcanus labe", (IClassification)BeeClassification.VIS, 19609, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    NODE("Node", "conficiens", (IClassification)BeeClassification.VIS, 0xFFF266, 16747753, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    REJUVENATING("Rejuvenating", "arcanus vitae", (IClassification)BeeClassification.VIS, 9556185, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    SKULKING("Skulking", "malevolens", (IClassification)BeeClassification.SKULKING, 5392423, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    BRAINY("Brainy", "cerebrum", (IClassification)BeeClassification.SKULKING, 8650608, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    GOSSAMER("Gossamer", "perlucidus", (IClassification)BeeClassification.SKULKING, 1589094, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    WISPY("Wispy", "umbrabilis", (IClassification)BeeClassification.SKULKING, 10270933, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    BATTY("Batty", "chiroptera", (IClassification)BeeClassification.SKULKING, 2569485, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    GHASTLY("Ghastly", "pallens", (IClassification)BeeClassification.SKULKING, 0xCCCCEE, 12552060, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TIMELY("Timely", "gallifreis", (IClassification)BeeClassification.TIME, 13021062, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    LORDLY("Lordly", "rassilonis", (IClassification)BeeClassification.TIME, 13021062, 9306643, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    DOCTORAL("Doctoral", "medicus qui", (IClassification)BeeClassification.TIME, 14542332, 4943500, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    MINIUM("Minium", "mutabilis", (IClassification)BeeClassification.ALCHEMICAL, 11274529, 3801867, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SPIRIT("Spirit", "larva", (IClassification)BeeClassification.SOUL, 11703883, EnumTemperature.WARM, EnumHumidity.NORMAL, false, true),
    SOUL("Soul", "anima", (IClassification)BeeClassification.SOUL, 8214811, EnumTemperature.HELLISH, EnumHumidity.NORMAL, true, false),
    IRON("Iron", "ferrus", (IClassification)BeeClassification.METALLIC, 0x686868, 0xE9E9E9, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    GOLD("Gold", "aurum", (IClassification)BeeClassification.METALLIC, 6834945, 0xFFFF0B, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    COPPER("Copper", "aercus", (IClassification)BeeClassification.METALLIC, 6834945, 16762906, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TIN("Tin", "stannum", (IClassification)BeeClassification.METALLIC, 4086125, 10926795, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SILVER("Silver", "argenteus", (IClassification)BeeClassification.METALLIC, 7634049, 9879492, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    LEAD("Lead", "plumbeus", (IClassification)BeeClassification.METALLIC, 9879492, 9546227, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    DIAMOND("Diamond", "diamond", (IClassification)BeeClassification.GEM, 2135425, 9303523, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    EMERALD("Emerald", "prasinus", (IClassification)BeeClassification.GEM, 21248, 1564002, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    CHICKEN("Chicken", "pullus", (IClassification)BeeClassification.FLESHY, 8209182, 14717022, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    BEEF("Beef", "bubulae", (IClassification)BeeClassification.FLESHY, 4203034, 11298643, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    PORK("Pork", "porcina", (IClassification)BeeClassification.FLESHY, 7494959, 13811603, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true);

    private String binomial;
    private String authority;
    private int bodyType;
    private int primaryColour;
    private int secondaryColour;
    private EnumTemperature temperature;
    private EnumHumidity humidity;
    private boolean hasEffect;
    private boolean isSecret;
    private boolean isCounted;
    private boolean isActive;
    private IClassification branch;
    private HashMap products;
    private HashMap specialty;
    private IAllele[] genomeTemplate;
    private String uid;
    private boolean dominant;
    private static final boolean defaultSecretSetting = true;

    public static void setupBeeSpecies() {
        if (ThaumcraftHelper.isActive()) {
            AIR.addSpecialty(new ur(Config.tcNuggets, 1, ThaumcraftHelper.NuggetType.QUICKSILVER.ordinal()), 8);
            EARTH.addSpecialty(new ur(Config.tcMiscResource, 1, ThaumcraftHelper.MiscResource.AMBER.ordinal()), 6);
            BRAINY.addSpecialty(new ur(Config.tcMiscResource, 1, ThaumcraftHelper.MiscResource.ZOMBIE_BRAIN.ordinal()), 2);
            CHICKEN.addSpecialty(new ur(Config.tcNuggetChicken, 1), 9);
            BEEF.addSpecialty(new ur(Config.tcNuggetBeef, 1), 9);
            PORK.addSpecialty(new ur(Config.tcNuggetPork, 1), 9);
        } else {
            SCHOLARLY.setInactive();
            SAVANT.setInactive();
            AIR.setInactive();
            EARTH.setInactive();
            INFUSED.setInactive();
            PURE.setInactive();
            FLUX.setInactive();
            NODE.setInactive();
            REJUVENATING.setInactive();
            BRAINY.setInactive();
            GOSSAMER.setInactive();
            WISPY.setInactive();
            BATTY.setInactive();
            CHICKEN.setInactive();
            BEEF.setInactive();
            PORK.setInactive();
        }
        if (EquivalentExchangeHelper.isActive()) {
            MINIUM.addSpecialty(new ur(Config.eeMinuimShard), 6);
        } else {
            MINIUM.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotCopper").size() <= 0) {
            COPPER.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotTin").size() <= 0) {
            TIN.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotSilver").size() <= 0) {
            SILVER.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotLead").size() <= 0) {
            LEAD.setInactive();
        }
        ESOTERIC.addProduct(Config.combs.getStackForType(CombType.OCCULT), 20).setGenome(BeeGenomeManager.getTemplateEsoteric()).register();
        MYSTERIOUS.addProduct(Config.combs.getStackForType(CombType.OCCULT), 25).setGenome(BeeGenomeManager.getTemplateMysterious()).register();
        ARCANE.addProduct(Config.combs.getStackForType(CombType.OCCULT), 30).addSpecialty(Config.drops.getStackForType(DropType.ENCHANTED, 1), 9).setGenome(BeeGenomeManager.getTemplateArcane()).register();
        CHARMED.addProduct(Config.combs.getStackForType(CombType.OTHERWORLDLY), 20).setGenome(BeeGenomeManager.getTemplateCharmed()).register();
        ENCHANTED.addProduct(Config.combs.getStackForType(CombType.OTHERWORLDLY), 30).setGenome(BeeGenomeManager.getTemplateEnchanted()).register();
        SUPERNATURAL.addProduct(Config.combs.getStackForType(CombType.OTHERWORLDLY), 40).addSpecialty(Config.pollen.getStackForType(PollenType.UNUSUAL), 8).setGenome(BeeGenomeManager.getTemplateSupernatural()).register();
        PUPIL.addProduct(Config.combs.getStackForType(CombType.PAPERY), 20).setGenome(BeeGenomeManager.getTemplatePupil()).register();
        SCHOLARLY.addProduct(Config.combs.getStackForType(CombType.PAPERY), 25).addSpecialty(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT), 2).setGenome(BeeGenomeManager.getTemplateScholarly()).register();
        SAVANT.addProduct(Config.combs.getStackForType(CombType.PAPERY), 40).addSpecialty(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT), 5).setGenome(BeeGenomeManager.getTemplateSavant()).register();
        STARK.addProduct(Config.combs.getStackForType(CombType.STARK), 10).setGenome(BeeGenomeManager.getTemplateStark()).register();
        AIR.addProduct(Config.combs.getStackForType(CombType.AIRY), 9).setGenome(BeeGenomeManager.getTemplateAir()).register();
        FIRE.addProduct(Config.combs.getStackForType(CombType.FIREY), 15).addSpecialty(new ur(up.bw), 4).setGenome(BeeGenomeManager.getTemplateFire()).register();
        WATER.addProduct(Config.combs.getStackForType(CombType.WATERY), 20).addSpecialty(new ur(amq.aW), 1).addSpecialty(new ur(Config.fPollen, 1, ForestryHelper.Pollen.CRYSTALLINE.ordinal()), 5).setGenome(BeeGenomeManager.getTemplateWater()).register();
        EARTH.addProduct(Config.combs.getStackForType(CombType.EARTHY), 30).setGenome(BeeGenomeManager.getTemplateEarth()).register();
        INFUSED.addProduct(Config.combs.getStackForType(CombType.INFUSED), 20).setGenome(BeeGenomeManager.getTemplateInfused()).register();
        AWARE.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 18).setGenome(BeeGenomeManager.getTemplateAware()).register();
        VIS.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 25).setGenome(BeeGenomeManager.getTemplateVis()).register();
        PURE.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 20).setGenome(BeeGenomeManager.getTemplatePure()).register();
        FLUX.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 20).setGenome(BeeGenomeManager.getTemplateFlux()).register();
        NODE.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 20).setGenome(BeeGenomeManager.getTemplateNode()).register();
        REJUVENATING.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 20).setGenome(BeeGenomeManager.getTemplateRejuvinating()).register();
        SKULKING.addProduct(Config.combs.getStackForType(CombType.SKULKING), 10).setGenome(BeeGenomeManager.getTemplateSkulking()).register();
        BRAINY.addProduct(Config.combs.getStackForType(CombType.SKULKING), 10).addProduct(new ur(up.bm), 6).setGenome(BeeGenomeManager.getTemplateBrainy()).register();
        BATTY.addProduct(Config.combs.getStackForType(CombType.SKULKING), 10).addSpecialty(new ur(up.M), 4).setGenome(BeeGenomeManager.getTemplateBatty()).register();
        GOSSAMER.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.SILKY.ordinal()), 15).setGenome(BeeGenomeManager.getTemplateGossamer()).register();
        WISPY.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.SILKY.ordinal()), 22).addSpecialty(new ur(Config.fCraftingResource, 1, ForestryHelper.CraftingMaterial.SILK_WISP.ordinal()), 4).setGenome(BeeGenomeManager.getTemplateWispy()).register();
        GHASTLY.addProduct(Config.combs.getStackForType(CombType.SKULKING), 8).addSpecialty(new ur(up.bp), 2).setGenome(BeeGenomeManager.getTemplateGhastly()).register();
        TIMELY.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.DRIPPING.ordinal()), 25).addProduct(Config.pollen.getStackForType(PollenType.PHASED), 10).setGenome(BeeGenomeManager.getTemplateTimely()).register();
        LORDLY.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.MYSTERIOUS.ordinal()), 5).addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.DRIPPING.ordinal()), 25).addProduct(Config.pollen.getStackForType(PollenType.PHASED), 15).setGenome(BeeGenomeManager.getTemplateLordly()).register();
        DOCTORAL.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.MYSTERIOUS.ordinal()), 10).addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.DRIPPING.ordinal()), 25).addProduct(Config.pollen.getStackForType(PollenType.PHASED), 19).addSpecialty(new ur((up)Config.jellyBaby), 7).setGenome(BeeGenomeManager.getTemplateDoctoral()).register();
        MINIUM.addProduct(Config.combs.getStackForType(CombType.OCCULT), 16).setGenome(BeeGenomeManager.getTemplateMinium()).register();
        SPIRIT.addProduct(Config.combs.getStackForType(CombType.SOUL), 13).setGenome(BeeGenomeManager.getTemplateSpirit()).register();
        SOUL.addProduct(Config.combs.getStackForType(CombType.SOUL), 24).setGenome(BeeGenomeManager.getTemplateSoul()).register();
        IRON.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.IRON), 8).setGenome(BeeGenomeManager.getTemplateIron()).register();
        GOLD.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(new ur(up.bq, 1), 6).setGenome(BeeGenomeManager.getTemplateGold()).register();
        COPPER.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.COPPER), 9).setGenome(BeeGenomeManager.getTemplateCopper()).register();
        TIN.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.TIN), 9).setGenome(BeeGenomeManager.getTemplateTin()).register();
        SILVER.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.SILVER), 6).setGenome(BeeGenomeManager.getTemplateSilver()).register();
        LEAD.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.LEAD), 7).setGenome(BeeGenomeManager.getTemplateLead()).register();
        DIAMOND.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.DIAMOND), 3).setGenome(BeeGenomeManager.getTemplateDiamond()).register();
        EMERALD.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.EMERALD), 2).setGenome(BeeGenomeManager.getTemplateEmerald()).register();
        CHICKEN.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateChicken()).register();
        BEEF.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateBeef()).register();
        PORK.addProduct(new ur(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplatePork()).register();
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BeeSpecies(IClassification speciesName, int genusName, EnumTemperature classification, EnumHumidity firstColour, boolean preferredTemp, boolean preferredHumidity) {
        this((String)var1_-1, (int)var2_-1, (String)speciesName, (String)genusName, (IClassification)classification, 0, (int)firstColour, 16739853, (EnumTemperature)preferredTemp, (EnumHumidity)preferredHumidity, (boolean)hasGlowEffect, true, true, (boolean)isSpeciesDominant);
        void isSpeciesDominant;
        void hasGlowEffect;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BeeSpecies(IClassification speciesName, int genusName, int classification, EnumTemperature firstColour, EnumHumidity secondColour, boolean preferredTemp, boolean preferredHumidity) {
        this((String)var1_-1, (int)var2_-1, (String)speciesName, (String)genusName, (IClassification)classification, 0, (int)firstColour, (int)secondColour, (EnumTemperature)preferredTemp, (EnumHumidity)preferredHumidity, (boolean)hasGlowEffect, true, true, (boolean)isSpeciesDominant);
        void isSpeciesDominant;
        void hasGlowEffect;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BeeSpecies(IClassification speciesName, int genusName, int classification, int body, EnumTemperature firstColour, EnumHumidity secondColour, boolean preferredTemp, boolean preferredHumidity, boolean hasGlowEffect, boolean isSpeciesSecret) {
        void isSpeciesCounted;
        void isSpeciesDominant;
        this.uid = "thaumicbees.species" + (String)speciesName;
        this.dominant = isSpeciesDominant;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
        this.binomial = (String)genusName;
        this.authority = "MysteriousAges";
        this.bodyType = body;
        this.primaryColour = (int)firstColour;
        this.secondaryColour = (int)secondColour;
        this.temperature = (EnumTemperature)preferredTemp;
        this.humidity = (EnumHumidity)preferredHumidity;
        this.hasEffect = hasGlowEffect;
        this.isSecret = isSpeciesSecret;
        this.isCounted = isSpeciesCounted;
        this.products = new HashMap();
        this.specialty = new HashMap();
        this.branch = (IClassification)classification;
        this.branch.addMemberSpecies((IAlleleSpecies)this);
        this.isActive = true;
    }

    public BeeSpecies setGenome(IAllele[] genome) {
        this.genomeTemplate = genome;
        return this;
    }

    public IAllele[] getGenome() {
        return this.genomeTemplate;
    }

    public BeeSpecies addProduct(ur produce, int percentChance) {
        this.products.put(produce, percentChance);
        return this;
    }

    public BeeSpecies addSpecialty(ur produce, int percentChance) {
        this.specialty.put(produce, percentChance);
        return this;
    }

    public ur getBeeItem(EnumBeeType beeType) {
        return BeeManager.beeInterface.getBeeStack(BeeManager.beeInterface.getBee(null, BeeManager.beeInterface.templateAsGenome(this.genomeTemplate)), beeType);
    }

    public String getName() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }

    public String getDescription() {
        return LocalizationManager.getLocalizedString(this.getUID() + ".description");
    }

    public int getBodyType() {
        return this.bodyType;
    }

    public int getPrimaryColor() {
        return this.primaryColour;
    }

    public int getSecondaryColor() {
        return this.secondaryColour;
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public BeeSpecies setInactive() {
        this.isActive = false;
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean isCounted() {
        return this.isCounted;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return this.authority;
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public HashMap getProducts() {
        return this.products;
    }

    public HashMap getSpecialty() {
        return this.specialty;
    }

    public String getUID() {
        return this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public boolean isJubilant(yc world, int biomeid, int x, int y, int z) {
        return true;
    }

    private BeeSpecies register() {
        BeeManager.breedingManager.registerBeeTemplate(this.getGenome());
        if (!this.isActive) {
            AlleleManager.alleleRegistry.blacklistAllele(this.getUID());
        }
        return this;
    }

    public jg getAchievement() {
        return null;
    }
}

