/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import thaumicbees.bees.AlleleEffect;
import thaumicbees.bees.EffectData;
import thaumicbees.item.ItemArmorApiarist;

public class AlleleEffectSpawnMob
extends AlleleEffect {
    protected boolean aggosOnPlayer = false;
    protected boolean spawnsWhilePlayerNear;
    protected String alternateMob;
    protected String mobName;
    protected String mobSound;
    protected int throttle;
    protected int chanceToSpawn;
    protected int maxMobsInArea;

    public AlleleEffectSpawnMob(String id, boolean isDominant, String mobToSpawn) {
        this(id, isDominant, mobToSpawn, null);
    }

    public AlleleEffectSpawnMob(String id, boolean isDominant, String mobToSpawn, String mobSoundFx) {
        super(id, isDominant);
        this.mobName = mobToSpawn;
        this.throttle = 200;
        this.chanceToSpawn = 100;
        this.maxMobsInArea = 6;
        this.mobSound = mobSoundFx;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            storedData = new EffectData(1, 1, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int count = storedData.getInteger(0);
        if (count >= this.throttle && !storedData.getBoolean(0)) {
            storedData.setBoolean(0, true);
            storedData.setInteger(0, 0);
        } else {
            storedData.setInteger(0, count + 1);
        }
        if (storedData.getBoolean(0)) {
            yc w = housing.getWorld();
            int roll = w.t.nextInt(100);
            if (roll <= this.chanceToSpawn) {
                if (this.spawnsWhilePlayerNear) {
                    List entities = this.getEntitiesWithinRange(genome, housing);
                    qx target = null;
                    for (lq e : entities) {
                        if (!(e instanceof qx)) continue;
                        target = (qx)e;
                        if (ItemArmorApiarist.getNumberPiecesWorn(target) < 4) break;
                        target = null;
                    }
                    if (target != null) {
                        storedData.setBoolean(0, !this.spawnMob(genome, target, w, housing, false));
                    } else if (this.alternateMob != null) {
                        storedData.setBoolean(0, !this.spawnMob(genome, null, w, housing, true));
                    }
                } else {
                    storedData.setBoolean(0, !this.spawnMob(genome, null, w, housing, true));
                }
            } else {
                if (this.mobSound != null && w.t.nextInt(100) < 35) {
                    int range = genome.getTerritory()[0];
                    double x = (double)housing.getXCoord() + w.t.nextDouble() * (double)(range * 2) - (double)range;
                    range = genome.getTerritory()[1];
                    double y = (double)housing.getYCoord() + w.t.nextDouble() * (double)(range * 2) - (double)range;
                    range = genome.getTerritory()[2];
                    double z = (double)housing.getZCoord() + w.t.nextDouble() * (double)(range * 2) - (double)range;
                    w.a(x, y, z, this.mobSound, 0.5f, (w.t.nextFloat() - w.t.nextFloat()) * 0.2f + 1.0f);
                }
                storedData.setBoolean(0, true);
            }
        }
        return storedData;
    }

    protected boolean spawnMob(IBeeGenome bee, qx player, yc world, IBeeHousing housing, boolean spawnAlternate) {
        boolean spawnedFlag = false;
        md mob = spawnAlternate && this.alternateMob != null ? (md)lv.a((String)this.alternateMob, (yc)world) : (md)lv.a((String)this.mobName, (yc)world);
        if (mob != null) {
            double[] pos = this.randomMobSpawnCoords(world, bee, housing);
            int entitiesCount = world.a(mob.getClass(), aoe.a((double)((int)pos[0]), (double)((int)pos[1]), (double)((int)pos[2]), (double)((int)pos[0] + 1), (double)((int)pos[1] + 1), (double)((int)pos[2] + 1)).b(8.0, 4.0, 8.0)).size();
            mob.a(pos[0], pos[1], pos[2], world.t.nextFloat() * 360.0f, 0.0f);
            if (entitiesCount < this.maxMobsInArea && mob.bs() && mob.bs()) {
                spawnedFlag = world.d((lq)mob);
                if (this.aggosOnPlayer && player != null && ItemArmorApiarist.getNumberPiecesWorn(player) < 4) {
                    mob.b((md)player);
                }
            }
        }
        return spawnedFlag;
    }

    public AlleleEffectSpawnMob setSpawnsOnPlayerNear(String alternateMobToSpawn) {
        this.spawnsWhilePlayerNear = true;
        this.alternateMob = alternateMobToSpawn;
        return this;
    }

    public AlleleEffectSpawnMob setAggrosPlayerOnSpawn() {
        this.aggosOnPlayer = true;
        return this;
    }

    public AlleleEffectSpawnMob setThrottle(int val) {
        this.throttle = val;
        return this;
    }

    public AlleleEffectSpawnMob setChanceToSpawn(int value) {
        this.chanceToSpawn = value;
        return this;
    }

    public AlleleEffectSpawnMob setMaxMobsInSpawnZone(int value) {
        this.maxMobsInArea = value;
        return this;
    }

    protected double[] randomMobSpawnCoords(yc world, IBeeGenome bee, IBeeHousing housing) {
        double[] pos = new double[]{(double)housing.getXCoord() + (world.t.nextDouble() * (double)((float)bee.getTerritory()[0] * housing.getTerritoryModifier(bee)) - (double)(bee.getTerritory()[0] / 2)), housing.getYCoord() + world.t.nextInt(3) - 1, (double)housing.getZCoord() + (world.t.nextDouble() * (double)((float)bee.getTerritory()[2] * housing.getTerritoryModifier(bee)) - (double)(bee.getTerritory()[2] / 2))};
        return pos;
    }
}

