/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;
import thaumicbees.bees.AlleleEffect;
import thaumicbees.bees.EffectData;

public class AlleleEffectAuraNodeFlux
extends AlleleEffect {
    private int effectTimeout;
    private int nodeRange;

    AlleleEffectAuraNodeFlux(String id, boolean dominant, int timeout, int range) {
        super(id, dominant);
        this.effectTimeout = timeout;
        this.nodeRange = range;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int timeout = storedData.getInteger(0);
        if (timeout >= this.effectTimeout) {
            EnumTag tag;
            yc world = housing.getWorld();
            int x = housing.getXCoord();
            int y = housing.getYCoord();
            int z = housing.getZCoord();
            while ((tag = EnumTag.values()[world.t.nextInt(EnumTag.values().length)]) == EnumTag.UNKNOWN || tag == EnumTag.WEATHER) {
            }
            int nodeId = ThaumcraftApi.getClosestAuraWithinRange((yc)world, (double)x, (double)y, (double)z, (double)this.nodeRange);
            if (nodeId != -1) {
                int quantity = world.t.nextInt(2) + 1;
                ThaumcraftApi.queueNodeChanges((int)nodeId, (int)0, (int)0, (boolean)false, (ObjectTags)new ObjectTags().add(tag, quantity), (float)0.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            storedData.setInteger(0, timeout + 1);
        }
        return storedData;
    }
}

