/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.client.gui.GuiSlag;
import factorization.common.TileEntitySlagFurnace;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class NEI_SlagRecipeConfig
extends TemplateRecipeHandler
implements IConfigureNEI {
    public void loadConfig() {
        API.registerRecipeHandler((ICraftingHandler)this);
        API.registerUsageHandler((IUsageHandler)this);
    }

    public String getName() {
        return "factorization slag furnace recipes";
    }

    public String getVersion() {
        return "1";
    }

    public void loadCraftingRecipes(ur result) {
        for (TileEntitySlagFurnace.SmeltingResult sr2 : TileEntitySlagFurnace.SlagRecipes.smeltingResults) {
            if (result != null && !result.a(sr2.output1) && !result.a(sr2.output2)) continue;
            this.arecipes.add(new CachedSlagRecipe(sr2));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("slagging")) {
            this.loadCraftingRecipes(null);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        ur ingredient;
        if (inputId.equals("slagging")) {
            ingredient = null;
        } else if (inputId.equals("item")) {
            ingredient = (ur)ingredients[0];
        } else {
            return;
        }
        for (TileEntitySlagFurnace.SmeltingResult sr2 : TileEntitySlagFurnace.SlagRecipes.smeltingResults) {
            if (ingredient != null && !ingredient.a(sr2.input)) continue;
            this.arecipes.add(new CachedSlagRecipe(sr2));
        }
    }

    public List handleItemTooltip(GuiRecipe gui, ur stack, List currenttip, int recipe) {
        int prob;
        if (stack == null) {
            return currenttip;
        }
        TileEntitySlagFurnace.SmeltingResult sr2 = ((CachedSlagRecipe)((Object)this.arecipes.get((int)recipe))).sr;
        float probability = 0.0f;
        float leftProb = 0.0f;
        float rightProb = 0.0f;
        int c = 0;
        if (sr2.output1 != null && stack.a(sr2.output1)) {
            leftProb = (float)((stack.a - 1) * 100) + sr2.prob1 * 100.0f;
            ++c;
        }
        if (sr2.output2 != null && stack.a(sr2.output2)) {
            rightProb = (float)((stack.a - 1) * 100) + sr2.prob2 * 100.0f;
            ++c;
        }
        if ((prob = (int)(leftProb + rightProb)) == 0) {
            return currenttip;
        }
        if (c == 2) {
            currenttip.add(prob + "% (both slots)");
        } else {
            currenttip.add(prob + "%");
        }
        return currenttip;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "slagging", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiSlag.class;
    }

    public String getRecipeName() {
        return "Slag Furnace";
    }

    public String getGuiTexture() {
        return "/factorization/texture/slagfurnacegui.png";
    }

    public String getOverlayIdentifier() {
        return "slagging";
    }

    class CachedSlagRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntitySlagFurnace.SmeltingResult sr;

        public CachedSlagRecipe(TileEntitySlagFurnace.SmeltingResult rs) {
            super((TemplateRecipeHandler)NEI_SlagRecipeConfig.this);
            this.sr = rs;
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.sr.input, 51, 6);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            int h = 11;
            int w2 = 109;
            ret.add(new PositionedStack((Object)this.sr.output2, w2, h));
            ret.add(new PositionedStack((Object)this.sr.output1, w2, h + 26));
            ur f = ((FurnaceRecipeHandler.FuelPair)FurnaceRecipeHandler.afuels.get((int)(NEI_SlagRecipeConfig.this.cycleticks / 48 % FurnaceRecipeHandler.afuels.size()))).stack.item;
            ret.add(new PositionedStack((Object)f, 51, 42));
            return ret;
        }
    }
}

