/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.client.gui.GuiMixer;
import factorization.common.FactorizationUtil;
import factorization.common.TileEntityMixer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.oredict.OreDictionary;

public class NEI_MixerRecipeConfig
extends TemplateRecipeHandler
implements IConfigureNEI {
    private ArrayList cache;

    public void loadConfig() {
        API.registerRecipeHandler((ICraftingHandler)this);
        API.registerUsageHandler((IUsageHandler)this);
    }

    public String getName() {
        return "factorization mixer recipes";
    }

    public String getVersion() {
        return "1";
    }

    public void loadCraftingRecipes(ur result) {
        for (TileEntityMixer.RecipeMatchInfo mr : this.getCache()) {
            if (result == null) {
                this.arecipes.add(new CachedMixerRecipe(mr));
                continue;
            }
            if (!result.a(mr.output)) continue;
            this.arecipes.add(new CachedMixerRecipe(mr));
        }
    }

    ArrayList getCache() {
        if (this.cache == null) {
            this.cache = TileEntityMixer.getRecipes();
        }
        return this.cache;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("mixing")) {
            this.loadCraftingRecipes(null);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(ur ingredient) {
        ArrayList<ur> items = new ArrayList<ur>();
        block0: for (TileEntityMixer.RecipeMatchInfo mr : this.getCache()) {
            if (ingredient == null) {
                this.arecipes.add(new CachedMixerRecipe(mr));
                continue;
            }
            for (Object o : mr.inputs) {
                items.clear();
                if (o instanceof ur) {
                    items.add((ur)o);
                } else if (o instanceof String) {
                    items.addAll(OreDictionary.getOres((String)((String)o)));
                } else if (o instanceof List) {
                    items.addAll((Collection)o);
                }
                for (ur item2 : items) {
                    if (!ingredient.a(item2)) continue;
                    this.arecipes.add(new CachedMixerRecipe(mr));
                    continue block0;
                }
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "mixing", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiMixer.class;
    }

    public String getRecipeName() {
        return "Mixer";
    }

    public String getGuiTexture() {
        return "/factorization/texture/mixer.png";
    }

    public String getOverlayIdentifier() {
        return "mixing";
    }

    class CachedMixerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntityMixer.RecipeMatchInfo recipe;

        public CachedMixerRecipe(TileEntityMixer.RecipeMatchInfo recipe) {
            super((TemplateRecipeHandler)NEI_MixerRecipeConfig.this);
            this.recipe = recipe;
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            int h = 14;
            int w2 = 33;
            switch (this.recipe.inputs.size()) {
                case 4: {
                    ret.add(new PositionedStack(this.recipe.inputs.get(3), w2 + 18, h + 18));
                }
                case 3: {
                    ret.add(new PositionedStack(this.recipe.inputs.get(2), w2, h + 18));
                }
                case 2: {
                    ret.add(new PositionedStack(this.recipe.inputs.get(1), w2, h));
                }
                case 1: {
                    ret.add(new PositionedStack(this.recipe.inputs.get(0), w2 + 18, h));
                }
            }
            w2 = 107;
            ArrayList<ur> output = new ArrayList<ur>();
            output.add(this.recipe.output);
            for (Object o : this.recipe.inputs) {
                ur cnt;
                ur is;
                if (!(o instanceof ur) || !(is = (ur)o).b().s() || (cnt = FactorizationUtil.normalize(is.b().getContainerItemStack(is))) == null) continue;
                output.add(cnt);
            }
            switch (output.size()) {
                default: {
                    ret.add(new PositionedStack(output.get(3), w2 + 18, h + 18));
                }
                case 3: {
                    ret.add(new PositionedStack(output.get(2), w2, h + 18));
                }
                case 2: {
                    ret.add(new PositionedStack(output.get(1), w2 + 18, h));
                }
                case 1: {
                    ret.add(new PositionedStack(output.get(0), w2, h));
                }
                case 0: 
            }
            return ret;
        }
    }
}

