/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.client.gui.GuiGrinder;
import factorization.common.TileEntityGrinder;
import java.awt.Rectangle;
import java.util.List;

public class NEI_GrinderRecipeConfig
extends TemplateRecipeHandler
implements IConfigureNEI {
    public void loadConfig() {
        API.registerRecipeHandler((ICraftingHandler)this);
        API.registerUsageHandler((IUsageHandler)this);
    }

    public String getName() {
        return "factorization grinder recipes";
    }

    public String getVersion() {
        return "1";
    }

    public void loadCraftingRecipes(ur result) {
        for (TileEntityGrinder.GrinderRecipe gr : TileEntityGrinder.recipes) {
            if (result != null && !result.a(gr.output)) continue;
            this.arecipes.add(new CachedGrinderRecipe(gr));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("grinding")) {
            this.loadCraftingRecipes(null);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(ur ingredient) {
        for (TileEntityGrinder.GrinderRecipe gr : TileEntityGrinder.recipes) {
            if (ingredient != null && !ingredient.a(gr.input)) continue;
            this.arecipes.add(new CachedGrinderRecipe(gr));
        }
    }

    public List handleItemTooltip(GuiRecipe gui, ur stack, List currenttip, int recipe) {
        if (stack == null) {
            return currenttip;
        }
        TileEntityGrinder.GrinderRecipe gr = ((CachedGrinderRecipe)((Object)this.arecipes.get((int)recipe))).gr;
        float prob = 0.0f;
        if (gr.output != null && stack.a(gr.output)) {
            prob = (float)((stack.a - 1) * 100) + gr.probability * 100.0f;
        }
        if (prob != 0.0f) {
            currenttip.add((int)prob + "%");
        }
        return currenttip;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "grinding", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiGrinder.class;
    }

    public String getRecipeName() {
        return "Grinder";
    }

    public String getGuiTexture() {
        return "/factorization/texture/grinder.png";
    }

    public String getOverlayIdentifier() {
        return "grinding";
    }

    class CachedGrinderRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntityGrinder.GrinderRecipe gr;

        CachedGrinderRecipe(TileEntityGrinder.GrinderRecipe gr) {
            super((TemplateRecipeHandler)NEI_GrinderRecipeConfig.this);
            this.gr = gr;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.gr.output, 111, 24);
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.gr.input, 51, 24);
        }
    }
}

