/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.client.gui.GuiCrystallizer;
import factorization.common.Core;
import factorization.common.TileEntityCrystallizer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class NEI_CrystallizerRecipeConfig
extends TemplateRecipeHandler
implements IConfigureNEI {
    public void loadConfig() {
        API.registerRecipeHandler((ICraftingHandler)this);
        API.registerUsageHandler((IUsageHandler)this);
    }

    public String getName() {
        return "factorization crystallizer recipes";
    }

    public String getVersion() {
        return "1";
    }

    public void loadCraftingRecipes(ur result) {
        for (TileEntityCrystallizer.CrystalRecipe cr : TileEntityCrystallizer.recipes) {
            if (result != null && !result.a(cr.output)) continue;
            this.arecipes.add(new CachedCrystallizerRecipe(cr));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crystallizing")) {
            this.loadCraftingRecipes(null);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(ur ingredient) {
        for (TileEntityCrystallizer.CrystalRecipe cr : TileEntityCrystallizer.recipes) {
            if (ingredient != null && !ingredient.a(cr.input) && (ingredient.b() != Core.registry.inverium || cr.inverium_count <= 0) && !ingredient.a(cr.solution)) continue;
            this.arecipes.add(new CachedCrystallizerRecipe(cr));
        }
    }

    public List handleItemTooltip(GuiRecipe gui, ur stack, List currenttip, int recipe) {
        if (stack == null) {
            return currenttip;
        }
        TileEntityCrystallizer.CrystalRecipe cr = ((CachedCrystallizerRecipe)((Object)this.arecipes.get((int)recipe))).cr;
        if (stack.a(cr.output)) {
            float prob = cr.output_count * 100.0f;
            if (prob == 100.0f) {
                // empty if block
            }
            currenttip.add((int)prob + "%");
        }
        if (stack.a(cr.solution)) {
            currenttip.add("Does not get used up");
        }
        if (stack.a(cr.input)) {
            currenttip.add("Extra copies of this can be added");
            currenttip.add("to the other slots to increase yield");
        }
        return currenttip;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(98, 78, 32, 16), "crystallizing", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiCrystallizer.class;
    }

    public String getRecipeName() {
        return "Crystallizer";
    }

    public String getGuiTexture() {
        return "/factorization/texture/crystal.png";
    }

    public String getOverlayIdentifier() {
        return "crystallizing";
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName(this.getGuiTexture());
        gui.drawTexturedModalRect(0, 15, 5, 11, 166, 95);
    }

    public int recipiesPerPage() {
        return 1;
    }

    class CachedCrystallizerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntityCrystallizer.CrystalRecipe cr;

        public CachedCrystallizerRecipe(TileEntityCrystallizer.CrystalRecipe cr) {
            super((TemplateRecipeHandler)NEI_CrystallizerRecipeConfig.this);
            this.cr = cr;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.cr.output, 75, 44);
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            ret.add(new PositionedStack((Object)this.cr.input, 75, 17));
            if (this.cr.inverium_count > 0) {
                ur inverium = new ur((up)Core.registry.inverium, this.cr.inverium_count);
                ret.add(new PositionedStack((Object)inverium, 103, 59));
                ret.add(new PositionedStack((Object)this.cr.solution, 47, 59));
            } else {
                ret.add(new PositionedStack((Object)this.cr.solution, 75, 73));
            }
            return ret;
        }
    }
}

