/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.api.Quaternion;
import factorization.fzds.Range;
import net.minecraftforge.common.ForgeDirection;

public class RotatedBB
extends aoe {
    Quaternion rotation;
    aoe basis;
    ForgeDirection[] axes = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST};
    private static ThreadLocal vertexBuffer = new ThreadLocal(){

        protected aoj[] initialValue() {
            aoj[] ret = new aoj[8];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = aoj.a((double)0.0, (double)0.0, (double)0.0);
            }
            return ret;
        }
    };

    protected RotatedBB() {
        super(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void set(Quaternion rotation, aoe basis) {
        this.rotation = rotation;
        this.basis = basis;
    }

    public double a(aoe collider, double deltaX) {
        return super.a(collider, deltaX);
    }

    public double b(aoe collider, double deltaY) {
        return super.b(collider, deltaY);
    }

    public double c(aoe collider, double deltaZ) {
        return super.c(collider, deltaZ);
    }

    public boolean a(aoe other) {
        ForgeDirection dir;
        int i;
        for (i = 0; i < this.axes.length; ++i) {
            Range otherNative;
            dir = this.axes[i];
            Range thisConverted = this.project(dir);
            if (thisConverted.intersects(otherNative = RotatedBB.getUnalteredRange(other, dir))) continue;
            return false;
        }
        for (i = 0; i < this.axes.length; ++i) {
            Range thisNative;
            dir = this.axes[i];
            Range otherConverted = RotatedBB.project(other, dir, this.rotation);
            if (otherConverted.intersects(thisNative = RotatedBB.getUnalteredRange(this.basis, dir))) continue;
            return false;
        }
        return true;
    }

    private static void set(aoj v, double x, double y2, double z) {
        v.c = x;
        v.d = y2;
        v.e = z;
    }

    private static void yoink(aoj[] ret, int i, int X, int Y, int Z) {
        RotatedBB.set(ret[i], ret[X].c, ret[Y].d, ret[Z].e);
    }

    static aoj[] getAabbVertices(aoe ab) {
        aoj[] ret = (aoj[])vertexBuffer.get();
        RotatedBB.set(ret[0], ab.a, ab.b, ab.c);
        RotatedBB.set(ret[1], ab.d, ab.e, ab.f);
        RotatedBB.yoink(ret, 2, 1, 0, 0);
        RotatedBB.yoink(ret, 3, 0, 1, 0);
        RotatedBB.yoink(ret, 4, 0, 0, 1);
        RotatedBB.yoink(ret, 5, 0, 1, 1);
        RotatedBB.yoink(ret, 6, 1, 0, 1);
        RotatedBB.yoink(ret, 7, 1, 1, 0);
        return ret;
    }

    private Range project(ForgeDirection dir) {
        Range range = new Range();
        aoj[] verts = RotatedBB.getAabbVertices(this);
        for (int i = 0; i < verts.length; ++i) {
            aoj v = verts[i];
            this.rotation.applyRotation(v);
            range.include(v, dir);
        }
        return range;
    }

    private static Range project(aoe bb, ForgeDirection dir, Quaternion rotation) {
        Range range = new Range();
        aoj[] verts = RotatedBB.getAabbVertices(bb);
        rotation.incrConjugate();
        for (int i = 0; i < verts.length; ++i) {
            aoj v = verts[i];
            rotation.applyRotation(v);
            range.include(v, dir);
        }
        rotation.incrConjugate();
        return range;
    }

    private static Range getUnalteredRange(aoe aabb, ForgeDirection dir) {
        switch (dir) {
            case EAST: 
            case WEST: {
                return new Range(aabb.a, aabb.d);
            }
            case UP: 
            case DOWN: {
                return new Range(aabb.b, aabb.e);
            }
            case NORTH: 
            case SOUTH: {
                return new Range(aabb.c, aabb.f);
            }
        }
        return null;
    }
}

