/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class RenderDimensionSliceEntity
extends bbv
implements IScheduledTickHandler {
    public static int update_frequency = 16;
    public static RenderDimensionSliceEntity instance;
    private Set renderInfoTracker = new HashSet();
    private static long megatickCount;
    public static int nest;
    EnumSet renderTicks = EnumSet.of(TickType.RENDER);

    public RenderDimensionSliceEntity() {
        instance = this;
    }

    static void checkGLError(String op) {
        int var2 = GL11.glGetError();
        if (var2 != 0) {
            String var3 = GLU.gluErrorString((int)var2);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + op);
            System.out.println(var2 + ": " + var3);
        }
    }

    static void markBlocksForUpdate(DimensionSliceEntity dse, int lx, int ly, int lz, int hx, int hy, int hz) {
        if (dse.renderInfo == null) {
            RenderDimensionSliceEntity renderDimensionSliceEntity = instance;
            ((Object)((Object)renderDimensionSliceEntity)).getClass();
            dse.renderInfo = renderDimensionSliceEntity.new DSRenderInfo(dse);
        }
        DSRenderInfo renderInfo = (DSRenderInfo)dse.renderInfo;
        for (int i = 0; i < renderInfo.renderers.length; ++i) {
            baj wr2 = renderInfo.renderers[i];
            if (!FactorizationUtil.intersect(lx, lx, wr2.c, wr2.c + 16) || !FactorizationUtil.intersect(ly, ly, wr2.d, wr2.d + 16) || !FactorizationUtil.intersect(lz, lz, wr2.e, wr2.e + 16)) continue;
            wr2.f();
        }
    }

    DSRenderInfo getRenderInfo(DimensionSliceEntity dse) {
        if (dse.renderInfo == null) {
            dse.renderInfo = new DSRenderInfo(dse);
        }
        return (DSRenderInfo)dse.renderInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(lq ent, double x, double y2, double z, float yaw, float partialTicks) {
        if (ent.L) {
            return;
        }
        if (ent.ab < 5) {
            return;
        }
        if (nest > 3) {
            return;
        }
        DimensionSliceEntity dse = (DimensionSliceEntity)ent;
        DSRenderInfo renderInfo = this.getRenderInfo(dse);
        if (nest == 0) {
            Core.profileStart("fzds");
            RenderDimensionSliceEntity.checkGLError("FZDS before render -- somebody left a mess!");
            renderInfo.lastRenderInMegaticks = megatickCount;
        } else if (nest == 1) {
            Core.profileStart("recursion");
        }
        ++nest;
        try {
            if (nest == 1) {
                Core.profileStart("build");
                Hammer.proxy.setShadowWorld();
                try {
                    renderInfo.update();
                }
                finally {
                    Hammer.proxy.restoreRealWorld();
                    Core.profileEnd();
                }
            }
            GL11.glPushMatrix();
            try {
                float pdx = (float)((dse.t - dse.T) * (double)partialTicks);
                float pdy = (float)((dse.u - dse.U) * (double)partialTicks);
                float pdz = (float)((dse.v - dse.V) * (double)partialTicks);
                GL11.glTranslatef((float)((float)x), (float)((float)y2), (float)((float)z));
                Quaternion rotation = dse.getRotation();
                if (!rotation.isZero()) {
                    Quaternion quat = rotation.add(dse.prevTickRotation);
                    quat.incrScale(0.5);
                    aoj vec = aoj.a((double)quat.x, (double)quat.y, (double)quat.z);
                    vec = vec.a();
                    double angle = Math.toDegrees(quat.setVector(vec));
                    GL11.glRotatef((float)((float)angle), (float)((float)vec.c), (float)((float)vec.d), (float)((float)vec.e));
                }
                GL11.glTranslatef((float)((float)(-dse.centerOffset.c)), (float)((float)(-dse.centerOffset.d)), (float)((float)(-dse.centerOffset.e)));
                if (dse.scale != 1.0f) {
                    GL11.glScalef((float)dse.scale, (float)dse.scale, (float)dse.scale);
                }
                if (dse.opacity != 1.0f) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)dse.opacity);
                }
                renderInfo.renderTerrain();
                RenderDimensionSliceEntity.checkGLError("FZDS terrain display list render");
                GL11.glTranslatef((float)((float)(dse.t - x)), (float)((float)(dse.u - y2)), (float)((float)(dse.v - z)));
                Coord c = dse.getCorner();
                GL11.glTranslatef((float)(-c.x), (float)(-c.y), (float)(-c.z));
                if (nest == 1) {
                    Hammer.proxy.setShadowWorld();
                    try {
                        renderInfo.renderEntities(partialTicks);
                    }
                    finally {
                        Hammer.proxy.restoreRealWorld();
                    }
                } else {
                    renderInfo.renderEntities(partialTicks);
                }
                RenderDimensionSliceEntity.checkGLError("FZDS entity render");
            }
            finally {
                if (dse.opacity != 1.0f) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GL11.glPopMatrix();
            }
        }
        catch (Exception e) {
            System.err.println("FZDS failed to render");
            e.printStackTrace(System.err);
        }
        finally {
            if (--nest == 0) {
                RenderDimensionSliceEntity.checkGLError("FZDS after render");
                Core.profileEnd();
            } else if (nest == 1) {
                Core.profileEnd();
            }
        }
    }

    void discardOldRenderLists() {
        Iterator it = this.renderInfoTracker.iterator();
        while (it.hasNext()) {
            DSRenderInfo renderInfo = (DSRenderInfo)it.next();
            if (renderInfo.lastRenderInMegaticks >= megatickCount - 1L) continue;
            renderInfo.discardRenderList();
            it.remove();
        }
    }

    @ForgeSubscribe
    public void worldChanged(WorldEvent.Unload unloadEvent) {
        megatickCount += 100L;
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        ++megatickCount;
        if (nest != 0) {
            nest = 0;
            Core.logFine("FZDS render nesting depth was not 0", new Object[0]);
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        this.discardOldRenderLists();
    }

    public EnumSet ticks() {
        return this.renderTicks;
    }

    public String getLabel() {
        return "fzdsRenderDealloc";
    }

    public int nextTickSpacing() {
        return 20;
    }

    static /* synthetic */ long access$000() {
        return megatickCount;
    }

    static {
        megatickCount = 0L;
        nest = 0;
    }

    class DSRenderInfo {
        private final int wr_display_list_size = 3;
        final int entity_buffer = 8;
        int renderCounts = 0;
        long lastRenderInMegaticks = RenderDimensionSliceEntity.access$000();
        boolean dirty = false;
        private int renderList = -1;
        private baj[] renderers = null;
        Coord corner;
        Coord far;
        DimensionSliceEntity dse;
        int xSize;
        int ySize;
        int zSize;
        int xSizeChunk;
        int ySizeChunk;
        int zSizeChunk;
        int cubicChunkCount;
        int last_update_index = 0;
        int render_skips = 0;

        public DSRenderInfo(DimensionSliceEntity dse) {
            this.dse = dse;
            this.corner = dse.getCorner();
            this.far = dse.getFarCorner();
            this.xSize = this.far.x - this.corner.x;
            this.ySize = this.far.y - this.corner.y;
            this.zSize = this.far.z - this.corner.z;
            this.xSizeChunk = this.xSize / 16;
            this.ySizeChunk = this.ySize / 16;
            this.zSizeChunk = this.zSize / 16;
            int xzSizeChunk = this.xSizeChunk * this.zSizeChunk;
            this.cubicChunkCount = (1 + this.xSizeChunk) * (1 + this.ySizeChunk) * (1 + this.zSizeChunk);
            this.renderers = new baj[this.cubicChunkCount];
            int i = 0;
            RenderDimensionSliceEntity.checkGLError("FZDS before render");
            for (int y2 = 0; y2 <= this.ySizeChunk; ++y2) {
                for (int x = 0; x <= this.xSizeChunk; ++x) {
                    for (int z = 0; z <= this.zSizeChunk; ++z) {
                        this.renderers[i] = new baj(this.corner.w, this.corner.w.g, this.corner.x + x * 16, this.corner.y + y2 * 16, this.corner.z + z * 16, this.getRenderList() + i * 3);
                        this.renderers[i].i = x * 16;
                        this.renderers[i].j = y2 * 16;
                        this.renderers[i].k = z * 16;
                        this.renderers[i].f();
                        RenderDimensionSliceEntity.checkGLError("FZDS WorldRenderer init");
                        ++i;
                    }
                }
            }
            assert (i == this.cubicChunkCount);
        }

        void update() {
            Core.profileStart("update");
            RenderDimensionSliceEntity.checkGLError("FZDS before WorldRender update");
            while (this.last_update_index < this.renderers.length) {
                baj wr2 = this.renderers[this.last_update_index];
                if (wr2.q) {
                    wr2.a();
                    ++this.last_update_index;
                    break;
                }
                ++this.last_update_index;
            }
            if (this.last_update_index == this.renderers.length) {
                this.last_update_index = 0;
            }
            Core.profileEnd();
        }

        void renderTerrain() {
            arw.a();
            Minecraft.x();
            if (Minecraft.u() && Core.dimension_slice_allow_smooth) {
                GL11.glShadeModel((int)7425);
            }
            GL11.glPushAttrib((int)16384);
            for (int pass = 0; pass < 2; ++pass) {
                if (pass == 1) {
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glEnable((int)3042);
                }
                for (int i = 0; i < this.renderers.length; ++i) {
                    baj wr2 = this.renderers[i];
                    wr2.l = true;
                    int displayList = wr2.a(pass);
                    if (displayList < 0) continue;
                    RenderDimensionSliceEntity.this.a("/terrain.png");
                    GL11.glCallList((int)displayList);
                }
            }
            GL11.glPopAttrib();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderEntities(float partialTicks) {
            arw.b();
            double sx = bdw.a.j;
            double sy = bdw.a.k;
            double sz = bdw.a.l;
            try {
                int xwidth = this.far.x - this.corner.x;
                int height = this.far.y - this.corner.y;
                int zwidth = this.far.z - this.corner.z;
                for (int cdx = 0; cdx < xwidth; ++cdx) {
                    for (int cdz = 0; cdz < zwidth; ++cdz) {
                        zz here = this.corner.w.d(this.corner.x + cdx * 16, this.corner.z + cdz * 16);
                        for (int i1 = 0; i1 < here.j.length; ++i1) {
                            List ents = here.j[i1];
                            for (int i2 = 0; i2 < ents.size(); ++i2) {
                                lq e = (lq)ents.get(i2);
                                if (e.u < (double)(this.corner.y - 8) || e.u > (double)(this.far.y + 8) || nest == 3 && e instanceof DimensionSliceEntity) continue;
                                bbu.a.a(e, partialTicks);
                            }
                        }
                        for (any te : here.i.values()) {
                            bdw.a.j = te.l;
                            bdw.a.k = te.m;
                            bdw.a.l = te.n;
                            bdw.a.a(te, partialTicks);
                        }
                    }
                }
            }
            finally {
                bdw.a.j = sx;
                bdw.a.k = sy;
                bdw.a.l = sz;
            }
        }

        int getRenderList() {
            if (this.renderList == -1) {
                this.renderList = arx.a((int)(3 * this.cubicChunkCount));
                RenderDimensionSliceEntity.this.renderInfoTracker.add(this);
                if (this.renderList == -1) {
                    Core.logWarning("GL display list allocation failed!", new Object[0]);
                }
            }
            return this.renderList;
        }

        void discardRenderList() {
            if (this.renderList != -1) {
                arx.b((int)this.renderList);
                this.renderList = -1;
            }
            this.dse.renderInfo = null;
        }
    }
}

