/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.Mod;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.common.Core;
import factorization.fzds.DeltaChunk;
import factorization.fzds.Hammer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.Property;

public class HammerInfo {
    File worldConfigFile = null;
    Configuration channelConfig;
    Configuration worldState;
    private int unsaved_allocations = 0;
    private boolean channel_config_dirty = false;
    boolean world_loaded = false;
    HashMap channel2category = new HashMap();
    private static final int defaultPadding = 128;
    private static final String channelsCategory = "channels";

    void setConfigFile(File f) {
        this.channelConfig = new Configuration(f);
    }

    void loadGlobalConfig() {
        if (this.worldState != null) {
            return;
        }
        in world = DimensionManager.getWorld((int)Hammer.dimensionID);
        this.world_loaded = true;
        File saveDir = world.getChunkSaveLocation();
        saveDir = saveDir.getAbsoluteFile();
        this.worldConfigFile = new File(saveDir, "hammer.state");
        this.worldState = new Configuration(this.worldConfigFile);
        this.saveChannelConfig();
    }

    public int makeChannelFor(Object modInstance, String channelId, int default_channel, int padding, String comment) {
        if (padding < 0) {
            padding = 128;
        }
        if (this.channelConfig == null) {
            throw new IllegalArgumentException("Tried to register channel too early");
        }
        Core.logFine("Allocating Hammer channel for %s: %s", modInstance, comment);
        Class<?> c = modInstance.getClass();
        Mod a = c.getAnnotation(Mod.class);
        if (a == null) {
            throw new IllegalArgumentException("modInstance is not a mod");
        }
        Mod info = c.getAnnotation(Mod.class);
        String modCategory = (info.modid() + "." + channelId).toLowerCase();
        int max = default_channel;
        boolean collision = false;
        for (Map.Entry entry : this.channelConfig.categories.entrySet()) {
            ConfigCategory cat;
            if (((String)entry.getKey()).equals(modCategory) || !(cat = (ConfigCategory)entry.getValue()).containsKey("channel")) continue;
            int here_chan = this.channelConfig.get((String)entry.getKey(), "channel", -1).getInt();
            max = Math.max(max, here_chan);
            if (here_chan != default_channel) continue;
            collision = true;
        }
        if (collision) {
            int newDefault = max + 1;
            Core.logFine("Default channel ID for %s (%s) was already taken, using %s", modCategory, default_channel, newDefault);
            default_channel = newDefault;
        }
        this.channelConfig.addCustomCategoryComment(modCategory, comment);
        int channelRet = this.channelConfig.get(modCategory, "channel", default_channel).getInt();
        padding = this.channelConfig.get(modCategory, "padding", padding).getInt();
        if (this.world_loaded) {
            this.saveChannelConfig();
        } else {
            this.channel_config_dirty = true;
        }
        this.channel2category.put(channelRet, this.channelConfig.getCategory(modCategory));
        return channelRet;
    }

    public int getPaddingForChannel(int channel) {
        ConfigCategory cat = (ConfigCategory)this.channel2category.get(channel);
        Property prop = cat.get("padding");
        int ret = prop.getInt(128);
        return ret;
    }

    Coord takeCell(int channel, DeltaCoord size) {
        this.loadGlobalConfig();
        Property chanAllocs = this.worldState.get("allocations", "channel" + channel, 0);
        int start = chanAllocs.getInt(0);
        int add = size.x + this.getPaddingForChannel(channel);
        chanAllocs.value = Integer.toString(start + add);
        Coord ret = new Coord(DeltaChunk.getServerShadowWorld(), start, 16, channel * 800);
        this.dirtyCellAllocations();
        return ret;
    }

    public void setAllocationCount(int channel, int count) {
        if (channel != 0) {
            throw new IllegalArgumentException("Non-zero channels not yet implemented");
        }
        ConfigCategory cat = (ConfigCategory)this.channel2category.get(channel);
        cat.get((String)"allocated").value = Integer.toString(count);
        this.saveCellAllocations();
    }

    File getWorldSaveFile() {
        yc hammerWorld = DeltaChunk.getServerShadowWorld();
        File base = new File(hammerWorld.J().g());
        return new File(base, "deltaChunk.cfg");
    }

    public void dirtyCellAllocations() {
        if (this.unsaved_allocations == 0) {
            this.saveCellAllocations();
        }
        ++this.unsaved_allocations;
    }

    public void saveCellAllocations() {
        if (this.channel_config_dirty) {
            this.channelConfig.save();
            this.channel_config_dirty = false;
        }
        if (this.worldState == null) {
            return;
        }
        this.worldState.save();
        this.unsaved_allocations = 0;
    }

    public void saveChannelConfig() {
        this.channelConfig.save();
    }
}

