/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.common.Core;
import factorization.common.WeakSet;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.DseCollider;
import factorization.fzds.DseRayTarget;
import factorization.fzds.FZDSCommand;
import factorization.fzds.HammerInfo;
import factorization.fzds.HammerNet;
import factorization.fzds.HammerProxy;
import factorization.fzds.HammerWorldProvider;
import factorization.fzds.Packet220FzdsWrap;
import factorization.fzds.api.IDeltaChunk;
import java.io.File;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="factorization.dimensionalSlice", name="Factorization Dimensional Slices", version="0.7.21", dependencies="required-after: factorization")
@NetworkMod(clientSideRequired=true, tinyPacketHandler=HammerNet.class)
public class Hammer {
    final String[] Lore = new String[]{"At twilight's end, the shadow's crossed,", "A new world birthed, the elder lost.", "Yet on the morn we wake to find", "That mem'ry left so far behind.", "To deafened ears we ask, unseen,", "\u201cWhich is life and which the dream?\u201d"};
    public static final String modId = "factorization.dimensionalSlice";
    public static final String name = "Factorization Dimensional Slices";
    public static Hammer instance;
    @SidedProxy(clientSide="factorization.fzds.HammerClientProxy", serverSide="factorization.fzds.HammerProxy")
    public static HammerProxy proxy;
    public static boolean enabled;
    public static int dimensionID;
    public static yc worldClient;
    public static double DSE_ChunkUpdateRangeSquared;
    public static int fzds_command_channel;
    static Set serverSlices;
    static Set clientSlices;
    private static final EnumSet serverTicks;
    static final HammerInfo hammerInfo;
    static final int channelWidth = 800;

    public Hammer() {
        instance = this;
    }

    @Mod.PreInit
    public void setup(FMLPreInitializationEvent event) {
        event.getModMetadata().parent = "factorization";
        enabled = Core.enable_dimension_slice;
        if (!enabled) {
            return;
        }
        EntityRegistry.registerModEntity(DimensionSliceEntity.class, (String)"fzds", (int)1, (Object)this, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(DseCollider.class, (String)"fzdsC", (int)2, (Object)this, (int)64, (int)80000, (boolean)false);
        dimensionID = Core.dimension_slice_dimid;
        DimensionManager.registerProviderType((int)dimensionID, HammerWorldProvider.class, (boolean)true);
        DimensionManager.registerDimension((int)dimensionID, (int)dimensionID);
        File base = event.getSuggestedConfigurationFile().getParentFile();
        hammerInfo.setConfigFile(new File(base, "hammerChannels.cfg"));
        fzds_command_channel = hammerInfo.makeChannelFor(this, "cmd", fzds_command_channel, -1, "This channel is used for Slices created using the /fzds command");
        ef.a((int)220, (boolean)true, (boolean)true, Packet220FzdsWrap.class);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            proxy.clientInit();
            NetworkRegistry.instance().registerConnectionHandler(new IConnectionHandler(){

                public void playerLoggedIn(Player player, eg netHandler, ce manager) {
                }

                public String connectionReceived(it netHandler, ce manager) {
                    return null;
                }

                public void connectionOpened(eg netClientHandler, MinecraftServer server, ce manager) {
                }

                public void connectionOpened(eg netClientHandler, String server, int port, ce manager) {
                }

                public void connectionClosed(ce manager) {
                    proxy.clientLogout(manager);
                }

                public void clientLoggedIn(eg clientHandler, ce manager, dw login) {
                    proxy.clientLogin(clientHandler, manager, login);
                }
            });
            TickRegistry.registerTickHandler((ITickHandler)new ITickHandler(){
                EnumSet clientTick = EnumSet.of(TickType.CLIENT);

                public EnumSet ticks() {
                    return this.clientTick;
                }

                public void tickStart(EnumSet type, Object ... tickData) {
                    proxy.checkForWorldChange();
                }

                public void tickEnd(EnumSet type, Object ... tickData) {
                    proxy.runShadowTick();
                }

                public String getLabel() {
                    return "FZ Hammer client tick";
                }
            }, (Side)Side.CLIENT);
        }
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new IScheduledTickHandler(){

            public EnumSet ticks() {
                return serverTicks;
            }

            public String getLabel() {
                return "FZDS save info";
            }

            public int nextTickSpacing() {
                return 100;
            }

            public void tickStart(EnumSet type, Object ... tickData) {
            }

            public void tickEnd(EnumSet type, Object ... tickData) {
                hammerInfo.saveCellAllocations();
            }
        }, (Side)Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)hammerInfo);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new DseRayTarget.ClickHandler());
        }
    }

    @Mod.ServerStarting
    public void setMainServerThread(FMLServerStartingEvent event) {
        if (!enabled) {
            return;
        }
        event.registerServerCommand((y)new FZDSCommand());
        DimensionManager.initDimension((int)dimensionID);
        assert (DimensionManager.shouldLoadSpawn((int)dimensionID));
        in hammerWorld = DimensionManager.getWorld((int)dimensionID);
        hammerWorld.a(new yi(){
            Coord center = new Coord(DeltaChunk.getClientShadowWorld(), 0, 0, 0);

            public void a(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
            }

            public void b(lq var1) {
            }

            public void a(String var1, double var2, double var4, double var6, float var8, float var9) {
            }

            public void a(String var1, int var2, int var3, int var4) {
            }

            public void a(qx var1, int var2, int var3, int var4, int var5, int var6) {
            }

            public void a(lq var1) {
            }

            public void a(int lx, int ly, int lz, int hx, int hy, int hz) {
                this.markBlocksForUpdate(lx, ly, lz, hx, hy, hz);
            }

            public void a(int x, int y2, int z) {
                this.markBlocksForUpdate(x, y2, z, x, y2, z);
            }

            public void b(int x, int y2, int z) {
                this.markBlocksForUpdate(x, y2, z, x, y2, z);
            }

            void markBlocksForUpdate(int lx, int ly, int lz, int hx, int hy, int hz) {
                Coord lower = new Coord(null, lx, ly, lz);
                Coord upper = new Coord(null, hx, hy, hz);
                yc realClientWorld = DeltaChunk.getClientRealWorld();
                Iterator it2 = DeltaChunk.getSlices(realClientWorld).iterator();
                while (it2.hasNext()) {
                    IDeltaChunk dse = (IDeltaChunk)((Object)it2.next());
                    if (dse.L) {
                        it2.remove();
                        continue;
                    }
                    if (!dse.getCorner().inside(lower, upper) && !dse.getFarCorner().inside(lower, upper)) continue;
                    dse.blocksChanged(lx, ly, lz);
                    dse.blocksChanged(hx, hy, hz);
                }
            }

            public void a(qx var1, String var2, double var3, double var5, double var7, float var9, float var10) {
            }

            public void b(int var1, int var2, int var3, int var4, int var5) {
            }

            public void a(int var1, int var2, int var3, int var4, int var5) {
            }
        });
        int view_distance = MinecraftServer.D().ad().o();
        DSE_ChunkUpdateRangeSquared = Math.pow(ik.a((int)view_distance) + 32, 2.0);
    }

    @Mod.ServerStopping
    public void saveInfo(FMLServerStoppingEvent event) {
        hammerInfo.saveCellAllocations();
        serverSlices.clear();
        clientSlices.clear();
    }

    public static aoj ent2vec(lq ent) {
        return ent.p.S().a(ent.t, ent.u, ent.v);
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        double desired_radius = 8.0;
        if (Core.force_max_entity_radius >= 0 && (double)Core.force_max_entity_radius < desired_radius) {
            desired_radius = Core.force_max_entity_radius;
            Core.logFine("Using %f as FZDS's maximum entity radius; this could cause failure to collide with FZDS entities", new Object[0]);
        }
        if (yc.MAX_ENTITY_RADIUS < desired_radius) {
            Core.logFine("Enlarging World.MAX_ENTITY_RADIUS from %f to %f", yc.MAX_ENTITY_RADIUS, desired_radius);
            Core.logFine("Please let the author know if this causes problems.", new Object[0]);
            yc.MAX_ENTITY_RADIUS = desired_radius;
        } else {
            Core.logFine("World.MAX_ENTITY_RADIUS was already set to %f, which is large enough for our purposes (%f)", yc.MAX_ENTITY_RADIUS, desired_radius);
        }
    }

    static {
        worldClient = null;
        DSE_ChunkUpdateRangeSquared = Math.pow(128.0, 2.0);
        fzds_command_channel = 0;
        serverSlices = new WeakSet();
        clientSlices = new WeakSet();
        serverTicks = EnumSet.of(TickType.SERVER);
        hammerInfo = new HammerInfo();
    }
}

