/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.Quaternion;
import factorization.common.Core;
import factorization.fzds.DSTeleporter;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.api.Caps;
import factorization.fzds.api.IDeltaChunk;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeDirection;

public class FZDSCommand
extends w {
    private static ArrayList subCommands = new ArrayList();
    public static SubCommand help;
    private static WeakReference currentSelection;
    private static Splitter comma;

    public String c() {
        return "fzds";
    }

    public int a() {
        return 2;
    }

    public static SubCommand add(SubCommand cmd, Requires ... reqs) {
        for (Requires r : reqs) {
            r.apply(cmd);
        }
        cmd.reqs = reqs;
        subCommands.add(cmd);
        return cmd;
    }

    public void b(aa sender, String[] args) {
        if (sender instanceof iq) {
            iq player = (iq)sender;
            boolean op = MinecraftServer.D().ad().e(player.bR);
            boolean cr = player.cd.d;
            if (!op && !cr) {
                sender.a("You must be op or in creative mode to use these commands");
                return;
            }
        }
        if (args.length == 0) {
            this.runCommand(help, sender, new String[]{"help"});
            return;
        }
        String cmd = args[0];
        for (SubCommand sc : subCommands) {
            for (String alias : sc.altNames) {
                if (!alias.equalsIgnoreCase(cmd)) continue;
                this.runCommand(sc, sender, args);
                return;
            }
        }
        sender.a("Not a command");
    }

    public static void setSelection(IDeltaChunk dse) {
        currentSelection = new WeakReference<IDeltaChunk>(dse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCommand(SubCommand cmd, aa sender, String[] args) {
        cmd.reset();
        cmd.setup(sender);
        ArrayList<String> cleanedArgs = new ArrayList<String>();
        for (String a : args) {
            if (Strings.isNullOrEmpty((String)a)) continue;
            if (a.startsWith("@")) {
                if (!cmd.op) {
                    throw new aq("You are not allowed to use arbitrary players", new Object[0]);
                }
                cmd.player = MinecraftServer.D().ad().f(a.substring(1));
                if (cmd.player != null) continue;
                throw new aq("Player not found", new Object[0]);
            }
            if (a.startsWith("#")) {
                if (!cmd.op) {
                    throw new aq("You are not allowed to use arbitrary locations", new Object[0]);
                }
                ArrayList<Integer> parts = new ArrayList<Integer>();
                for (String stupid : comma.split((CharSequence)a.substring(1))) {
                    parts.add(Integer.parseInt(stupid));
                }
                in w2 = DimensionManager.getWorld((int)((Integer)parts.get(0)));
                cmd.user = new Coord((yc)w2, (Integer)parts.get(1), (Integer)parts.get(2), (Integer)parts.get(3));
                continue;
            }
            cleanedArgs.add(a);
        }
        if (cmd.player != null) {
            cmd.user = new Coord((lq)cmd.player);
        }
        if (cmd.user != null) {
            cmd.world = cmd.user.w;
        }
        if (cmd.needPlayer && cmd.player == null) {
            throw new aq("No player specified", new Object[0]);
        }
        if (cmd.needCoord && cmd.user == null) {
            throw new aq("No coordinate specified", new Object[0]);
        }
        if (cmd.needOp && !cmd.op) {
            throw new aq("Insufficient permissions", new Object[0]);
        }
        if (cmd.needSelection && cmd.selected == null) {
            throw new aq("No DSE selected", new Object[0]);
        }
        cmd.arg0 = (String)cleanedArgs.remove(0);
        try {
            String[] sc = new String[cleanedArgs.size()];
            cmd.call(cleanedArgs.toArray(sc));
        }
        finally {
            cmd.reset();
        }
    }

    static String join(ArrayList cmd) {
        String ret = "";
        for (SubCommand sc : cmd) {
            ret = ret + " ";
            if (sc.help.length == 1) {
                ret = ret + sc.help[0];
                continue;
            }
            ret = ret + "(" + sc.help[0];
            for (int i = 1; i < sc.help.length; ++i) {
                ret = ret + " " + sc.help[i];
            }
            ret = ret + ")";
        }
        return ret;
    }

    private static String pick(String ... bits) {
        for (int i = 0; i < bits.length - 1; i += 2) {
            if (!bits[i].equalsIgnoreCase(bits[i + 1])) continue;
            return bits[i + 1];
        }
        return bits[bits.length - 1];
    }

    static {
        currentSelection = new WeakReference<Object>(null);
        comma = Splitter.on((String)",");
        help = FZDSCommand.add(new SubCommand(new String[]{"help", "[subcmd]+"}){

            @Override
            String details() {
                return "Gives a list of all subcommands, or information about the given subcommands";
            }

            @Override
            void call(String[] args) {
                boolean any2 = false;
                block0: for (String s2 : args) {
                    any2 = true;
                    for (SubCommand sc : subCommands) {
                        for (String alt : sc.altNames) {
                            if (!alt.equalsIgnoreCase(s2)) continue;
                            sc.arg0 = s2;
                            sc.sender = this.sender;
                            sc.inform();
                            if (sc == this) break block0;
                            sc.reset();
                            break block0;
                        }
                    }
                }
                if (any2) {
                    return;
                }
                ArrayList<SubCommand> good = new ArrayList<SubCommand>();
                for (SubCommand sc : subCommands) {
                    if (sc != this) {
                        sc.setup(this.sender);
                    }
                    if (sc.appropriate()) {
                        good.add(sc);
                    }
                    if (sc == this) continue;
                    sc.reset();
                }
                this.sender.a(FZDSCommand.join(good));
                this.sender.a("The commands need a Coord, DSE, or player.");
                this.sender.a("If these are not implicitly available, you can provide them using:");
                this.sender.a(" #worldId,x,y,z @PlayerName");
                this.sender.a("Best commands: cut goc leave drop");
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"go|gob|got"}){

            @Override
            String details() {
                return "Teleports player to the " + FZDSCommand.pick(new String[]{"gob", "bottom", "got", "top", "center"}) + " of the selection, in Hammerspace. Be ready to fly.";
            }

            @Override
            public void call(String[] args) {
                DSTeleporter tp = this.getTp();
                tp.destination = this.arg0.equalsIgnoreCase("gob") ? this.selected.getCorner() : (this.arg0.equalsIgnoreCase("got") ? this.selected.getFarCorner() : this.selected.getCenter());
                if (DimensionManager.getWorld((int)Core.dimension_slice_dimid) != this.player.p) {
                    manager.transferPlayerToDimension(this.player, Core.dimension_slice_dimid, (yq)tp);
                } else {
                    --tp.destination.x;
                    tp.destination.moveToTopBlock();
                    this.player.a((double)tp.destination.x + 0.5, (double)tp.destination.y, (double)tp.destination.z + 0.5);
                }
            }
        }, Requires.PLAYER, Requires.CREATIVE, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"enterhammer"}){

            @Override
            String details() {
                return "Teleports the player into hammerspace";
            }

            @Override
            void call(String[] args) {
                if (this.player.aq == Hammer.dimensionID) {
                    return;
                }
                DSTeleporter tp = this.getTp();
                tp.destination.set(DeltaChunk.getServerShadowWorld(), 0, 64, 0);
                manager.transferPlayerToDimension(this.player, Hammer.dimensionID, (yq)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"leave"}){

            @Override
            String details() {
                return "Teleports the player to the overworld";
            }

            @Override
            void call(String[] args) {
                DSTeleporter tp = this.getTp();
                in w2 = DimensionManager.getWorld((int)0);
                if (w2 == this.player.p) {
                    return;
                }
                s target = this.player.bZ();
                if (target == null) {
                    target = w2.H();
                }
                if (target != null) {
                    tp.destination.set(target);
                }
                manager.transferPlayerToDimension(this.player, 0, (yq)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"jump"}){

            @Override
            String details() {
                return "Warps player to the selection";
            }

            @Override
            void call(String[] args) {
                DSTeleporter tp = this.getTp();
                tp.destination = new Coord(this.selected);
                manager.transferPlayerToDimension(this.player, this.selected.aq, (yq)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"tome"}){

            @Override
            String details() {
                return "Warps selection to player";
            }

            @Override
            void call(String[] args) {
                this.selected.t = this.user.x;
                this.selected.u = this.user.y;
                this.selected.v = this.user.z;
            }
        }, Requires.COORD, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"cut|rcut|copy|rcopy", "x,y,z", "x,y,z"}){

            @Override
            String details() {
                return "Creates a Slice from the range given" + FZDSCommand.pick(new String[]{"rcut", ", relative to user's position", ""});
            }

            @Override
            void call(String[] args) {
                Coord base = this.arg0.equalsIgnoreCase("rcut") ? this.user.copy() : new Coord(this.user.w, 0, 0, 0);
                boolean copy = this.arg0.contains("copy");
                Coord low = base.add(DeltaCoord.parse(args[0]));
                Coord up2 = base.add(DeltaCoord.parse(args[1]));
                Coord.sort(low, up2);
                final Coord lower = low.copy();
                final Coord upper = up2.copy();
                Core.notify(null, lower, "Low", new String[0]);
                Core.notify(null, upper, "High", new String[0]);
                IDeltaChunk dse = DeltaChunk.makeSlice(Hammer.fzds_command_channel, lower, upper, new DeltaChunk.AreaMap(){

                    @Override
                    public void fillDse(DeltaChunk.DseDestination destination) {
                        Coord here = user.copy();
                        for (int x = lower.x; x <= upper.x; ++x) {
                            for (int y2 = lower.y; y2 <= upper.y; ++y2) {
                                for (int z = lower.z; z <= upper.z; ++z) {
                                    here.set(here.w, x, y2, z);
                                    destination.include(here);
                                }
                            }
                        }
                    }
                }, !copy);
                dse.permit(Caps.ROTATE).forbid(Caps.COLLIDE);
                dse.p.d((lq)dse);
                FZDSCommand.setSelection(dse);
            }
        }, Requires.COORD);
        FZDSCommand.add(new SubCommand(new String[]{"drop"}){

            @Override
            String details() {
                return "Returns a Slice's blocks to the world, destroying the Slice";
            }

            @Override
            void call(String[] args) {
                DeltaChunk.paste(this.selected, true);
                DeltaChunk.clear(this.selected);
                this.selected.x();
                FZDSCommand.setSelection(null);
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"paste"}){

            @Override
            String details() {
                return "Clones a Slice's blocks into the world";
            }

            @Override
            void call(String[] args) {
                DeltaChunk.paste(this.selected, true);
            }
        }, Requires.SELECTION, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"grass"}){

            @Override
            String details() {
                return "Places a grass block at the user's feet";
            }

            @Override
            void call(String[] args) {
                this.user.add(0, -1, 0).setId((amq)amq.x);
            }
        }, Requires.COORD, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"snap"}){

            @Override
            String details() {
                return "Rounds the Slice's position down to integers";
            }

            @Override
            void call(String[] args) {
                this.selected.t = (int)this.selected.t;
                this.selected.u = (int)this.selected.u;
                this.selected.v = (int)this.selected.v;
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"removeall"}){

            @Override
            String details() {
                return "Removes all Slices";
            }

            @Override
            void call(String[] args) {
                int i = 0;
                for (in w2 : MinecraftServer.D().c) {
                    for (lq ent : w2.e) {
                        if (!(ent instanceof DimensionSliceEntity)) continue;
                        ent.x();
                        ++i;
                    }
                }
                this.sender.a("Removed " + i);
            }
        }, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"selection"}){

            @Override
            String details() {
                return "Prints the selection";
            }

            @Override
            void call(String[] args) {
                this.sender.a("> " + (Object)((Object)this.selected));
                FZDSCommand.setSelection(this.selected);
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"rot?"}){

            @Override
            String details() {
                return "Gives the rotation & angular velocity of the selection";
            }

            @Override
            void call(String[] args) {
                this.sender.a("r = " + this.selected.getRotation());
                this.sender.a("\u03c9 = " + this.selected.getRotationalVelocity());
                if (!this.selected.can(Caps.ROTATE)) {
                    this.sender.a("(Does not have the ROTATE cap, so this is meaningless)");
                }
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"+|-"}){

            @Override
            String details() {
                return "Changes which (loaded) Slice is selected";
            }

            @Override
            void call(String[] args) {
                boolean add = this.arg0.equals("+");
                Iterator it2 = DeltaChunk.getSlices((yc)MinecraftServer.D().a(0)).iterator();
                IDeltaChunk first = null;
                IDeltaChunk prev = null;
                IDeltaChunk next = null;
                IDeltaChunk last = null;
                boolean found_current = false;
                while (it2.hasNext()) {
                    IDeltaChunk here = (IDeltaChunk)((Object)it2.next());
                    if (here.L) {
                        Core.logWarning((Object)((Object)here) + " was not removed", new Object[0]);
                        it2.remove();
                        continue;
                    }
                    last = here;
                    if (first == null) {
                        first = last;
                    }
                    if (!found_current) {
                        prev = last;
                    }
                    if (found_current && next == null) {
                        next = last;
                    }
                    if (last != this.selected) continue;
                    found_current = true;
                }
                if (first == null) {
                    this.sender.a("There are no DSEs loaded");
                    FZDSCommand.setSelection(null);
                    return;
                }
                this.selected = this.selected == null ? (add ? first : last) : (this.selected == last && add ? first : (this.selected == first && !add ? last : (add ? next : prev)));
                this.sender.a("> " + (Object)((Object)this.selected));
                FZDSCommand.setSelection(this.selected);
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"remove"}){

            @Override
            String details() {
                return "Destroys the selection";
            }

            @Override
            void call(String[] args) {
                this.selected.x();
                FZDSCommand.setSelection(null);
                this.sender.a("Made dead");
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"sr|sw", "angle\u00b0", "[direction=UP]"}){

            @Override
            String details() {
                return "Sets the Slice's rotation";
            }

            @Override
            void call(String[] args) {
                ForgeDirection dir;
                if (args.length != 2 && args.length != 1) {
                    throw new as();
                }
                if (!this.selected.can(Caps.ROTATE)) {
                    this.sender.a("Selection does not have the rotation cap");
                    return;
                }
                double theta = Math.toRadians(Double.parseDouble(args[0]));
                try {
                    dir = args.length == 2 ? ForgeDirection.valueOf((String)args[1].toUpperCase()) : ForgeDirection.UP;
                }
                catch (IllegalArgumentException e) {
                    String msg = "Direction must be:";
                    for (ForgeDirection d : ForgeDirection.values()) {
                        if (d == ForgeDirection.UNKNOWN) continue;
                        msg = msg + " " + d;
                    }
                    this.sender.a(msg);
                    return;
                }
                int derivative = -1;
                if (this.arg0.equalsIgnoreCase("sr")) {
                    derivative = 0;
                } else if (this.arg0.equalsIgnoreCase("sw")) {
                    derivative = 1;
                } else {
                    throw new as();
                }
                Quaternion toMod = derivative == 0 ? this.selected.getRotation() : this.selected.getRotationalVelocity();
                toMod.update(Quaternion.getRotationQuaternion(theta, dir));
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"d|v|r|w", "+|=", "[W=1]", "X", "Y", "Z"}){

            @Override
            String details() {
                return "Changes or sets displacement/velocity/rotation/angular_velocity";
            }

            @Override
            void call(String[] args) {
                char type = this.arg0.charAt(0);
                if (args.length != 4 && args.length != 5) {
                    if (type == 'd' || type == 'v') {
                        this.sender.a("Usage: /fzds d(isplacement)|v(elocity) +|= X Y Z");
                    }
                    if (type == 'r' || type == 'w') {
                        this.sender.a("Usage: /fzds r(otation)|w(rotational velocity) +|= [W=1] X Y Z (a quaternion; cmds sr & sw are simpler)");
                    }
                    return;
                }
                int i = 0;
                double w2 = 1.0;
                if (args.length == 5) {
                    w2 = Double.parseDouble(args[1]);
                    i = 1;
                }
                double x = Double.parseDouble(args[1 + i]);
                double y2 = Double.parseDouble(args[2 + i]);
                double z = Double.parseDouble(args[3 + i]);
                if (!(type != 'r' && type != 'w' || this.selected.can(Caps.ROTATE))) {
                    this.sender.a("Selection does not have the ROTATE cap");
                    return;
                }
                if (args[0].equals("+")) {
                    if (type == 'd' || type == 's') {
                        this.selected.b(this.selected.t + x, this.selected.u + y2, this.selected.v + z);
                    } else if (type == 'v') {
                        this.selected.g(x / 20.0, y2 / 20.0, z / 20.0);
                    } else if (type == 'r') {
                        this.selected.getRotation().incrAdd(new Quaternion(w2, x, y2, z));
                    } else if (type == 'w') {
                        this.selected.getRotationalVelocity().incrAdd(new Quaternion(w2, x, y2, z));
                    } else {
                        this.sender.a("Not a command?");
                    }
                } else if (args[0].equals("=")) {
                    if (type == 'd' || type == 's') {
                        this.selected.b(x, y2, z);
                    } else if (type == 'v') {
                        this.selected.w = 0.0;
                        this.selected.x = 0.0;
                        this.selected.y = 0.0;
                        this.selected.g(x / 20.0, y2 / 20.0, z / 20.0);
                    } else if (type == 'r') {
                        this.selected.setRotation(new Quaternion(w2, x, y2, z));
                    } else if (type == 'w') {
                        Quaternion omega = new Quaternion(w2, x, y2, z);
                        this.selected.setRotationalVelocity(omega);
                    } else {
                        this.sender.a("Not a command?");
                    }
                    this.selected.getRotation().incrNormalize();
                    this.selected.getRotationalVelocity().incrNormalize();
                } else {
                    this.sender.a("+ or =?");
                }
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"dirty"}){

            @Override
            String details() {
                return "[Moves the selection back and forth]";
            }

            @Override
            void call(String[] args) {
                this.selected.getRotationalVelocity().w *= -1.0;
                this.selected.getRotation().w *= -1.0;
                this.selected.getRotation().w += 0.1;
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"caps"}){

            @Override
            String details() {
                return "Lists the available Caps";
            }

            @Override
            void call(String[] args) {
                String r = "";
                for (Caps cap : Caps.values()) {
                    r = r + " " + (Object)((Object)cap);
                }
                this.sender.a(r);
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"cap?"}){

            @Override
            String details() {
                return "Lists the Caps enabled on the selection";
            }

            @Override
            void call(String[] args) {
                String r = "";
                for (Caps cap : Caps.values()) {
                    if (!this.selected.can(cap)) continue;
                    r = r + " " + (Object)((Object)cap);
                }
                this.sender.a(r);
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"cap+|cap-", "CAP+"}){

            @Override
            String details() {
                return "Gives or takes away Caps. May cause client desyncing.";
            }

            @Override
            void call(String[] args) {
                for (String a : args) {
                    Caps cap = Caps.valueOf(a);
                    if (this.arg0.equalsIgnoreCase("cap+")) {
                        this.selected.permit(cap);
                        continue;
                    }
                    this.selected.forbid(cap);
                }
            }
        }, Requires.SELECTION, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"scale", "newscale"}){

            @Override
            void call(String[] args) {
                if (!this.selected.can(Caps.SCALE)) {
                    this.sender.a("Selection doesn't have the SCALE cap");
                    return;
                }
                ((DimensionSliceEntity)this.selected).scale = Float.parseFloat(args[0]);
            }
        }, Requires.SELECTION, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"alpha", "newOpacity"}){

            @Override
            void call(String[] args) {
                if (!this.selected.can(Caps.TRANSPARENT)) {
                    this.sender.a("Selection doesn't have the TRANSPARENT cap");
                    return;
                }
                ((DimensionSliceEntity)this.selected).opacity = Float.parseFloat(args[0]);
            }
        }, Requires.SELECTION, Requires.CREATIVE);
    }

    public static enum Requires {
        OP,
        PLAYER,
        COORD,
        SELECTION,
        CREATIVE;


        void apply(SubCommand sc) {
            switch (this) {
                case OP: {
                    sc.needOp = true;
                    break;
                }
                case PLAYER: {
                    sc.needPlayer = true;
                    break;
                }
                case COORD: {
                    sc.needCoord = true;
                    break;
                }
                case SELECTION: {
                    sc.needSelection = true;
                    break;
                }
                case CREATIVE: {
                    sc.needCreative = true;
                }
            }
        }
    }

    public static abstract class SubCommand {
        String[] help;
        ArrayList altNames = new ArrayList();
        private boolean needOp;
        private boolean needPlayer;
        private boolean needCoord;
        private boolean needSelection;
        private boolean needCreative;
        Requires[] reqs;
        private static Splitter pipe = Splitter.on((char)'|');
        static gm manager = MinecraftServer.a((MinecraftServer)MinecraftServer.D());
        String arg0;
        aa sender;
        iq player;
        yc world;
        Coord user;
        boolean op;
        boolean creative;
        IDeltaChunk selected;

        public SubCommand(String ... help) {
            this.help = help;
            if (help.length == 0) {
                throw new IllegalArgumentException("No subcommand name");
            }
            for (String s2 : pipe.split((CharSequence)help[0])) {
                this.altNames.add(s2);
            }
        }

        public SubCommand() {
        }

        abstract void call(String[] var1);

        private void reset() {
            this.sender = null;
            this.player = null;
            this.world = null;
            this.user = null;
            this.op = false;
            this.creative = false;
            this.selected = null;
        }

        private void setup(aa sender) {
            this.sender = sender;
            if (sender instanceof iq) {
                this.player = (iq)sender;
            }
            if (sender instanceof any) {
                this.user = new Coord((any)sender);
            }
            this.selected = (IDeltaChunk)((Object)currentSelection.get());
            if (sender.a(4, "stop")) {
                this.op = true;
            }
            if (sender instanceof ann) {
                this.op = true;
            }
            if (this.op) {
                this.creative = true;
            }
        }

        DSTeleporter getTp() {
            DSTeleporter tp = new DSTeleporter((in)this.player.p);
            tp.destination = new Coord(this.player.p, 0, 0, 0);
            return tp;
        }

        boolean appropriate() {
            if (this.needOp && !this.op) {
                return false;
            }
            return !this.needCreative || this.creative;
        }

        String details() {
            return null;
        }

        final String getHelp() {
            String msg = "";
            boolean first = true;
            for (String m : this.help) {
                if (first) {
                    first = false;
                } else {
                    msg = msg + " ";
                }
                msg = msg + m;
            }
            return msg;
        }

        final String getNeeds() {
            if (this.reqs.length == 0) {
                return "";
            }
            String ret = "[Need:";
            for (Requires r : this.reqs) {
                ret = ret + " " + (Object)((Object)r);
            }
            return ret + "]";
        }

        void inform() {
            String msg = this.getHelp();
            String d = this.details();
            if (d != null) {
                msg = msg + ": " + d;
            }
            this.sender.a(msg);
        }
    }
}

