/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.Quaternion;
import factorization.common.Core;
import factorization.fzds.DSTeleporter;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DseCollider;
import factorization.fzds.DseRayTarget;
import factorization.fzds.Hammer;
import factorization.fzds.HammerNet;
import factorization.fzds.MetaAxisAlignedBB;
import factorization.fzds.PacketProxyingPlayer;
import factorization.fzds.api.Caps;
import factorization.fzds.api.IDeltaChunk;
import factorization.fzds.api.IFzdsCustomTeleport;
import factorization.fzds.api.IFzdsEntryControl;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class DimensionSliceEntity
extends IDeltaChunk
implements IFzdsEntryControl,
IEntityAdditionalSpawnData {
    private Coord hammerCell;
    private Coord farCorner;
    aoj centerOffset;
    private int capabilities = Caps.of(Caps.MOVE, Caps.COLLIDE, Caps.DRAG);
    aoe realArea = null;
    MetaAxisAlignedBB metaAABB = null;
    private aoe shadowArea = null;
    private aoe shadowCollisionArea = null;
    private aoe realCollisionArea = null;
    private aoe realDragArea = null;
    private boolean needAreaUpdate = true;
    ArrayList children = null;
    private double last_motion_hash = Double.NaN;
    private Quaternion rotation = new Quaternion();
    private Quaternion rotationalVelocity = new Quaternion();
    private Quaternion last_shared_rotation = new Quaternion();
    private Quaternion last_shared_rotational_velocity = new Quaternion();
    Quaternion prevTickRotation = new Quaternion();
    float scale = 1.0f;
    float opacity = 1.0f;
    Object renderInfo = null;
    PacketProxyingPlayer proxy = null;
    private DseRayTarget rayTarget = null;
    private lq[] raypart = null;
    private boolean rayOutOfDate = true;

    public DimensionSliceEntity(yc world) {
        super(world);
        if (world == DeltaChunk.getWorld(world)) {
            this.x();
        }
        this.al = true;
        this.D.b(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public DimensionSliceEntity(yc world, Coord lowerCorner, Coord upperCorner) {
        this(world);
        this.setCorners(lowerCorner, upperCorner);
    }

    private void setCorners(Coord lowerCorner, Coord upperCorner) {
        if (lowerCorner.w != DeltaChunk.getWorld(this.p)) {
            throw new IllegalArgumentException("My corners are not shadow!");
        }
        this.hammerCell = lowerCorner;
        this.farCorner = upperCorner;
        DeltaCoord dc = upperCorner.difference(lowerCorner);
        this.centerOffset = aoj.a((double)(dc.x / 2), (double)(dc.y / 2), (double)(dc.z / 2));
    }

    public String toString() {
        return super.toString() + " - " + this.hammerCell + "  to  " + this.farCorner;
    }

    @Override
    public aoj real2shadow(aoj realCoords) {
        aoj buffer = aoj.a((double)0.0, (double)0.0, (double)0.0);
        double diffX = realCoords.c + this.centerOffset.c - this.t;
        double diffY = realCoords.d + this.centerOffset.d - this.u;
        double diffZ = realCoords.e + this.centerOffset.e - this.v;
        buffer.c = (double)this.hammerCell.x + diffX;
        buffer.d = (double)this.hammerCell.y + diffY;
        buffer.e = (double)this.hammerCell.z + diffZ;
        return buffer;
    }

    @Override
    public aoj shadow2real(aoj shadowCoords) {
        aoj buffer = aoj.a((double)0.0, (double)0.0, (double)0.0);
        double diffX = shadowCoords.c - (double)this.hammerCell.x;
        double diffY = shadowCoords.d - (double)this.hammerCell.y;
        double diffZ = shadowCoords.e - (double)this.hammerCell.z;
        buffer.c = diffX - this.centerOffset.c;
        buffer.d = diffY - this.centerOffset.d;
        buffer.e = diffZ - this.centerOffset.e;
        this.rotation.applyRotation(buffer);
        buffer.c += this.t;
        buffer.d += this.u;
        buffer.e += this.v;
        return buffer;
    }

    @Override
    public void shadow2real(Coord c) {
        c.set(this.shadow2real(c.createVector()));
        c.w = this.p;
    }

    @Override
    public void real2shadow(Coord c) {
        c.set(this.real2shadow(c.createVector()));
        c.w = DeltaChunk.getWorld(this.p);
    }

    @Override
    public Coord getCorner() {
        return this.hammerCell;
    }

    @Override
    public Coord getCenter() {
        return this.hammerCell.center(this.farCorner);
    }

    @Override
    public Coord getFarCorner() {
        return this.farCorner;
    }

    public aoe E() {
        return null;
    }

    public void c_(qx player) {
    }

    protected void a() {
    }

    protected void a(bq tag) {
        this.hammerCell = new Coord(DeltaChunk.getWorld(this.p), 0, 0, 0);
        this.farCorner = this.hammerCell.copy();
        this.capabilities = tag.e("cap");
        this.rotation = Quaternion.loadFromTag(tag, "r");
        this.rotationalVelocity = Quaternion.loadFromTag(tag, "w");
        this.centerOffset = aoj.a((double)0.0, (double)0.0, (double)0.0);
        this.centerOffset.c = tag.g("cox");
        this.centerOffset.d = tag.g("coy");
        this.centerOffset.e = tag.g("coz");
        this.hammerCell.readFromNBT("min", tag);
        this.farCorner.readFromNBT("max", tag);
    }

    protected void b(bq tag) {
        tag.a("cap", this.capabilities);
        this.rotation.writeToTag(tag, "r");
        this.rotationalVelocity.writeToTag(tag, "w");
        tag.a("cox", (float)this.centerOffset.c);
        tag.a("coy", (float)this.centerOffset.d);
        tag.a("coz", (float)this.centerOffset.e);
        this.hammerCell.writeToNBT("min", tag);
        this.farCorner.writeToNBT("max", tag);
    }

    public boolean L() {
        return false;
    }

    public boolean M() {
        return false;
    }

    private aoe cloneAABB(aoe orig) {
        aoe ret = this.makeAABB();
        ret.c(orig);
        return ret;
    }

    private aoe makeAABB() {
        return aoe.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    private aoe offsetAABB(aoe orig, double dx, double dy, double dz) {
        return aoe.a((double)(orig.a + dx), (double)(orig.b + dy), (double)(orig.c + dz), (double)(orig.d + dx), (double)(orig.e + dy), (double)(orig.f + dz));
    }

    private void updateRealArea() {
        Coord c = this.hammerCell;
        double odx = this.t - (double)c.x - this.centerOffset.c;
        double ody = this.u - (double)c.y - this.centerOffset.d;
        double odz = this.v - (double)c.z - this.centerOffset.e;
        this.realArea = this.offsetAABB(this.shadowArea, odx, ody, odz);
        this.realCollisionArea = this.offsetAABB(this.shadowCollisionArea, odx, ody, odz);
        this.needAreaUpdate = false;
        if (this.children == null && this.p.I) {
            this.children = new ArrayList();
        } else if (this.children == null && !this.p.I) {
            this.children = new ArrayList();
            DeltaCoord size = this.getFarCorner().difference(this.getCorner());
            DeltaCoord half = size.scale(0.5);
            for (int dx = 0; dx <= size.x; dx += 16) {
                for (int dy = 0; dy <= size.y; dy += 16) {
                    for (int dz = 0; dz <= size.z; dz += 16) {
                        DseCollider e = new DseCollider(this, aoj.a((double)(dx - half.x), (double)(dy - half.y), (double)(dz - half.z)));
                        e.y();
                        this.p.d((lq)e);
                    }
                }
            }
        }
        this.metaAABB = new MetaAxisAlignedBB(this.hammerCell.w, this.shadowArea, aoj.a((double)odx, (double)ody, (double)odz), this.rotation, this.real2shadow(aoj.a((double)this.t, (double)this.u, (double)this.v)));
        this.metaAABB.setUnderlying(this.realArea);
    }

    private void updateShadowArea() {
        Coord c = this.getCorner();
        Coord d = this.getFarCorner();
        aoe start = null;
        for (int x = c.x; x <= d.x; ++x) {
            for (int y2 = c.y; y2 <= d.y; ++y2) {
                for (int z = c.z; z <= d.z; ++z) {
                    aoe b;
                    amq block2 = amq.p[c.w.a(x, y2, z)];
                    if (block2 == null || (b = block2.e(c.w, x, y2, z)) == null) continue;
                    if (start == null) {
                        start = b;
                        continue;
                    }
                    start.a = Math.min(start.a, b.a);
                    start.b = Math.min(start.b, b.b);
                    start.c = Math.min(start.c, b.c);
                    start.d = Math.max(start.d, b.d);
                    start.e = Math.max(start.e, b.e);
                    start.f = Math.max(start.f, b.f);
                }
            }
        }
        if (start == null) {
            if (this.p.I) {
                return;
            }
            this.shadowArea = this.makeAABB();
            this.shadowCollisionArea = this.makeAABB();
            this.realArea = this.makeAABB();
            this.realCollisionArea = this.makeAABB();
            return;
        }
        this.shadowArea = this.cloneAABB(start);
        this.shadowCollisionArea = this.shadowArea.b(2.0, 2.0, 2.0);
        this.updateRealArea();
    }

    @Override
    public void blocksChanged(int x, int y2, int z) {
        if (this.shadowArea == null) {
            this.needAreaUpdate = true;
            return;
        }
        this.needAreaUpdate |= (double)x < this.shadowArea.a || (double)y2 < this.shadowArea.b || (double)z < this.shadowArea.c || (double)x > this.shadowArea.d || (double)y2 > this.shadowArea.e || (double)z > this.shadowArea.f;
    }

    public void b(double par1, double par3, double par5) {
        super.b(par1, par3, par5);
        this.needAreaUpdate = true;
    }

    boolean updateHashMotion() {
        double hash = this.w * 10.0 + this.x * 1010.0 + this.y * 101010.0;
        if (hash == this.last_motion_hash) {
            return false;
        }
        this.last_motion_hash = hash;
        return true;
    }

    void updateMotion() {
        if (this.w == 0.0 && this.x == 0.0 && this.y == 0.0 && this.rotationalVelocity.isZero()) {
            return;
        }
        if (this.realArea == null || this.metaAABB == null) {
            return;
        }
        if (this.realDragArea == null || this.updateHashMotion() || !this.rotationalVelocity.isZero()) {
            this.realDragArea = this.realArea.a(this.w, this.x, this.y);
        }
        this.q = this.t;
        this.r = this.u;
        this.s = this.v;
        Quaternion rotation_copy = new Quaternion(this.rotation);
        this.t += this.w;
        this.u += this.x;
        this.v += this.y;
        this.rotation.incrMultiply(this.rotationalVelocity);
        this.last_shared_rotation.incrMultiply(this.last_shared_rotational_velocity);
        boolean moved = true;
        if (!this.Y && this.can(Caps.COLLIDE)) {
            List collisions = this.p.a((lq)this, this.realArea);
            aoe collision = null;
            for (int i = 0; i < collisions.size(); ++i) {
                aoe solid = (aoe)collisions.get(i);
                if (solid == this.metaAABB || !this.metaAABB.a(solid)) continue;
                collision = solid;
                break;
            }
            if (collision != null) {
                this.t -= this.w;
                this.u -= this.x;
                this.v -= this.y;
                moved = false;
                this.h(0.0, 0.0, 0.0);
                this.rotationalVelocity.update(0.0, 0.0, 0.0, 0.0);
                this.rotation = rotation_copy;
            }
        }
        if (moved) {
            double s2 = 5.0;
            double dx = (this.t - this.q) * s2;
            double dy = (this.u - this.r) * s2;
            double dz = (this.v - this.s) * s2;
            List ents = this.p.b((lq)this, (aoe)this.metaAABB);
            for (int i = 0; i < ents.size(); ++i) {
                lq e = (lq)ents.get(i);
                e.t += dx;
                e.u += dy;
                e.v += dz;
                if (Math.abs(e.w) < this.w) {
                    e.w = this.w;
                }
                if (Math.abs(e.x) < this.x) {
                    e.x = this.x;
                }
                if (!(Math.abs(e.y) < this.y)) continue;
                e.y = this.y;
            }
            this.updateRealArea();
        }
    }

    void shareRotationInfo() {
        boolean d0 = !this.rotation.isEqual(this.last_shared_rotation);
        boolean d1 = !this.rotationalVelocity.isEqual(this.last_shared_rotational_velocity);
        cz toSend = null;
        if (d0 && d1) {
            toSend = HammerNet.makePacket((short)2, this.k, this.rotation, this.rotationalVelocity);
            this.last_shared_rotation.update(this.rotation);
            this.last_shared_rotational_velocity.update(this.rotationalVelocity);
        } else if (d0) {
            toSend = HammerNet.makePacket((short)0, this.k, this.rotation);
            this.last_shared_rotation.update(this.rotation);
        } else if (d1) {
            toSend = HammerNet.makePacket((short)1, this.k, this.rotationalVelocity);
            this.last_shared_rotational_velocity.update(this.rotationalVelocity);
        }
        if (toSend != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.t, (double)this.u, (double)this.v, (double)64.0, (int)this.aq, toSend);
        }
    }

    void doUpdate() {
        if (this.p.I) {
            this.prevTickRotation.update(this.rotation);
            this.rayOutOfDate = true;
        } else if (this.proxy == null && !this.L) {
            DeltaChunk.getSlices(this.p).add(this);
            this.proxy = new PacketProxyingPlayer(this, DeltaChunk.getServerShadowWorld());
            this.proxy.p.d((lq)this.proxy);
            return;
        }
        this.updateMotion();
        if (!this.p.I && this.can(Caps.ROTATE)) {
            this.shareRotationInfo();
        }
        if (this.needAreaUpdate) {
            Core.profileStart("updateArea");
            this.updateShadowArea();
            Core.profileEnd();
        }
        if (!this.p.I) {
            if (this.shadowArea == null) {
                this.updateShadowArea();
            }
            if (this.shadowArea == null) {
                if (this.hammerCell.blockExists() && !this.can(Caps.EMPTY)) {
                    this.x();
                    Core.logFine("%s dying due to empty area", this.toString());
                } else {
                    this.needAreaUpdate = true;
                }
            } else {
                if (this.can(Caps.TAKE_INTERIOR_ENTITIES)) {
                    this.takeInteriorEntities();
                }
                if (this.can(Caps.REMOVE_EXTERIOR_ENTITIES)) {
                    this.removeExteriorEntities();
                }
            }
            if (this.L) {
                this.endSlice();
                return;
            }
        }
    }

    public void y() {
        Core.profileStart("FZDSEntityTick");
        this.doUpdate();
        Core.profileEnd();
    }

    private void takeInteriorEntities() {
        List realEntities = this.p.a(lq.class, this.realArea);
        for (int i = 0; i < realEntities.size(); ++i) {
            lq ent = (lq)realEntities.get(i);
            if (ent == this) continue;
            this.takeEntity(ent);
        }
    }

    private void removeExteriorEntities() {
        for (int x = this.hammerCell.x; x <= this.farCorner.x; x += 16) {
            for (int z = this.hammerCell.z; z <= this.farCorner.z; z += 16) {
                if (!this.p.f(x, 64, z)) continue;
                zz chunk = this.p.d(x, z);
                for (int j = 0; j < chunk.j.length; ++j) {
                    List l = chunk.j[j];
                    for (int k = 0; k < l.size(); ++k) {
                        aoe bb;
                        lq ent = (lq)l.get(k);
                        if (ent.u < 0.0 || ent.u > (double)this.p.P() || ent == this || (bb = ent.D) == null || this.shadowArea.a(bb)) continue;
                        this.ejectEntity(ent);
                    }
                }
            }
        }
    }

    boolean forbidEntityTransfer(lq ent) {
        return ent.an > 0;
    }

    void takeEntity(lq ent) {
        if (this.forbidEntityTransfer(ent)) {
            return;
        }
        IFzdsEntryControl ifec = null;
        if (ent instanceof IFzdsEntryControl && !(ifec = (IFzdsEntryControl)ent).canEnter(this)) {
            return;
        }
        yc shadowWorld = DeltaChunk.getServerShadowWorld();
        aoj newLocation = this.real2shadow(Hammer.ent2vec(ent));
        this.transferEntity(ent, shadowWorld, newLocation);
        if (ifec != null) {
            ifec.onEnter(this);
        }
    }

    void ejectEntity(lq ent) {
        if (this.forbidEntityTransfer(ent)) {
            return;
        }
        IFzdsEntryControl ifec = null;
        if (ent instanceof IFzdsEntryControl && !(ifec = (IFzdsEntryControl)ent).canExit(this)) {
            return;
        }
        aoj newLocation = this.shadow2real(Hammer.ent2vec(ent));
        this.transferEntity(ent, this.p, newLocation);
        if (ifec != null) {
            ifec.onExit(this);
        }
    }

    void transferEntity(lq ent, yc newWorld, aoj newPosition) {
        if (ent instanceof IFzdsCustomTeleport) {
            ((IFzdsCustomTeleport)ent).transferEntity(this.p, newPosition);
            return;
        }
        if (ent instanceof iq) {
            if (!this.can(Caps.TRANSFER_PLAYERS)) {
                return;
            }
            iq player = (iq)ent;
            MinecraftServer ms = MinecraftServer.D();
            gm manager = ms.ad();
            DSTeleporter tp = new DSTeleporter((in)newWorld);
            tp.preciseDestination = newPosition;
            manager.transferPlayerToDimension(player, newWorld.K().j(), (yq)tp);
        } else {
            ent.p.e(ent);
            ent.L = false;
            lq phoenix = lv.a((String)lv.b((lq)ent), (yc)newWorld);
            if (phoenix == null) {
                return;
            }
            phoenix.a(ent, true);
            phoenix.an = phoenix.ab();
            ent.L = true;
            phoenix.b(newPosition.c, newPosition.d, newPosition.e);
            newWorld.d(phoenix);
        }
    }

    void endSlice() {
        DeltaChunk.getSlices(this.p).remove(this);
    }

    public void x() {
        super.x();
        this.endSlice();
    }

    public boolean a(double distSquared) {
        int s2 = 128;
        return distSquared < (double)(s2 * s2);
    }

    @Override
    public boolean canEnter(IDeltaChunk dse) {
        return false;
    }

    @Override
    public boolean canExit(IDeltaChunk dse) {
        return true;
    }

    @Override
    public void onEnter(IDeltaChunk dse) {
    }

    @Override
    public void onExit(IDeltaChunk dse) {
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.capabilities);
        this.rotation.write(data);
        this.rotationalVelocity.write(data);
        data.writeFloat((float)this.centerOffset.c);
        data.writeFloat((float)this.centerOffset.d);
        data.writeFloat((float)this.centerOffset.e);
        this.hammerCell.writeToStream(data);
        this.farCorner.writeToStream(data);
        if (this.can(Caps.SCALE)) {
            data.writeFloat(this.scale);
        }
        if (this.can(Caps.TRANSPARENT)) {
            data.writeFloat(this.opacity);
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            this.capabilities = data.readInt();
            this.rotation = Quaternion.read((DataInput)data);
            this.rotationalVelocity = Quaternion.read((DataInput)data);
            this.centerOffset = aoj.a((double)data.readFloat(), (double)data.readFloat(), (double)data.readFloat());
            this.hammerCell = this.can(Caps.ORACLE) ? new Coord(this.p, 0, 0, 0) : new Coord(DeltaChunk.getClientShadowWorld(), 0, 0, 0);
            this.hammerCell.readFromStream(data);
            this.farCorner = this.hammerCell.copy();
            this.farCorner.readFromStream(data);
            if (this.can(Caps.SCALE)) {
                this.scale = data.readFloat();
            }
            if (this.can(Caps.TRANSPARENT)) {
                this.opacity = data.readFloat();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.b(par1, par3, par5);
        this.b(par7, par8);
    }

    public void g(double par1, double par3, double par5) {
        super.g(par1, par3, par5);
        this.am = false;
    }

    @Override
    public boolean can(Caps cap) {
        return cap.in(this.capabilities);
    }

    @Override
    public DimensionSliceEntity permit(Caps cap) {
        this.capabilities |= cap.bit;
        if (cap == Caps.ORACLE) {
            this.forbid(Caps.COLLIDE);
            this.forbid(Caps.DRAG);
            this.forbid(Caps.TAKE_INTERIOR_ENTITIES);
            this.forbid(Caps.REMOVE_EXTERIOR_ENTITIES);
            this.forbid(Caps.TRANSFER_PLAYERS);
        }
        return this;
    }

    @Override
    public DimensionSliceEntity forbid(Caps cap) {
        this.capabilities &= ~cap.bit;
        return this;
    }

    @Override
    public Quaternion getRotation() {
        return this.rotation;
    }

    @Override
    public Quaternion getRotationalVelocity() {
        return this.rotationalVelocity;
    }

    @Override
    public void setRotation(Quaternion r) {
        this.rotation = r;
    }

    @Override
    public void setRotationalVelocity(Quaternion w2) {
        this.rotationalVelocity = w2;
    }

    public float Y() {
        return 0.0f;
    }

    public lq[] ao() {
        if (!this.p.I) {
            return null;
        }
        if (this.rayOutOfDate) {
            if (this.raypart == null) {
                this.raypart = new lq[1];
                this.rayTarget = new DseRayTarget(this);
                this.raypart[0] = this.rayTarget;
            }
            this.rayOutOfDate = false;
            Hammer.proxy.updateRayPosition(this.rayTarget);
        }
        return this.raypart;
    }
}

