/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.TransferLib;
import factorization.fzds.api.IDeltaChunk;
import java.util.Set;
import net.minecraftforge.common.DimensionManager;

public class DeltaChunk {
    private static aoj buffer = aoj.a((double)0.0, (double)0.0, (double)0.0);
    private static Coord shadow = new Coord(null, 0, 0, 0);

    static Set getSlices(yc w2) {
        if (w2 == null) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return Hammer.clientSlices;
            }
            return Hammer.serverSlices;
        }
        return w2.I ? Hammer.clientSlices : Hammer.serverSlices;
    }

    public static yc getClientShadowWorld() {
        return Hammer.worldClient;
    }

    public static yc getServerShadowWorld() {
        return DimensionManager.getWorld((int)Hammer.dimensionID);
    }

    public static yc getClientRealWorld() {
        return Hammer.proxy.getClientRealWorld();
    }

    public static yc getWorld(yc realWorld) {
        if (realWorld == null) {
            return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? DeltaChunk.getClientShadowWorld() : DeltaChunk.getServerShadowWorld();
        }
        return realWorld.I ? DeltaChunk.getClientShadowWorld() : DeltaChunk.getServerShadowWorld();
    }

    public static IDeltaChunk allocateSlice(yc spawnWorld, int channel, DeltaCoord size) {
        Coord base = Hammer.hammerInfo.takeCell(channel, size);
        return new DimensionSliceEntity(spawnWorld, base, base.add(size));
    }

    public static IDeltaChunk findClosest(lq target, Coord pos) {
        if (target == null) {
            return null;
        }
        IDeltaChunk closest = null;
        double dist = Double.POSITIVE_INFINITY;
        yc real_world = DeltaChunk.getClientRealWorld();
        for (IDeltaChunk here : DeltaChunk.getSlices(target.p)) {
            if (here.p != real_world && !pos.inside(here.getCorner(), here.getFarCorner())) continue;
            if (closest == null) {
                closest = here;
                continue;
            }
            double here_dist = target.e((lq)here);
            if (!(here_dist < dist)) continue;
            dist = here_dist;
            closest = here;
        }
        return closest;
    }

    public static aoj shadow2nearestReal(lq player, double x, double y2, double z) {
        IDeltaChunk closest = DeltaChunk.findClosest(player, new Coord(player.p, x, y2, z));
        if (closest == null) {
            return null;
        }
        DeltaChunk.buffer.c = x;
        DeltaChunk.buffer.d = y2;
        DeltaChunk.buffer.e = z;
        aoj ret = closest.shadow2real(buffer);
        return ret;
    }

    public static IDeltaChunk makeSlice(int channel, Coord min, Coord max, AreaMap mapper2, boolean wipeSrc) {
        DeltaCoord size = max.difference(min);
        final IDeltaChunk dse = DeltaChunk.allocateSlice(min.w, channel, size);
        aoj vrm = min.centerVec(max);
        dse.t = (int)vrm.c;
        dse.u = (int)vrm.d;
        dse.v = (int)vrm.e;
        mapper2.fillDse(new DseDestination(){

            @Override
            public void include(Coord real) {
                shadow.set(real);
                dse.real2shadow(shadow);
                TransferLib.move(real, shadow, false, true);
            }
        });
        if (wipeSrc) {
            mapper2.fillDse(new DseDestination(){

                @Override
                public void include(Coord real) {
                    shadow.set(real);
                    dse.real2shadow(shadow);
                    TransferLib.setRaw(shadow, 1, 0);
                    shadow.setId(0);
                }
            });
        }
        return dse;
    }

    public static void paste(IDeltaChunk selected, boolean overwriteDestination) {
        Coord a = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        Coord b = a.copy();
        aoj vShadowMin = aoj.a((double)0.0, (double)0.0, (double)0.0);
        aoj vShadowMax = aoj.a((double)0.0, (double)0.0, (double)0.0);
        selected.getCorner().setAsVector(vShadowMin);
        selected.getFarCorner().setAsVector(vShadowMax);
        a.set(vShadowMin);
        b.set(vShadowMax);
        DeltaCoord dc = b.difference(a);
        Coord dest = new Coord(selected);
        Coord c = new Coord(a.w, 0, 0, 0);
        for (int x = a.x; x <= b.x; ++x) {
            for (int y2 = a.y; y2 <= b.y; ++y2) {
                for (int z = a.z; z <= b.z; ++z) {
                    c.set(a.w, x, y2, z);
                    dest.set(c);
                    selected.shadow2real(dest);
                    TransferLib.move(c, dest, false, overwriteDestination);
                }
            }
        }
    }

    public static void clear(IDeltaChunk selected) {
        Coord a = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        Coord b = a.copy();
        aoj vShadowMin = aoj.a((double)0.0, (double)0.0, (double)0.0);
        aoj vShadowMax = aoj.a((double)0.0, (double)0.0, (double)0.0);
        selected.getCorner().setAsVector(vShadowMin);
        selected.getFarCorner().setAsVector(vShadowMax);
        a.set(vShadowMin);
        b.set(vShadowMax);
        Coord c = new Coord(a.w, 0, 0, 0);
        for (int x = a.x; x < b.x; ++x) {
            for (int y2 = a.y; y2 < b.y; ++y2) {
                for (int z = a.z; z < b.z; ++z) {
                    c.set(a.w, x, y2, z);
                    selected.shadow2real(c);
                    c.markBlockForUpdate();
                }
            }
        }
    }

    public static interface DseDestination {
        public void include(Coord var1);
    }

    public static interface AreaMap {
        public void fillDse(DseDestination var1);
    }
}

