/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.VectorUV;
import java.util.ArrayList;

public class WireRenderingCube {
    int icon;
    public VectorUV corner;
    public VectorUV origin;
    public VectorUV axis;
    public double ul;
    public double vl;
    public float theta;

    public WireRenderingCube(int icon, VectorUV corner, VectorUV origin) {
        if (origin == null) {
            origin = new VectorUV(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.corner = corner;
        this.origin = origin;
        this.axis = new VectorUV(0.0f, 0.0f, 0.0f);
        this.theta = 0.0f;
        this.setIcon(icon);
    }

    void writeToNBT(bq tag) {
        tag.a("icon", this.icon);
        this.corner.writeToTag(tag, "c");
        this.origin.writeToTag(tag, "o");
        this.axis.writeToTag(tag, "a");
        tag.a("theta", this.theta);
    }

    static WireRenderingCube loadFromNBT(bq tag) {
        int icon = tag.e("icon");
        VectorUV c = VectorUV.readFromTag(tag, "c");
        VectorUV o = VectorUV.readFromTag(tag, "o");
        VectorUV a = VectorUV.readFromTag(tag, "a");
        WireRenderingCube rc = new WireRenderingCube(icon, c, o);
        rc.axis = a;
        rc.theta = tag.g("theta");
        return rc;
    }

    void writeToArray(ArrayList args) {
        args.add(this.icon);
        this.corner.addInfoToArray(args);
        this.origin.addInfoToArray(args);
        this.axis.addInfoToArray(args);
        args.add(Float.valueOf(this.theta));
    }

    static float takeFloat(ArrayList args) {
        return ((Float)args.remove(0)).floatValue();
    }

    static WireRenderingCube readFromArray(ArrayList args) {
        int icon = (Integer)args.remove(0);
        VectorUV c = new VectorUV(WireRenderingCube.takeFloat(args), WireRenderingCube.takeFloat(args), WireRenderingCube.takeFloat(args));
        VectorUV o = new VectorUV(WireRenderingCube.takeFloat(args), WireRenderingCube.takeFloat(args), WireRenderingCube.takeFloat(args));
        VectorUV a = new VectorUV(WireRenderingCube.takeFloat(args), WireRenderingCube.takeFloat(args), WireRenderingCube.takeFloat(args));
        WireRenderingCube rc = new WireRenderingCube(icon, c, o);
        rc.axis = a;
        rc.theta = WireRenderingCube.takeFloat(args);
        return rc;
    }

    public boolean equals(WireRenderingCube other) {
        return this.corner.equals(other.corner) && this.origin.equals(other.origin) && this.icon == other.icon;
    }

    public WireRenderingCube copy() {
        WireRenderingCube ret = new WireRenderingCube(this.icon, this.corner.copy(), this.origin.copy());
        ret.ul = this.ul;
        ret.vl = this.vl;
        ret.axis = this.axis.copy();
        ret.theta = this.theta;
        return ret;
    }

    public WireRenderingCube normalize() {
        VectorUV newCorner = this.corner.copy();
        VectorUV newOrigin = this.origin.copy();
        newCorner.rotate(this.axis.x, this.axis.y, this.axis.z, this.theta);
        newOrigin.rotate(this.axis.x, this.axis.y, this.axis.z, this.theta);
        newCorner.x = Math.abs(newCorner.x);
        newCorner.y = Math.abs(newCorner.y);
        newCorner.z = Math.abs(newCorner.z);
        return new WireRenderingCube(this.icon, newCorner, newOrigin);
    }

    public void toBlockBounds(amq b) {
        WireRenderingCube cube = this.normalize();
        VectorUV c = cube.corner;
        VectorUV o = cube.origin;
        c.scale(0.0625f);
        o = o.add(8, 8, 8);
        o.scale(0.0625f);
        b.a(o.x - c.x, o.y - c.y, o.z - c.z, o.x + c.x, o.y + c.y, o.z + c.z);
    }

    public WireRenderingCube rotate(double ax, double ay, double az, int theta) {
        return this.rotate((float)ax, (float)ay, (float)az, theta);
    }

    public WireRenderingCube rotate(float ax, float ay, float az, int theta) {
        if (theta == 0) {
            this.axis = new VectorUV(0.0f, 0.0f, 0.0f);
            this.theta = 0.0f;
            return this;
        }
        this.axis = new VectorUV(ax, ay, az);
        this.theta = theta;
        return this;
    }

    public void setIcon(int newIcon) {
        this.icon = newIcon;
        this.ul = (double)((this.icon & 0xF) << 4) / 256.0;
        this.vl = (double)(this.icon & 0xF0) / 256.0;
    }

    public VectorUV[] faceVerts(int face) {
        VectorUV[] ret = new VectorUV[4];
        VectorUV v = this.corner;
        int c = 8;
        switch (face) {
            case 0: {
                ret[0] = new VectorUV(v.x, -v.y, v.z);
                ret[1] = new VectorUV(-v.x, -v.y, v.z);
                ret[2] = new VectorUV(-v.x, -v.y, -v.z);
                ret[3] = new VectorUV(v.x, -v.y, -v.z);
                break;
            }
            case 1: {
                ret[0] = new VectorUV(v.x, v.y, -v.z);
                ret[1] = new VectorUV(-v.x, v.y, -v.z);
                ret[2] = new VectorUV(-v.x, v.y, v.z);
                ret[3] = new VectorUV(v.x, v.y, v.z);
                break;
            }
            case 2: {
                ret[0] = new VectorUV(v.x, v.y, -v.z);
                ret[1] = new VectorUV(v.x, -v.y, -v.z);
                ret[2] = new VectorUV(-v.x, -v.y, -v.z);
                ret[3] = new VectorUV(-v.x, v.y, -v.z);
                break;
            }
            case 3: {
                ret[0] = new VectorUV(v.x, v.y, v.z);
                ret[1] = new VectorUV(-v.x, v.y, v.z);
                ret[2] = new VectorUV(-v.x, -v.y, v.z);
                ret[3] = new VectorUV(v.x, -v.y, v.z);
                break;
            }
            case 4: {
                ret[0] = new VectorUV(-v.x, v.y, v.z);
                ret[1] = new VectorUV(-v.x, v.y, -v.z);
                ret[2] = new VectorUV(-v.x, -v.y, -v.z);
                ret[3] = new VectorUV(-v.x, -v.y, v.z);
                break;
            }
            case 5: {
                ret[0] = new VectorUV(v.x, v.y, v.z);
                ret[1] = new VectorUV(v.x, -v.y, v.z);
                ret[2] = new VectorUV(v.x, -v.y, -v.z);
                ret[3] = new VectorUV(v.x, v.y, -v.z);
            }
        }
        for (VectorUV vert : ret) {
            vert.incr(this.origin);
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            switch (face) {
                case 0: 
                case 1: {
                    for (VectorUV vert : ret) {
                        vert.u = vert.x + 8.0f;
                        vert.v = vert.z + 8.0f;
                    }
                    break;
                }
                case 2: {
                    for (VectorUV vert : ret) {
                        vert.u = 16.0f - (vert.x + 8.0f);
                        vert.v = 16.0f - (vert.y + 8.0f);
                    }
                    break;
                }
                case 3: {
                    for (VectorUV vert : ret) {
                        vert.u = vert.x + 8.0f;
                        vert.v = 16.0f - (vert.y + 8.0f);
                    }
                    break;
                }
                case 4: {
                    for (VectorUV vert : ret) {
                        vert.u = 16.0f - (vert.y + 8.0f);
                        vert.v = vert.z + 8.0f;
                    }
                    break;
                }
                case 5: {
                    for (VectorUV vert : ret) {
                        vert.u = 16.0f - (vert.y + 8.0f);
                        vert.v = 16.0f - (vert.z + 8.0f);
                    }
                    break;
                }
            }
            for (VectorUV main : ret) {
                float udelta = 0.0f;
                float vdelta = 0.0f;
                int nada = 0;
                if (main.u > 16.0f) {
                    udelta = main.u - 16.0f;
                } else if (main.u < 0.0f) {
                    udelta = main.u;
                } else {
                    ++nada;
                }
                if (main.v > 16.0f) {
                    vdelta = main.v - 16.0f;
                } else if (main.v < 0.0f) {
                    vdelta = main.v;
                } else {
                    ++nada;
                }
                if (nada == 2) continue;
                for (VectorUV other : ret) {
                    other.u -= udelta;
                    other.v -= vdelta;
                }
            }
        }
        if (this.theta != 0.0f) {
            for (VectorUV vert : ret) {
                vert.rotate(this.axis.x, this.axis.y, this.axis.z, this.theta);
            }
        }
        return ret;
    }
}

