/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.PriorityQueue;

public class TileEntityWrathLamp
extends TileEntityCommon {
    static final int radius = 6;
    static final int radiusSq = 36;
    static final int diameter = 12;
    static final int maxDepth = 24;
    private short[] beamDepths = new short[169];
    private Updater updater = new InitialBuild();
    static boolean isUpdating = false;
    static int update_count;
    static final int update_limit = 64;
    static PriorityQueue airToUpdate;
    static final int[] deltas;
    static HashSet toVisit;

    public static void handleAirUpdates() {
        update_count = 0;
        while (update_count < 64 && airToUpdate.size() > 0) {
            ((Coord)airToUpdate.remove()).check();
        }
    }

    static void doAirCheck(yc w2, int x, int y2, int z) {
        if (w2.I) {
            return;
        }
        if (update_count > 64) {
            airToUpdate.add(new Coord(w2, x, y2, z));
            return;
        }
        TileEntityWrathLamp lamp = TileEntityWrathLamp.findLightAirParent(w2, x, y2, z);
        if (lamp == null) {
            ++update_count;
            w2.e(x, y2, z, 0);
        } else {
            lamp.activate(y2);
        }
    }

    private int getDepthIndex(int x, int z) {
        int dx = this.l - x;
        int dz = this.n - z;
        dz += 6;
        if ((dx += 6) < 0 || dx > 12) {
            throw new IndexOutOfBoundsException("x = " + dx);
        }
        if (dz < 0 || dz > 12) {
            throw new IndexOutOfBoundsException("z = " + dz);
        }
        return dx + dz * 12;
    }

    static TileEntityWrathLamp findLightAirParent(yc world, int x, int y2, int z) {
        toVisit.clear();
        for (int dcx : deltas) {
            for (int dcz : deltas) {
                if (!world.f(x + dcx, y2, z + dcz)) continue;
                toVisit.add(world.d(x + dcx, z + dcz));
            }
        }
        for (zz chunk : toVisit) {
            for (any o : chunk.i.values()) {
                TileEntityWrathLamp lamp;
                if (!(o instanceof TileEntityWrathLamp) || !(lamp = (TileEntityWrathLamp)o).lightsBlock(x, y2, z)) continue;
                return lamp;
            }
        }
        return null;
    }

    private boolean inArea(int x, int y2, int z) {
        if (y2 > this.m) {
            return false;
        }
        if (y2 < this.m - 24) {
            return false;
        }
        return this.l - 6 <= x && x <= this.l + 6 && this.n - 6 <= z && z <= this.n + 6;
    }

    private boolean lightsBlock(int x, int y2, int z) {
        if (!this.inArea(x, y2, z)) {
            return false;
        }
        short depth = this.beamDepths[this.getDepthIndex(x, z)];
        return y2 >= depth && depth != -1;
    }

    public void g() {
        Core.profileStart("WrathLamp");
        isUpdating = true;
        this.updater = this.updater.update();
        isUpdating = false;
        Core.profileEnd();
    }

    @Override
    public void w_() {
        super.w_();
        Core.profileStart("WrathLamp");
        for (int x = this.l - 6; x <= this.l + 6; ++x) {
            for (int z = this.n - 6; z <= this.n + 6; ++z) {
                int id = this.k.a(x, this.m, z);
                if (id != Core.registry.lightair_block.cm) continue;
                this.k.e(x, this.m, z, 0);
            }
        }
        Core.profileEnd();
        if (this.k.I) {
            RelightTask task = new RelightTask(this.k);
            task.b(this.l, this.m, this.n);
            this.k.d((lq)task);
        }
    }

    double dist(int x, int y2, int z) {
        return Math.sqrt(x * x + y2 * y2 + z * z);
    }

    boolean eq(double a, double b) {
        return Math.abs(a - b) < 0.9;
    }

    float div(int a, int b) {
        if (b == 0) {
            return Math.signum(a) * 4095.0f;
        }
        return a / b;
    }

    boolean myTrace(int x, int z) {
        int dx = x - this.l;
        int dz = z - this.n;
        float idealm = this.div(dz, dx);
        float old_dist = Float.MAX_VALUE;
        while (x != this.l || z != this.n) {
            int id = this.k.a(x, this.m, z);
            if (amq.p[id] != null && amq.p[id].c() && amq.r[id] != 0) {
                return false;
            }
            dx = x - this.l;
            dz = z - this.n;
            float m = this.div(dz, dx);
            int addx = (int)(-Math.signum(dx));
            int addz = (int)(-Math.signum(dz));
            if (addx == 0 && addz == 0) {
                return true;
            }
            if (addx == 0) {
                z += addz;
                continue;
            }
            if (addz == 0) {
                x += addx;
                continue;
            }
            float m_x = this.div(dz, dx + addx);
            float m_z = this.div(dz + addz, dx);
            if (Math.abs(idealm - m_x) <= Math.abs(idealm - m_z)) {
                x += addx;
                continue;
            }
            z += addz;
        }
        return true;
    }

    boolean clearTo(int x, int y2, int z) {
        return this.myTrace(x, z);
    }

    @Override
    public void neighborChanged() {
        this.activate(this.m);
    }

    void activate(int at_height) {
        this.updater = this.updater.getActive(at_height);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LAMP;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Lamp;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    static {
        airToUpdate = new PriorityQueue(1024);
        deltas = new int[]{0, -16, 16};
        toVisit = new HashSet(45);
    }

    public static class RelightTask
    extends lq {
        int delay;

        public RelightTask(yc par1World) {
            super(par1World);
        }

        protected void a() {
            this.delay = 40;
        }

        protected void a(bq var1) {
        }

        protected void b(bq var1) {
        }

        public void j_() {
            --this.delay;
            if (this.delay == 0) {
                int r = 21;
                int x = (int)(this.t - (double)r);
                while ((double)x <= this.t + (double)r) {
                    int z = (int)(this.v - (double)r);
                    while ((double)z <= this.v + (double)r) {
                        int y2 = (int)this.u;
                        while ((double)y2 >= this.u - 24.0) {
                            this.p.z(x, y2, z);
                            --y2;
                        }
                        ++z;
                    }
                    ++x;
                }
                this.x();
            }
        }
    }

    class Idler
    extends Updater {
        Idler() {
        }

        boolean couldUpdate(int dx, int dz) {
            return TileEntityWrathLamp.this.k.a(TileEntityWrathLamp.this.l + dx, TileEntityWrathLamp.this.m, TileEntityWrathLamp.this.n + dz) == 0;
        }

        @Override
        public Updater update() {
            if (this.couldUpdate(0, 1) || this.couldUpdate(0, -1) || this.couldUpdate(1, 0) || this.couldUpdate(-1, 0)) {
                return new InitialBuild();
            }
            return this;
        }

        @Override
        Updater getActive(int start_height) {
            InitialBuild r = new InitialBuild();
            r.start_height = Math.max(r.start_height, start_height);
            return r;
        }
    }

    class InitialBuild
    extends Updater {
        int height;
        int start_delay;
        Updater next_updater;

        InitialBuild() {
            this.height = -100;
            this.start_delay = 20;
            this.next_updater = new Idler();
        }

        @Override
        public Updater update() {
            int z;
            int x;
            if (this.start_delay >= 0) {
                --this.start_delay;
                return this;
            }
            this.height = this.height == -100 ? (this.start_height == -100 ? TileEntityWrathLamp.this.m : this.start_height) : --this.height;
            if (this.height < TileEntityWrathLamp.this.m - 24) {
                return this.next_updater;
            }
            if (this.height == TileEntityWrathLamp.this.m) {
                Arrays.fill(TileEntityWrathLamp.this.beamDepths, (short)0);
                for (x = TileEntityWrathLamp.this.l - 6; x <= TileEntityWrathLamp.this.l + 6; ++x) {
                    for (z = TileEntityWrathLamp.this.n - 6; z <= TileEntityWrathLamp.this.n + 6; ++z) {
                        if (TileEntityWrathLamp.this.clearTo(x, TileEntityWrathLamp.this.m, z)) continue;
                        ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[((TileEntityWrathLamp)TileEntityWrathLamp.this).getDepthIndex((int)x, (int)z)] = -1;
                    }
                }
            }
            for (x = TileEntityWrathLamp.this.l - 6; x <= TileEntityWrathLamp.this.l + 6; ++x) {
                for (z = TileEntityWrathLamp.this.n - 6; z <= TileEntityWrathLamp.this.n + 6; ++z) {
                    int index = TileEntityWrathLamp.this.getDepthIndex(x, z);
                    if (TileEntityWrathLamp.this.beamDepths[index] != 0) continue;
                    int block2 = TileEntityWrathLamp.this.k.a(x, this.height, z);
                    int belowBlock = TileEntityWrathLamp.this.k.a(x, this.height - 3, z);
                    if (belowBlock != 0 && belowBlock != Core.registry.lightair_block.cm && this.height != TileEntityWrathLamp.this.m) {
                        ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[index] = (short)this.height;
                        continue;
                    }
                    if (block2 == 0 && TileEntityWrathLamp.this.k.a(x, this.height - 1, z) == amq.ce.cm) {
                        block2 = -1;
                    }
                    if (block2 == 0) {
                        TileEntityWrathLamp.this.k.e(x, this.height, z, Core.registry.lightair_block.cm);
                        continue;
                    }
                    if (block2 == Core.registry.lightair_block.cm || x == TileEntityWrathLamp.this.l && this.height == TileEntityWrathLamp.this.m && z == TileEntityWrathLamp.this.n) continue;
                    ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[index] = (short)this.height;
                }
            }
            if (this.height == 0) {
                return this.next_updater;
            }
            return this;
        }

        @Override
        Updater getActive(int start_height) {
            if (!(this.next_updater instanceof InitialBuild)) {
                this.next_updater = new InitialBuild();
            }
            this.next_updater.start_height = Math.max(++start_height, this.next_updater.start_height);
            return this;
        }
    }

    abstract class Updater {
        int start_height = -100;

        Updater() {
        }

        abstract Updater update();

        abstract Updater getActive(int var1);
    }

    private static class Coord
    implements Comparable {
        yc w;
        int x;
        int y;
        int z;

        Coord(yc w2, int x, int y2, int z) {
            this.w = w2;
            this.x = x;
            this.y = y2;
            this.z = z;
        }

        void check() {
            TileEntityWrathLamp.doAirCheck(this.w, this.x, this.y, this.z);
        }

        public int compareTo(Coord o) {
            return o.y - this.y;
        }
    }
}

