/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.ICoord;
import factorization.common.BlockLightAir;
import factorization.common.Core;
import factorization.common.ResourceType;
import factorization.common.Sound;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class TileEntityWrathFire
extends any
implements ICoord {
    final int max_generation = 45;
    final int max_age = 35;
    static Random rand = new Random();
    static final List deltas = Arrays.asList(-1, 0, 1);
    public static HashMap transforms = new HashMap();
    static BlockMatch air = new BlockMatch(0, -1);
    static BlockMatch fire = new BlockMatch((amq)amq.au);
    static BlockMatch netherBrick = new BlockMatch(amq.bD);
    static BlockMatch netherFence = new BlockMatch(amq.bE);
    static BlockMatch netherStair = new BlockMatch(amq.bF);
    static BlockMatch netherSlab = new BlockMatch((amq)amq.an, 6);
    static BlockMatch netherSlabUp = new BlockMatch((amq)amq.an, 14);
    static BlockMatch netherDoubleSlab = new BlockMatch((amq)amq.am, 6);
    BlockMatch host = null;
    int age = 0;
    int generation = 0;
    int random_time_offset = rand.nextInt();
    public static int updateCount = 0;

    public static void burn(Object key, Object val) {
        if (key instanceof amq) {
            key = new BlockMatch((amq)key);
        }
        if (val instanceof amq) {
            val = new BlockMatch((amq)val);
        }
        transforms.put((BlockMatch)key, (BlockMatch)val);
    }

    public static void burn(Object key) {
        TileEntityWrathFire.burn(key, air);
    }

    public static void setupBurning() {
        for (int i = 0; i < amq.p.length; ++i) {
            agi m;
            amq block2 = amq.p[i];
            if (block2 == null || (m = block2.cB) != agi.d && m != agi.n && m != agi.k && m != agi.j && m != agi.l && m != agi.y && m != agi.E) continue;
            TileEntityWrathFire.burn(block2);
        }
        TileEntityWrathFire.burn(amq.aW);
        TileEntityWrathFire.burn(amq.bD, amq.bD);
        TileEntityWrathFire.burn(amq.H, amq.P);
        TileEntityWrathFire.burn(amq.P, amq.H);
        TileEntityWrathFire.burn(amq.x, amq.y);
        TileEntityWrathFire.burn(amq.as, amq.F);
        TileEntityWrathFire.burn(amq.z, amq.w);
        TileEntityWrathFire.burn(amq.w, amq.z);
        TileEntityWrathFire.burn(new BlockMatch(amq.bp, 0), new BlockMatch(amq.bp, 2));
        TileEntityWrathFire.burn(new BlockMatch(amq.bp, 2), new BlockMatch(amq.bp, 0));
        TileEntityWrathFire.burn(new BlockMatch(amq.bp, 1), new BlockMatch(amq.bp, 0));
        TileEntityWrathFire.burn(amq.ar, amq.z);
        TileEntityWrathFire.burn(amq.al, new BlockMatch(Core.registry.resource_block, ResourceType.DARKIRONBLOCK.md));
    }

    public void b(bq tag) {
        super.b(tag);
        if (this.host == null) {
            return;
        }
        tag.a("host_id", this.host.id);
        tag.a("host_md", this.host.md);
        tag.a("age", this.age);
        tag.a("generation", this.generation);
    }

    public void a(bq tag) {
        super.a(tag);
        this.host = new BlockMatch(tag.e("host_id"), tag.e("host_md"));
        this.age = tag.e("age");
        this.generation = tag.e("generation");
    }

    static TileEntityWrathFire getFire(yc worldObj, int x, int y2, int z) {
        any te = worldObj.q(x, y2, z);
        if (te instanceof TileEntityWrathFire) {
            return (TileEntityWrathFire)te;
        }
        return null;
    }

    boolean blockSupports(Coord c) {
        return this.host.matches(c);
    }

    boolean isBlockSupported(Coord c) {
        for (Coord n : c.getNeighborsAdjacent()) {
            if (!this.blockSupports(n)) continue;
            return true;
        }
        return false;
    }

    void inherit(TileEntityWrathFire parent) {
        if (parent == null) {
            return;
        }
        this.host = parent.host;
        this.generation = Math.max(this.generation, parent.generation + 1);
    }

    boolean trySpawn(Coord c) {
        if (!Core.spread_wrathfire) {
            return false;
        }
        if (this.generation > 45) {
            return false;
        }
        int id = c.getId();
        if (id != 0 && !c.isAir()) {
            return false;
        }
        if (!this.isBlockSupported(c)) {
            return false;
        }
        if (c.is(Core.registry.lightair_block) && c.getMd() == 1) {
            return false;
        }
        if (rand.nextInt(3) == 0) {
            return true;
        }
        BlockLightAir cfr_ignored_0 = Core.registry.lightair_block;
        c.setIdMd(Core.registry.lightair_block.cm, 1);
        TileEntityWrathFire fire = (TileEntityWrathFire)c.getTE(TileEntityWrathFire.class);
        if (fire != null) {
            fire.inherit(this);
            return true;
        }
        c.setId(0);
        c.rmTE();
        return false;
    }

    @Override
    public Coord getCoord() {
        return new Coord(this);
    }

    void die() {
        this.w_();
        if ((double)rand.nextFloat() < 0.3333) {
            fire.set(this.getCoord());
        } else {
            this.getCoord().setId(0);
        }
    }

    public void g() {
        if (!this.k.I) {
            this.doUpdate();
        }
    }

    void doUpdate() {
        if ((this.k.G() + (long)this.random_time_offset) % 25L != 0L) {
            return;
        }
        if ((double)rand.nextFloat() > 0.95) {
            return;
        }
        if (this.age > 35) {
            this.die();
            return;
        }
        if (updateCount > 100 && rand.nextBoolean()) {
            return;
        }
        ++updateCount;
        BlockMatch burnTo = (BlockMatch)transforms.get(this.host);
        if (burnTo == null) {
            this.die();
            return;
        }
        Coord here = this.getCoord();
        if (netherBrick.equals(this.host) || netherStair.equals(this.host) || netherFence.equals(this.host) || netherSlab.equals(this.host) || netherSlabUp.equals(this.host) || netherDoubleSlab.equals(this.host)) {
            int furnace_size = 13;
            int src_count = 0;
            for (Coord c : here.getNeighborsDiagonal()) {
                if (!netherBrick.matches(c) && !netherStair.matches(c) && !netherFence.matches(c) && !netherSlab.matches(c) && !netherSlabUp.matches(c) && !netherDoubleSlab.matches(c)) continue;
                ++src_count;
            }
            if (src_count < furnace_size) {
                if (src_count == 0) {
                    this.die();
                    return;
                }
                this.age += furnace_size - src_count;
                return;
            }
            ArrayList n = here.getRandomNeighborsAdjacent();
            for (Coord c : n) {
                if (c.is(amq.bD)) continue;
                for (BlockMatch match : transforms.keySet()) {
                    BlockMatch burnsTo;
                    if (!match.matches(c) || transforms.containsKey(burnsTo = (BlockMatch)transforms.get(match))) continue;
                    burnsTo.set(c);
                    ++this.age;
                    return;
                }
            }
            return;
        }
        ++this.age;
        for (Coord c : here.getRandomNeighborsDiagonal()) {
            if (!this.trySpawn(c)) continue;
            return;
        }
        if (this.age < 11) {
            return;
        }
        for (Coord c : here.getRandomNeighborsDiagonal()) {
            if (!this.host.matches(c)) continue;
            burnTo.set(c);
            return;
        }
        this.age += 10;
    }

    boolean tryLoadTarget(int id, int md2) {
        for (BlockMatch match : transforms.keySet()) {
            if (!match.isType(id, md2)) continue;
            this.host = match;
            return true;
        }
        if (netherBrick.isType(id, md2) || netherFence.isType(id, md2) || netherStair.isType(id, md2) || netherSlab.isType(id, md2) || netherSlabUp.isType(id, md2) || netherDoubleSlab.isType(id, md2)) {
            this.host = netherBrick;
            return true;
        }
        return false;
    }

    void setTarget(int id, int md2) {
        if (this.tryLoadTarget(id, md2)) {
            return;
        }
    }

    public static void ignite(Coord baseBlock, Coord fireBlock, qx player) {
        fireBlock.setIdMd(Core.registry.lightair_block.cm, 1);
        TileEntityWrathFire fire = (TileEntityWrathFire)fireBlock.getTE(TileEntityWrathFire.class);
        if (fire == null) {
            return;
        }
        if (netherBrick.matches(baseBlock) || netherFence.matches(baseBlock) || netherStair.matches(baseBlock) || netherSlab.matches(baseBlock) || netherSlabUp.matches(baseBlock) || netherDoubleSlab.matches(baseBlock)) {
            Sound.wrathForge.playAt((lq)player);
        } else {
            Sound.wrathLight.playAt(fireBlock);
            if (!fireBlock.w.I) {
                Core.logInfo("Wrath Igniter used at " + fireBlock + " by '" + player.bR + "'", new Object[0]);
            }
        }
        fire.setTarget(baseBlock.getId(), baseBlock.getMd());
    }

    public static class BlockMatch {
        int id;
        int md;

        public BlockMatch(int id, int md2) {
            this.id = id;
            this.md = md2;
        }

        public BlockMatch(amq block2) {
            this(block2.cm, -1);
        }

        public BlockMatch(amq block2, int md2) {
            this(block2.cm, md2);
        }

        boolean matches(Coord c) {
            int i = c.getId();
            if (i != this.id) {
                return false;
            }
            if (this.md == -1) {
                return true;
            }
            return this.md == c.getMd();
        }

        boolean isType(int id, int md2) {
            if (id != this.id) {
                return false;
            }
            if (this.md == -1) {
                return true;
            }
            return this.md == md2;
        }

        void set(Coord c) {
            if (this.md == -1) {
                c.setId(this.id);
            } else {
                c.setIdMd(this.id, this.md);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockMatch) {
                BlockMatch m = (BlockMatch)obj;
                return this.id == m.id && this.md == m.md;
            }
            return false;
        }

        public int hashCode() {
            return this.id << 4 + this.md;
        }

        public String toString() {
            return this.id + ":" + this.md;
        }
    }
}

