/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.CubeFace;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.WireConnections;
import java.io.DataInput;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityWire
extends TileEntityCommon
implements IChargeConductor {
    public byte supporting_side;
    private boolean extended_wire = false;
    Charge charge = new Charge(this);

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LEADWIRE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Wire;
    }

    @Override
    public boolean activate(qx entityplayer) {
        return false;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    byte getExtraInfo() {
        return this.supporting_side;
    }

    @Override
    void useExtraInfo(byte b) {
        this.supporting_side = b;
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        tag.a("side", this.supporting_side);
        this.charge.writeToNBT(tag, "charge");
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.supporting_side = tag.c("side");
    }

    boolean find_support() {
        if (!this.extended_wire) {
            return false;
        }
        for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
            if (!this.canPlaceAgainst(null, this.getCoord().towardSide(side), side)) continue;
            this.supporting_side = (byte)side;
            this.shareInfo();
            return true;
        }
        return false;
    }

    boolean is_directly_supported() {
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        if (!supporter.blockExists()) {
            return true;
        }
        return supporter.isSolidOnSide(this.supporting_side);
    }

    boolean is_supported() {
        if (this.is_directly_supported()) {
            return true;
        }
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        TileEntityWire parent = (TileEntityWire)supporter.getTE(TileEntityWire.class);
        if (parent != null) {
            this.extended_wire = true;
            return parent.is_supported();
        }
        return false;
    }

    @Override
    boolean canPlaceAgainst(qx player, Coord supporter, int side) {
        if (supporter.isSolidOnSide(side)) {
            return true;
        }
        TileEntityWire parent = (TileEntityWire)supporter.getTE(TileEntityWire.class);
        if (parent != null && parent.is_directly_supported()) {
            return parent.supporting_side != side && parent.supporting_side != CubeFace.oppositeSide(side);
        }
        return false;
    }

    public void g() {
        if (this.k.I) {
            return;
        }
        this.charge.update();
    }

    @Override
    public void neighborChanged() {
        if (!this.is_supported()) {
            Core.registry.factory_block.c(this.k, this.l, this.m, this.n, BlockClass.Wire.md, 0);
            Coord here = this.getCoord();
            here.setId(0);
            here.rmTE();
        }
    }

    int getComplexity(byte new_side) {
        this.supporting_side = new_side;
        int complexity = new WireConnections(this).getComplexity();
        for (Coord ne : this.getCoord().getNeighborsAdjacent()) {
            TileEntityWire w2 = (TileEntityWire)ne.getTE(TileEntityWire.class);
            if (w2 == null) continue;
            complexity += new WireConnections(w2).getComplexity();
        }
        TileEntityWire below = (TileEntityWire)this.getCoord().add(ForgeDirection.getOrientation((int)this.supporting_side)).getTE(TileEntityWire.class);
        if (below != null && below.supporting_side == this.supporting_side) {
            complexity += 16;
        }
        return complexity;
    }

    @Override
    void onPlacedBy(qx player, ur is, int side) {
        side = (new int[]{1, 0, 3, 2, 5, 4})[side];
        if (player.ah()) {
            this.supporting_side = (byte)side;
            if (this.is_supported()) {
                this.shareInfo();
                return;
            }
        }
        byte best_side = (byte)side;
        int best_complexity = this.getComplexity(best_side) - 1;
        if (!this.is_supported()) {
            best_complexity = 2457;
        }
        for (byte s2 = 0; s2 < 6; s2 = (byte)((byte)(s2 + 1))) {
            int test;
            if (s2 == side) continue;
            this.supporting_side = s2;
            if (!this.is_supported() || (test = this.getComplexity(s2)) >= best_complexity) continue;
            best_complexity = test;
            best_side = s2;
        }
        this.supporting_side = best_side;
        this.shareInfo();
    }

    void shareInfo() {
        this.broadcastMessage(null, 121, this.supporting_side);
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    public aoh collisionRayTrace(yc w2, int x, int y2, int z, aoj startVec, aoj endVec) {
        return new WireConnections(this).collisionRayTrace(w2, x, y2, z, startVec, endVec);
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public void setBlockBounds(amq b) {
        new WireConnections(this).setBlockBounds(b);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 121) {
            this.supporting_side = input.readByte();
            this.getCoord().redraw();
            return true;
        }
        return false;
    }
}

