/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntitySolarBoiler;
import java.io.DataInput;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEntitySteamTurbine
extends TileEntityCommon
implements ITankContainer,
IChargeConductor {
    LiquidTank steamTank = new LiquidTank(TileEntitySolarBoiler.steam_stack.copy(), 16000, (any)this);
    Charge charge = new Charge(this);
    int fan_speed = 0;
    public int fan_rotation = 0;
    int last_speed = -9999;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.STEAMTURBINE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        FactorizationUtil.writeTank(tag, this.steamTank, "steam");
        this.charge.writeToNBT(tag);
        tag.a("fan", this.fan_speed);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        FactorizationUtil.readTank(tag, this.steamTank, "steam");
        this.charge.readFromNBT(tag);
        this.fan_speed = tag.e("fan");
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.steamTank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.steamTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UP) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.steamTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UP) {
            return null;
        }
        return this.steamTank;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        float s2 = (float)(this.steamTank.getLiquid().amount * 16) / (float)this.steamTank.getCapacity();
        return "Steam: " + String.format("%.1f", Float.valueOf(s2)) + "\nFan: " + this.fan_speed;
    }

    public void shareFanSpeed() {
        boolean share = false;
        if (this.last_speed + this.fan_speed < 2) {
            share = true;
        } else if (this.fan_speed > 0) {
            share = Math.abs((double)this.last_speed / (double)this.fan_speed) > 0.05;
        } else if (this.fan_speed == 0 && this.last_speed != 0) {
            share = true;
        }
        if (share) {
            this.last_speed = this.fan_speed;
            this.broadcastMessage(null, 71, this.fan_speed);
        }
    }

    public void g() {
        long seed;
        this.fan_rotation += Math.min(35, this.fan_speed);
        if (this.k.I) {
            return;
        }
        this.shareFanSpeed();
        this.charge.update();
        if (this.k.A(this.l, this.m, this.n)) {
            this.fan_speed = Math.max(0, this.fan_speed - 1);
            return;
        }
        LiquidStack steam = this.steamTank.getLiquid();
        if (steam == null) {
            steam = LiquidDictionary.getLiquid((String)"Steam", (int)0);
            this.steamTank.setLiquid(steam);
        }
        if ((seed = (long)this.getCoord().seed() + this.k.G()) % 5L == 0L) {
            if (this.fan_speed > steam.amount) {
                this.fan_speed -= 10;
                steam.amount = 0;
            } else if (steam.amount == this.fan_speed) {
                steam.amount = 0;
            } else if (steam.amount > this.fan_speed) {
                steam.amount -= this.fan_speed + 1;
                ++this.fan_speed;
            }
        }
        if (this.fan_speed < 0) {
            this.fan_speed = 0;
            return;
        }
        if (3 * this.charge.getValue() > this.fan_speed) {
            return;
        }
        this.charge.addValue(this.fan_speed);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 71) {
            this.fan_speed = input.readInt();
            return true;
        }
        return false;
    }
}

