/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.IReflectionTarget;
import factorization.common.BlockClass;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;

public class TileEntitySolarTurbine
extends TileEntityCommon
implements IChargeConductor,
IReflectionTarget {
    Charge charge = new Charge(this);
    int reflectors = 0;
    public int water_level = 0;
    public static final int max_water = 16384;
    int fan_speed = 0;
    public float fan_rotation = 0.0f;
    int last_speed = -99;
    int last_quart_water_level = -99;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOLARTURBINE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return "Power: " + this.getHeat();
    }

    @Override
    public void addReflector(int strength) {
        this.reflectors += strength;
        if (this.reflectors < 0) {
            System.err.println("reflector count went negative!");
            new Exception().printStackTrace();
            this.reflectors = 0;
        }
    }

    public int getReflectors() {
        return this.reflectors;
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.charge.writeToNBT(tag);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.charge.readFromNBT(tag);
        this.fan_rotation = rand.nextInt(90);
    }

    @Override
    public boolean activate(qx entityplayer) {
        return false;
    }

    int getHeat() {
        return this.reflectors;
    }

    boolean saturated() {
        return this.charge.getValue() > this.getHeat() * 3;
    }

    void adjustFanSpeed() {
        int heat = this.getHeat();
        if (heat != this.fan_speed) {
            int delta = heat - this.fan_speed;
            int change = delta / 16;
            if (change == 0) {
                change = 1;
            }
            this.fan_speed = (int)((float)this.fan_speed + Math.copySign(change, delta));
        }
    }

    boolean distant(int original, int curent, float delta) {
        int d = (int)((float)original * delta);
        return curent < original - d || original + d < curent;
    }

    void updateClients() {
        int quart_water_level;
        if (this.last_speed != this.fan_speed) {
            this.broadcastMessage(null, 71, this.fan_speed);
            this.last_speed = this.fan_speed;
        }
        if (this.last_quart_water_level != (quart_water_level = this.water_level / 4)) {
            this.broadcastMessage(null, 70, this.water_level);
            this.last_quart_water_level = quart_water_level;
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case 71: {
                this.fan_speed = input.readInt();
                return true;
            }
            case 70: {
                this.water_level = input.readInt();
                this.getCoord().redraw();
                return true;
            }
        }
        return false;
    }

    public void g() {
        Coord below;
        this.fan_rotation = this.fan_speed == -1 ? (float)((double)this.fan_rotation + (rand.nextBoolean() ? -0.25 : 0.25)) : (this.fan_speed > 35 ? (this.fan_rotation += 35.0f) : (this.fan_rotation += (float)this.fan_speed));
        if (this.k.I) {
            return;
        }
        this.updateClients();
        this.charge.update();
        if (this.water_level <= 0 && ((below = this.getCoord().add(0, -1, 0)).is(amq.D) || below.is(amq.E)) && below.getMd() == 0) {
            below.setId(0);
            this.water_level = 16384;
            this.getCoord().redraw();
        }
        if (this.water_level <= 0) {
            return;
        }
        int heat = this.getHeat();
        if (heat <= 0) {
            this.adjustFanSpeed();
            return;
        }
        if (this.saturated()) {
            if (heat > 0) {
                if (this.fan_speed > heat / 2) {
                    --this.fan_speed;
                }
            } else {
                this.adjustFanSpeed();
            }
            return;
        }
        this.adjustFanSpeed();
        if (this.reflectors == 0 && this.k.G() % 20L == 0L) {
            return;
        }
        int last_cut = this.water_level / 64;
        int delta = Math.min(heat, this.water_level);
        this.charge.addValue(delta);
        this.water_level -= delta;
        if (this.water_level / 64 != last_cut) {
            this.getCoord().redraw();
        }
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return side != 1;
    }
}

