/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public class TileEntitySlagFurnace
extends TileEntityFactorization {
    ur[] furnaceItemStacks = new ur[4];
    public int furnaceBurnTime;
    public int currentFuelItemBurnTime;
    public int furnaceCookTime;
    static final int input = 0;
    static final int fuel = 1;
    static final int output = 2;

    public int k_() {
        return 4;
    }

    public ur a(int i) {
        return this.furnaceItemStacks[i];
    }

    public void a(int i, ur is) {
        this.furnaceItemStacks[i] = is;
    }

    public String b() {
        return "Slag Furnace";
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
            case UP: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
            return 1;
        }
        return 2;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SLAGFURNACE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.MachineLightable;
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.readSlotsFromNBT(tag);
        this.furnaceBurnTime = tag.e("burnTime");
        this.furnaceCookTime = tag.e("cookTime");
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.writeSlotsToNBT(tag);
        tag.a("burnTime", this.furnaceBurnTime);
        tag.a("cookTime", this.furnaceCookTime);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public void g() {
        boolean burnState = this.isBurning();
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (this.k.I) {
            return;
        }
        boolean invChanged = false;
        if (this.furnaceBurnTime <= 0 && this.canSmelt()) {
            this.currentFuelItemBurnTime = this.furnaceBurnTime = anr.a((ur)this.furnaceItemStacks[1]) / 2;
            this.broadcastMessage(null, 140, this.furnaceBurnTime);
            if (this.furnaceBurnTime > 0) {
                invChanged = true;
                if (this.furnaceItemStacks[1] != null) {
                    --this.furnaceItemStacks[1].a;
                    if (this.furnaceItemStacks[1].a == 0) {
                        this.furnaceItemStacks[1] = this.furnaceItemStacks[1].b().getContainerItemStack(this.furnaceItemStacks[1]);
                    }
                }
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.furnaceCookTime;
            if (this.furnaceCookTime >= 200 || Core.cheat) {
                this.furnaceCookTime = 0;
                this.smeltItem();
                invChanged = true;
            }
        } else {
            this.furnaceCookTime = 0;
        }
        if (burnState != this.isBurning() || this.isBurning() && this.draw_active != 1) {
            this.draw_active = (byte)-1;
            this.drawActive(this.furnaceBurnTime > 0 ? 2 : 0);
            Coord here = this.getCoord();
            here.redraw();
            here.updateLight();
        }
        if (invChanged) {
            this.d();
        }
    }

    boolean checkFit(ur output, ur res, int resSize) {
        if (output == null) {
            return true;
        }
        if (!FactorizationUtil.identical(output, res)) {
            return false;
        }
        return output.a + resSize <= output.d();
    }

    boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        SmeltingResult res = SlagRecipes.getSlaggingResult(this.furnaceItemStacks[0]);
        if (res == null) {
            return false;
        }
        return this.checkFit(this.furnaceItemStacks[2], res.output1, (int)res.prob1) && this.checkFit(this.furnaceItemStacks[3], res.output2, (int)res.prob2);
    }

    int getRandomSize(float f) {
        int i = (int)f;
        if (f - (float)i > rand.nextFloat()) {
            ++i;
        }
        return i;
    }

    void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        SmeltingResult res = SlagRecipes.getSlaggingResult(this.furnaceItemStacks[0]);
        if (this.furnaceItemStacks[2] == null) {
            this.furnaceItemStacks[2] = ur.b((ur)res.output1);
            this.furnaceItemStacks[2].a = 0;
        }
        if (this.furnaceItemStacks[3] == null) {
            this.furnaceItemStacks[3] = ur.b((ur)res.output2);
            this.furnaceItemStacks[3].a = 0;
        }
        ur fo0 = this.furnaceItemStacks[2];
        ur fo1 = this.furnaceItemStacks[3];
        fo0.a += this.getRandomSize(res.prob1);
        fo1.a += this.getRandomSize(res.prob2);
        if (fo0.a > fo0.d()) {
            fo0.a = fo0.d();
        }
        if (fo1.a > fo1.d()) {
            fo1.a = fo1.d();
        }
        if (fo0.a <= 0) {
            this.furnaceItemStacks[2] = null;
        }
        if (fo1.a <= 0) {
            this.furnaceItemStacks[3] = null;
        }
        --this.furnaceItemStacks[0].a;
        if (this.furnaceItemStacks[0].a == 0) {
            this.furnaceItemStacks[0] = null;
        }
    }

    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 200;
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentFuelItemBurnTime == 0) {
            this.currentFuelItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentFuelItemBurnTime;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            if (messageType == 0) {
                this.getCoord().updateLight();
            }
            return true;
        }
        if (messageType == 140) {
            this.furnaceBurnTime = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    public ef l() {
        return super.getDescriptionPacketWith(140, this.furnaceBurnTime);
    }

    public static class SlagRecipes {
        public static ArrayList smeltingResults = new ArrayList();

        static void register(Object o_input, float prob1, Object o_output1, float prob2, Object o_output2) {
            ur input = SlagRecipes.obj2is(o_input);
            ur output1 = SlagRecipes.obj2is(o_output1);
            ur output2 = SlagRecipes.obj2is(o_output2);
            input = ur.b((ur)input);
            input.a = 1;
            SmeltingResult value = new SmeltingResult(input, prob1, output1, prob2, output2);
            smeltingResults.add(value);
        }

        static ur obj2is(Object o) {
            if (o instanceof ur) {
                return (ur)o;
            }
            if (o instanceof amq) {
                amq b = (amq)o;
                return new ur(up.e[b.cm]);
            }
            if (o instanceof up) {
                return new ur((up)o);
            }
            return null;
        }

        static SmeltingResult getSlaggingResult(ur input) {
            for (SmeltingResult res : smeltingResults) {
                if (!FactorizationUtil.identical(input, res.input)) continue;
                return res;
            }
            return null;
        }
    }

    public static class SmeltingResult {
        public ur input;
        public float prob1;
        public float prob2;
        public ur output1;
        public ur output2;

        SmeltingResult(ur input, float prob1, ur output1, float prob2, ur output2) {
            this.input = input;
            this.prob1 = prob1;
            this.prob2 = prob2;
            this.output1 = output1;
            this.output2 = output2;
        }
    }
}

