/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.CubeFace;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemMachineUpgrade;
import factorization.common.Sound;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.regex.Matcher;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityRouter
extends TileEntityFactorization {
    public final int maxSearchPerTick = 16;
    public int guiLastButtonSet = 0;
    public boolean upgradeItemFilter = false;
    public boolean upgradeMachineFilter = false;
    public boolean upgradeSpeed = false;
    public boolean upgradeThorough = false;
    public boolean upgradeThroughput = false;
    public boolean upgradeEject = false;
    public int target_side = 1;
    public int target_slot = -1;
    public boolean is_input = true;
    public boolean match_to_visit = false;
    public int eject_direction;
    public String match;
    ur buffer = null;
    ur[] filter = new ur[9];
    Coord lastSeenAt;
    private HashSet visited = new HashSet();
    private LinkedList frontier = new LinkedList();
    private static Random random = new Random();
    int delayDistance;
    private int ticksSinceLastSpam = 9999;
    int last_eject = 0;

    public TileEntityRouter() {
        this.match = new String("");
    }

    void resetGraph() {
        this.visited.clear();
        this.visited.add(this);
        this.frontier.add(this);
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.DarkIron;
    }

    void putParticles(yc world) {
        double vz;
        double vy;
        double vx;
        double pz;
        double py;
        double px2;
        int i;
        if (this.lastSeenAt == null) {
            return;
        }
        if (this.draw_active == 0) {
            return;
        }
        int out_count = 1;
        int in_count = 1;
        if (this.is_input) {
            in_count = this.upgradeThroughput ? (in_count += 5) : (in_count += 3);
        } else if (this.upgradeThroughput) {
            out_count += 5;
        } else {
            in_count += 3;
        }
        for (i = out_count; i != 0; --i) {
            px2 = (double)this.l + 0.5 + (double)(random.nextFloat() / 2.0f);
            py = (double)this.m + 0.5 + (double)(random.nextFloat() / 2.0f);
            pz = (double)this.n + 0.5 + (double)(random.nextFloat() / 2.0f);
            vx = (double)this.lastSeenAt.x - px2 + (double)(random.nextFloat() / 2.0f);
            vy = (double)this.lastSeenAt.y - py + (double)(random.nextFloat() / 2.0f);
            vz = (double)this.lastSeenAt.z - pz + (double)(random.nextFloat() / 2.0f);
            world.a("portal", px2, py, pz, vx, vy, vz);
        }
        for (i = in_count; i != 0; --i) {
            px2 = (double)this.lastSeenAt.x + 0.5 + (double)(random.nextFloat() / 2.0f);
            py = (double)this.lastSeenAt.y + 0.5 + (double)(random.nextFloat() / 2.0f);
            pz = (double)this.lastSeenAt.z + 0.5 + (double)(random.nextFloat() / 2.0f);
            vx = (double)this.l - px2 + (double)(random.nextFloat() / 2.0f);
            vy = (double)this.m - py + (double)(random.nextFloat() / 2.0f);
            vz = (double)this.n - pz + (double)(random.nextFloat() / 2.0f);
            world.a("portal", px2, py, pz, vx, vy, vz);
        }
    }

    private la openInventory(any ent) {
        if (ent instanceof anm) {
            la chest = FactorizationUtil.openDoubleChest((anm)ent);
            return chest == null ? this : chest;
        }
        if (ent instanceof la) {
            return (la)ent;
        }
        return null;
    }

    boolean tryInsert(any ent) {
        la inv;
        if (ent.r()) {
            return false;
        }
        if (ent instanceof la && this.actOn(inv = this.openInventory(ent))) {
            this.draw_active = (byte)(this.draw_active + 1);
            Coord here = new Coord(ent);
            this.delayDistance = !this.upgradeSpeed ? (int)here.distance(this.lastSeenAt) : 1;
            this.lastSeenAt = here;
            this.broadcastItem(24, null);
            return true;
        }
        return false;
    }

    Coord getEjectCoord() {
        if (!this.upgradeEject) {
            return null;
        }
        return this.getCoord().add(new CubeFace(this.eject_direction).toVector());
    }

    void eject() {
        ForgeDirection access_side;
        ISidedInventory isi;
        if (this.last_eject != 0) {
            --this.last_eject;
        }
        this.last_eject = 20;
        Coord target = this.getEjectCoord();
        la inv = (la)target.getTE(la.class);
        if (inv == null) {
            return;
        }
        int start = 0;
        int end = inv.k_();
        if (inv instanceof ISidedInventory && (start = (isi = (ISidedInventory)inv).getStartInventorySide(access_side = ForgeDirection.getOrientation((int)CubeFace.oppositeSide(this.eject_direction)))) == (end = start + isi.getSizeInventorySide(access_side))) {
            return;
        }
        for (int slot = start; slot < end; ++slot) {
            if (!this.moveStack(this, 0, (la)target.getTE(la.class), slot)) continue;
            return;
        }
    }

    @Override
    void doLogic() {
        Core.profileStart("router");
        this.needLogic();
        ++this.ticksSinceLastSpam;
        if (this.lastSeenAt == null) {
            this.lastSeenAt = this.getCoord();
        }
        if (this.frontier.size() == 0) {
            this.resetGraph();
        }
        if (this.upgradeEject && !this.is_input && this.buffer != null && this.buffer.a > 0) {
            this.eject();
        }
        if (this.delayDistance > 0) {
            --this.delayDistance;
            return;
        }
        int i = 16;
        if (this.upgradeSpeed) {
            i *= 2;
        }
        while (i-- != 0 && this.shouldUpdate() && this.frontier.size() > 0) {
            this.updateFrontier();
            if (this.delayDistance == 0) continue;
        }
        Core.profileEnd();
    }

    any popFrontier() {
        if (this.upgradeSpeed) {
            return (any)this.frontier.remove();
        }
        int closestDistance = Integer.MAX_VALUE;
        int closestIndex = 0;
        int end = Math.min(8, this.frontier.size());
        for (int i = 0; i < end; ++i) {
            int d = this.lastSeenAt.distanceSq(new Coord((any)this.frontier.get(i)));
            if (d < closestDistance) {
                closestDistance = d;
                closestIndex = i;
            }
            if (closestDistance != 1) continue;
            return (any)this.frontier.remove(i);
        }
        return (any)this.frontier.remove(closestIndex);
    }

    void updateFrontier() {
        if (this.frontier.size() == 0) {
            return;
        }
        any here = this.popFrontier();
        if (here != this && this.tryInsert(here) && this.upgradeThorough) {
            this.resetGraph();
            this.frontier.add(here);
            return;
        }
        for (Coord neighbor : new Coord(here).getNeighborsAdjacent()) {
            any ent = neighbor.getTE();
            if (!(ent instanceof la) || this.visited.contains(ent) || this.match_to_visit && !this.matchIInventory((la)ent)) continue;
            this.frontier.add(ent);
            this.visited.add(ent);
        }
    }

    boolean shouldUpdate() {
        if (this.k.A(this.l, this.m, this.n)) {
            return false;
        }
        if (this.is_input) {
            return this.buffer != null;
        }
        if (this.buffer == null) {
            return true;
        }
        return this.buffer.a < this.buffer.d();
    }

    boolean moveStack(la src, int src_slot, la dest, int dest_slot) {
        ur srcStack = src.a(src_slot);
        ur destStack = dest.a(dest_slot);
        if (srcStack == null || srcStack.a <= 0) {
            return false;
        }
        if (destStack == null) {
            if (this.upgradeThroughput) {
                src.a(src_slot, null);
                dest.a(dest_slot, srcStack);
                return true;
            }
            destStack = srcStack.l();
            destStack.a = 0;
        }
        if (!FactorizationUtil.identical(srcStack, destStack)) {
            return false;
        }
        if (destStack.a >= destStack.d()) {
            return false;
        }
        if (this.upgradeThroughput) {
            int movable = destStack.d() - destStack.a;
            if (movable > srcStack.a) {
                destStack.a += srcStack.a;
                src.a(src_slot, null);
                dest.a(dest_slot, destStack);
                return true;
            }
            srcStack.a(movable);
            destStack.a += movable;
            if (srcStack.a == 0) {
                srcStack = null;
            }
            src.a(src_slot, srcStack);
            dest.a(dest_slot, destStack);
        } else {
            --srcStack.a;
            srcStack = FactorizationUtil.normalize(srcStack);
            ++destStack.a;
            src.a(src_slot, srcStack);
            dest.a(dest_slot, destStack);
        }
        return true;
    }

    boolean isIInventoryBanned(String name2) {
        if (Core.routerBan == null) {
            return false;
        }
        Matcher m = Core.routerBan.matcher(name2);
        return m.matches();
    }

    public String getIInventoryName(la t) {
        String invName = t.b();
        if (invName == null || invName.length() == 0) {
            String className = t.getClass().getSimpleName();
            if (className == null || className.length() == 0) {
                return t.toString();
            }
            return className.toLowerCase();
        }
        return invName;
    }

    boolean matchIInventory(la t) {
        if (t == null) {
            return false;
        }
        String invName = this.getIInventoryName(t);
        if (invName == null || this.isIInventoryBanned(invName)) {
            return false;
        }
        if (this.upgradeEject && t == this.getEjectCoord().getTE(la.class)) {
            return false;
        }
        if (this.match == null || this.match.length() == 0 || !this.upgradeMachineFilter) {
            return true;
        }
        invName = invName.toLowerCase();
        for (String comp : this.match.split("\\|")) {
            if ((comp = comp.toLowerCase()).startsWith("!")) {
                if (!invName.startsWith(comp = comp.replaceFirst("!", ""))) continue;
                return false;
            }
            if (!invName.startsWith(comp)) continue;
            return true;
        }
        return false;
    }

    boolean isLocked(la t) {
        if (t instanceof ISidedInventory) {
            int free_count = 0;
            ISidedInventory inv = (ISidedInventory)t;
            for (ForgeDirection side : ForgeDirection.values()) {
                if (inv.getSizeInventorySide(side) == 0) continue;
                ++free_count;
            }
            return free_count == 0;
        }
        return false;
    }

    boolean legalSlot(la t, int slot) {
        if (!(t instanceof ISidedInventory)) {
            return true;
        }
        ISidedInventory s2 = (ISidedInventory)t;
        for (ForgeDirection side : ForgeDirection.values()) {
            int low = s2.getStartInventorySide(side);
            int high = low + s2.getSizeInventorySide(side);
            if (low > slot || slot >= high) continue;
            return true;
        }
        return false;
    }

    boolean itemPassesInsertFilter(la inv, ur is) {
        ur here;
        int i;
        if (!this.upgradeItemFilter) {
            return true;
        }
        int matching_count = 0;
        boolean empty_filter = true;
        for (i = 0; i < this.filter.length; ++i) {
            here = this.filter[i];
            if (here == null) continue;
            empty_filter = false;
            if (!FactorizationUtil.identical(here, is)) continue;
            matching_count += here.a;
        }
        if (empty_filter) {
            return true;
        }
        for (i = 0; i < inv.k_(); ++i) {
            here = inv.a(i);
            if (here == null || !FactorizationUtil.identical(here, is)) continue;
            matching_count -= here.a;
        }
        return matching_count > 0;
    }

    boolean itemPassesExtractFilter(ur is) {
        if (!this.upgradeItemFilter) {
            return true;
        }
        if (is == null) {
            return false;
        }
        int hits = 0;
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i] == null) continue;
            ++hits;
            if (this.filter[i].a(is)) {
                return true;
            }
            if (this.filter[i].c != is.c || !is.b().n() || !this.filter[i].h() || !is.h()) continue;
            return true;
        }
        return hits == 0;
    }

    boolean actOn(la t) {
        int end;
        int start;
        if (t == null) {
            return false;
        }
        if (t instanceof TileEntityRouter && (!this.upgradeMachineFilter || this.match == null || this.match.isEmpty())) {
            return false;
        }
        if (!this.matchIInventory(t)) {
            return false;
        }
        if (t instanceof ISidedInventory && this.target_side < 6 && this.target_side >= 0 && this.target_slot < 0) {
            t = new FactorizationUtil.ISidedWrapper((ISidedInventory)t, ForgeDirection.getOrientation((int)this.target_side));
        }
        if (this.target_slot < 0) {
            start = 0;
            end = t.k_();
        } else {
            if (this.isLocked(t)) {
                return false;
            }
            start = this.target_slot;
            end = this.target_slot + 1;
            if (start >= t.k_()) {
                return false;
            }
        }
        for (int slot = start; slot < end; ++slot) {
            if (!this.legalSlot(t, slot)) continue;
            if (this.is_input) {
                if (!this.itemPassesInsertFilter(t, this.buffer) || !this.moveStack(this, 0, t, slot)) continue;
                this.d();
                t.d();
                return true;
            }
            if (!this.itemPassesExtractFilter(t.a(slot)) || !this.moveStack(t, slot, this, 0)) continue;
            this.d();
            t.d();
            return true;
        }
        return false;
    }

    void verifyUpgrades() {
        if (!this.upgradeItemFilter) {
            for (int i = 0; i < this.filter.length; ++i) {
                this.filter[i] = null;
            }
        }
        if (!this.upgradeMachineFilter) {
            this.match_to_visit = false;
            this.match = null;
        }
    }

    @Override
    public void dropContents() {
        super.dropContents();
        ArrayList<ur> toDrop = new ArrayList<ur>();
        if (this.upgradeItemFilter) {
            toDrop.add(new ur((up)Core.registry.router_item_filter));
        }
        if (this.upgradeMachineFilter) {
            toDrop.add(new ur((up)Core.registry.router_machine_filter));
        }
        if (this.upgradeSpeed) {
            toDrop.add(new ur((up)Core.registry.router_speed));
        }
        if (this.upgradeThorough) {
            toDrop.add(new ur((up)Core.registry.router_thorough));
        }
        if (this.upgradeThroughput) {
            toDrop.add(new ur((up)Core.registry.router_throughput));
        }
        if (this.upgradeEject) {
            toDrop.add(new ur((up)Core.registry.router_eject));
        }
        Coord here = this.getCoord();
        for (ur is : toDrop) {
            FactorizationUtil.spawnItemStack(here, is);
        }
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.verifyUpgrades();
        tag.a("target_side", this.target_side);
        tag.a("use_slot", this.target_slot);
        tag.a("is_input", this.is_input);
        this.writeSlotsToNBT(tag);
        if (this.match != null) {
            tag.a("match", this.match);
        }
        tag.a("match_to_visit", this.match_to_visit);
        tag.a("eject_side", this.eject_direction);
        tag.a("upgrade_item_filter", this.upgradeItemFilter);
        tag.a("upgrade_machine_filter", this.upgradeMachineFilter);
        tag.a("upgrade_speed", this.upgradeSpeed);
        tag.a("upgrade_thorough", this.upgradeThorough);
        tag.a("upgrade_throughput", this.upgradeThroughput);
        tag.a("upgrade_eject", this.upgradeEject);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.target_side = tag.e("target_side");
        this.target_slot = tag.e("use_slot");
        this.is_input = tag.n("is_input");
        if (tag.b("buffer")) {
            this.buffer = ur.a((bq)tag.l("buffer"));
        } else {
            this.readSlotsFromNBT(tag);
        }
        this.match = tag.i("match");
        this.match_to_visit = tag.n("match_to_visit");
        this.eject_direction = tag.e("eject_side");
        this.upgradeItemFilter = tag.n("upgrade_item_filter");
        this.upgradeMachineFilter = tag.n("upgrade_machine_filter");
        this.upgradeSpeed = tag.n("upgrade_speed");
        this.upgradeThorough = tag.n("upgrade_thorough");
        this.upgradeThroughput = tag.n("upgrade_throughput");
        this.upgradeEject = tag.n("upgrade_eject");
    }

    @Override
    public boolean takeUpgrade(ur is) {
        ItemMachineUpgrade upgrade = (ItemMachineUpgrade)is.b();
        if (upgrade == Core.registry.router_item_filter) {
            if (this.upgradeItemFilter) {
                return false;
            }
            this.upgradeItemFilter = true;
        } else if (upgrade == Core.registry.router_machine_filter) {
            if (this.upgradeMachineFilter) {
                return false;
            }
            this.upgradeMachineFilter = true;
        } else if (upgrade == Core.registry.router_speed) {
            if (this.upgradeSpeed) {
                return false;
            }
            this.upgradeSpeed = true;
        } else if (upgrade == Core.registry.router_thorough) {
            if (this.upgradeThorough) {
                return false;
            }
            this.upgradeThorough = true;
        } else if (upgrade == Core.registry.router_throughput) {
            if (this.upgradeThroughput) {
                return false;
            }
            this.upgradeThroughput = true;
        } else if (upgrade == Core.registry.router_eject) {
            if (this.upgradeEject) {
                return false;
            }
            this.upgradeEject = true;
        } else {
            return false;
        }
        return true;
    }

    public int k_() {
        return 10;
    }

    public ur a(int i) {
        if (i == 0) {
            return this.buffer;
        }
        int f = i - 1;
        if (f >= 0 && f < this.filter.length) {
            return this.filter[f];
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        if (i == 0) {
            this.buffer = itemstack;
            return;
        }
        int f = i - 1;
        if (f >= 0 && f < this.filter.length) {
            this.filter[f] = itemstack;
        }
    }

    public String b() {
        return "Item Router";
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.ROUTER;
    }

    public boolean handleMessageFromAny(int messageType, DataInput input) throws IOException {
        boolean need_share;
        switch (messageType) {
            case 21: {
                int m = input.readInt();
                need_share = this.target_side != m;
                this.target_side = m;
                break;
            }
            case 20: {
                int m = input.readInt();
                need_share = m != this.target_slot;
                this.target_slot = m;
                break;
            }
            case 23: {
                boolean b = input.readBoolean();
                need_share = b != this.is_input;
                this.is_input = b;
                break;
            }
            case 22: {
                String s2 = input.readUTF();
                need_share = this.match == null || !this.match.equals(s2);
                this.match = s2;
                break;
            }
            case 25: {
                boolean b = input.readBoolean();
                need_share = b != this.match_to_visit;
                this.match_to_visit = b;
                break;
            }
            case 28: {
                int m = input.readInt();
                need_share = m != this.eject_direction;
                this.eject_direction = m;
                break;
            }
            default: {
                return false;
            }
        }
        if (need_share && !this.k.I) {
            this.broadcastItem(messageType, null);
        }
        return true;
    }

    @Override
    void sendFullDescription(qx player) {
        super.sendFullDescription(player);
        this.broadcastItem(-1, player);
    }

    public void broadcastItem(int messageType, qx who) {
        boolean all;
        boolean bl = all = messageType == -1;
        if (all || messageType == 21) {
            this.broadcastMessage(who, 21, this.target_side);
        }
        if (all || messageType == 20) {
            this.broadcastMessage(who, 20, this.target_slot);
        }
        if (all || messageType == 23) {
            this.broadcastMessage(who, 23, this.is_input);
        }
        if (all || messageType == 27) {
            this.broadcastMessage(who, 27, this.upgradeItemFilter, this.upgradeMachineFilter, this.upgradeSpeed, this.upgradeThorough, this.upgradeThroughput, this.upgradeEject);
        }
        if (all || messageType == 22) {
            if (this.match == null) {
                this.match = "";
            }
            this.broadcastMessage(who, 22, this.match);
        }
        if (all || messageType == 25) {
            this.broadcastMessage(who, 25, this.match_to_visit);
        }
        if (all || messageType == 28) {
            this.broadcastMessage(who, 28, this.eject_direction);
        }
        if (messageType == 24 && this.lastSeenAt != null && this.ticksSinceLastSpam > 10) {
            this.broadcastMessage(who, 24, this.lastSeenAt.x, this.lastSeenAt.y, this.lastSeenAt.z);
            this.ticksSinceLastSpam = 0;
        }
    }

    @Override
    public void broadcastMessage(qx who, int messageType, Object ... items) {
        Core.network.broadcastMessage(who, this.getCoord(), messageType, items);
    }

    public void removeUpgrade(int upgradeType, qx player) {
        ur drop = null;
        if (upgradeType == Core.registry.router_item_filter.upgradeId && this.upgradeItemFilter) {
            for (int i = 0; i < this.filter.length; ++i) {
                ur is = this.filter[i];
                if (is == null) continue;
                player.bJ.a(is);
                this.filter[i] = null;
            }
            drop = new ur((up)Core.registry.router_item_filter);
            this.upgradeItemFilter = false;
        } else if (upgradeType == Core.registry.router_machine_filter.upgradeId && this.upgradeMachineFilter) {
            drop = new ur((up)Core.registry.router_machine_filter);
            this.upgradeMachineFilter = false;
        } else if (upgradeType == Core.registry.router_speed.upgradeId && this.upgradeSpeed) {
            drop = new ur((up)Core.registry.router_speed);
            this.upgradeSpeed = false;
        } else if (upgradeType == Core.registry.router_thorough.upgradeId && this.upgradeThorough) {
            drop = new ur((up)Core.registry.router_thorough);
            this.upgradeThorough = false;
        } else if (upgradeType == Core.registry.router_throughput.upgradeId && this.upgradeThroughput) {
            drop = new ur((up)Core.registry.router_throughput);
            this.upgradeThroughput = false;
        } else if (upgradeType == Core.registry.router_eject.upgradeId && this.upgradeEject) {
            drop = new ur((up)Core.registry.router_eject);
            this.upgradeEject = false;
        }
        this.verifyUpgrades();
        if (drop != null) {
            player.bJ.a(drop);
        } else if (!this.k.I) {
            // empty if block
        }
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        if (this.handleMessageFromAny(messageType, input)) {
            return true;
        }
        if (messageType == 26) {
            this.removeUpgrade(input.readInt(), Core.network.getCurrentPlayer());
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (this.handleMessageFromAny(messageType, input)) {
            return true;
        }
        if (messageType == 24) {
            int x = input.readInt();
            int y2 = input.readInt();
            int z = input.readInt();
            this.lastSeenAt = new Coord(this.k, x, y2, z);
            this.drawActive(1);
            return true;
        }
        if (messageType == 27) {
            this.upgradeItemFilter = input.readBoolean();
            this.upgradeMachineFilter = input.readBoolean();
            this.upgradeSpeed = input.readBoolean();
            this.upgradeThorough = input.readBoolean();
            this.upgradeThroughput = input.readBoolean();
            this.upgradeEject = input.readBoolean();
            this.verifyUpgrades();
            return true;
        }
        return false;
    }

    @Override
    int getLogicSpeed() {
        return 2;
    }

    @Override
    void makeNoise() {
        this.putParticles(this.k);
        if ((double)rand.nextFloat() > 0.9898 && this.lastSeenAt != null) {
            Sound.routerCluck.playAt(this);
        }
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

