/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityExtension;
import factorization.fzds.DeltaChunk;
import factorization.fzds.TransferLib;
import factorization.fzds.api.IDeltaChunk;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityRocketEngine
extends TileEntityCommon {
    boolean inSlice = false;
    boolean isLeaderEngine = false;
    public boolean isFiring = false;
    int availableFuel = -1;
    int nonfuelMass = 0;
    public boolean lastValidationStatus = false;
    private boolean ignitionRequest = false;
    private static int[][] perimDeltas = new int[][]{{-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {-1, 0, 2}, {0, 0, -1}, {0, 0, 2}, {1, 0, -1}, {1, 0, 2}, {2, 0, -1}, {2, 0, 0}, {2, 0, 1}, {2, 0, 2}};
    long next_free_time = 0L;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.ROCKETENGINE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.DarkIron;
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        tag.a("inSlice", this.inSlice);
        tag.a("isLeaderEngine", this.isLeaderEngine);
        tag.a("isFiring", this.isFiring);
        tag.a("availableFuel", this.availableFuel);
        tag.a("nonfuelMass", this.nonfuelMass);
        tag.a("lastValidationStatus", this.lastValidationStatus);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.inSlice = tag.n("inSlice");
        this.isLeaderEngine = tag.n("isLeaderEngine");
        this.isFiring = tag.n("isFiring");
        this.availableFuel = tag.e("availableFuel");
        this.nonfuelMass = tag.e("nonfuelMass");
        this.lastValidationStatus = tag.n("lastValidationStatus");
    }

    List getArea() {
        return this.getArea(this.getCoord(), new DeltaCoord(1, 1, 1));
    }

    List getArea(Coord c, DeltaCoord dc) {
        ArrayList<Coord> ret = new ArrayList<Coord>(12);
        for (int dyc = 0; dyc < 3; ++dyc) {
            int dy = dyc * dc.y;
            for (int dxc = 0; dxc < 2; ++dxc) {
                int dx = dxc * dc.x;
                for (int dzc = 0; dzc < 2; ++dzc) {
                    int dz = dzc * dc.z;
                    ret.add(c.add(dx, dy, dz));
                }
            }
        }
        return ret;
    }

    DeltaCoord getCornerDirection(qx player, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        DeltaCoord dc = FactorizationUtil.getFlatDiagonalFacing(player);
        if (dc.isZero()) {
            return null;
        }
        ForgeDirection fside = ForgeDirection.getOrientation((int)side);
        if (fside.offsetY == 0) {
            dc.x = dc.x * (fside.offsetX != 0 ? -1 : 1);
            dc.z = dc.z * (fside.offsetZ != 0 ? -1 : 1);
        }
        dc.y = fside == ForgeDirection.DOWN ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            if (dc.get(i) != 0) continue;
            dc.set(i, 1);
        }
        return dc;
    }

    @Override
    boolean canPlaceAgainst(qx player, Coord c, int side) {
        DeltaCoord dc;
        if (player.p.I) {
            return false;
        }
        if (!c.isReplacable()) {
            c = c.towardSide(side);
        }
        if ((dc = this.getCornerDirection(player, side)) == null) {
            Core.notify(player, c, "Place it differently", new String[0]);
            return false;
        }
        boolean fail = false;
        for (Coord spot : this.getArea(c, dc)) {
            if (spot.isReplacable()) continue;
            if (!fail) {
                Core.clearNotifications(player);
                fail = true;
            }
            if (spot.equals(c)) continue;
            Core.notify(player, spot, Core.NotifyStyle.FORCE, "X", new String[0]);
        }
        if (fail) {
            Core.notify(player, c, Core.NotifyStyle.FORCE, "Obstructed", new String[0]);
            return false;
        }
        aoe area = aoe.a((double)c.x, (double)c.y, (double)c.z, (double)c.x, (double)c.y, (double)c.z);
        Iterator i$ = c.w.b(null, area = area.a((double)(2 * dc.x), (double)(3 * dc.y), (double)(2 * dc.z))).iterator();
        if (i$.hasNext()) {
            Object o = i$.next();
            lq e = (lq)o;
            if (e.L() || !(e instanceof md)) {
                // empty if block
            }
            Core.notify(player, c, Core.NotifyStyle.FORCE, "Obstructed by entity", new String[0]);
            Coord ec = new Coord(e);
            if (!ec.equals(c)) {
                String it = "(this guy)";
                if (e instanceof qx) {
                    it = "(this player)";
                }
                if (e instanceof qc) {
                    it = "(thissss guy)";
                }
                Core.notify(player, new Coord(e), Core.NotifyStyle.FORCE, it, new String[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    void onPlacedBy(qx player, ur is, int side) {
        DeltaCoord dc = this.getCornerDirection(player, side);
        List area = this.getArea(this.getCoord(), dc);
        Coord myDestination = (Coord)area.get(0);
        for (Coord c : area) {
            if (!c.isSubmissiveTo(myDestination)) continue;
            myDestination = c;
        }
        Coord here = this.getCoord();
        TileEntityRocketEngine base = this;
        if (!here.equals(myDestination)) {
            here.removeTE();
            base = new TileEntityRocketEngine();
            myDestination.setId(Core.factory_block_id);
            myDestination.setTE(base);
        }
        for (Coord spot : area) {
            if (!spot.equals(myDestination)) {
                spot.setId(Core.factory_block_id);
                TileEntityExtension tex = new TileEntityExtension(base);
                spot.setTE(tex);
                tex.getBlockClass().enforce(spot);
            }
            spot.redraw();
        }
        this.ignitionRequest = true;
    }

    @Override
    void onRemove() {
        Coord here = this.getCoord();
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                for (int dz = -5; dz <= 5; ++dz) {
                    Coord c = here.add(dx, dy, dz);
                    TileEntityExtension tex = (TileEntityExtension)c.getTE(TileEntityExtension.class);
                    if (tex == null || tex.getParent() != this) continue;
                    c.setId(0);
                }
            }
        }
        here.setId(0);
    }

    @Override
    public void setBlockBounds(amq b) {
        b.a(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 2.0f);
    }

    Coord[] getIgnitionArea() {
        int i;
        Coord[] ret = new Coord[perimDeltas.length + 4];
        Coord here = this.getCoord();
        for (i = 0; i < perimDeltas.length; ++i) {
            ret[i] = here.add(perimDeltas[i][0], 0, perimDeltas[i][1]);
        }
        i = 0;
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dz = 0; dz <= 1; ++dz) {
                ret[TileEntityRocketEngine.perimDeltas.length + i] = here.add(dx, -1, dz);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public void neighborChanged() {
        this.ignitionRequest = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ContiguitySolver canIgnite(qx player) {
        int fireCount = 0;
        for (Coord n : this.getIgnitionArea()) {
            fireCount += n.isBlockBurning() ? 1 : 0;
        }
        if (fireCount < 4) {
            return null;
        }
        ContiguitySolver solver = new ContiguitySolver(this);
        try {
            solver.solve();
        }
        catch (RocketValidationException e) {
            e.notify(this, player);
            for (TileEntityRocketEngine engine : solver.engines) {
                engine.setValid(false);
            }
            return null;
        }
        for (TileEntityRocketEngine engine : solver.engines) {
            engine.setValid(true);
            if (engine == this) continue;
            for (Coord n : engine.getIgnitionArea()) {
                fireCount += n.isBlockBurning() ? 1 : 0;
            }
        }
        double perfect = solver.engines.size() * 12;
        double score = (double)fireCount / perfect;
        if (score >= 0.5) {
            if (solver.entireRocket.size() != 0) return solver;
            Core.notify(null, this.getCoord(), "No body?\nBug!", new String[0]);
            return null;
        } else {
            Core.notify(null, this.getCoord(), "Nope!", new String[0]);
        }
        return null;
    }

    void ignite(ContiguitySolver solver) {
        Coord min;
        Core.notify(null, this.getCoord(), "Ignition", new String[0]);
        this.isLeaderEngine = true;
        for (TileEntityRocketEngine engine : solver.engines) {
            engine.isFiring = true;
            engine.inSlice = true;
        }
        Coord max = min = (Coord)TileEntityRocketEngine.choose(solver.entireRocket);
        for (Coord c : solver.entireRocket) {
            if (c.isSubmissiveTo(min)) {
                min = c;
            }
            if (!max.isSubmissiveTo(c)) continue;
            max = c;
        }
        DeltaCoord size = max.difference(min);
        DeltaCoord half = size.scale(0.5);
        Coord center = min.add(half);
        IDeltaChunk dse = DeltaChunk.allocateSlice(this.k, -1, new DeltaCoord(0, 0, 0));
        center.setAsEntityLocation(dse);
        dse.t += 0.5;
        dse.u -= 5.0;
        dse.v += 0.5;
        aoj real = aoj.a((double)0.0, (double)0.0, (double)0.0);
        Coord dest = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        for (TileEntityRocketEngine engine : solver.engines) {
            Coord c = engine.getCoord();
            solver.entireRocket.remove(c);
            c.setAsVector(real);
            dest.set(dse.real2shadow(real));
            TransferLib.move(c, dest, true, true);
        }
        for (Coord c : solver.entireRocket) {
            c.setAsVector(real);
            dest.set(dse.real2shadow(real));
            TransferLib.move(c, dest, true, true);
        }
        this.k.d((lq)dse);
    }

    void broadcastState(qx who) {
        this.broadcastMessage(null, 151, this.lastValidationStatus, this.isFiring);
    }

    void setValid(boolean nv) {
        if (nv != this.lastValidationStatus) {
            this.lastValidationStatus = nv;
            this.broadcastState(null);
        }
    }

    boolean isValid(qx player) {
        this.setValid(this.calculateValidation(player));
        this.broadcastState(null);
        return this.lastValidationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean calculateValidation(qx player) {
        long now = System.currentTimeMillis();
        if (now < this.next_free_time) {
            return this.lastValidationStatus;
        }
        long start = System.currentTimeMillis();
        try {
            new ContiguitySolver(this).solve();
        }
        catch (RocketValidationException e) {
            e.notify(this, player);
            boolean bl = false;
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            long delay = Math.max((end - start) * 100L, 2000L);
            this.next_free_time = end + delay;
        }
        return true;
    }

    @Override
    public boolean activate(qx entityplayer) {
        if (this.k.I) {
            return true;
        }
        if (this.isValid(entityplayer)) {
            Core.notify(entityplayer, this.getCoord(), "Rocket is valid", new String[0]);
        }
        return true;
    }

    @Override
    public ef getAuxillaryInfoPacket() {
        return this.getDescriptionPacketWith(151, this.lastValidationStatus, this.isFiring);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 151) {
            boolean v = input.readBoolean();
            boolean f = input.readBoolean();
            if (v != this.lastValidationStatus || this.isFiring != f) {
                this.lastValidationStatus = v;
                this.isFiring = f;
                this.getCoord().redraw();
            }
            return true;
        }
        return false;
    }

    public void g() {
        if (this.k.I) {
            return;
        }
        if (!(this.inSlice && this.isFiring || !this.ignitionRequest)) {
            this.ignitionRequest = false;
            ContiguitySolver solver = this.canIgnite(null);
            if (solver != null) {
                this.ignite(solver);
            }
        }
    }

    public void notifyArea(qx player) {
        ContiguitySolver solver = this.canIgnite(player);
        for (Coord c : solver.entireRocket) {
            Core.notify(player, c, Core.NotifyStyle.FORCE, "" + c.y, new String[0]);
        }
    }

    static Object choose(HashSet src) {
        Iterator it = src.iterator();
        Object ret = it.next();
        it.remove();
        return ret;
    }

    static HashSet fillPlane(Iterable seeds, int planeNormal, Criteria criteria) throws RocketValidationException {
        HashSet<Coord> ret = new HashSet<Coord>(81);
        HashSet<Coord> frontier = new HashSet<Coord>();
        for (Coord seed : seeds) {
            if (!criteria.fits(seed)) continue;
            frontier.add(seed);
        }
        while (frontier.size() > 0) {
            if (ret.size() == Core.max_rocket_base_size) {
                throw new RocketValidationException("Rocket is too wide");
            }
            Coord me = (Coord)TileEntityRocketEngine.choose(frontier);
            ret.add(me);
            Coord[] neighbors = me.getNeighborsInPlane(planeNormal);
            for (int i = 0; i < neighbors.length; ++i) {
                Coord n = neighbors[i];
                if (ret.contains(n) || frontier.contains(n) || !criteria.fits(n)) continue;
                frontier.add(n);
            }
        }
        return ret;
    }

    static void movePlane(ArrayList coordSet, DeltaCoord dc) {
        for (Coord c : coordSet) {
            c.adjust(dc);
        }
    }

    static int expandPlane(ArrayList coordSet, ForgeDirection normal, Criteria crit) {
        int ord = normal.ordinal();
        HashSet<Coord> toAdd = new HashSet<Coord>();
        for (Coord me : coordSet) {
            Coord[] neighbors = me.getNeighborsInPlane(ord);
            for (int i = 0; i < neighbors.length; ++i) {
                Coord n = neighbors[i];
                if (coordSet.contains(n) || !crit.fits(n)) continue;
                toAdd.add(n);
            }
        }
        int ret = toAdd.size();
        coordSet.addAll(toAdd);
        return ret;
    }

    static void collapsePlane(ArrayList plane, Criteria crit) {
        Iterator it = plane.iterator();
        while (it.hasNext()) {
            Coord here = (Coord)it.next();
            if (crit.fits(here)) continue;
            it.remove();
        }
    }

    static HashSet cloneSet(Collection src) {
        HashSet<Coord> ret = new HashSet<Coord>(src.size());
        for (Coord c : src) {
            ret.add(c.copy());
        }
        return ret;
    }

    static ArrayList cloneArray(Collection src) {
        ArrayList<Coord> ret = new ArrayList<Coord>(src.size());
        for (Coord c : src) {
            ret.add(c.copy());
        }
        return ret;
    }

    static class ContiguitySolver {
        TileEntityRocketEngine seed;
        HashSet engines = new HashSet();
        HashSet entireRocket = new HashSet();
        ArrayList mountingPlane = new ArrayList();
        int fuel = 0;

        public ContiguitySolver(TileEntityRocketEngine seed) {
            this.seed = seed;
        }

        void addEngine(TileEntityCommon engine) {
            if (engine instanceof TileEntityExtension) {
                engine = ((TileEntityExtension)engine).getParent();
            }
            if (engine instanceof TileEntityRocketEngine) {
                this.engines.add((TileEntityRocketEngine)engine);
            }
        }

        public void solve() throws RocketValidationException {
            Coord mounting = this.seed.getCoord().add(0, 3, 0);
            Criteria isSolid = new Criteria(){

                public boolean fits(Coord coord) {
                    return coord.getHardness() > 0.0f;
                }
            };
            List<Coord> seeds = Arrays.asList(mounting, mounting.add(1, 0, 0), mounting.add(1, 0, 1), mounting.add(0, 0, 1));
            this.mountingPlane.addAll(TileEntityRocketEngine.fillPlane(seeds, 0, isSolid));
            if (this.mountingPlane.size() == 0) {
                throw new RocketValidationException("Rocket engine is attatched to nothing");
            }
            TileEntityRocketEngine.movePlane(this.mountingPlane, new DeltaCoord(0, -3, 0));
            for (Coord c : this.mountingPlane) {
                this.addEngine((TileEntityCommon)c.getTE(TileEntityCommon.class));
            }
            TileEntityRocketEngine.movePlane(this.mountingPlane, new DeltaCoord(0, 3, 0));
            for (TileEntityRocketEngine engine : this.engines) {
                this.entireRocket.addAll(engine.getArea());
            }
            ArrayList heightScan = TileEntityRocketEngine.cloneArray(this.mountingPlane);
            int y2 = 0;
            DeltaCoord upwards = new DeltaCoord(0, 1, 0);
            this.entireRocket.addAll(TileEntityRocketEngine.cloneArray(this.mountingPlane));
            block2: while (true) {
                if (++y2 > Core.max_rocket_height) {
                    throw new RocketValidationException("Rocket is too tall");
                }
                TileEntityRocketEngine.movePlane(heightScan, upwards);
                TileEntityRocketEngine.collapsePlane(heightScan, isSolid);
                int last_size = heightScan.size();
                while (true) {
                    TileEntityRocketEngine.expandPlane(heightScan, ForgeDirection.UP, isSolid);
                    int new_size = heightScan.size();
                    if (new_size >= Core.max_rocket_base_size) {
                        throw new RocketValidationException("Rocket is too wide");
                    }
                    if (new_size == last_size) break;
                    last_size = new_size;
                }
                if (heightScan.size() >= Core.max_rocket_base_size) {
                    throw new RocketValidationException("Rocket is too wide");
                }
                if (heightScan.size() == 0) {
                    --y2;
                    break;
                }
                this.entireRocket.addAll(TileEntityRocketEngine.cloneArray(heightScan));
                Iterator i$ = this.mountingPlane.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    Coord c = (Coord)i$.next();
                    this.entireRocket.add(c.add(0, y2, 0));
                }
                break;
            }
            if (this.entireRocket.size() == 0) {
                throw new RocketValidationException("Rocket is made of nothing!?");
            }
            if (this.engines.size() == 0) {
                throw new RocketValidationException("Rocket has no engines!?");
            }
            Coord below = this.seed.getCoord();
            for (Coord c : this.entireRocket) {
                any te = c.getTE();
                if (te instanceof TileEntityExtension) {
                    te = ((TileEntityExtension)te).getParent();
                }
                if (te instanceof TileEntityRocketEngine && this.engines.contains(te)) continue;
                below.set(c);
                --below.y;
                if (!isSolid.fits(below) || this.entireRocket.contains(below)) continue;
                throw new RocketValidationException("Can't drag", below);
            }
        }
    }

    static interface Criteria {
        public boolean fits(Object var1);
    }

    static class RocketValidationException
    extends Exception {
        String msg;
        Coord mark = null;

        public RocketValidationException(String msg) {
            this.msg = msg;
        }

        public RocketValidationException(String msg, Coord mark) {
            this.msg = msg;
            this.mark = mark;
        }

        public void notify(TileEntityRocketEngine where, qx who) {
            if (who != null) {
                if (this.mark == null) {
                    Core.notify(who, where.getCoord(), this.msg, new String[0]);
                } else {
                    Core.notify(who, where.getCoord(), "Validation failed", new String[0]);
                    Core.notify(who, this.mark, this.msg, new String[0]);
                }
            }
        }
    }
}

