/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.ReflectionHelper;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityMixer
extends TileEntityFactorization
implements IChargeConductor {
    ur[] input = new ur[4];
    ur[] output = new ur[4];
    ArrayList outputBuffer = new ArrayList();
    int progress = 0;
    int speed = 0;
    Charge charge = new Charge(this);
    int last_speed = -1;
    float rotation = 0.0f;
    private static ArrayList recipe_cache = null;
    RecipeMatchInfo cache = null;
    boolean dirty = true;

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.charge.writeToNBT(tag);
        tag.a("progress", this.progress);
        tag.a("speed", this.speed);
        this.writeSlotsToNBT(tag);
        by buffer = new by();
        for (ur is : this.outputBuffer) {
            bq itag = new bq();
            is.b(itag);
            buffer.a((cd)itag);
        }
        tag.a("outBuffer", (cd)buffer);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.charge.readFromNBT(tag);
        this.progress = tag.e("progress");
        this.speed = tag.e("speed");
        this.readSlotsFromNBT(tag);
        by outBuffer = tag.m("outBuffer");
        if (outBuffer != null) {
            for (int i = 0; i < outBuffer.c(); ++i) {
                cd base = outBuffer.b(i);
                if (!(base instanceof bq)) continue;
                ur is = ur.a((bq)((bq)base));
                this.outputBuffer.add(is);
            }
        }
        this.setDirty();
    }

    void setDirty() {
        if (this.k != null && this.k.I) {
            return;
        }
        this.dirty = true;
        this.cache = null;
    }

    @Override
    public void dropContents() {
        super.dropContents();
        Coord here = this.getCoord();
        for (ur is : this.outputBuffer) {
            FactorizationUtil.spawnItemStack(here, is);
        }
        this.setDirty();
    }

    public int k_() {
        return 8;
    }

    public ur a(int slot) {
        if (slot >= 0 && slot < 4) {
            return this.input[slot];
        }
        if ((slot -= 4) >= 0 && slot < 4) {
            return this.output[slot];
        }
        return null;
    }

    public void a(int slot, ur is) {
        this.setDirty();
        if (slot >= 0 && slot < 4) {
            this.input[slot] = is;
            return;
        }
        if ((slot -= 4) >= 0 && slot < 4) {
            this.output[slot] = is;
            return;
        }
    }

    public String b() {
        return "Mixer";
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 4;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 4;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIXER;
    }

    @Override
    public void g() {
        super.g();
        this.charge.update();
        this.rotation += (float)this.speed;
        this.shareRotationSpeed();
    }

    void shareRotationSpeed() {
        if (this.speed != this.last_speed) {
            this.broadcastMessage(null, 100, this.speed);
            this.last_speed = this.speed;
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 100) {
            this.speed = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    int getLogicSpeed() {
        return 4;
    }

    int getRemainingProgress() {
        return 250 - this.progress;
    }

    public float getRotation() {
        return this.rotation;
    }

    boolean removeMatching(ur[] hay, ur needle) {
        for (int i = 0; i < hay.length; ++i) {
            if (!FactorizationUtil.wildcardSimilar(needle, hay[i])) continue;
            hay[i] = FactorizationUtil.normalDecr(hay[i]);
            return true;
        }
        return false;
    }

    boolean recipeMatches(List recipeItems) {
        int i;
        ur[] in = new ur[this.input.length];
        for (i = 0; i < this.input.length; ++i) {
            if (this.input[i] == null) continue;
            in[i] = this.input[i].l();
        }
        for (i = 0; i < recipeItems.size(); ++i) {
            Object o = recipeItems.get(i);
            List<ur> all = o instanceof ur ? Arrays.asList((ur)o) : (List<ur>)o;
            boolean found = false;
            for (int R = 0; R < all.size(); ++R) {
                ur recipeItem = all.get(R);
                if (!this.removeMatching(in, recipeItem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static ArrayList getRecipes() {
        ArrayList<RecipeMatchInfo> cache = new ArrayList<RecipeMatchInfo>();
        block0: for (Object o : wn.a().b()) {
            int s2;
            wr sr2;
            wp recipe = (wp)o;
            List inputList = null;
            ur output = null;
            if (recipe.getClass() == wr.class) {
                sr2 = (wr)recipe;
                inputList = sr2.b;
                output = sr2.b();
            }
            if (recipe.getClass() == ShapelessOreRecipe.class) {
                sr2 = (ShapelessOreRecipe)recipe;
                inputList = (List)ReflectionHelper.getPrivateValue(ShapelessOreRecipe.class, (Object)sr2, (String[])new String[]{"input"});
                output = sr2.b();
            }
            if (inputList == null || (s2 = inputList.size()) <= 1 || s2 > 4) continue;
            for (int i = 0; i < inputList.size(); ++i) {
                Object p = inputList.get(i);
                if (p instanceof String) {
                    p = OreDictionary.getOres((String)((String)p));
                }
                if (p instanceof List) {
                    for (ur is : (List)p) {
                        if (TileEntityMixer.isOkayRecipeItem(is)) continue;
                        continue block0;
                    }
                }
                if (p instanceof ur && !TileEntityMixer.isOkayRecipeItem((ur)p)) continue block0;
            }
            cache.add(new RecipeMatchInfo(inputList, output, recipe));
        }
        return cache;
    }

    private static boolean isOkayRecipeItem(ur is) {
        up item2 = is.b();
        if (item2 == up.aK || item2 == up.aL) {
            return false;
        }
        if (is.j() > 255) {
            return false;
        }
        if (item2.s()) {
            ur container = FactorizationUtil.normalize(item2.getContainerItemStack(is));
            if (container == null) {
                return true;
            }
            if (container.b() != item2) {
                return true;
            }
            if (container.f() || container.h()) {
                return false;
            }
            if (container.a(is)) {
                return false;
            }
        }
        return true;
    }

    RecipeMatchInfo getRecipe() {
        boolean empty = true;
        for (int i = 0; i < this.input.length; ++i) {
            if (this.input[i] == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return null;
        }
        if (recipe_cache == null) {
            recipe_cache = TileEntityMixer.getRecipes();
        }
        RecipeMatchInfo longest = null;
        for (int i = 0; i < recipe_cache.size(); ++i) {
            RecipeMatchInfo result = (RecipeMatchInfo)recipe_cache.get(i);
            if (!this.recipeMatches(result.inputs) || longest != null && longest.inputs.size() >= result.inputs.size()) continue;
            longest = result;
        }
        return longest;
    }

    static ur[] copyArray(ur[] src) {
        ur[] clone = new ur[src.length];
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == null) continue;
            clone[i] = src[i].l();
        }
        return clone;
    }

    boolean addItems(ur[] out, ur[] src) {
        for (ur is : src) {
            int i;
            for (i = 0; i < out.length; ++i) {
                if (out[i] == null || !FactorizationUtil.identical(is, out[i])) continue;
                int free = out[i].d() - out[i].a;
                int delta = Math.min(free, is.a);
                is.a -= delta;
                out[i].a += delta;
                if ((is = FactorizationUtil.normalize(is)) == null) break;
            }
            if (is == null) continue;
            for (i = 0; i < out.length; ++i) {
                if (out[i] != null) continue;
                out[i] = is.l();
                is = null;
                break;
            }
            if (is == null) continue;
            this.normalize(out);
            this.normalize(src);
            return false;
        }
        this.normalize(out);
        this.normalize(src);
        return true;
    }

    boolean hasFreeSpace(RecipeMatchInfo mr) {
        return this.addItems(TileEntityMixer.copyArray(this.output), new ur[]{mr.output.l()});
    }

    RecipeMatchInfo getCachedRecipe() {
        if (!this.dirty) {
            return this.cache;
        }
        this.dirty = false;
        this.cache = this.getRecipe();
        return this.cache;
    }

    void slow() {
        if (this.progress > 0) {
            this.progress = (int)Math.max(0.0, (double)this.progress * 0.8 - 5.0);
        }
        if (this.speed > 0) {
            --this.speed;
        }
    }

    boolean extractEnergy() {
        int i = Math.max(2, this.speed);
        return this.charge.tryTake(i) > 0;
    }

    void craftRecipe(RecipeMatchInfo mr) {
        ry craft = FactorizationUtil.makeCraftingGrid();
        block0: for (int count = 0; count < mr.inputs.size(); ++count) {
            Object o = mr.inputs.get(count);
            for (int i = 0; i < this.input.length; ++i) {
                if (o instanceof ur) {
                    o = ((ur)o).l();
                    ((ur)o).a = 1;
                }
                if (!FactorizationUtil.oreDictionarySimilar(o, this.input[i])) continue;
                craft.a(count, this.input[i].a(1));
                continue block0;
            }
        }
        qx fakePlayer = FactorizationUtil.makePlayer(this.getCoord(), "Mixer");
        sp craftResult = new sp();
        ur out = mr.output.l();
        if (out.a < 1) {
            out.a = 1;
        }
        craftResult.a(0, out);
        sq slot = new sq(fakePlayer, (la)craft, (la)craftResult, 0, 0, 0);
        slot.a(fakePlayer, out);
        this.outputBuffer.add(out);
        FactorizationUtil.addInventoryToArray((la)craft, this.outputBuffer);
        FactorizationUtil.addInventoryToArray((la)fakePlayer.bJ, this.outputBuffer);
        this.setDirty();
    }

    boolean drainBuffer() {
        if (this.outputBuffer.size() > 0) {
            int i;
            ur toAdd = (ur)this.outputBuffer.get(0);
            for (i = 0; i < this.output.length; ++i) {
                if (this.output[i] != null) continue;
                this.output[i] = (ur)this.outputBuffer.remove(0);
                return true;
            }
            for (i = 0; i < this.output.length; ++i) {
                int free = this.output[i].d() - this.output[i].a;
                if (!FactorizationUtil.similar(this.output[i], toAdd) || free <= 0) continue;
                int toTake = Math.min(free, toAdd.a);
                toAdd.a -= toTake;
                this.output[i].a += toTake;
                if (toAdd.a > 0) continue;
                this.outputBuffer.remove(0);
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    void doLogic() {
        this.needLogic();
        if (this.drainBuffer()) {
            return;
        }
        RecipeMatchInfo mr = this.getCachedRecipe();
        if (mr == null) {
            this.slow();
            return;
        }
        if (!this.hasFreeSpace(mr)) {
            this.slow();
            return;
        }
        if (this.speed < 5 && this.extractEnergy()) {
            ++this.speed;
        } else if (!this.extractEnergy() && this.speed > 0) {
            int ns = Math.min(this.speed - 1, (int)((double)this.speed * 0.8));
            ns = Math.max(ns, 0);
            System.out.println("Slowing: " + this.speed + " to " + ns);
            this.speed = ns;
        }
        this.progress += this.speed;
        if (this.getRemainingProgress() <= 0 || Core.cheat) {
            this.progress = 0;
            this.craftRecipe(mr);
            this.normalize(this.input);
            while (this.drainBuffer()) {
            }
            this.speed = Math.min(50, this.speed + 1);
        }
    }

    void normalize(ur[] is) {
        for (int i = 0; i < is.length; ++i) {
            is[i] = FactorizationUtil.normalize(is[i]);
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public int getMixProgressScaled(int scale) {
        return this.progress * scale / (this.progress + this.getRemainingProgress());
    }

    @Override
    byte getExtraInfo2() {
        return (byte)this.speed;
    }

    @Override
    void useExtraInfo(byte b) {
        this.speed = b;
    }

    public static class RecipeMatchInfo {
        public ArrayList inputs = new ArrayList();
        public ur output;
        public wp theRecipe;

        public RecipeMatchInfo(List recipeInput, ur recipeOutput, wp theRecipe) {
            for (Object o : recipeInput) {
                if (o instanceof ur) {
                    this.inputs.add(((ur)o).l());
                    continue;
                }
                this.inputs.add(o);
            }
            this.output = recipeOutput.l();
            this.theRecipe = theRecipe;
        }
    }
}

