/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoord;
import factorization.api.IReflectionTarget;
import factorization.common.BlockClass;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;

public class TileEntityMirror
extends TileEntityCommon {
    Coord reflection_target = null;
    public boolean is_lit = false;
    int next_check = 1;
    public int target_rotation = -99;
    int last_shared = -1;
    boolean gotten_info_packet = false;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIRROR;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        if (this.reflection_target != null) {
            this.reflection_target.writeToNBT("target", tag);
        }
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        if (tag.b("targetx")) {
            this.reflection_target = this.getCoord();
            this.reflection_target.readFromNBT("target", tag);
            this.updateRotation();
        } else {
            this.reflection_target = null;
        }
    }

    @Override
    public boolean activate(qx entityplayer) {
        this.neighborChanged();
        return false;
    }

    @Override
    public void neighborChanged() {
        this.next_check = -1;
    }

    int getPower() {
        return 1;
    }

    int clipAngle(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return angle;
    }

    boolean hasSun() {
        boolean raining = this.k.N() && this.k.a((int)this.l, (int)this.m).G > 0.0f;
        return this.getCoord().canSeeSky() && this.k.u() && !raining;
    }

    void broadcastTargetInfoIfChanged() {
        if (this.getTargetInfo() != this.last_shared) {
            this.broadcastMessage(null, 60, this.getTargetInfo());
            this.last_shared = this.getTargetInfo();
        }
    }

    int getTargetInfo() {
        return this.reflection_target == null ? -99 : this.target_rotation;
    }

    void setRotationTarget(int new_target) {
        if (this.target_rotation != new_target) {
            this.target_rotation = new_target;
        }
    }

    @Override
    public ef getAuxillaryInfoPacket() {
        return this.getDescriptionPacketWith(60, this.target_rotation, this.getTargetInfo());
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case 60: {
                this.target_rotation = input.readInt();
                this.getCoord().redraw();
                this.gotten_info_packet = true;
                return true;
            }
        }
        return false;
    }

    @Override
    void onRemove() {
        super.onRemove();
        if (this.reflection_target == null) {
            return;
        }
        this.reflection_target.w = this.k;
        if (this.k == null) {
            return;
        }
        IReflectionTarget target = (IReflectionTarget)this.reflection_target.getTE(IReflectionTarget.class);
        if (target == null) {
            return;
        }
        if (this.is_lit) {
            target.addReflector(-this.getPower());
            this.is_lit = false;
        }
        this.reflection_target = null;
    }

    @Override
    public void w_() {
        super.w_();
        if (this.k != null) {
            this.onRemove();
        }
    }

    void setNextCheck() {
        this.next_check = 80 + rand.nextInt(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void g() {
        if (this.k.I) {
            return;
        }
        if (this.next_check-- <= 0) {
            try {
                this.setNextCheck();
                if (this.reflection_target == null) {
                    this.findTarget();
                    if (this.reflection_target == null) {
                        return;
                    }
                } else {
                    this.reflection_target.setWorld(this.k);
                }
                IReflectionTarget target = null;
                target = (IReflectionTarget)this.reflection_target.getTE(IReflectionTarget.class);
                if (target == null) {
                    if (this.reflection_target.blockExists()) {
                        this.reflection_target = null;
                        this.is_lit = false;
                    }
                    return;
                }
                if (!this.myTrace(this.reflection_target.x, this.reflection_target.z) && this.is_lit) {
                    this.is_lit = false;
                    target.addReflector(-this.getPower());
                    this.reflection_target = null;
                    this.setRotationTarget(-99);
                    return;
                }
                if (this.hasSun() != this.is_lit) {
                    this.is_lit = this.hasSun();
                    target.addReflector(this.is_lit ? this.getPower() : -this.getPower());
                }
            }
            finally {
                this.broadcastTargetInfoIfChanged();
            }
        }
    }

    void findTarget() {
        if (this.reflection_target != null) {
            IReflectionTarget target = (IReflectionTarget)this.reflection_target.getTE(IReflectionTarget.class);
            if (target != null) {
                if (this.is_lit) {
                    target.addReflector(-this.getPower());
                }
                this.reflection_target = null;
            }
            this.is_lit = false;
        }
        int search_distance = 11;
        ICoord closest = null;
        int last_dist = Integer.MAX_VALUE;
        Coord me = this.getCoord();
        double maxRadiusSq = 79.21000000000001;
        for (int x = this.l - search_distance; x <= this.l + search_distance; ++x) {
            for (int z = this.n - search_distance; z <= this.n + search_distance; ++z) {
                int new_dist;
                Coord here = new Coord(this.k, x, this.m, z);
                IReflectionTarget target = (IReflectionTarget)here.getTE(IReflectionTarget.class);
                if (target == null || !this.myTrace(x, z) || (new_dist = me.distanceSq(here)) >= last_dist || !((double)new_dist <= maxRadiusSq)) continue;
                last_dist = new_dist;
                closest = target;
            }
        }
        if (closest != null) {
            this.reflection_target = closest.getCoord();
            this.updateRotation();
        } else {
            this.setRotationTarget(-99);
        }
    }

    void updateRotation() {
        DeltaCoord dc = this.getCoord().difference(this.reflection_target);
        int new_target = this.clipAngle((int)Math.toDegrees(dc.getAngleHorizontal()));
        this.setRotationTarget(new_target);
    }

    double div(double a, double b) {
        if (b == 0.0) {
            return Math.signum(a) * 4095.0;
        }
        return a / b;
    }

    boolean myTrace(double x, double z) {
        double offset_x = (x += 0.5) - ((double)this.l + 0.5);
        double offset_z = (z += 0.5) - ((double)this.n + 0.5);
        double length = Math.hypot(offset_x, offset_z);
        double dx = offset_x / length;
        double dz = offset_z / length;
        x -= dx;
        z -= dz;
        int bx = 0;
        int bz = 0;
        int i = 0;
        while ((double)i < length) {
            bx = (int)Math.round(x + 0.5) - 1;
            bz = (int)Math.round(z + 0.5) - 1;
            if (bx == this.l && bz == this.n) {
                return true;
            }
            int id = this.k.a(bx, this.m, bz);
            amq b = amq.p[id];
            boolean air_like = false;
            if (b == null) {
                air_like = true;
            } else {
                air_like = b.isAirBlock(this.k, bx, this.m, bz);
                air_like |= b.e(this.k, bx, this.m, bz) == null;
            }
            if (!air_like) {
                return false;
            }
            x -= dx;
            z -= dz;
            ++i;
        }
        return false;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }
}

