/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemCraft;
import factorization.common.Sound;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityMaker
extends TileEntityFactorization
implements ISidedInventory {
    public boolean[] targets = new boolean[9];
    ur input;
    ur paper;
    ur craft;
    ur output;
    private final int input_slot = 0;
    private final int paper_slot = 1;
    private final int craft_slot = 2;
    private final int output_slot = 3;

    public TileEntityMaker() {
        this.targets[4] = true;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public int k_() {
        return 4;
    }

    public ur a(int i) {
        switch (i) {
            case 0: {
                return this.input;
            }
            case 1: {
                return this.paper;
            }
            case 2: {
                return this.craft;
            }
            case 3: {
                return this.output;
            }
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        switch (i) {
            case 0: {
                this.input = itemstack;
                break;
            }
            case 1: {
                this.paper = itemstack;
                break;
            }
            case 2: {
                this.craft = itemstack;
                break;
            }
            case 3: {
                this.output = itemstack;
            }
        }
        this.d();
    }

    public String b() {
        return "Craft Maker";
    }

    public void setTargets(int id, boolean flag) {
        if (this.targets[id] != flag) {
            this.targets[id] = flag;
            this.broadcastTarget(null, id);
        }
    }

    boolean insertItem(int targetSlot, boolean doTarget) {
        if (!doTarget) {
            return true;
        }
        if (this.craft == null) {
            return false;
        }
        ItemCraft ic = (ItemCraft)this.craft.b();
        if (this.input == null) {
            return ic.isSlotSet(this.craft, targetSlot);
        }
        ur toAdd = this.input.l();
        toAdd.a = 1;
        if (ic.addItem(this.craft, targetSlot, toAdd, this)) {
            --this.input.a;
            if (this.input.a < 1) {
                this.input = null;
            }
            return true;
        }
        return ic.isSlotSet(this.craft, targetSlot);
    }

    boolean havePaper() {
        if (this.paper == null) {
            return false;
        }
        return this.paper.b() == up.aK;
    }

    void eatPaper() {
        assert (this.paper.b() == up.aK);
        --this.paper.a;
        this.paper = FactorizationUtil.normalize(this.paper);
    }

    @Override
    int getLogicSpeed() {
        return 16;
    }

    @Override
    void doLogic() {
        int free;
        if (this.paper != null && this.craft == null && this.paper.b() instanceof ItemCraft) {
            this.craft = this.paper;
            this.paper = null;
        }
        if (this.paper == null && this.craft != null && this.craft.b() == up.aK) {
            this.paper = this.craft;
            this.craft = null;
        }
        if (this.paper != null && this.paper.b() == up.aK && this.craft != null && this.craft.b() == up.aK && (free = this.paper.d() - this.paper.a) > 0) {
            free = Math.min(free, this.craft.a);
            this.craft.a -= free;
            this.paper.a += free;
            this.craft = FactorizationUtil.normalize(this.craft);
        }
        boolean have_craft = this.craft != null && this.craft.b() instanceof ItemCraft;
        boolean is_armed = this.input != null && this.input.a > 0 && !(this.input.b() instanceof ItemCraft) && this.output == null;
        boolean could_move = this.craft != null && this.output == null;
        boolean haveFlag = false;
        for (boolean target : this.targets) {
            haveFlag |= target;
        }
        if (!haveFlag) {
            is_armed = false;
        }
        if (is_armed && this.havePaper() && this.craft == null) {
            this.craft = new ur((up)Core.registry.item_craft);
            have_craft = true;
            this.eatPaper();
        }
        if (have_craft && (is_armed || could_move)) {
            boolean success = true;
            for (int index = 0; index < 9; ++index) {
                success &= this.insertItem(index, this.targets[index]);
            }
            if (success) {
                this.output = this.craft;
                this.craft = null;
                this.drawActive(3);
                this.pulse();
            }
        }
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        for (int i = 0; i < 9; ++i) {
            tag.a("target" + i, this.targets[i]);
        }
        TileEntityMaker.saveItem("input", tag, this.input);
        TileEntityMaker.saveItem("craft", tag, this.craft);
        TileEntityMaker.saveItem("output", tag, this.output);
        TileEntityMaker.saveItem("paper", tag, this.paper);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        for (int i = 0; i < 9; ++i) {
            this.targets[i] = tag.n("target" + i);
        }
        this.input = TileEntityMaker.readItem("input", tag);
        this.craft = TileEntityMaker.readItem("craft", tag);
        this.output = TileEntityMaker.readItem("output", tag);
        this.paper = TileEntityMaker.readItem("paper", tag);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
            case UP: {
                return 0;
            }
        }
        return 3;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    void sendFullDescription(qx player) {
        super.sendFullDescription(player);
        for (int i = 0; i < 9; ++i) {
            this.broadcastTarget(player, i);
        }
    }

    void broadcastTarget(qx who, int slot) {
        this.broadcastMessage(who, 11, slot, this.targets[slot]);
    }

    boolean handleMessageFromAny(int messageType, DataInput input) throws IOException {
        if (messageType == 11) {
            int target_id = input.readInt();
            boolean state = input.readBoolean();
            if (!this.k.I) {
                this.setTargets(target_id, state);
            } else {
                this.targets[target_id] = state;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        return this.handleMessageFromAny(messageType, input);
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        return this.handleMessageFromAny(messageType, input);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MAKER;
    }

    @Override
    void makeNoise() {
        Sound.makerUse.playAt(this);
    }
}

