/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntitySlagFurnace;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Field;

public class TileEntityHeater
extends TileEntityCommon
implements IChargeConductor {
    Charge charge = new Charge(this);
    public byte heat = 0;
    public static final byte maxHeat = 32;
    byte last_heat = (byte)-99;
    static Class rpAlloyFurnace = null;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.HEATER;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.charge.writeToNBT(tag);
        tag.a("heat", this.heat);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.charge.readFromNBT(tag);
        this.heat = tag.c("heat");
    }

    int charge2heat(int i) {
        return (int)((double)i / 1.5);
    }

    void updateClient() {
        int delta = Math.abs(this.heat - this.last_heat);
        if (delta > 2) {
            this.broadcastMessage(null, 80, this.heat);
            this.last_heat = this.heat;
        }
    }

    @Override
    byte getExtraInfo() {
        return this.heat;
    }

    @Override
    void useExtraInfo(byte b) {
        this.heat = b;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 80) {
            this.heat = input.readByte();
            return true;
        }
        return false;
    }

    public void g() {
        int heatToRemove;
        int avail;
        int rate;
        if (this.k.I) {
            return;
        }
        this.updateClient();
        Coord here = this.getCoord();
        if (here.isPowered()) {
            this.charge.update();
            return;
        }
        long now = this.k.G() + (long)here.seed();
        if (now % (long)(rate = 4) == 0L && (avail = Math.min(heatToRemove = 32 - this.heat, this.charge.getValue())) > 0 && this.charge2heat(heatToRemove) > 0) {
            this.heat = (byte)(this.heat + this.charge2heat(this.charge.deplete(heatToRemove)));
        }
        this.charge.update();
        if (this.heat <= 0) {
            return;
        }
        for (Coord c : here.getRandomNeighborsAdjacent()) {
            this.sendHeat(c.getTE());
            if (this.heat > 0) continue;
            return;
        }
    }

    boolean shouldHeat(int cookTime) {
        if ((double)this.heat >= 16.0) {
            return true;
        }
        return cookTime > 0;
    }

    int addGraceHeat(int burnTime) {
        return Math.max(4, burnTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendHeat(any te) {
        ProxiedHeatingResult pf;
        Object furnace;
        if (te instanceof anr) {
            furnace = (anr)te;
            if (!this.TEF_canSmelt((anr)furnace)) {
                return;
            }
            pf = new ProxiedHeatingResult(new Coord(te), ((anr)furnace).a, ((anr)furnace).c);
            ((anr)furnace).a = pf.burnTime;
            ((anr)furnace).c = Math.min(pf.cookTime, 199);
            akh.a((((anr)furnace).c > 0 ? 1 : 0) != 0, (yc)this.k, (int)te.l, (int)te.m, (int)te.n);
        }
        if (te instanceof TileEntitySlagFurnace) {
            furnace = (TileEntitySlagFurnace)te;
            if (!((TileEntitySlagFurnace)furnace).canSmelt()) {
                return;
            }
            pf = new ProxiedHeatingResult(new Coord(te), ((TileEntitySlagFurnace)furnace).furnaceBurnTime, ((TileEntitySlagFurnace)furnace).furnaceCookTime);
            ((TileEntitySlagFurnace)furnace).furnaceBurnTime = pf.burnTime;
            ((TileEntitySlagFurnace)furnace).furnaceCookTime = pf.cookTime;
        }
        if (te instanceof TileEntityCrystallizer) {
            TileEntityCrystallizer crys = (TileEntityCrystallizer)te;
            if (!crys.needHeat()) {
                return;
            }
            ++crys.heat;
            this.heat = (byte)(this.heat - 1);
        }
        if (rpAlloyFurnace != null && rpAlloyFurnace.isInstance(te)) {
            Exception err = null;
            try {
                Field burntimeField = rpAlloyFurnace.getField("burntime");
                ProxiedHeatingResult pf2 = new ProxiedHeatingResult(new Coord(te), burntimeField.getInt(te), 0);
                burntimeField.setInt(te, pf2.burnTime);
            }
            catch (SecurityException e) {
                err = e;
            }
            catch (NoSuchFieldException e) {
                err = e;
            }
            catch (IllegalArgumentException e) {
                err = e;
            }
            catch (IllegalAccessException e) {
                err = e;
            }
            finally {
                if (err != null) {
                    rpAlloyFurnace = null;
                    Core.logWarning("Failed to reflect into RedPower AlloyFurnace; heating disabled.", new Object[0]);
                    err.printStackTrace();
                }
            }
        }
    }

    boolean TEF_canSmelt(anr diss) {
        if (diss.a(0) == null) {
            return false;
        }
        ur var1 = wj.a().getSmeltingResult(diss.a(0));
        if (var1 == null) {
            return false;
        }
        if (diss.a(2) == null) {
            return true;
        }
        if (!diss.a(2).a(var1)) {
            return false;
        }
        int result = diss.a((int)2).a + var1.a;
        return result <= diss.c() && result <= var1.d();
    }

    private class ProxiedHeatingResult {
        int burnTime;
        int cookTime;
        int topBurnTime;

        public ProxiedHeatingResult(Coord furnace, int burnTime, int cookTime) {
            this.burnTime = burnTime;
            this.cookTime = cookTime;
            this.topBurnTime = 200;
            this.calculate(furnace);
        }

        private void calculate(Coord furnace) {
            for (int i = 0; i < 2; ++i) {
                if (TileEntityHeater.this.heat <= 16) {
                    return;
                }
                if (this.burnTime < this.topBurnTime) {
                    ++this.burnTime;
                } else {
                    ++this.cookTime;
                }
                TileEntityHeater.this.heat = (byte)(TileEntityHeater.this.heat - 1);
            }
        }
    }
}

