/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityGrinder
extends TileEntityFactorization
implements IChargeConductor {
    ur input;
    ur output;
    Charge charge = new Charge(this);
    int progress = 0;
    float energy = 0.0f;
    int speed = 0;
    final int grind_time = 75;
    int last_speed = 0;
    public int rotation;
    public static ArrayList recipes = new ArrayList();

    public int k_() {
        return 2;
    }

    public ur a(int slot) {
        if (slot == 0) {
            return this.input;
        }
        if (slot == 1) {
            return this.output;
        }
        return null;
    }

    public void a(int slot, ur is) {
        if (slot == 0) {
            this.input = is;
        }
        if (slot == 1) {
            this.output = is;
        }
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.readSlotsFromNBT(tag);
        this.charge.readFromNBT(tag);
        this.progress = tag.e("progress");
        this.energy = tag.g("fenergy");
        this.speed = tag.e("speed");
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.writeSlotsToNBT(tag);
        this.charge.writeToNBT(tag);
        tag.a("progress", this.progress);
        tag.a("fenergy", this.energy);
        tag.a("speed", this.speed);
    }

    public String b() {
        return "Grinder";
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        float p = (float)(this.speed * 100) / 50.0f;
        return "Speed: " + (int)p + "%%";
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.GRINDER;
    }

    void slowDown() {
        if (this.speed > 0) {
            --this.speed;
        }
    }

    void shareSpeed() {
        if (this.speed != this.last_speed) {
            this.last_speed = this.speed;
            this.broadcastMessage(null, 90, this.speed);
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 90) {
            this.speed = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    public void g() {
        this.rotation += this.speed;
        this.charge.update();
        super.g();
    }

    @Override
    byte getExtraInfo2() {
        return (byte)this.speed;
    }

    @Override
    void useExtraInfo2(byte b) {
        this.speed = b;
    }

    @Override
    void doLogic() {
        this.shareSpeed();
        this.needLogic();
        if (this.energy < 30.0f && this.charge.getValue() >= 15) {
            this.energy += (float)(this.charge.deplete(60) / 10);
        }
        if (this.energy <= 0.0f) {
            this.slowDown();
            if (this.progress > 0) {
                --this.progress;
            }
            this.energy = 0.0f;
            return;
        }
        boolean powered = this.getCoord().isPowered();
        boolean grind_flag = this.canGrind();
        if (grind_flag || powered) {
            if (this.speed < 50) {
                ++this.speed;
                this.energy -= 2.0f;
            } else if (grind_flag) {
                if (this.progress == 75 || Core.cheat) {
                    this.progress = 0;
                    this.grind();
                } else {
                    ++this.progress;
                }
                this.energy -= 1.0f;
            }
        } else {
            this.slowDown();
        }
        if (!grind_flag) {
            this.progress = 0;
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public static void addRecipe(ur input, ur output, float probability) {
        GrinderRecipe toAdd = new GrinderRecipe(input, output, probability);
        for (GrinderRecipe gr : recipes) {
            if (!gr.input.equals(toAdd.input)) continue;
            return;
        }
        recipes.add(toAdd);
    }

    boolean canGrind() {
        this.input = FactorizationUtil.normalize(this.input);
        if (this.input == null) {
            return false;
        }
        for (GrinderRecipe gr : recipes) {
            if (!FactorizationUtil.identical(gr.input, this.input)) continue;
            if (this.output == null) {
                return true;
            }
            if (!FactorizationUtil.identical(this.output, gr.output)) {
                return false;
            }
            return !((double)this.output.a + ((double)((int)gr.probability) + 0.99) > (double)this.output.d());
        }
        return false;
    }

    void grind() {
        for (GrinderRecipe gr : recipes) {
            if (!FactorizationUtil.identical(gr.input, this.input)) continue;
            if (this.output == null) {
                this.output = gr.output.l();
                this.output.a = 0;
            }
            int min = (int)gr.probability;
            this.output.a += min;
            this.output.a = this.output.a + (rand.nextFloat() < gr.probability - (float)min ? 1 : 0);
            --this.input.a;
            this.input = FactorizationUtil.normalize(this.input);
            return;
        }
    }

    public int getGrindProgressScaled(int total) {
        return total * this.progress / 75;
    }

    public static class GrinderRecipe {
        public ur input;
        public ur output;
        public float probability;

        GrinderRecipe(ur input, ur output, float probability) {
            this.input = input;
            this.output = output;
            this.probability = probability;
        }
    }
}

