/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.VectorUV;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.RenderingCube;
import factorization.common.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;

public class TileEntityGreenware
extends TileEntityCommon {
    public ArrayList parts = new ArrayList();
    public int lastTouched = 0;
    int totalHeat = 0;
    public boolean renderedAsBlock = true;
    public static int dryTime = 2400;
    public static int bisqueHeat = 1000;
    public static int glazeHeat = bisqueHeat * 20;
    public static final int clayIconStart = 192;
    static HashMap selections = new HashMap();
    public static RenderingCube selected;
    private ClayState lastState = null;

    public static ClayState getStateFromInfo(int touch, int heat) {
        if (heat > glazeHeat) {
            return ClayState.GLAZED;
        }
        if (heat > bisqueHeat) {
            return ClayState.BISQUED;
        }
        if (touch > dryTime) {
            return ClayState.DRY;
        }
        return ClayState.WET;
    }

    public ClayState getState() {
        return TileEntityGreenware.getStateFromInfo(this.lastTouched, this.totalHeat);
    }

    public int getIcon(RenderingCube rc) {
        int icon = 0;
        switch (this.getState()) {
            case WET: {
                icon = 0;
                if (!this.isSelected(rc)) break;
                icon = 1;
                break;
            }
            case DRY: {
                icon = 3;
                break;
            }
            case BISQUED: {
                icon = 5;
                break;
            }
            case GLAZED: {
                return rc.icon;
            }
        }
        return 192 + icon;
    }

    public void touch() {
        if (this.getState() == ClayState.WET) {
            this.lastTouched = 0;
        }
    }

    public boolean renderEfficient() {
        return this.getState() != ClayState.WET;
    }

    public boolean canEdit() {
        return this.getState() == ClayState.WET;
    }

    void initialize() {
        this.parts.clear();
        this.parts.add(new RenderingCube(192, new VectorUV(3.0f, 5.0f, 3.0f)));
        this.touch();
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.GREENWARE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Ceramic;
    }

    void writeParts(bq tag) {
        by l = new by();
        for (RenderingCube rc : this.parts) {
            bq rc_tag = new bq();
            rc.writeToNBT(rc_tag);
            l.a((cd)rc_tag);
        }
        tag.a("parts", (cd)l);
        tag.a("touch", this.lastTouched);
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.writeParts(tag);
    }

    void loadParts(bq tag) {
        if (tag == null) {
            this.initialize();
            return;
        }
        by partList = tag.m("parts");
        if (partList == null) {
            this.initialize();
            return;
        }
        this.parts.clear();
        for (int i = 0; i < partList.c(); ++i) {
            bq rc_tag = (bq)partList.b(i);
            this.parts.add(RenderingCube.loadFromNBT(rc_tag));
        }
        this.lastTouched = tag.e("touch");
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.loadParts(tag);
    }

    @Override
    public ef getAuxillaryInfoPacket() {
        ArrayList<Integer> args = new ArrayList<Integer>(2 + this.parts.size() * 7);
        args.add(130);
        args.add(this.getState().ordinal());
        for (RenderingCube rc : this.parts) {
            rc.writeToArray(args);
        }
        return this.getDescriptionPacketWith(args.toArray());
    }

    @Override
    void onPlacedBy(qx player, ur is, int side) {
        super.onPlacedBy(player, is, side);
        this.loadParts(is.p());
    }

    ur getItem() {
        ur ret = Core.registry.greenware_item.l();
        bq tag = new bq();
        this.writeParts(tag);
        ret.d(tag);
        return ret;
    }

    public void g() {
        super.g();
        if (this.k.I) {
            return;
        }
        switch (this.getState()) {
            case WET: {
                if (!this.k.N()) {
                    ++this.lastTouched;
                }
                if (this.totalHeat <= 0) break;
                --this.totalHeat;
                ++this.lastTouched;
            }
        }
        if (this.getState() != this.lastState) {
            this.lastState = this.getState();
            this.broadcastMessage(null, 135, this.lastState.ordinal());
        }
    }

    public boolean isSelected(RenderingCube rc) {
        return rc == selected;
    }

    @Override
    public boolean activate(qx player) {
        ur held;
        if (this.getState() == ClayState.WET) {
            this.touch();
        }
        if ((held = player.bS()) == null) {
            return false;
        }
        int heldId = held.b().cj;
        if (heldId == up.ax.cj && this.getState() == ClayState.DRY) {
            this.lastTouched = 0;
            if (player.cd.d) {
                return true;
            }
            int ci = player.bJ.c;
            player.bJ.a[ci] = new ur(up.aw);
            return true;
        }
        if (heldId == amq.ae.cm) {
            this.lastTouched = dryTime + 1;
            return true;
        }
        if (held.b() != up.aI || held.a == 0) {
            return false;
        }
        --held.a;
        if (player.p.I) {
            return true;
        }
        if (this.parts.size() >= 32) {
            Core.notify(player, this.getCoord(), "Too complex", new String[0]);
            ++held.a;
            return false;
        }
        this.addLump(player.bR);
        return true;
    }

    void addLump(String creator) {
        this.parts.add(new RenderingCube(192, new VectorUV(4.0f, 4.0f, 4.0f)));
        if (!this.k.I) {
            this.broadcastMessage(null, 132, creator);
            selections.put(creator, new SelectionInfo(this, this.parts.size() - 1));
            this.touch();
        } else if (creator.equals(Minecraft.x().g.bR)) {
            selected = (RenderingCube)this.parts.get(this.parts.size() - 1);
        }
    }

    void removeLump(int id) {
        if (id < 0 || id >= this.parts.size()) {
            return;
        }
        this.parts.remove(id);
        if (!this.k.I) {
            this.broadcastMessage(null, 134, id);
            this.touch();
        }
    }

    public static boolean isValidLump(RenderingCube rc) {
        float edge = 24.0f;
        for (int i = 0; i < 6; ++i) {
            for (VectorUV vertex : rc.faceVerts(i)) {
                if (Math.abs(vertex.x) > edge) {
                    return false;
                }
                if (Math.abs(vertex.y) > edge) {
                    return false;
                }
                if (!(Math.abs(vertex.z) > edge)) continue;
                return false;
            }
        }
        if (rc.corner.x <= 0.0f || rc.corner.y <= 0.0f || rc.corner.z <= 0.0f) {
            return false;
        }
        float max = 8.0f;
        return !(rc.corner.x > max) && !(rc.corner.y > max) && !(rc.corner.z > max);
    }

    void updateLump(int id, RenderingCube newCube) {
        if (id < 0 || id >= this.parts.size()) {
            return;
        }
        RenderingCube old = (RenderingCube)this.parts.get(id);
        if (old.equals(newCube)) {
            return;
        }
        old.icon = newCube.icon;
        old.corner = newCube.corner;
        old.trans = newCube.trans;
        this.touch();
        if (this.k.I) {
            return;
        }
    }

    void shareLump(int id, RenderingCube selection) {
        ArrayList<Integer> toSend = new ArrayList<Integer>();
        toSend.add(id);
        selection.writeToArray(toSend);
        this.broadcastMessage(null, 133, toSend.toArray());
    }

    private float getFloat(DataInput input) throws IOException {
        int r = (int)(input.readFloat() * 2.0f);
        return (float)r / 2.0f;
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        if (messageType == 131) {
            selections.put(Core.network.getCurrentPlayer().bR, new SelectionInfo(this, input.readInt()));
            return true;
        }
        if (messageType == 136) {
            qw inv = Core.network.getCurrentPlayer().bJ;
            ur is = inv.a[inv.c];
            if (is == null) {
                return true;
            }
            up item2 = is.b();
            if (item2 == null) {
                return true;
            }
            int id = item2.cj;
            if (is.b() == up.ax && this.getState() == ClayState.DRY) {
                is.c = up.ax.cj;
                this.lastTouched = 0;
            }
            if (id == amq.ae.cm) {
                this.lastTouched = dryTime;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case 130: {
                this.readStateChange(input);
                this.parts.clear();
                ArrayList args = new ArrayList();
                try {
                    while (true) {
                        this.parts.add(RenderingCube.readFromDataInput(input));
                    }
                }
                catch (IOException e) {
                    break;
                }
            }
            case 133: {
                this.updateLump(input.readInt(), RenderingCube.readFromDataInput(input));
                break;
            }
            case 132: {
                this.addLump(input.readUTF());
                break;
            }
            case 134: {
                this.removeLump(input.readInt());
                break;
            }
            case 135: {
                this.readStateChange(input);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void readStateChange(DataInput input) throws IOException {
        switch (ClayState.values()[input.readInt()]) {
            case WET: {
                this.lastTouched = 0;
                break;
            }
            case DRY: {
                this.lastTouched = dryTime + 10;
                break;
            }
            case BISQUED: {
                this.totalHeat = bisqueHeat + 1;
                break;
            }
            case GLAZED: {
                this.totalHeat = glazeHeat + 1;
            }
        }
        this.getCoord().redraw();
    }

    public static enum ClayState {
        WET("Wet Greenware"),
        DRY("Bone-Dry Greenware"),
        BISQUED("Bisqued"),
        GLAZED("High-Fire Glazed");

        public String english;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ClayState() {
            void en;
            this.english = en;
        }
    }

    static class SelectionInfo {
        TileEntityGreenware gw;
        int id;

        SelectionInfo(TileEntityGreenware gw, int id) {
            this.gw = gw;
            this.id = id;
        }
    }
}

