/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.DeltaCoord;
import factorization.common.BlockClass;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;

public class TileEntityExtension
extends TileEntityCommon {
    private TileEntityCommon _parent = null;
    private DeltaCoord pc;

    public TileEntityExtension() {
    }

    public TileEntityExtension(TileEntityCommon parent) {
        this._parent = parent;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.EXTENDED;
    }

    @Override
    public BlockClass getBlockClass() {
        TileEntityCommon p = this.getParent();
        if (p == null) {
            return BlockClass.Default;
        }
        return p.getBlockClass();
    }

    @Override
    void onRemove() {
        super.onRemove();
        TileEntityCommon p = this.getParent();
        if (p != null) {
            p.onRemove();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public TileEntityCommon getParent() {
        if (this._parent == null && this.pc != null) {
            this._parent = (TileEntityCommon)this.getCoord().add(this.pc).getTE(TileEntityCommon.class);
            if (this._parent == null || this._parent.getClass() == TileEntityExtension.class) {
                this.setParent(null);
            }
        }
        return this._parent;
    }

    public void setParent(TileEntityCommon newParent) {
        if (newParent == null || newParent.getClass() == TileEntityExtension.class) {
            this._parent = null;
            this.pc = null;
            return;
        }
        this._parent = newParent;
        this.pc = newParent.getCoord().difference(this.getCoord());
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        if (this.pc != null) {
            this.pc.writeToTag("p", tag);
        }
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.pc = DeltaCoord.readFromTag("p", tag);
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool() {
        TileEntityCommon p = this.getParent();
        if (p == null && this.pc != null) {
            p = (TileEntityCommon)this.getCoord().add(this.pc).getTE(TileEntityCommon.class);
        }
        if (p != null) {
            return p.getCollisionBoundingBoxFromPool();
        }
        return super.getCollisionBoundingBoxFromPool();
    }

    public void s() {
        super.s();
        if (this._parent != null && this.pc == null) {
            this.setParent(this._parent);
        }
    }

    @Override
    public ef getAuxillaryInfoPacket() {
        if (this.pc == null) {
            return super.getAuxillaryInfoPacket();
        }
        return this.getDescriptionPacketWith(150, this.pc);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 150) {
            this.pc = DeltaCoord.read(input);
            return true;
        }
        return false;
    }

    @Override
    public boolean activate(qx entityplayer) {
        TileEntityCommon p = this.getParent();
        if (p != null) {
            return p.activate(entityplayer);
        }
        return false;
    }

    @Override
    public void neighborChanged() {
        TileEntityCommon p = this.getParent();
        if (p != null) {
            p.neighborChanged();
        }
    }
}

