/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationHack;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityCrystallizer
extends TileEntityFactorization {
    ur[] inputs = new ur[6];
    ur output;
    public ur growing_crystal;
    public ur solution;
    public int heat;
    public int progress;
    public static final int topHeat = 300;
    int share_delay = 600;
    int current_state = -1;
    int last_state = -1;
    public static ArrayList recipes = new ArrayList();

    @Override
    public void b(bq tag) {
        super.b(tag);
        this.writeSlotsToNBT(tag);
        tag.a("heat", this.heat);
        tag.a("progress", this.progress);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.readSlotsFromNBT(tag);
        this.heat = tag.e("heat");
        this.progress = tag.e("progress");
    }

    public int k_() {
        return this.inputs.length + 1;
    }

    public ur a(int slot) {
        this.needLogic();
        if (slot == this.inputs.length) {
            return this.output;
        }
        return this.inputs[slot];
    }

    public void a(int slot, ur is) {
        this.needLogic();
        if (slot == this.inputs.length) {
            this.output = is;
            return;
        }
        this.inputs[slot] = is;
    }

    public String b() {
        return "Crystallizer";
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return this.inputs.length;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return 1;
        }
        return this.inputs.length;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.CRYSTALLIZER;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    int pickInputSlot(ur must_match) {
        int slot = -1;
        int max_size = -99;
        for (int i = 0; i < this.inputs.length; ++i) {
            int here_size;
            if (must_match != null && this.inputs[i] != null && !FactorizationUtil.identical(must_match, this.inputs[i]) || (here_size = FactorizationUtil.getStackSize(this.inputs[i])) <= max_size) continue;
            max_size = here_size;
            slot = i;
        }
        return slot;
    }

    public int getProgressRemaining() {
        return 24000 / this.getLogicSpeed() - this.progress;
    }

    public float getProgress() {
        return (float)this.progress / (float)(this.getProgressRemaining() + this.progress);
    }

    boolean needHeat() {
        if (this.heat >= 300) {
            return false;
        }
        return this.getMatchingRecipe() != null;
    }

    void empty() {
        this.growing_crystal = null;
        this.solution = null;
        this.shareState();
    }

    @Override
    void doLogic() {
        if (this.heat <= 0) {
            this.current_state = 1;
            this.empty();
            return;
        }
        CrystalRecipe match = this.getMatchingRecipe();
        if (match == null) {
            this.heat = Math.max(this.heat - 3, 0);
            this.progress = (int)Math.min((double)this.progress * 0.005 - 1.0, 0.0);
            this.current_state = 2;
            this.empty();
            return;
        }
        if (this.growing_crystal == null) {
            this.growing_crystal = match.output;
            this.solution = match.solution;
            this.share_delay = 0;
            this.current_state = 3;
        }
        if (this.heat < 300) {
            this.current_state = 4;
            this.shareState();
            return;
        }
        this.needLogic();
        if (this.progress == 0) {
            this.share_delay = 0;
            this.current_state = 5;
        }
        ++this.progress;
        if (this.getProgressRemaining() <= 0 || Core.cheat) {
            this.heat = Core.cheat ? 280 : 0;
            this.progress = 0;
            match.apply(this);
            this.share_delay = 0;
            this.current_state = 6;
        }
        this.shareState();
    }

    void shareState() {
        --this.share_delay;
        if (this.share_delay <= 0 || this.current_state != this.last_state) {
            this.share_delay = 300;
            this.broadcastMessage(null, this.getAuxillaryInfoPacket());
            this.last_state = this.current_state;
        }
    }

    int countMaterial(ur toMatch) {
        int count = 0;
        for (ur is : this.inputs) {
            if (is == null) continue;
            if (toMatch.j() == -1 && is.c == toMatch.c) {
                count += is.a;
                continue;
            }
            if (!FactorizationUtil.identical(is, toMatch)) continue;
            count += is.a;
        }
        return count;
    }

    public static void addRecipe(ur input, ur output, float output_count, ur solution, int inverium_count) {
        if (output.a != 1) {
            throw new RuntimeException("Stacksize should be 1");
        }
        if (output_count == 0.0f) {
            throw new RuntimeException("output_count is 0");
        }
        output = output.l();
        output.a = 0;
        recipes.add(new CrystalRecipe(input, output, output_count, solution, inverium_count));
    }

    CrystalRecipe getMatchingRecipe() {
        for (CrystalRecipe r : recipes) {
            if (!r.matches(this)) continue;
            return r;
        }
        return null;
    }

    ur null2fake(ur is) {
        if (is == null) {
            return Core.registry.crystallizer_item;
        }
        return is;
    }

    ur unfake(ur is) {
        if (is.a(Core.registry.crystallizer_item)) {
            return null;
        }
        return is;
    }

    @Override
    public ef getAuxillaryInfoPacket() {
        return this.getDescriptionPacketWith(110, this.null2fake(this.growing_crystal), this.null2fake(this.solution), this.progress);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 110) {
            this.growing_crystal = this.unfake(FactorizationHack.loadItemStackFromDataInput(input));
            this.solution = this.unfake(FactorizationHack.loadItemStackFromDataInput(input));
            this.progress = input.readInt();
            return true;
        }
        return false;
    }

    public double m() {
        return 576.0;
    }

    public static class CrystalRecipe {
        public ur input;
        public ur output;
        public ur solution;
        public float output_count;
        public int inverium_count;

        public CrystalRecipe(ur input, ur output, float output_count, ur solution, int inverium_count) {
            this.input = input;
            this.output = output;
            this.output_count = output_count;
            this.solution = solution;
            this.inverium_count = inverium_count;
        }

        boolean matches(TileEntityCrystallizer crys) {
            if (crys.countMaterial(new ur((up)Core.registry.inverium, 1, -1)) < this.inverium_count) {
                return false;
            }
            if (crys.output != null) {
                if (!FactorizationUtil.identical(crys.output, this.output)) {
                    return false;
                }
                if ((float)crys.output.a + this.output_count > (float)crys.output.d()) {
                    return false;
                }
            }
            if (this.solution != null && crys.countMaterial(this.solution) < this.solution.a) {
                return false;
            }
            if (this.input != null) {
                return crys.countMaterial(this.input) >= this.input.a;
            }
            return true;
        }

        private void applyTo(TileEntityCrystallizer crys, int slot) {
            int delta = (int)this.output_count;
            if ((float)delta != this.output_count && TileEntityFactorization.rand.nextFloat() < this.output_count - (float)delta) {
                ++delta;
            }
            if (crys.output != null && crys.output.a + delta > crys.output.d()) {
                return;
            }
            ur is = this.input.l();
            while (is.a > 0) {
                --crys.inputs[slot].a;
                crys.inputs[slot] = FactorizationUtil.normalize(crys.inputs[slot]);
                --is.a;
            }
            if (crys.output == null) {
                crys.output = this.output.l();
                assert (this.output.a == 0) : "output stack size is specified in the output_count";
                crys.output.a = 0;
            }
            crys.output.a += delta;
            int dead_inverium = this.inverium_count;
            for (int inverium_slot = 0; inverium_slot < crys.inputs.length && dead_inverium != 0; ++inverium_slot) {
                ur inverium = crys.inputs[inverium_slot];
                if (inverium == null || inverium.b() != Core.registry.inverium) continue;
                int toRemove = Math.min(dead_inverium, inverium.a);
                inverium.a -= toRemove;
                dead_inverium -= toRemove;
                if (inverium.a > 0) continue;
                crys.inputs[inverium_slot] = null;
            }
        }

        void apply(TileEntityCrystallizer crys) {
            ur inverium = new ur((up)Core.registry.inverium, 0, -1);
            for (int i = 0; i < crys.inputs.length; ++i) {
                ur is = crys.inputs[i];
                if (is == null || !FactorizationUtil.identical(this.input, is) || crys.countMaterial(inverium) < this.inverium_count) continue;
                this.applyTo(crys, i);
            }
        }
    }
}

