/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationHack;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityBarrel
extends TileEntityFactorization {
    public static final int normalBarrelSize = 4096;
    public static final int largeBarrelSize = 65536;
    public static final int maxStackDrop = 64;
    public ur item;
    private ur topStack;
    private int middleCount;
    private ur bottomStack;
    public int upgrade = 0;
    private int lastCount = 0;
    long lastClick = -1000L;
    private static ur emptyItemStack = new ur(0, 0, 0);

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.BARREL;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Barrel;
    }

    public int getItemCount() {
        if (this.item == null) {
            return 0;
        }
        if (this.topStack == null || !this.itemMatch(this.topStack)) {
            this.topStack = this.item.l();
            this.topStack.a = 0;
        }
        if (this.bottomStack == null || !this.itemMatch(this.bottomStack)) {
            this.bottomStack = this.item.l();
            this.bottomStack.a = 0;
        }
        return this.topStack.a + this.middleCount + this.bottomStack.a;
    }

    public int getMaxSize() {
        if (this.upgrade == 0) {
            return 4096;
        }
        return 65536;
    }

    public void updateStacks() {
        if (this.item == null) {
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        int count = this.getItemCount();
        if (count == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        int upperLine = this.getMaxSize() - this.item.d();
        if (count > upperLine) {
            this.topStack = this.item.l();
            this.topStack.a = count - upperLine;
            count -= this.topStack.a;
        } else {
            this.topStack.a = 0;
        }
        this.bottomStack.a = Math.min(this.item.d(), count);
        this.middleCount = count -= this.bottomStack.a;
    }

    public void changeItemCount(int delta) {
        this.middleCount = this.getItemCount() + delta;
        if (this.middleCount < 0) {
            Core.logSevere("Tried to set the item count to negative value " + this.middleCount + " at " + this.getCoord(), new Object[0]);
            this.middleCount = 0;
            this.item = null;
        }
        if (this.middleCount > this.getMaxSize()) {
            Core.logSevere("Factorization barrel size " + this.middleCount + " is larger than the maximum, " + this.getMaxSize() + " at " + this.getCoord(), new Object[0]);
        }
        this.bottomStack = null;
        this.topStack = null;
        this.updateStacks();
        this.broadcastItemCount();
    }

    public void setItemCount(int val) {
        this.bottomStack = null;
        this.topStack = null;
        this.middleCount = val;
        this.changeItemCount(0);
    }

    private ur makeStack(int count) {
        if (this.item == null) {
            return null;
        }
        ur ret = this.item.l();
        ret.a = count;
        assert (ret.a > 0 && ret.a <= this.item.d());
        return ret;
    }

    public int k_() {
        return 2;
    }

    public ur a(int slot) {
        if (this.item == null) {
            this.cleanBarrel();
            return null;
        }
        if (slot == 0) {
            return this.bottomStack;
        }
        if (slot == 1) {
            return this.topStack;
        }
        return null;
    }

    static int sizeOf(ur is) {
        if (is == null) {
            return 0;
        }
        return is.a;
    }

    private boolean itemMatch(ur is) {
        if (is == null || this.item == null) {
            return false;
        }
        this.item.a = is.a;
        return FactorizationUtil.identical(this.item, is);
    }

    @Override
    public ur a(int slot, int amount) {
        ur is = this.a(slot);
        if (is == null) {
            return null;
        }
        if (this.getItemCount() - amount < 0) {
            return null;
        }
        ur ret = is.a(amount);
        this.updateStacks();
        this.broadcastItemCount();
        return ret;
    }

    public void a(int slot, ur is) {
        ur old_item = this.item;
        this.taintBarrel(is);
        if (is != null && !this.itemMatch(is)) {
            new Exception().printStackTrace();
            return;
        }
        switch (slot) {
            case 0: {
                this.bottomStack = is;
                break;
            }
            case 1: {
                this.topStack = is;
            }
        }
        if (old_item != this.item) {
            this.broadcastItem();
        }
        this.broadcastItemCount();
    }

    public String b() {
        return "Barrel";
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
        }
        return -1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return 1;
        }
        return 0;
    }

    void info(qx entityplayer) {
        if (this.item == null && this.getItemCount() == 0) {
            Core.notify(entityplayer, this.getCoord(), "Empty", new String[0]);
        } else if (this.getItemCount() >= this.getMaxSize()) {
            Core.notify(entityplayer, this.getCoord(), "Full of %s", Core.getTranslationKey(this.item));
        } else {
            Core.notify(entityplayer, this.getCoord(), "%s %s", "" + this.getItemCount(), Core.getTranslationKey(this.item));
        }
    }

    void taintBarrel(ur is) {
        if (is == null) {
            return;
        }
        if (this.getItemCount() != 0) {
            return;
        }
        if (is.d() >= this.getMaxSize()) {
            return;
        }
        this.item = is.l();
        this.broadcastItem();
    }

    void broadcastItem() {
        if (this.k != null && !this.k.I) {
            Core.network.broadcastMessage(null, this.getCoord(), 41, this.item);
        }
    }

    void broadcastItemCount() {
        if (this.k != null && !this.k.I) {
            this.lastCount = this.getItemCount();
            Core.network.broadcastMessage(null, this.getCoord(), 42, this.lastCount);
        }
    }

    void cleanBarrel() {
        if (this.getItemCount() == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
        } else assert (this.item != null);
    }

    @Override
    public boolean takeUpgrade(ur is) {
        if (is.b() == Core.registry.barrel_enlarge && this.upgrade == 0) {
            this.upgrade = 1;
            this.broadcastMessage(null, this.getAuxillaryInfoPacket());
            return true;
        }
        return false;
    }

    @Override
    public boolean activate(qx entityplayer) {
        if (entityplayer.p.I) {
            return true;
        }
        if (this.k.G() - this.lastClick < 10L && this.item != null) {
            this.addAllItems(entityplayer);
            return true;
        }
        this.lastClick = this.k.G();
        int handslot = entityplayer.bJ.c;
        if (handslot < 0 || handslot > 8) {
            return true;
        }
        ur is = entityplayer.bJ.a(handslot);
        if (is == null) {
            this.info(entityplayer);
            return true;
        }
        if (is.h()) {
            if (this.getItemCount() == 0) {
                Core.notify(entityplayer, this.getCoord(), "No storing damaged items", new String[0]);
            } else {
                this.info(entityplayer);
            }
            return true;
        }
        this.taintBarrel(is);
        if (!this.itemMatch(is)) {
            if (Core.getTranslationKey(is.b()).equals(Core.getTranslationKey(this.item))) {
                Core.notify(entityplayer, this.getCoord(), "That item is different", new String[0]);
            } else {
                this.info(entityplayer);
            }
            return true;
        }
        int free = this.getMaxSize() - this.getItemCount();
        if (free <= 0) {
            this.info(entityplayer);
            return true;
        }
        int take = Math.min(free, is.a);
        is.a -= take;
        this.changeItemCount(take);
        if (is.a == 0) {
            entityplayer.bJ.a(handslot, null);
        }
        return true;
    }

    @Override
    public void click(qx entityplayer) {
        if (entityplayer.p.I) {
            return;
        }
        if (this.getItemCount() == 0 || this.item == null) {
            this.info(entityplayer);
            return;
        }
        int to_remove = Math.min(this.item.d(), this.getItemCount());
        if (entityplayer.ah() && to_remove >= 1) {
            to_remove = 1;
        }
        this.ejectItem(this.makeStack(to_remove), false, entityplayer);
        this.changeItemCount(-to_remove);
        this.cleanBarrel();
    }

    void addAllItems(qx entityplayer) {
        int free_space;
        ur hand = entityplayer.bJ.a(entityplayer.bJ.c);
        if (hand != null) {
            this.taintBarrel(hand);
        }
        if (hand != null && !this.itemMatch(hand)) {
            if (Core.getTranslationKey(hand).equals(Core.getTranslationKey(this.item))) {
                Core.notify(entityplayer, this.getCoord(), "That item is different", new String[0]);
            } else {
                this.info(entityplayer);
            }
            return;
        }
        qw inv = entityplayer.bJ;
        int total_delta = 0;
        for (int i = 0; i < inv.k_() && (free_space = this.getMaxSize() - (this.getItemCount() + total_delta)) > 0; ++i) {
            ur is = inv.a(i);
            if (is == null || is.a <= 0 || !this.itemMatch(is)) continue;
            int toAdd = Math.min(is.a, free_space);
            if (is == hand && toAdd > 1) {
                --toAdd;
            }
            total_delta += toAdd;
            is.a -= toAdd;
            if (is.a > 0) continue;
            inv.a(i, null);
        }
        this.changeItemCount(total_delta);
        if (total_delta > 0) {
            Core.proxy.updatePlayerInventory(entityplayer);
        }
    }

    public boolean canLose() {
        return this.getItemCount() > 64 * this.item.d();
    }

    @Override
    public void dropContents() {
        if (this.upgrade > 0) {
            FactorizationUtil.spawnItemStack(this.getCoord(), new ur((up)Core.registry.barrel_enlarge));
        }
        if (this.item == null || this.getItemCount() <= 0) {
            return;
        }
        int count = this.getItemCount();
        for (int i = 0; i < 64; ++i) {
            int to_drop = Math.min(this.item.d(), count);
            this.ejectItem(this.makeStack(to_drop), this.getItemCount() > 1024, null);
            if ((count -= to_drop) <= 0) break;
        }
        if (count > 0) {
            this.broadcastMessage(null, 43, this.upgrade);
        }
        this.topStack = null;
        this.middleCount = 0;
        this.bottomStack = null;
    }

    static void spawnBreakParticles(Coord c, int upgrade) {
        if (upgrade > 0) {
            for (int theta = 0; theta < 360; ++theta) {
                if (rand.nextInt(10) != 2) continue;
                float speed = 2.0f;
                float start = -2.0f;
                double a = Math.toRadians(theta);
                c.w.a("portal", (double)((float)c.x + 0.5f) + Math.cos(a) * (double)start, (double)c.y, (double)((float)c.z + 0.5f) + Math.sin(a) * (double)start, Math.cos(a) * (double)speed, 0.0, Math.sin(a) * (double)speed);
            }
        } else {
            c.w.a("largesmoke", (double)((float)c.x + 0.5f), (double)((float)c.y + 0.5f), (double)((float)c.z + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        TileEntityBarrel.saveItem("item_type", tag, this.item);
        tag.a("item_count", this.getItemCount());
        tag.a("upgrade", this.upgrade);
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.item = TileEntityBarrel.readItem("item_type", tag);
        this.upgrade = tag.e("upgrade");
        this.setItemCount(tag.e("item_count"));
    }

    @Override
    void sendFullDescription(qx player) {
        super.sendFullDescription(player);
        this.broadcastItem();
        this.changeItemCount(0);
    }

    @Override
    public ef getAuxillaryInfoPacket() {
        int ic = this.getItemCount();
        if (ic == 0) {
            return this.getDescriptionPacketWith(40, ic, this.upgrade, emptyItemStack);
        }
        return this.getDescriptionPacketWith(40, ic, this.upgrade, this.item);
    }

    @Override
    void doLogic() {
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void g() {
        this.updateStacks();
        if (this.lastCount != this.getItemCount()) {
            this.broadcastItemCount();
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case 42: {
                this.setItemCount(input.readInt());
                break;
            }
            case 40: {
                int i = input.readInt();
                this.upgrade = input.readInt();
                if (i > 0) {
                    this.item = FactorizationHack.loadItemStackFromDataInput(input);
                }
                this.setItemCount(i);
                break;
            }
            case 41: {
                this.item = FactorizationHack.loadItemStackFromDataInput(input);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Barrel of " + this.getItemCount() + " " + this.item;
    }

    public double m() {
        if (Core.render_barrel_close) {
            return 25.0;
        }
        return 1024.0;
    }
}

