/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.MatrixTransform;
import factorization.api.VectorUV;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;

public class RenderingCube {
    int icon;
    public VectorUV corner;
    public MatrixTransform trans;
    public double ul;
    public double vl;
    static VectorUV[] cache = new VectorUV[4];

    public RenderingCube(int icon, VectorUV corner) {
        this.corner = corner;
        this.trans = new MatrixTransform();
        this.setIcon(icon);
    }

    public RenderingCube(int icon, VectorUV corner, VectorUV offset) {
        this(icon, corner);
        if (offset != null) {
            this.trans.translate(offset.x, offset.y, offset.z);
        }
    }

    void writeToNBT(bq tag) {
        tag.a("icon", this.icon);
        this.corner.writeToTag(tag, "c");
        this.trans.writeToTag(tag, "t");
    }

    static RenderingCube loadFromNBT(bq tag) {
        int icon = tag.e("icon");
        VectorUV c = VectorUV.readFromTag(tag, "c");
        MatrixTransform trans = MatrixTransform.readFromTag(tag, "t");
        RenderingCube rc = new RenderingCube(icon, c);
        rc.trans = trans;
        return rc;
    }

    void writeToArray(ArrayList args) {
        args.add(this.icon);
        this.corner.addInfoToArray(args);
        this.trans.addToList(args);
    }

    static float takeFloat(ArrayList args) {
        return ((Float)args.remove(0)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    static RenderingCube readFromDataInput(DataInput input) throws IOException {
        int icon = input.readInt();
        VectorUV c = new VectorUV(input.readFloat(), input.readFloat(), input.readFloat());
        MatrixTransform trans = MatrixTransform.fromDataInput(input);
        RenderingCube ret = new RenderingCube(icon, c);
        ret.trans = trans;
        return ret;
    }

    public boolean equals(RenderingCube other) {
        return this.corner.equals(other.corner) && this.icon == other.icon && this.trans.equals(other.trans);
    }

    public RenderingCube copy() {
        RenderingCube ret = new RenderingCube(this.icon, this.corner.copy());
        ret.ul = this.ul;
        ret.vl = this.vl;
        ret.trans = this.trans.copy();
        return ret;
    }

    public RenderingCube rotate(int x, int y2, int z, int theta) {
        RenderingCube ret = this.copy();
        ret.trans.rotate(x, y2, z, (float)Math.toRadians(theta));
        return ret;
    }

    public RenderingCube translate(int x, int y2, int z) {
        RenderingCube ret = this.copy();
        ret.trans.translate(x, y2, z);
        return ret;
    }

    public RenderingCube normalize() {
        return this;
    }

    public void setIcon(int newIcon) {
        this.icon = newIcon;
        this.ul = (double)((this.icon & 0xF) << 4) / 256.0;
        this.vl = (double)(this.icon & 0xF0) / 256.0;
    }

    void set(int i, float x, float y2, float z) {
        RenderingCube.cache[i].x = x;
        RenderingCube.cache[i].y = y2;
        RenderingCube.cache[i].z = z;
    }

    public VectorUV[] faceVerts(int face) {
        int i;
        VectorUV v = this.corner;
        int c = 8;
        switch (face) {
            case 0: {
                this.set(0, v.x, -v.y, v.z);
                this.set(1, -v.x, -v.y, v.z);
                this.set(2, -v.x, -v.y, -v.z);
                this.set(3, v.x, -v.y, -v.z);
                break;
            }
            case 1: {
                this.set(0, v.x, v.y, -v.z);
                this.set(1, -v.x, v.y, -v.z);
                this.set(2, -v.x, v.y, v.z);
                this.set(3, v.x, v.y, v.z);
                break;
            }
            case 2: {
                this.set(0, v.x, v.y, -v.z);
                this.set(1, v.x, -v.y, -v.z);
                this.set(2, -v.x, -v.y, -v.z);
                this.set(3, -v.x, v.y, -v.z);
                break;
            }
            case 3: {
                this.set(0, v.x, v.y, v.z);
                this.set(1, -v.x, v.y, v.z);
                this.set(2, -v.x, -v.y, v.z);
                this.set(3, v.x, -v.y, v.z);
                break;
            }
            case 4: {
                this.set(0, -v.x, v.y, v.z);
                this.set(1, -v.x, v.y, -v.z);
                this.set(2, -v.x, -v.y, -v.z);
                this.set(3, -v.x, -v.y, v.z);
                break;
            }
            case 5: {
                this.set(0, v.x, v.y, v.z);
                this.set(1, v.x, -v.y, v.z);
                this.set(2, v.x, -v.y, -v.z);
                this.set(3, v.x, v.y, -v.z);
            }
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            switch (face) {
                case 0: 
                case 1: {
                    VectorUV vert;
                    for (i = 0; i < cache.length; ++i) {
                        vert = cache[i];
                        vert.u = vert.x + 8.0f;
                        vert.v = vert.z + 8.0f;
                    }
                    break;
                }
                case 2: {
                    VectorUV vert;
                    for (i = 0; i < cache.length; ++i) {
                        vert = cache[i];
                        vert.u = 16.0f - (vert.x + 8.0f);
                        vert.v = 16.0f - (vert.y + 8.0f);
                    }
                    break;
                }
                case 3: {
                    VectorUV vert;
                    for (i = 0; i < cache.length; ++i) {
                        vert = cache[i];
                        vert.u = vert.x + 8.0f;
                        vert.v = 16.0f - (vert.y + 8.0f);
                    }
                    break;
                }
                case 4: {
                    VectorUV vert;
                    for (i = 0; i < cache.length; ++i) {
                        vert = cache[i];
                        vert.u = 16.0f - (vert.y + 8.0f);
                        vert.v = vert.z + 8.0f;
                    }
                    break;
                }
                case 5: {
                    VectorUV vert;
                    for (i = 0; i < cache.length; ++i) {
                        vert = cache[i];
                        vert.u = 16.0f - (vert.y + 8.0f);
                        vert.v = 16.0f - (vert.z + 8.0f);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid face number");
                }
            }
            for (i = 0; i < cache.length; ++i) {
                VectorUV main = cache[i];
                float udelta = 0.0f;
                float vdelta = 0.0f;
                int nada = 0;
                if (main.u > 16.0f) {
                    udelta = main.u - 16.0f;
                } else if (main.u < 0.0f) {
                    udelta = main.u;
                } else {
                    ++nada;
                }
                if (main.v > 16.0f) {
                    vdelta = main.v - 16.0f;
                } else if (main.v < 0.0f) {
                    vdelta = main.v;
                } else {
                    ++nada;
                }
                if (nada == 2) continue;
                for (int J = 0; J < cache.length; ++J) {
                    VectorUV other = cache[J];
                    other.u -= udelta;
                    other.v -= vdelta;
                }
            }
        }
        for (i = 0; i < cache.length; ++i) {
            RenderingCube.cache[i] = this.trans.apply(cache[i]);
        }
        return cache;
    }

    static {
        for (int i = 0; i < cache.length; ++i) {
            RenderingCube.cache[i] = new VectorUV();
        }
    }
}

