/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.IActOnCraft;
import factorization.common.BlockClass;
import factorization.common.BlockFactorization;
import factorization.common.BlockLightAir;
import factorization.common.BlockResource;
import factorization.common.Core;
import factorization.common.ExoArmor;
import factorization.common.ExoBuoyantBarrel;
import factorization.common.ExoCobblestoneDrive;
import factorization.common.ExoMountedPiston;
import factorization.common.ExoWallJump;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemAcidBottle;
import factorization.common.ItemAngularSaw;
import factorization.common.ItemBagOfHolding;
import factorization.common.ItemBattery;
import factorization.common.ItemBlockProxy;
import factorization.common.ItemBlockResource;
import factorization.common.ItemChargeMeter;
import factorization.common.ItemCraft;
import factorization.common.ItemCraftingComponent;
import factorization.common.ItemFactorization;
import factorization.common.ItemInverium;
import factorization.common.ItemMachineUpgrade;
import factorization.common.ItemMatrixProgrammer;
import factorization.common.ItemMirror;
import factorization.common.ItemOreProcessing;
import factorization.common.ItemPocketTable;
import factorization.common.ItemSculptingTool;
import factorization.common.ItemWandOfCooling;
import factorization.common.ItemWrathIgniter;
import factorization.common.ResourceType;
import factorization.common.Sound;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntityFzNull;
import factorization.common.TileEntityGrinder;
import factorization.common.TileEntitySlagFurnace;
import factorization.common.TileEntityWrathFire;
import factorization.common.TileEntityWrathLamp;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Registry
implements ICraftingHandler,
IWorldGenerator,
ITickHandler {
    public static final int ExoKeyCount = 3;
    public ItemFactorization item_factorization;
    public ItemBlockResource item_resource;
    public BlockFactorization factory_block;
    public BlockFactorization factory_rendering_block = null;
    public BlockLightAir lightair_block;
    public BlockResource resource_block;
    public ur router_item;
    public ur maker_item;
    public ur stamper_item;
    public ur packager_item;
    public ur barrel_item;
    public ur lamp_item;
    public ur air_item;
    public ur slagfurnace_item;
    public ur battery_item_hidden;
    public ur heater_item;
    public ur steamturbine_item;
    public ur solarboiler_item;
    public ur mirror_item_hidden;
    public ur leadwire_item;
    public ur grinder_item;
    public ur mixer_item;
    public ur crystallizer_item;
    public ur greenware_item;
    public ur rocket_engine_item_hidden;
    @Deprecated
    public ur solar_turbine_item;
    public ur silver_ore_item;
    public ur silver_block_item;
    public ur lead_block_item;
    public ur dark_iron_block_item;
    public ur exoworkshop_item;
    public ur is_factory;
    public ur is_lamp;
    public ur is_lightair;
    public ItemCraft item_craft;
    public ItemBagOfHolding bag_of_holding;
    public ItemPocketTable pocket_table;
    public ItemWandOfCooling wand_of_cooling;
    public ItemCraftingComponent diamond_shard;
    public wp diamond_shard_recipe;
    public ur diamond_shard_packet;
    public wp boh_upgrade_recipe;
    public ItemWrathIgniter wrath_igniter;
    public ItemCraftingComponent silver_ingot;
    public ItemCraftingComponent lead_ingot;
    public ItemCraftingComponent dark_iron;
    public ItemCraftingComponent exo_chasis;
    public ExoArmor exo_head;
    public ExoArmor exo_chest;
    public ExoArmor exo_leg;
    public ExoArmor exo_foot;
    public ExoBuoyantBarrel exo_buoyant_barrel;
    public ExoCobblestoneDrive exo_cobble_drive;
    public ExoMountedPiston exo_mounted_piston;
    public ExoWallJump exo_wall_jump;
    public ItemMachineUpgrade router_item_filter;
    public ItemMachineUpgrade router_machine_filter;
    public ItemMachineUpgrade router_speed;
    public ItemMachineUpgrade router_thorough;
    public ItemMachineUpgrade router_throughput;
    public ItemMachineUpgrade router_eject;
    public ItemMachineUpgrade barrel_enlarge;
    public ur fake_is;
    public ItemCraftingComponent acid;
    public ItemCraftingComponent magnet;
    public ItemCraftingComponent insulated_coil;
    public ItemCraftingComponent motor;
    public ItemCraftingComponent fan;
    public ItemCraftingComponent diamond_cutting_head;
    public ur sulfuric_acid;
    public ur aqua_regia;
    public ItemChargeMeter charge_meter;
    public ItemMirror mirror;
    public ItemBattery battery;
    public ItemOreProcessing ore_dirty_gravel;
    public ItemOreProcessing ore_clean_gravel;
    public ItemOreProcessing ore_reduced;
    public ItemOreProcessing ore_crystal;
    public ItemCraftingComponent sludge;
    public ItemCraftingComponent inverium;
    public ItemSculptingTool sculpt_tool;
    public ItemAngularSaw angular_saw;
    public ItemCraftingComponent heatHole;
    public ItemCraftingComponent logicMatrix;
    public ItemCraftingComponent logicMatrixIdentifier;
    public ItemCraftingComponent logicMatrixProgrammer;
    public up fz_steam;
    public ItemCraftingComponent nether_powder;
    public ItemCraftingComponent rocket_fuel;
    public ItemCraftingComponent rocket_fuel_liquid_entry;
    public ItemBlockProxy rocket_engine;
    public LiquidStack liquidStackRocketFuel;
    public ItemCraftingComponent bucket_rocket_fuel;
    public agi materialMachine = new agi(agk.h);
    aby silverGen;
    HashSet added_ids = new HashSet();
    private EnumSet serverTicks = EnumSet.of(TickType.SERVER);

    void makeBlocks() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.factory_rendering_block = new BlockFactorization(Core.factory_block_id);
            amq.p[this.factory_rendering_block.cm] = null;
        }
        this.factory_block = new BlockFactorization(Core.factory_block_id);
        this.lightair_block = new BlockLightAir(Core.lightair_id);
        this.resource_block = new BlockResource(Core.resource_id);
        this.is_factory = new ur((amq)this.factory_block);
        this.is_lightair = new ur((amq)this.lightair_block);
        GameRegistry.registerBlock((amq)this.factory_block, ItemFactorization.class, (String)"FZ factory");
        GameRegistry.registerBlock((amq)this.lightair_block, (String)"FZ Lightair");
        GameRegistry.registerBlock((amq)this.resource_block, ItemBlockResource.class, (String)"FZ resource");
        GameRegistry.registerCraftingHandler((ICraftingHandler)this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this);
        Core.tab((amq)this.factory_block, Core.TabType.MATERIALS);
    }

    void registerSimpleTileEntities() {
        FactoryType.registerTileEntities();
        GameRegistry.registerTileEntity(TileEntityFzNull.class, (String)"fz.null");
        EntityRegistry.registerGlobalEntityID(TileEntityWrathLamp.RelightTask.class, (String)"factory_relight_task", (int)Core.entity_relight_task_id);
    }

    private void addName(Object what, String name2) {
        Core.proxy.addName(what, name2);
    }

    public int itemID(String name2, int default_id) {
        int id = Integer.parseInt(Core.config.getItem((String)"item", (String)name2, (int)default_id).value);
        if (this.added_ids.contains(default_id)) {
            throw new RuntimeException("Default ID already used: " + default_id);
        }
        if (up.e[id] != null) {
            throw new RuntimeException("Item ID conflict: " + id + " is already taken by " + up.e[id] + "; tried to use it for Factorization " + name2);
        }
        this.added_ids.add(default_id);
        return id;
    }

    void makeItems() {
        this.ore_dirty_gravel = new ItemOreProcessing(this.itemID("oreDirtyGravel", 9034), 36, "dirtyGravel");
        this.ore_clean_gravel = new ItemOreProcessing(this.itemID("oreCleanGravel", 9035), 37, "cleanGravel");
        this.ore_reduced = new ItemOreProcessing(this.itemID("oreReduced", 9036), 38, "reduced");
        this.ore_crystal = new ItemOreProcessing(this.itemID("oreCrystal", 9037), 39, "crystal");
        this.ore_dirty_gravel.addEnglishNames("Dirty ", " Gravel");
        this.ore_clean_gravel.addEnglishNames("Clean ", " Chunks");
        this.ore_reduced.addEnglishNames("Reduced ", " Chunks");
        this.ore_crystal.addEnglishNames("Crystalline ", "");
        this.sludge = new ItemCraftingComponent(this.itemID("sludge", 9039), "item.sludge", 40);
        this.addName((Object)this.sludge, "Sludge");
        OreDictionary.registerOre((String)"FZ.sludge", (up)this.sludge);
        this.item_factorization = (ItemFactorization)up.e[this.factory_block.cm];
        this.item_resource = (ItemBlockResource)up.e[this.resource_block.cm];
        Core.tab(this.resource_block, Core.TabType.MATERIALS);
        this.router_item = FactoryType.ROUTER.itemStack("Router");
        this.barrel_item = FactoryType.BARREL.itemStack("Barrel");
        this.maker_item = FactoryType.MAKER.itemStack("Craftpacket Maker");
        this.stamper_item = FactoryType.STAMPER.itemStack("Craftpacket Stamper");
        this.lamp_item = FactoryType.LAMP.itemStack("Wrathlamp");
        this.packager_item = FactoryType.PACKAGER.itemStack("Packager");
        this.slagfurnace_item = FactoryType.SLAGFURNACE.itemStack("Slag Furnace");
        this.battery_item_hidden = FactoryType.BATTERY.itemStack("Battery Block");
        this.solar_turbine_item = FactoryType.SOLARTURBINE.itemStack("Solar Turbine");
        this.steamturbine_item = FactoryType.STEAMTURBINE.itemStack("Steam Turbine");
        this.solarboiler_item = FactoryType.SOLARBOILER.itemStack("Solar Boiler");
        this.heater_item = FactoryType.HEATER.itemStack("Furnace Heater");
        this.mirror_item_hidden = FactoryType.MIRROR.itemStack("Reflective Mirror");
        this.leadwire_item = FactoryType.LEADWIRE.itemStack("Lead Wire");
        this.grinder_item = FactoryType.GRINDER.itemStack("Grinder");
        this.mixer_item = FactoryType.MIXER.itemStack("Mixer");
        this.crystallizer_item = FactoryType.CRYSTALLIZER.itemStack("Crystallizer");
        this.greenware_item = FactoryType.GREENWARE.itemStack("Clay Sculpture");
        this.rocket_engine_item_hidden = FactoryType.ROCKETENGINE.itemStack("Rocket Engine");
        this.silver_ore_item = ResourceType.SILVERORE.itemStack("Silver Ore");
        this.silver_block_item = ResourceType.SILVERBLOCK.itemStack("Block of Silver");
        this.lead_block_item = ResourceType.LEADBLOCK.itemStack("Block of Lead");
        this.dark_iron_block_item = ResourceType.DARKIRONBLOCK.itemStack("Block of Dark Iron");
        this.exoworkshop_item = ResourceType.EXOMODDER.itemStack("Exo-Modder");
        this.lead_ingot = new ItemCraftingComponent(this.itemID("leadIngot", 9014), "Lead Ingot", 51);
        this.silver_ingot = new ItemCraftingComponent(this.itemID("silverIngot", 9015), "Silver Ingot", 52);
        OreDictionary.registerOre((String)"oreSilver", (ur)this.silver_ore_item);
        OreDictionary.registerOre((String)"ingotSilver", (ur)new ur((up)this.silver_ingot));
        OreDictionary.registerOre((String)"ingotLead", (ur)new ur((up)this.lead_ingot));
        OreDictionary.registerOre((String)"blockSilver", (ur)this.silver_block_item);
        OreDictionary.registerOre((String)"blockLead", (ur)this.lead_block_item);
        this.addName((Object)this.lead_ingot, "Lead Ingot");
        this.addName((Object)this.silver_ingot, "Silver Ingot");
        this.diamond_shard = new ItemCraftingComponent(this.itemID("diamondShard", 9006), "item.diamondshard", 48);
        this.addName((Object)this.diamond_shard, "Diamond Shard");
        OreDictionary.registerOre((String)"FZ.diamondShard", (up)this.diamond_shard);
        this.wrath_igniter = new ItemWrathIgniter(this.itemID("wrathIgniter", 9007));
        this.addName((Object)this.wrath_igniter, "Wrath Igniter");
        this.dark_iron = new ItemCraftingComponent(this.itemID("darkIron", 9008), "item.darkiron", 50);
        this.addName((Object)this.dark_iron, "Dark Iron Ingot");
        OreDictionary.registerOre((String)"FZ.darkIron", (up)this.dark_iron);
        this.bag_of_holding = new ItemBagOfHolding(this.itemID("bagOfHolding", 9001));
        this.addName(this.bag_of_holding, "Bag of Holding");
        this.logicMatrixProgrammer = new ItemMatrixProgrammer(this.itemID("logicMatrixProgrammer", 9043), "Logic Matrix Programmer", 22);
        DungeonHooks.addDungeonLoot((ur)new ur((up)this.logicMatrixProgrammer), (int)50);
        this.logicMatrix = new ItemCraftingComponent(this.itemID("logicMatrix", 9044), "Logic Matrix", 26);
        this.logicMatrixIdentifier = new ItemCraftingComponent(this.itemID("logicMatrixID", 9045), "Logic Matrix: Identifier", 27);
        this.heatHole = new ItemCraftingComponent(this.itemID("heatHole", 9046), "Heat Hole", 25);
        this.wand_of_cooling = new ItemWandOfCooling(this.itemID("wandOfCooling", 9005));
        this.addName((Object)this.wand_of_cooling, "Wand of Cooling");
        this.router_item_filter = new ItemMachineUpgrade(this.itemID("routerItemFilter", 9016), "Item Filter", "Router Upgrade", FactoryType.ROUTER, 0);
        this.router_machine_filter = new ItemMachineUpgrade(this.itemID("routerMachineFilter", 9017), "Machine Filter", "Router Upgrade", FactoryType.ROUTER, 1);
        this.router_speed = new ItemMachineUpgrade(this.itemID("routerSpeed", 9018), "Speed Boost", "Router Upgrade", FactoryType.ROUTER, 2);
        this.router_thorough = new ItemMachineUpgrade(this.itemID("routerThorough", 9019), "Thoroughness", "Router Upgrade", FactoryType.ROUTER, 3);
        this.router_throughput = new ItemMachineUpgrade(this.itemID("routerThroughput", 9020), "Bandwidth", "Router Upgrade", FactoryType.ROUTER, 4);
        this.router_eject = new ItemMachineUpgrade(this.itemID("routerEject", 9031), "Ejector", "Router Upgrade", FactoryType.ROUTER, 5);
        this.barrel_enlarge = new ItemMachineUpgrade(this.itemID("barrelEnlarge", 9032), "Extra-Dimensional Storage", "Barrel Upgrade", FactoryType.BARREL, 6);
        this.acid = new ItemAcidBottle(this.itemID("acid", 9024), "Sulfuric Acid", 53);
        this.sulfuric_acid = new ur((up)this.acid, 1);
        this.aqua_regia = new ur((up)this.acid, 1, 1);
        this.addName(this.acid.d(this.aqua_regia), "Aqua Regia");
        OreDictionary.registerOre((String)"sulfuricAcid", (ur)this.sulfuric_acid);
        OreDictionary.registerOre((String)"aquaRegia", (ur)this.aqua_regia);
        this.magnet = new ItemCraftingComponent(this.itemID("magnet", 9025), "Magnet", 54);
        this.insulated_coil = new ItemCraftingComponent(this.itemID("coil", 9026), "Insulated Coil", 55);
        this.motor = new ItemCraftingComponent(this.itemID("motor", 9027), "Motor", 56);
        this.fan = new ItemCraftingComponent(this.itemID("fan", 9028), "Fan", 57);
        this.diamond_cutting_head = new ItemCraftingComponent(this.itemID("diamondCuttingHead", 9038), "Diamond Cutting Head", 58);
        this.charge_meter = new ItemChargeMeter(this.itemID("chargemeter", 9029));
        this.addName((Object)this.charge_meter, "Charge Meter");
        this.mirror = new ItemMirror(this.itemID("mirror", 9030));
        this.addName((Object)this.mirror, "Reflective Mirror");
        this.battery = new ItemBattery(this.itemID("battery", 9033));
        this.addName(this.battery, "Battery Block");
        this.item_craft = new ItemCraft(this.itemID("itemCraftId", 9000));
        this.addName((Object)this.item_craft, "Craftpacket");
        this.exo_head = new ExoArmor(this.itemID("mechaHead", 9010), 0).setSlotCount(5);
        this.exo_chest = new ExoArmor(this.itemID("mechaChest", 9011), 1).setSlotCount(8);
        this.exo_leg = new ExoArmor(this.itemID("mechaLeg", 9012), 2).setSlotCount(7);
        this.exo_foot = new ExoArmor(this.itemID("mechaFoot", 9013), 3).setSlotCount(4);
        this.exo_chasis = new ItemCraftingComponent(this.itemID("mechaChasis", 9009), "item.exochasis", 5);
        this.addName((Object)this.exo_chasis, "Exo-Chassis");
        this.addName((Object)this.exo_head, "Exo-Helmet");
        this.addName((Object)this.exo_chest, "Exo-Chestplate");
        this.addName((Object)this.exo_leg, "Exo-Leggings");
        this.addName((Object)this.exo_foot, "Exo-Boots");
        this.exo_buoyant_barrel = new ExoBuoyantBarrel(this.itemID("mechaBouyantBarrel", 9021));
        this.exo_cobble_drive = new ExoCobblestoneDrive(this.itemID("mechaCobbleDrive", 9022));
        this.exo_mounted_piston = new ExoMountedPiston(this.itemID("mechaMountedPiston", 9023));
        this.exo_wall_jump = new ExoWallJump(this.itemID("mechaSpring", 9047));
        this.addName(this.exo_buoyant_barrel, "Buoyant Barrel");
        this.addName(this.exo_cobble_drive, "Cobblestone Drive");
        this.addName(this.exo_mounted_piston, "Shoulder-Mounted Piston");
        this.addName(this.exo_wall_jump, "Wall Jumping Boots");
        this.angular_saw = new ItemAngularSaw(this.itemID("angularSaw", 9042));
        this.addName((Object)this.angular_saw, "Angular Saw");
        MinecraftForge.setToolClass((up)this.angular_saw, (String)"pickaxe", (int)3);
        this.sculpt_tool = new ItemSculptingTool(this.itemID("sculptTool", 9041));
        this.addName((Object)this.sculpt_tool, "Sculpting Tool");
        this.inverium = new ItemInverium(this.itemID("inverium", 9040), "item.inverium", 192, 1);
        this.addName((Object)this.inverium, "Inverium Drop");
        OreDictionary.registerOre((String)"FZ.inverium", (up)this.inverium);
        this.pocket_table = new ItemPocketTable(this.itemID("pocketCraftingTable", 9002));
        this.addName((Object)this.pocket_table, "Pocket Crafting Table");
        this.fz_steam = new up(this.itemID("steam", 9049));
        this.fz_steam.setTextureFile("/factorization/texture/blocks.png");
        this.fz_steam.c(52);
        this.fz_steam.b("steam");
        this.addName(this.fz_steam, "Steam");
        this.nether_powder = new ItemCraftingComponent(this.itemID("netherPowder", 9050), "Netherrack Powder", 41);
        if (Core.enable_dimension_slice) {
            this.rocket_fuel = new ItemCraftingComponent(this.itemID("heldRocketFuel", 9051), "Rocket Fuel", 42);
            this.rocket_fuel_liquid_entry = new ItemCraftingComponent(this.itemID("liquidRocketFuel", 9052), "Rocket Fuel", 36);
            this.rocket_fuel_liquid_entry.setTextureFile("/factorization/texture/blocks.png");
            this.rocket_engine = (ItemBlockProxy)new ItemBlockProxy(this.itemID("rocketEngine", 9053), this.rocket_engine_item_hidden).setTextureFile("/factorization/texture/items.png").b(7, 0).b("rocketEngine").d(1);
            this.addName((Object)this.rocket_engine, "Rocket Engine");
            this.bucket_rocket_fuel = new ItemCraftingComponent(this.itemID("bucketRocketFuel", 9054), "Bucket of Rocket Fuel", 43);
            this.bucket_rocket_fuel.d(1);
            this.bucket_rocket_fuel.a(up.aw);
        }
    }

    void recipe(ur res, Object ... params) {
        GameRegistry.addRecipe((ur)res, (Object[])params);
    }

    void shapelessRecipe(ur res, Object ... params) {
        GameRegistry.addShapelessRecipe((ur)res, (Object[])params);
    }

    void oreRecipe(ur res, Object ... params) {
        ShapedOreRecipe rec = new ShapedOreRecipe(res, params);
        wn.a().b().add(rec);
    }

    void shapelessOreRecipe(ur res, Object ... params) {
        ShapelessOreRecipe rec = new ShapelessOreRecipe(res, params);
        wn.a().b().add(rec);
    }

    void makeRecipes() {
        this.recipe(new ur((amq)amq.am), "-", "-", Character.valueOf('-'), new ur((amq)amq.an, 1));
        this.shapelessRecipe(new ur((up)this.dark_iron, 4), this.dark_iron_block_item);
        this.recipe(this.dark_iron_block_item, new Object[]{"II", "II", Character.valueOf('I'), this.dark_iron});
        ur BOH = new ur((up)this.bag_of_holding, 1);
        this.recipe(BOH, new Object[]{"LOL", "ILI", " I ", Character.valueOf('I'), this.dark_iron, Character.valueOf('O'), up.bn, Character.valueOf('L'), up.aF});
        this.shapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, up.bn, up.aF});
        this.boh_upgrade_recipe = FactorizationUtil.createShapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, up.bn, up.aF});
        this.recipe(new ur((up)this.pocket_table), " #", "| ", Character.valueOf('#'), amq.aB, Character.valueOf('|'), up.D);
        this.recipe(new ur((up)this.logicMatrixIdentifier), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), up.bu, Character.valueOf('X'), this.logicMatrixProgrammer});
        this.recipe(new ur((up)this.logicMatrixProgrammer), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), this.dark_iron, Character.valueOf('X'), this.logicMatrixProgrammer});
        TileEntityCrystallizer.addRecipe(new ur(amq.w), new ur((up)this.logicMatrix), 1.0f, new ur((up)up.bs), 1);
        TileEntityCrystallizer.addRecipe(new ur(up.bx), new ur((up)this.heatHole), 1.0f, new ur((up)up.bs), 1);
        this.recipe(new ur((up)this.wand_of_cooling), new Object[]{" OD", " IO", "I  ", Character.valueOf('O'), amq.as, Character.valueOf('D'), this.heatHole, Character.valueOf('I'), up.o});
        this.diamond_shard_recipe = FactorizationUtil.createShapedRecipe(new ur((up)this.diamond_shard, 18), "OTO", "TDT", "OTO", Character.valueOf('O'), amq.as, Character.valueOf('T'), amq.ap, Character.valueOf('D'), amq.aA);
        ItemCraft.addStamperRecipe(this.diamond_shard_recipe);
        this.diamond_shard_packet = new ur((up)this.item_craft);
        this.diamond_shard_packet.b(255);
        for (int i : new int[]{0, 2, 6, 8}) {
            this.item_craft.addItem(this.diamond_shard_packet, i, new ur(amq.as), null);
        }
        for (int i : new int[]{1, 3, 5, 7}) {
            this.item_craft.addItem(this.diamond_shard_packet, i, new ur(amq.ap), null);
        }
        this.item_craft.addItem(this.diamond_shard_packet, 4, new ur(amq.aA), null);
        this.recipe(this.diamond_shard_packet, "OTO", "TDT", "OTO", Character.valueOf('O'), amq.as, Character.valueOf('T'), amq.ap, Character.valueOf('D'), amq.aA);
        this.recipe(new ur((up)this.wrath_igniter), new Object[]{"D ", " B", Character.valueOf('D'), this.diamond_shard, Character.valueOf('B'), amq.bD});
        this.recipe(new ur((up)this.lead_ingot, 9), "#", Character.valueOf('#'), this.lead_block_item);
        this.recipe(new ur((up)this.silver_ingot, 9), "#", Character.valueOf('#'), this.silver_block_item);
        this.oreRecipe(this.lead_block_item, "###", "###", "###", Character.valueOf('#'), "ingotLead");
        this.oreRecipe(this.silver_block_item, "###", "###", "###", Character.valueOf('#'), "ingotSilver");
        wj.a().addSmelting(this.resource_block.cm, 0, new ur((up)this.silver_ingot), 0.3f);
        this.recipe(new ur((up)this.exo_chasis), "III", "InI", "III", Character.valueOf('I'), up.o, Character.valueOf('n'), up.bq);
        this.recipe(new ur((up)this.exo_head), new Object[]{"###", "# #", Character.valueOf('#'), this.exo_chasis});
        this.recipe(new ur((up)this.exo_chest), new Object[]{"# #", "###", "###", Character.valueOf('#'), this.exo_chasis});
        this.recipe(new ur((up)this.exo_leg), new Object[]{"###", "# #", "# #", Character.valueOf('#'), this.exo_chasis});
        this.recipe(new ur((up)this.exo_foot), new Object[]{"# #", "# #", Character.valueOf('#'), this.exo_chasis});
        this.oreRecipe(new ur((up)this.exo_buoyant_barrel), "W_W", "PBP", "WVW", Character.valueOf('W'), "plankWood", Character.valueOf('_'), amq.aP, Character.valueOf('P'), amq.ac, Character.valueOf('B'), this.barrel_item, Character.valueOf('V'), up.aE);
        ur is_cobble_drive = new ur((up)this.exo_cobble_drive);
        this.recipe(is_cobble_drive, "OPO", "WTL", "OOO", Character.valueOf('O'), amq.as, Character.valueOf('P'), amq.ac, Character.valueOf('W'), up.ax, Character.valueOf('T'), up.g, Character.valueOf('L'), up.ay);
        this.recipe(is_cobble_drive, "OPO", "LTW", "OOO", Character.valueOf('O'), amq.as, Character.valueOf('P'), amq.ac, Character.valueOf('W'), up.ax, Character.valueOf('T'), up.g, Character.valueOf('L'), up.ay);
        this.recipe(new ur((up)this.exo_mounted_piston), "CNC", "LSL", "CCC", Character.valueOf('C'), amq.z, Character.valueOf('S'), amq.Y, Character.valueOf('N'), amq.ac, Character.valueOf('L'), amq.aM);
        this.oreRecipe(new ur((up)this.angular_saw), "O ", "MY", "! ", Character.valueOf('O'), new ur((up)this.diamond_cutting_head), Character.valueOf('M'), new ur((up)this.motor), Character.valueOf('Y'), new ur(up.o), Character.valueOf('!'), "ingotLead");
        this.recipe(new ur((up)this.exo_wall_jump), "ILI", "IBI", "OOO", Character.valueOf('I'), up.o, Character.valueOf('L'), up.aF, Character.valueOf('B'), up.Y, Character.valueOf('O'), up.aM);
        this.recipe(new ur((up)this.sculpt_tool), " c", "/ ", Character.valueOf('c'), up.aI, Character.valueOf('/'), up.D);
        ItemSculptingTool.addModeChangeRecipes();
        this.oreRecipe(new ur((up)this.inverium, 1, 1), "LGL", "GDG", "LGL", Character.valueOf('L'), "ingotLead", Character.valueOf('G'), up.p, Character.valueOf('D'), up.n);
        this.recipe(this.router_item, new Object[]{"MMM", "oIO", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), up.aP, Character.valueOf('o'), up.bn, Character.valueOf('O'), up.bA});
        this.recipe(this.router_item, new Object[]{"MMM", "OIo", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), up.aP, Character.valueOf('o'), up.bn, Character.valueOf('O'), up.bA});
        this.recipe(new ur((up)this.router_item_filter), new Object[]{"ITI", "GDG", "ICI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), amq.aT, Character.valueOf('D'), this.logicMatrixIdentifier, Character.valueOf('G'), up.p, Character.valueOf('C'), amq.ax});
        this.oreRecipe(new ur((up)this.router_machine_filter), new Object[]{"ITI", "SDS", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), amq.aT, Character.valueOf('D'), this.logicMatrixIdentifier, Character.valueOf('S'), "ingotSilver", Character.valueOf('B'), up.aL});
        this.recipe(new ur((up)this.router_speed), new Object[]{"ISI", "SCS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), up.aY, Character.valueOf('C'), up.aZ});
        this.recipe(new ur((up)this.router_thorough), new Object[]{"ISI", "SSS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), amq.bf});
        this.recipe(new ur((up)this.router_throughput), new Object[]{"IBI", "B!B", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('B'), up.bw, Character.valueOf('!'), up.aP});
        this.oreRecipe(new ur((up)this.router_eject), new Object[]{"IWI", "C_C", "IPI", Character.valueOf('I'), this.dark_iron, Character.valueOf('W'), "plankWood", Character.valueOf('C'), amq.z, Character.valueOf('_'), amq.aP, Character.valueOf('P'), amq.ac});
        this.recipe(new ur((up)this.barrel_enlarge), new Object[]{"IOI", "BWB", "ILI", Character.valueOf('I'), this.dark_iron, Character.valueOf('W'), this.barrel_item, Character.valueOf('O'), up.bn, Character.valueOf('B'), up.bo, Character.valueOf('L'), up.aF});
        this.oreRecipe(this.barrel_item, "W-W", "W W", "WWW", Character.valueOf('W'), "logWood", Character.valueOf('-'), "slabWood");
        this.recipe(this.maker_item, "#p#", "# #", "#C#", Character.valueOf('#'), amq.z, Character.valueOf('p'), amq.ac, Character.valueOf('C'), amq.aB);
        this.fake_is = this.maker_item;
        this.recipe(this.stamper_item, "#p#", "III", "#C#", Character.valueOf('#'), amq.z, Character.valueOf('p'), amq.ac, Character.valueOf('I'), up.o, Character.valueOf('C'), amq.aB);
        this.recipe(this.packager_item, "#M#", "# #", "#S#", Character.valueOf('#'), amq.z, Character.valueOf('M'), this.maker_item, Character.valueOf('S'), this.stamper_item);
        this.oreRecipe(this.lamp_item, new Object[]{"ISI", "GWG", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), "ingotSilver", Character.valueOf('G'), amq.bt, Character.valueOf('W'), new ur((up)this.wrath_igniter, 1, -1)});
        this.recipe(this.slagfurnace_item, "CFC", "C C", "CFC", Character.valueOf('C'), amq.z, Character.valueOf('F'), amq.aE);
        OreDictionary.registerOre((String)"oreIron", (ur)new ur(amq.K));
        OreDictionary.registerOre((String)"oreGold", (ur)new ur(amq.J));
        OreDictionary.registerOre((String)"ingotIron", (ur)new ur(up.o));
        OreDictionary.registerOre((String)"ingotGold", (ur)new ur(up.p));
        TileEntitySlagFurnace.SlagRecipes.register(amq.aQ, 5.8f, up.aC, 0.2f, amq.w);
        this.recipe(this.exoworkshop_item, new Object[]{"MCM", "i i", "i i", Character.valueOf('C'), amq.aB, Character.valueOf('M'), this.exo_chasis, Character.valueOf('i'), up.o});
        this.oreRecipe(this.greenware_item, "c", "-", Character.valueOf('c'), up.aI, Character.valueOf('-'), "slabWood");
        this.shapelessRecipe(this.sulfuric_acid, up.M, up.M, up.m, up.bs);
        this.shapelessOreRecipe(this.sulfuric_acid, "dustSulfur", up.m, up.bs);
        this.shapelessRecipe(this.aqua_regia, new Object[]{this.sulfuric_acid, this.nether_powder, up.bE});
        this.recipe(new ur((up)this.fan), "I I", " I ", "I I", Character.valueOf('I'), up.o);
        this.shapelessRecipe(new ur((up)this.motor), this.solar_turbine_item);
        this.recipe(this.solarboiler_item, "I#I", "I I", "III", Character.valueOf('I'), up.o, Character.valueOf('#'), amq.bs);
        this.oreRecipe(this.steamturbine_item, new Object[]{"I#I", "GXG", "LML", Character.valueOf('I'), up.o, Character.valueOf('#'), amq.bs, Character.valueOf('G'), amq.bt, Character.valueOf('X'), this.fan, Character.valueOf('L'), "ingotLead", Character.valueOf('M'), this.motor});
        this.oreRecipe(new ur((up)this.charge_meter), "WSW", "W/W", "LIL", Character.valueOf('W'), amq.A, Character.valueOf('S'), up.au, Character.valueOf('/'), up.D, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), up.o);
        this.oreRecipe(new ur((up)this.battery, 1, 2), new Object[]{"ILI", "LAL", "ILI", Character.valueOf('I'), up.o, Character.valueOf('L'), "ingotLead", Character.valueOf('A'), this.acid});
        for (int damage : new int[]{1, 2}) {
            this.recipe(new ur((up)this.magnet), "WWW", "WIW", "WBW", Character.valueOf('W'), this.leadwire_item, Character.valueOf('I'), up.o, Character.valueOf('B'), new ur((up)this.battery, 1, damage));
            this.recipe(new ur((up)this.battery, 1, damage - 1), "W", "B", "W", Character.valueOf('W'), this.leadwire_item, Character.valueOf('B'), new ur((up)this.battery, 1, damage));
        }
        this.oreRecipe(this.heater_item, new Object[]{"CCC", "L L", "CCC", Character.valueOf('C'), this.insulated_coil, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(new ur((up)this.insulated_coil), "LLL", "LCL", "LLL", Character.valueOf('L'), "ingotLead", Character.valueOf('C'), amq.aZ);
        this.oreRecipe(new ur((up)this.motor), new Object[]{"CIC", "CMC", "LIL", Character.valueOf('C'), this.insulated_coil, Character.valueOf('M'), this.magnet, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), up.o});
        this.oreRecipe(new ur((up)this.mirror), "SSS", "S#S", "SSS", Character.valueOf('S'), "ingotSilver", Character.valueOf('#'), amq.bt);
        ur with_8 = this.leadwire_item.l();
        with_8.a = 8;
        this.oreRecipe(with_8, "LLL", Character.valueOf('L'), "ingotLead");
        this.recipe(new ur((up)this.diamond_cutting_head), new Object[]{"SSS", "SIS", "SSS", Character.valueOf('S'), this.diamond_shard, Character.valueOf('I'), up.o});
        this.oreRecipe(this.grinder_item, new Object[]{"LIL", "I*I", "IMI", Character.valueOf('L'), "ingotLead", Character.valueOf('I'), up.o, Character.valueOf('*'), this.diamond_cutting_head, Character.valueOf('M'), this.motor});
        TileEntityGrinder.addRecipe(new ur(amq.w), new ur(amq.z), 1.0f);
        TileEntityGrinder.addRecipe(new ur(amq.z), new ur(amq.I), 1.0f);
        TileEntityGrinder.addRecipe(new ur(amq.I), new ur(amq.H), 1.0f);
        TileEntityGrinder.addRecipe(new ur((amq)amq.x), new ur(amq.y), 1.0f);
        TileEntityGrinder.addRecipe(new ur((amq)amq.bB), new ur(amq.y), 1.0f);
        TileEntityGrinder.addRecipe(new ur(amq.az), new ur(up.n), 2.25f);
        TileEntityGrinder.addRecipe(new ur(amq.bU), new ur(up.bH), 2.25f);
        TileEntityGrinder.addRecipe(new ur(amq.aQ), new ur(up.aC), 6.5f);
        TileEntityGrinder.addRecipe(new ur(amq.Q), new ur(up.aW, 1, 4), 8.0f);
        TileEntityGrinder.addRecipe(new ur(amq.L), new ur(up.m), 3.5f);
        this.oreRecipe(this.mixer_item, new Object[]{" X ", "WMW", "LUL", Character.valueOf('X'), this.fan, Character.valueOf('W'), up.ax, Character.valueOf('M'), this.motor, Character.valueOf('L'), "ingotLead", Character.valueOf('U'), up.bz});
        wj.a().addSmelting(this.sludge.cj, 0, new ur(up.aI), 0.1f);
        this.recipe(this.crystallizer_item, "-", "S", "U", Character.valueOf('-'), up.D, Character.valueOf('S'), up.K, Character.valueOf('U'), up.bz);
        ur lime = new ur(up.aW, 1, 10);
        TileEntityCrystallizer.addRecipe(lime, new ur(up.aM), 1.0f, new ur(up.aG), 0);
        TileEntityGrinder.addRecipe(new ur(amq.be), new ur((up)this.nether_powder, 1), 1.0f);
        if (Core.enable_dimension_slice) {
            this.shapelessRecipe(new ur((up)this.rocket_fuel, 3), new Object[]{this.nether_powder, this.nether_powder, this.nether_powder, up.bE});
            this.liquidStackRocketFuel = new LiquidStack((up)this.rocket_fuel_liquid_entry, 0);
            LiquidDictionary.getOrCreateLiquid((String)"powderRocketFuel", (LiquidStack)this.liquidStackRocketFuel);
            this.recipe(new ur((up)this.rocket_engine), new Object[]{"#F#", "#I#", "I I", Character.valueOf('#'), amq.al, Character.valueOf('F'), this.rocket_fuel, Character.valueOf('I'), up.o});
            this.shapelessRecipe(new ur((up)this.bucket_rocket_fuel), new Object[]{up.aw, this.rocket_fuel, this.rocket_fuel});
            ur air = new ur(up.aw, 0);
            ur emptyBucket = new ur(up.aw, 1);
            LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(new LiquidStack((up)this.rocket_fuel_liquid_entry, 500), new ur((up)this.rocket_fuel, 1), air));
            LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(new LiquidStack((up)this.rocket_fuel_liquid_entry, 1000), new ur((up)this.bucket_rocket_fuel, 1), emptyBucket));
        }
    }

    public void setToolEffectiveness() {
        for (String tool : new String[]{"pickaxe", "axe", "shovel"}) {
            MinecraftForge.removeBlockEffectiveness((amq)this.factory_block, (String)tool);
            MinecraftForge.removeBlockEffectiveness((amq)this.resource_block, (String)tool);
        }
        BlockClass.DarkIron.harvest("pickaxe", 2);
        BlockClass.Barrel.harvest("axe", 1);
        BlockClass.Machine.harvest("pickaxe", 0);
        BlockClass.MachineLightable.harvest("pickaxe", 0);
        BlockClass.Cage.harvest("pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel((amq)this.resource_block, (String)"pickaxe", (int)2);
    }

    public void makeOther() {
        this.silverGen = new aby(this.resource_block.cm, Core.silver_ore_node_size);
    }

    public void generate(Random rand, int chunkX, int chunkZ, yc world, zw chunkGenerator, zw chunkProvider) {
        if (!Core.gen_silver_ore) {
            return;
        }
        if ((chunkZ + 3 * chunkX) % 5 != 0) {
            return;
        }
        int x = chunkX * 16 + rand.nextInt(16);
        int z = chunkZ * 16 + rand.nextInt(16);
        int y2 = 5 + rand.nextInt(48);
        this.silverGen.a(world, rand, x, y2, z);
    }

    public void onTickServer() {
        TileEntityWrathLamp.handleAirUpdates();
        TileEntityWrathFire.updateCount = 0;
    }

    public boolean extractEnergy(qx player, int chargeCount) {
        ur is;
        int i;
        qw inv = player.bJ;
        int totalCharge = 0;
        for (i = 0; i < inv.k_(); ++i) {
            is = inv.a(i);
            if (is == null || is.b() != this.battery) continue;
            totalCharge += this.battery.getStorage(is);
        }
        if (totalCharge < chargeCount) {
            return false;
        }
        for (i = 0; i < inv.k_(); ++i) {
            is = inv.a(i);
            if (is == null || is.b() != this.battery) continue;
            int storage = this.battery.getStorage(is);
            int delta = Math.min(chargeCount, storage);
            storage -= delta;
            chargeCount -= delta;
            if (delta > 0) {
                this.battery.setStorage(is, storage);
            }
            if (chargeCount > 0) continue;
            return true;
        }
        return false;
    }

    @ForgeSubscribe
    public boolean onItemPickup(EntityItemPickupEvent event) {
        qx player = event.entityPlayer;
        px item2 = event.item;
        ur is = item2.d();
        if (item2 == null || is == null || is.a == 0) {
            return true;
        }
        if (player.L) {
            return true;
        }
        qw inv = player.bJ;
        int remaining_size = is.a;
        int free_slots = 0;
        for (int i = 0; i < inv.k_(); ++i) {
            int free;
            ur here = inv.a(i);
            if (here == null) {
                ++free_slots;
                continue;
            }
            if (FactorizationUtil.identical(is, here) && (remaining_size -= (free = here.d() - here.a)) <= 0) break;
        }
        if (remaining_size > 0) {
            ArrayList<ur> bags = new ArrayList<ur>();
            for (int i = 0; i < inv.k_(); ++i) {
                ur here = inv.a(i);
                if (here == null || here.b() != this.bag_of_holding) continue;
                bags.add(here);
            }
            boolean success = false;
            for (ur bag : bags) {
                if (is.a < 0) break;
                success = this.bag_of_holding.insertItem(bag, is);
            }
            if (success) {
                Sound.bagSlurp.playAt((lq)player);
            }
        }
        Core.proxy.pokePocketCrafting();
        return true;
    }

    public void onCrafting(qx player, ur stack, la craftMatrix) {
        for (int i = 0; i < craftMatrix.k_(); ++i) {
            up item2;
            ur here = craftMatrix.a(i);
            if (here == null || !((item2 = here.b()) instanceof IActOnCraft)) continue;
            ((IActOnCraft)item2).onCraft(here, craftMatrix, i, stack, player);
        }
        if (stack.b() == this.item_craft && stack.j() == this.diamond_shard_packet.j()) {
            stack.d((bq)this.diamond_shard_packet.p().b());
            stack.b(1);
        }
    }

    public void onSmelting(qx player, ur item2) {
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        this.onTickServer();
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return this.serverTicks;
    }

    public String getLabel() {
        return "FZ_registry";
    }
}

