/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.VectorUV;
import factorization.common.Command;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.Sound;
import factorization.common.TileEntityBarrel;
import factorization.common.TileEntityCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IllegalFormatException;

public class NetworkFactorization
implements ITinyPacketHandler {
    protected static final short factorizeTEChannel = 0;
    protected static final short factorizeMsgChannel = 1;
    protected static final short factorizeCmdChannel = 2;
    protected static final short factorizeNtfyChannel = 3;
    int huge_tag_warnings = 0;
    private double maxBroadcastDistSq = 2.0 * Math.pow(64.0, 2.0);
    private static final ThreadLocal currentPlayer = new ThreadLocal();

    public NetworkFactorization() {
        Core.network = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ef TEmessagePacket(Coord src, int messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeInt(src.x);
            output.writeInt(src.y);
            output.writeInt(src.z);
            output.writeShort(messageType);
            Object[] arr$ = items;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) {
                    output.flush();
                    return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)0, (byte[])outputStream.toByteArray());
                }
                Object item2 = arr$[i$];
                if (item2 == null) {
                    throw new RuntimeException("Argument is null!");
                }
                if (item2 instanceof Integer) {
                    output.writeInt((Integer)item2);
                } else if (item2 instanceof Byte) {
                    output.writeByte(((Byte)item2).byteValue());
                } else if (item2 instanceof String) {
                    output.writeUTF((String)item2);
                } else if (item2 instanceof Boolean) {
                    output.writeBoolean((Boolean)item2);
                } else if (item2 instanceof Float) {
                    output.writeFloat(((Float)item2).floatValue());
                } else if (item2 instanceof ur) {
                    ur is = (ur)item2;
                    bq tag = new bq();
                    is.b(tag);
                    bq.a((cd)tag, (DataOutput)output);
                    if (outputStream.size() > 65536 && is.o()) {
                        if (this.huge_tag_warnings++ < 10) {
                            Core.logWarning("Item " + is + " probably has a huge NBT tag; it will be stripped from the packet; at " + src, new Object[0]);
                            if (this.huge_tag_warnings == 10) {
                                Core.logWarning("(This will no longer be logged)", new Object[0]);
                            }
                        }
                        bq tag_copy = is.p();
                        is.d(null);
                        try {
                            ef ef2 = this.TEmessagePacket(src, messageType, items);
                            return ef2;
                        }
                        finally {
                            is.d(tag_copy);
                        }
                    }
                } else if (item2 instanceof VectorUV) {
                    VectorUV v = (VectorUV)item2;
                    output.writeFloat(v.x);
                    output.writeFloat(v.y);
                    output.writeFloat(v.z);
                } else {
                    if (!(item2 instanceof DeltaCoord)) throw new RuntimeException("Argument is not Integer/Byte/String/Boolean/Float/ItemStack/DeltaCoord/RenderingCube.Vector: " + item2);
                    DeltaCoord dc = (DeltaCoord)item2;
                    dc.write(output);
                }
                ++i$;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ef translatePacket(String ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            for (String i : items) {
                output.writeUTF(i);
            }
            output.flush();
            return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)1, (byte[])outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ef notifyPacket(Coord where, String format, String ... args) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeInt(where.x);
            output.writeInt(where.y);
            output.writeInt(where.z);
            output.writeUTF(format);
            output.writeInt(args.length);
            for (String a : args) {
                output.writeUTF(a);
            }
            output.flush();
            new PacketDispatcher();
            return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)3, (byte[])outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendCommand(qx player, Command cmd, byte arg) {
        byte[] data = new byte[]{cmd.id, arg};
        cz packet = PacketDispatcher.getTinyPacket((Object)Core.instance, (short)2, (byte[])data);
        Core.proxy.addPacket(player, (ef)packet);
    }

    public void broadcastMessage(qx who, Coord src, int messageType, Object ... msg) {
        ef toSend = this.TEmessagePacket(src, messageType, msg);
        if (who == null || !who.p.I) {
            this.broadcastPacket(who, src, toSend);
        } else {
            Core.proxy.addPacket(who, toSend);
        }
    }

    public void broadcastPacket(qx who, Coord src, ef toSend) {
        if (src.w == null) {
            new NullPointerException("Coord is null").printStackTrace();
            return;
        }
        if (who == null) {
            zz srcChunk = src.getChunk();
            for (qx player : src.w.h) {
                double x = (double)src.x - player.t;
                double z = (double)src.z - player.v;
                if (x * x + z * z > this.maxBroadcastDistSq || !Core.proxy.playerListensToCoord(player, src)) continue;
                Core.proxy.addPacket(player, toSend);
            }
        } else {
            Core.proxy.addPacket(who, toSend);
        }
    }

    qx getCurrentPlayer() {
        qx ret = (qx)currentPlayer.get();
        if (ret == null) {
            throw new NullPointerException("currentPlayer wasn't set");
        }
        return ret;
    }

    public void handle(eg handler, cz mapData) {
        this.handlePacketData(handler, mapData.b, mapData.c, handler.getPlayer());
    }

    void handlePacketData(eg handler, int channel, byte[] data, qx me) {
        currentPlayer.set(me);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(inputStream);
        switch (channel) {
            case 0: {
                this.handleTE(input);
                break;
            }
            case 1: {
                this.handleMsg(input);
                break;
            }
            case 2: {
                this.handleCmd(data);
                break;
            }
            case 3: {
                this.handleNtfy(input);
                break;
            }
            default: {
                Core.logWarning("Got packet with invalid channel %i with player = %s ", channel, me);
            }
        }
        currentPlayer.set(null);
    }

    void handleTE(DataInputStream input) {
        try {
            yc world = this.getCurrentPlayer().p;
            int x = input.readInt();
            int y2 = input.readInt();
            int z = input.readInt();
            int messageType = input.readShort();
            Coord here = new Coord(world, x, y2, z);
            if (Core.debug_network) {
                System.out.println("FactorNet: " + messageType + "      " + here);
            }
            if (!here.blockExists() && world.I) {
                return;
            }
            if (messageType == 2 && !world.I) {
                TileEntityCommon tec = (TileEntityCommon)here.getTE(TileEntityCommon.class);
                if (tec != null) {
                    this.broadcastPacket(this.getCurrentPlayer(), here, tec.l());
                }
                return;
            }
            if (messageType == 1 && world.I) {
                FactoryType ft = FactoryType.fromMd(input.readInt());
                byte extraData = input.readByte();
                byte extraData2 = input.readByte();
                try {
                    messageType = input.readInt();
                }
                catch (IOException e) {
                    messageType = -1;
                }
                TileEntityCommon spawn = (TileEntityCommon)here.getTE(TileEntityCommon.class);
                if (spawn != null && spawn.getFactoryType() != ft) {
                    world.r(x, y2, z);
                    spawn = null;
                }
                if (spawn == null) {
                    spawn = ft.makeTileEntity();
                    spawn.k = world;
                    world.a(x, y2, z, (any)spawn);
                }
                if (spawn != null) {
                    spawn.useExtraInfo(extraData);
                    spawn.useExtraInfo2(extraData2);
                }
            }
            if (messageType == -1) {
                return;
            }
            TileEntityCommon tec = (TileEntityCommon)here.getTE(TileEntityCommon.class);
            if (tec == null) {
                this.handleForeignMessage(world, x, y2, z, tec, messageType, input);
                return;
            }
            boolean handled = here.w.I ? tec.handleMessageFromServer(messageType, input) : tec.handleMessageFromClient(messageType, input);
            if (!handled) {
                this.handleForeignMessage(world, x, y2, z, tec, messageType, input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handleMsg(DataInputStream input) {
        String main;
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        try {
            main = input.readUTF();
        }
        catch (IOException e1) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        try {
            while (true) {
                String orig = input.readUTF();
                String name2 = orig + ".name";
                String transd = bn.a().b(name2);
                if (transd.compareTo(name2) == 0) {
                    items.add(orig);
                    continue;
                }
                items.add(transd);
            }
        }
        catch (IOException e) {
            try {
                this.getCurrentPlayer().b(String.format(main, items.toArray()));
            }
            catch (IllegalFormatException e2) {
                System.out.print("Illegal format: \"" + main + '\"');
                for (String i : items) {
                    System.out.print(" \"" + i + "\"");
                }
                System.out.println();
                e2.printStackTrace();
            }
            return;
        }
    }

    void handleForeignMessage(yc world, int x, int y2, int z, any ent, int messageType, DataInput input) throws IOException {
        if (world.I) {
            Coord here = new Coord(world, x, y2, z);
            switch (messageType) {
                case 11: {
                    Sound.receive(input);
                    break;
                }
                case 12: {
                    amq.ac.b(world, x, y2, z, 0, input.readInt());
                    here.setId(0);
                    break;
                }
                case 43: {
                    TileEntityBarrel.spawnBreakParticles(here, input.readInt());
                    break;
                }
                default: {
                    if (world.f(x, y2, z)) {
                        Core.logFine("Got unhandled message: " + messageType + " for " + here, new Object[0]);
                        break;
                    }
                    Core.logFine("Got message to unloaded chunk: " + messageType + " for " + here, new Object[0]);
                }
            }
        }
    }

    void handleCmd(byte[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        byte s2 = data[0];
        byte arg = data[1];
        Command.fromNetwork(this.getCurrentPlayer(), s2, arg);
    }

    void handleNtfy(DataInputStream input) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            qx me = this.getCurrentPlayer();
            if (!me.p.I) {
                return;
            }
            try {
                int x = input.readInt();
                int y2 = input.readInt();
                int z = input.readInt();
                String msg = input.readUTF();
                int argCount = input.readInt();
                String[] args = new String[argCount];
                for (int i = 0; i < argCount; ++i) {
                    args[i] = input.readUTF();
                }
                Core.notify(me, new Coord(me.p, x, y2, z), msg, args);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class MessageType {
        public static final int ShareAll = -1;
        public static final int PlaySound = 11;
        public static final int PistonPush = 12;
        public static final int DrawActive = 0;
        public static final int FactoryType = 1;
        public static final int DescriptionRequest = 2;
        public static final int MakerTarget = 11;
        public static final int RouterSlot = 20;
        public static final int RouterTargetSide = 21;
        public static final int RouterMatch = 22;
        public static final int RouterIsInput = 23;
        public static final int RouterLastSeen = 24;
        public static final int RouterMatchToVisit = 25;
        public static final int RouterDowngrade = 26;
        public static final int RouterUpgradeState = 27;
        public static final int RouterEjectDirection = 28;
        public static final int BarrelDescription = 40;
        public static final int BarrelItem = 41;
        public static final int BarrelCount = 42;
        public static final int BarrelLoss = 43;
        public static final int BatteryLevel = 50;
        public static final int MirrorDescription = 60;
        public static final int TurbineWater = 70;
        public static final int TurbineSpeed = 71;
        public static final int HeaterHeat = 80;
        public static final int GrinderSpeed = 90;
        public static final int MixerSpeed = 100;
        public static final int CrystallizerInfo = 110;
        public static final int WireFace = 121;
        public static final int SculptDescription = 130;
        public static final int SculptSelect = 131;
        public static final int SculptNew = 132;
        public static final int SculptMove = 133;
        public static final int SculptRemove = 134;
        public static final int SculptState = 135;
        public static final int SculptWater = 136;
        public static final int FurnaceBurnTime = 140;
        public static final int ExtensionInfo = 150;
        public static final int RocketState = 151;
    }
}

