/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.Core;
import factorization.common.RenderingCube;
import factorization.common.TileEntityGreenware;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class ItemSculptingTool
extends up {
    protected ItemSculptingTool(int id) {
        super(id);
        this.setTextureFile("/factorization/texture/items.png");
        this.c(70);
        this.setNoRepair();
        this.e(0);
        this.d(1);
        this.b("item.sculptTool");
        Core.tab(this, Core.TabType.TOOLS);
        this.o();
    }

    static void addModeChangeRecipes() {
        int length = ToolMode.values().length;
        ToolMode[] mode = ToolMode.values();
        for (int i = 0; i < length; ++i) {
            int j;
            for (j = i + 1; j < length && !mode[j].craftable; ++j) {
            }
            if (j == length) {
                j = 0;
            }
            Core.registry.shapelessRecipe(ItemSculptingTool.fromMode(mode[j]), ItemSculptingTool.fromMode(mode[i]));
        }
    }

    ToolMode getMode(int damage) {
        if (damage < 0) {
            return ToolMode.SELECTOR;
        }
        if (damage >= ToolMode.values().length) {
            return ToolMode.SELECTOR;
        }
        return ToolMode.values()[damage];
    }

    static ur fromMode(ToolMode mode) {
        return new ur((up)Core.registry.sculpt_tool, 1, mode.ordinal());
    }

    public int b(int damage) {
        return this.cl + this.getMode(damage).ordinal();
    }

    public void a(ur is, qx player, List list, boolean verbose) {
        ToolMode mode = this.getMode(is.j());
        list.add(mode.english);
        ToolMode nextMode = mode.next;
        while (nextMode != mode) {
            list.add("(" + nextMode.english + ")");
            nextMode = nextMode.next;
        }
        Core.brand(list);
    }

    void changeMode(ur is) {
        ToolMode mode = this.getMode(is.j());
        is.b(mode.next.ordinal());
    }

    public boolean a(ur par1ItemStack, qx par2EntityPlayer, yc par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        return this.tryPlaceIntoWorld(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
    }

    public boolean tryPlaceIntoWorld(ur is, qx player, yc w2, int x, int y2, int z, int side, float vx, float vy, float vz) {
        Coord here = new Coord(w2, x, y2, z);
        TileEntityGreenware gw = (TileEntityGreenware)here.getTE(TileEntityGreenware.class);
        if (gw == null) {
            if (player.ah()) {
                this.changeMode(is);
                if (player.bJ.a[player.bJ.c] == is) {
                    player.bJ.a[player.bJ.c] = is.l();
                }
                return true;
            }
            return false;
        }
        TileEntityGreenware.ClayState state = gw.getState();
        ToolMode mode = this.getMode(is.j());
        if (state != TileEntityGreenware.ClayState.WET) {
            if (w2.I) {
                return false;
            }
            switch (state) {
                case DRY: {
                    Core.notify(player, gw.getCoord(), "The clay is dry\nUse a %s.", Core.getTranslationKey(up.ax));
                    break;
                }
                case BISQUED: 
                case GLAZED: {
                    Core.notify(player, gw.getCoord(), "This clay has been fired and can not be reshaped.", new String[0]);
                    break;
                }
                default: {
                    Core.notify(player, gw.getCoord(), "This clay can not be reshaped.", new String[0]);
                }
            }
            return false;
        }
        if (w2.I) {
            if (mode == ToolMode.SELECTOR) {
                if (gw.parts.size() == 0) {
                    return true;
                }
                int id = gw.parts.indexOf(TileEntityGreenware.selected);
                if (player.ah()) {
                    if (--id <= -1) {
                        id = gw.parts.size() - 1;
                    }
                } else if (++id == gw.parts.size()) {
                    id = 0;
                }
                TileEntityGreenware.selected = (RenderingCube)gw.parts.get(id);
                gw.broadcastMessage(null, 131, id);
            }
            return true;
        }
        if (mode == ToolMode.SELECTOR) {
            return true;
        }
        TileEntityGreenware.SelectionInfo sel = (TileEntityGreenware.SelectionInfo)TileEntityGreenware.selections.get(player.bR);
        if (sel == null) {
            return false;
        }
        if (sel.gw != gw) {
            return false;
        }
        if (sel.id < 0 || sel.id >= gw.parts.size()) {
            return false;
        }
        RenderingCube selection = (RenderingCube)gw.parts.get(sel.id);
        switch (mode) {
            case MOVER: {
                RenderingCube test = selection.copy();
                this.move(test, player.ah(), side);
                if (!TileEntityGreenware.isValidLump(test)) break;
                this.move(selection, player.ah(), side);
                gw.shareLump(sel.id, selection);
                break;
            }
            case STRETCHER: {
                RenderingCube test = selection.copy();
                this.stretch(test, player.ah(), side);
                if (!TileEntityGreenware.isValidLump(test)) break;
                this.stretch(selection, player.ah(), side);
                gw.shareLump(sel.id, selection);
                break;
            }
            case REMOVER: {
                px drop;
                gw.removeLump(sel.id);
                if (gw.parts.size() == 0) {
                    here.setId(0);
                    drop = new px(w2, (double)gw.l, (double)gw.m, (double)gw.n, Core.registry.greenware_item.l());
                } else {
                    drop = new px(w2, (double)gw.l, (double)gw.m, (double)gw.n, new ur(up.aI));
                }
                w2.d((lq)drop);
                break;
            }
            case ROTATOR: {
                RenderingCube test = selection.copy();
                this.rotate(test, player.ah(), side);
                if (!TileEntityGreenware.isValidLump(test)) break;
                this.rotate(selection, player.ah(), side);
                gw.shareLump(sel.id, selection);
                break;
            }
            case RESETTER: {
                selection.trans.reset();
                gw.shareLump(sel.id, selection);
            }
        }
        return true;
    }

    void rotate(RenderingCube cube, boolean reverse, int side) {
        float delta = (float)Math.toRadians(11.25);
        if (reverse) {
            delta *= -1.0f;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        cube.trans.rotate(direction.offsetX, direction.offsetY, direction.offsetZ, delta);
    }

    void move(RenderingCube cube, boolean reverse, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        this.stretch(cube, reverse, dir.ordinal());
        this.stretch(cube, !reverse, dir.getOpposite().ordinal());
    }

    void stretch(RenderingCube cube, boolean reverse, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        float delta = reverse ? -0.5f : 0.5f;
        switch (dir) {
            case SOUTH: {
                cube.corner.z += delta;
                cube.trans.translate(0.0f, 0.0f, delta);
                break;
            }
            case NORTH: {
                cube.corner.z += delta;
                cube.trans.translate(0.0f, 0.0f, -delta);
                break;
            }
            case EAST: {
                cube.corner.x += delta;
                cube.trans.translate(delta, 0.0f, 0.0f);
                break;
            }
            case WEST: {
                cube.corner.x += delta;
                cube.trans.translate(-delta, 0.0f, 0.0f);
                break;
            }
            case UP: {
                cube.corner.y += delta;
                cube.trans.translate(0.0f, delta, 0.0f);
                break;
            }
            case DOWN: {
                cube.corner.y += delta;
                cube.trans.translate(0.0f, -delta, 0.0f);
            }
        }
    }

    static enum ToolMode {
        SELECTOR("Select", true),
        MOVER("Move", true),
        STRETCHER("Stretch", false),
        REMOVER("Remove", true),
        ROTATOR("Rotate", true),
        RESETTER("Unrotate", false);

        String english;
        boolean craftable;
        ToolMode next;

        /*
         * WARNING - void declaration
         */
        private ToolMode() {
            void craftable;
            void english;
            this.english = english;
            this.craftable = craftable;
            this.next = this;
        }

        static void group(ToolMode ... group) {
            ToolMode prev = group[group.length - 1];
            for (ToolMode me : group) {
                me.next = prev;
                prev = me;
            }
        }

        static {
            ToolMode.group(MOVER, STRETCHER);
            ToolMode.group(REMOVER, RESETTER);
        }
    }
}

