/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import net.minecraftforge.oredict.OreDictionary;

public class FactorizationUtil {
    static Random rand = new Random();

    public static boolean identical(ur a, ur b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.c == b.c && a.j() == b.j() && FactorizationUtil.sameItemTags(a, b);
    }

    public static boolean sameItemTags(ur a, ur b) {
        if (a.d == null || b.d == null) {
            return a.d == b.d;
        }
        a.d.p("tag");
        b.d.p("tag");
        return a.d.equals((Object)b.d);
    }

    public static boolean similar(ur a, ur b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.c == b.c && a.j() == b.j();
    }

    public static boolean wildcardSimilar(ur template, ur stranger) {
        if (template == null || stranger == null) {
            return template == stranger;
        }
        if (template.j() == -1) {
            return template.c == stranger.c;
        }
        return FactorizationUtil.similar(template, stranger);
    }

    public static boolean oreDictionarySimilar(Object template, ur stranger) {
        if (template instanceof String) {
            ArrayList ores = OreDictionary.getOres((String)((String)template));
            for (int i = 0; i < ores.size(); ++i) {
                if (!FactorizationUtil.wildcardSimilar((ur)ores.get(i), stranger)) continue;
                return true;
            }
            return false;
        }
        if (template instanceof List) {
            for (Object o : (List)template) {
                if (!FactorizationUtil.oreDictionarySimilar(o, stranger)) continue;
                return true;
            }
            return false;
        }
        return FactorizationUtil.wildcardSimilar((ur)template, stranger);
    }

    public static ur normalDecr(ur is) {
        --is.a;
        return is.a <= 0 ? null : is;
    }

    public static bq getTag(ur is) {
        bq ret = is.p();
        if (ret == null) {
            ret = new bq();
            is.d(ret);
        }
        return ret;
    }

    public static boolean itemCanFire(yc w2, ur is, int tickDelay) {
        bq tag = FactorizationUtil.getTag(is);
        long t = tag.f("lf");
        if (t > w2.G()) {
            tag.a("lf", w2.G());
            return true;
        }
        if (t + (long)tickDelay > w2.G()) {
            return false;
        }
        tag.a("lf", w2.G());
        return true;
    }

    public static ur normalize(ur is) {
        if (is == null || is.a <= 0) {
            return null;
        }
        return is;
    }

    public static int getStackSize(ur is) {
        if (is == null) {
            return 0;
        }
        return is.a;
    }

    public static int getFreeSpace(ur is, int stackLimit) {
        int max = Math.min(is.d(), stackLimit);
        return Math.max(0, max - is.a);
    }

    @Deprecated
    public static ur transferStackToArea(la srcInv, int slotIndex, la destInv, Iterable targetSlots) {
        ur target;
        int i;
        ur is = srcInv.a(slotIndex);
        if (is == null || is.a == 0) {
            return null;
        }
        Iterator i$ = targetSlots.iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            target = destInv.a(i);
            if (target == null) continue;
            if (FactorizationUtil.identical(is, target)) {
                int free_space = target.d() - target.a;
                int incr = Math.min(free_space, is.a);
                if (incr <= 0) continue;
                is.a -= incr;
                target.a += incr;
            }
            if (is.a > 0) continue;
            srcInv.a(slotIndex, null);
            return null;
        }
        i$ = targetSlots.iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            target = destInv.a(i);
            if (target != null) continue;
            destInv.a(i, is.l());
            is.a = 0;
            srcInv.a(slotIndex, null);
            return null;
        }
        if (is.a <= 0) {
            srcInv.a(slotIndex, null);
            return null;
        }
        srcInv.a(slotIndex, is);
        return is;
    }

    public static ur transferSlotToSlots(sr clickSlot, Iterable destinations) {
        ur clickStack = FactorizationUtil.normalize(clickSlot.c());
        if (clickStack == null) {
            return null;
        }
        for (sr slot : destinations) {
            int freeSpace;
            ur is = FactorizationUtil.normalize(slot.c());
            if (is == null || !FactorizationUtil.identical(is, clickStack) || (freeSpace = Math.min(is.d() - is.a, slot.a() - is.a)) <= 0 || !slot.a(clickStack)) continue;
            int delta = Math.min(freeSpace, clickStack.a);
            is.a += delta;
            slot.c(is);
            clickStack.a -= delta;
            if (clickStack.a > 0) continue;
            clickSlot.c(null);
            return null;
        }
        for (sr slot : destinations) {
            if (slot.d() || !slot.a(clickStack)) continue;
            int freeSpace = Math.min(slot.a(), clickStack.d());
            int delta = Math.min(freeSpace, clickStack.a);
            ur toPut = clickStack.l();
            toPut.a = delta;
            slot.c(toPut);
            clickStack.a -= delta;
            if ((clickStack = FactorizationUtil.normalize(clickStack)) != null) continue;
            clickSlot.c(null);
            return null;
        }
        clickSlot.c(FactorizationUtil.normalize(clickStack));
        return null;
    }

    public static la openDoubleChest(anm chest) {
        anm origChest = chest;
        yc world = chest.k;
        int i = chest.l;
        int j = chest.m;
        int k = chest.n;
        int chestBlock = amq.ax.cm;
        if (world.a(i - 1, j, k) == chestBlock) {
            return new kz(origChest.b(), (la)((anm)world.q(i - 1, j, k)), (la)origChest);
        }
        if (world.a(i, j, k - 1) == chestBlock) {
            return new kz(origChest.b(), (la)((anm)world.q(i, j, k - 1)), (la)origChest);
        }
        if (world.a(i + 1, j, k) == chestBlock) {
            return null;
        }
        if (world.a(i, j, k + 1) == chestBlock) {
            return null;
        }
        return chest;
    }

    public static wp createShapedRecipe(ur result, Object ... args) {
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (args[var4] instanceof String[]) {
            String[] var7 = (String[])args[var4++];
            for (int var8 = 0; var8 < var7.length; ++var8) {
                String var9 = var7[var8];
                ++var6;
                var5 = var9.length();
                var3 = var3 + var9;
            }
        } else {
            while (args[var4] instanceof String) {
                String var11 = (String)args[var4++];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        }
        HashMap<Character, ur> var12 = new HashMap<Character, ur>();
        while (var4 < args.length) {
            Character var13 = (Character)args[var4];
            ur var14 = null;
            if (args[var4 + 1] instanceof up) {
                var14 = new ur((up)args[var4 + 1]);
            } else if (args[var4 + 1] instanceof amq) {
                var14 = new ur((amq)args[var4 + 1], 1, -1);
            } else if (args[var4 + 1] instanceof ur) {
                var14 = (ur)args[var4 + 1];
            }
            var12.put(var13, var14);
            var4 += 2;
        }
        ur[] var15 = new ur[var5 * var6];
        for (int var16 = 0; var16 < var5 * var6; ++var16) {
            char var10 = var3.charAt(var16);
            var15[var16] = var12.containsKey(Character.valueOf(var10)) ? ((ur)var12.get(Character.valueOf(var10))).l() : null;
        }
        return new wq(var5, var6, var15, result);
    }

    public static wp createShapelessRecipe(ur result, Object ... args) {
        ArrayList<ur> var3 = new ArrayList<ur>();
        for (Object var7 : args) {
            if (var7 instanceof ur) {
                var3.add(((ur)var7).l());
                continue;
            }
            if (var7 instanceof up) {
                var3.add(new ur((up)var7));
                continue;
            }
            if (!(var7 instanceof amq)) {
                throw new RuntimeException("Invalid shapeless recipy!");
            }
            var3.add(new ur((amq)var7));
        }
        return new wr(result, var3);
    }

    static px spawnItemStack(Coord c, ur item2) {
        if (item2 == null) {
            return null;
        }
        double dx = (double)rand.nextFloat() * 0.5 - 0.5;
        double dy = (double)rand.nextFloat() * 0.5 - 0.5;
        double dz = (double)rand.nextFloat() * 0.5 - 0.5;
        px entityitem = new px(c.w, (double)c.x + 0.5, (double)c.y + 0.5, (double)c.z + 0.5, item2);
        entityitem.x = 0.2 + rand.nextGaussian() * 0.02;
        entityitem.w = rand.nextGaussian() * 0.02;
        entityitem.y = rand.nextGaussian() * 0.02;
        c.w.d((lq)entityitem);
        return entityitem;
    }

    public static int determineOrientation(qx player) {
        if (player.A > 75.0f) {
            return 0;
        }
        if (player.A <= -75.0f) {
            return 1;
        }
        int var7 = ke.c((double)((double)((180.0f + player.z) * 4.0f / 360.0f) + 0.5)) & 3;
        return var7 == 0 ? 2 : (var7 == 1 ? 5 : (var7 == 2 ? 3 : (var7 == 3 ? 4 : 0)));
    }

    public static DeltaCoord getFlatDiagonalFacing(qx player) {
        double angle = Math.toRadians(90.0f + player.z);
        int dx = Math.cos(angle) > 0.0 ? 1 : -1;
        int dz = Math.sin(angle) > 0.0 ? 1 : -1;
        return new DeltaCoord(dx, 0, dz);
    }

    public static Enum shiftEnum(Enum current, Enum[] values, int delta) {
        int next = current.ordinal() + delta;
        if (next < 0) {
            return values[values.length - 1];
        }
        if (next >= values.length) {
            return values[0];
        }
        return values[next];
    }

    public static void writeTank(bq tag, LiquidTank tank, String name2) {
        LiquidStack ls = tank.getLiquid();
        if (ls == null) {
            return;
        }
        bq liquid_tag = new bq(name2);
        ls.writeToNBT(liquid_tag);
        tag.a(name2, (cd)liquid_tag);
    }

    public static void readTank(bq tag, LiquidTank tank, String name2) {
        bq liquid_tag = tag.l(name2);
        LiquidStack ls = LiquidStack.loadLiquidStackFromNBT((bq)liquid_tag);
        tank.setLiquid(ls);
    }

    public static void spill(Coord where, LiquidStack what) {
        if (what == null || what.amount < 0) {
            return;
        }
        LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidSpilledEvent(what, where.w, where.x, where.y, where.z));
    }

    public static aoj getMin(aoe aabb) {
        return aoj.a((double)aabb.a, (double)aabb.b, (double)aabb.c);
    }

    public static void setMin(aoe aabb, aoj v) {
        aabb.a = v.c;
        aabb.b = v.d;
        aabb.c = v.e;
    }

    public static aoj getMax(aoe aabb) {
        return aoj.a((double)aabb.d, (double)aabb.e, (double)aabb.f);
    }

    public static void setMax(aoe aabb, aoj v) {
        aabb.d = v.c;
        aabb.e = v.d;
        aabb.f = v.e;
    }

    public static aoj averageVec(aoj a, aoj b) {
        return aoj.a((double)((a.c + b.c) / 2.0), (double)((a.d + b.d) / 2.0), (double)((a.e + b.e) / 2.0));
    }

    public static boolean intersect(double la2, double ha, double lb, double hb) {
        return !(ha < lb) && !(hb < la2);
    }

    public static ry makeCraftingGrid() {
        return new ry(new rq(){

            public boolean a(qx entityplayer) {
                return false;
            }

            public void a(la iinventory) {
            }
        }, 3, 3);
    }

    public static qx makePlayer(final Coord where, String use) {
        qx fakePlayer = new qx(where.w){

            public void a(String var1) {
            }

            public boolean a(int var1, String var2) {
                return false;
            }

            public s b() {
                return new s(where.x, where.y, where.z);
            }
        };
        fakePlayer.bR = "[FZ " + use + "]";
        where.setAsEntityLocation((lq)fakePlayer);
        return fakePlayer;
    }

    public static void addInventoryToArray(la inv, ArrayList ret) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur is = FactorizationUtil.normalize(inv.a(i));
            if (is == null) continue;
            ret.add(is);
        }
    }

    public static class ISidedWrapper
    implements la {
        ISidedInventory isi;
        ForgeDirection side;

        public ISidedWrapper(ISidedInventory isi, ForgeDirection side) {
            this.isi = isi;
            this.side = side;
        }

        public int k_() {
            return this.isi.getSizeInventorySide(this.side);
        }

        private int getSlot(int slotIndex) {
            return this.isi.getStartInventorySide(this.side) + slotIndex;
        }

        public ur a(int slotIndex) {
            return this.isi.a(this.getSlot(slotIndex));
        }

        public ur a(int slotIndex, int amount) {
            return this.isi.a(this.getSlot(slotIndex), amount);
        }

        public void a(int slotIndex, ur stack) {
            this.isi.a(this.getSlot(slotIndex), stack);
        }

        public String b() {
            return this.isi.b();
        }

        public int c() {
            return this.isi.c();
        }

        public void d() {
            this.isi.d();
        }

        public ur a_(int var1) {
            return null;
        }

        public boolean a_(qx var1) {
            return true;
        }

        public void l_() {
        }

        public void f() {
        }
    }
}

