/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.IExoUpgrade;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.Sound;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISpecialArmor;

public class ExoWallJump
extends up
implements IExoUpgrade,
ITickHandler {
    static float targetRotation = 0.0f;
    static int turningFrames = 10;

    protected ExoWallJump(int par1) {
        super(par1);
        this.b("exo.wallJump");
        Core.tab(this, Core.TabType.MISC);
        this.c(163);
        this.d(1);
        this.setTextureFile("/factorization/texture/items.png");
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.CLIENT);
    }

    @Override
    public boolean canUpgradeArmor(ur is, int armorIndex) {
        return armorIndex == 3;
    }

    @Override
    public ur tickUpgrade(qx player, ur armor, ur upgrade, boolean isEnabled) {
        bq tag = FactorizationUtil.getTag(upgrade);
        boolean maxChargeCount = true;
        int charges = tag.e("C");
        if (charges < 1 && !isEnabled) {
            if (!player.E) {
                return null;
            }
            if (FactorizationUtil.itemCanFire(player.p, upgrade, 40)) {
                tag.a("C", charges + 1);
                return upgrade;
            }
            return null;
        }
        if (isEnabled && charges > 0 && FactorizationUtil.itemCanFire(player.p, upgrade, 40)) {
            aoj position = aoj.a((double)player.t, (double)player.u, (double)player.v);
            aoj incidence = player.Z();
            double dist = 2.0;
            aoj var6 = position.c(incidence.c * dist, incidence.d * dist, incidence.e * dist);
            aoh selected = player.p.a(position, var6);
            if (selected == null || selected.a != aoi.a) {
                return null;
            }
            ForgeDirection dir = ForgeDirection.values()[selected.e];
            if (!player.p.isBlockSolidOnSide(selected.b, selected.c, selected.d, dir)) {
                return null;
            }
            if (dir.offsetY != 0) {
                return null;
            }
            player.S = 0.0f;
            player.j(0.8f);
            if (player instanceof iq && !player.p.I) {
                iq mp = (iq)player;
                mp.a.g = 0;
                player.z += 180.0f;
                Sound.wallJump.playAt((lq)player);
            } else {
                if (turningFrames != 0) {
                    if (dir.offsetX != 0) {
                        player.w *= -1.1;
                    }
                    if (dir.offsetZ != 0) {
                        player.y *= -1.1;
                    }
                    player.x += (double)0.4f;
                } else {
                    player.x += 0.1;
                }
                turningFrames = 0;
            }
            tag.a("C", charges - 1);
            return upgrade;
        }
        return null;
    }

    @Override
    public void addArmorProperties(ur is, ISpecialArmor.ArmorProperties armor) {
    }

    @Override
    public int getArmorDisplay(ur is) {
        return 0;
    }

    @Override
    public boolean damageArmor(md entity, ur stack, lh source, int damage, int slot) {
        return false;
    }

    @Override
    public String getDescription() {
        return "Jump against walls";
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        float totalFrames = 5.0f;
        if ((float)turningFrames < 5.0f && ((Boolean)Core.isMainClientThread.get()).booleanValue()) {
            double diff;
            ++turningFrames;
            qx player = Core.proxy.getClientPlayer();
            double motionTheta = Math.toDegrees(Math.atan2(player.y, player.w));
            motionTheta += (double)(360 * (int)(player.z / 360.0f) - 90);
            float perc = (float)turningFrames / 5.0f;
            if ((double)perc < 0.75) {
                perc = (float)((double)perc * 1.25);
            }
            if ((diff = motionTheta - (double)player.z) > 180.0) {
                diff -= 360.0;
            }
            if (diff < -180.0) {
                diff += 360.0;
            }
            if (Math.abs(diff) < 0.5) {
                turningFrames = 5;
            } else {
                player.z = (float)((double)player.z + diff * (double)perc);
            }
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT);
    }

    public String getLabel() {
        return "exospring";
    }

    public void a(ur is, qx player, List infoList, boolean verbose) {
        infoList.add("Exo-Upgrade");
        Core.brand(infoList);
    }
}

