/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.ExoStateActivation;
import factorization.api.ExoStateShader;
import factorization.api.ExoStateType;
import factorization.common.ExoArmor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;

public class ExoCore
implements ITickHandler {
    private static HashMap playerMap = new HashMap();
    private static ArrayList toRemove = new ArrayList(2);
    private static EnumSet myTicks = EnumSet.of(TickType.PLAYER, TickType.SERVER);

    public ExoCore() {
        for (Side side : Side.values()) {
            TickRegistry.registerTickHandler((ITickHandler)this, (Side)side);
        }
    }

    private static ExoPlayerState getPlayerState(qx player) {
        ExoPlayerState mps = (ExoPlayerState)playerMap.get(player.bR);
        if (mps == null) {
            mps = new ExoPlayerState(player);
            playerMap.put(player.bR, mps);
        }
        return mps;
    }

    public static void updatePlayerStates() {
        for (String playerName : playerMap.keySet()) {
            ExoPlayerState playerState = (ExoPlayerState)playerMap.get(playerName);
            if (!((ExoPlayerState)playerState).player.L) continue;
            toRemove.add(playerName);
        }
        for (String playerName : toRemove) {
            playerMap.remove(playerName);
        }
    }

    public static void tickPlayer(qx player) {
        if (player.L && !player.p.I) {
            playerMap.remove(player.bR);
            return;
        }
        ExoPlayerState mps = ExoCore.getPlayerState(player);
        mps.update();
        ExoArmor.onTickPlayer(player, mps);
    }

    public static void buttonPressed(qx player, int button, boolean isOn) {
        ExoStateType mst = null;
        switch (button) {
            case 0: {
                mst = ExoStateType.BUTTON1;
                break;
            }
            case 1: {
                mst = ExoStateType.BUTTON2;
                break;
            }
            case 2: {
                mst = ExoStateType.BUTTON3;
            }
        }
        if (mst != null) {
            ExoCore.getPlayerState(player).touchState(mst, isOn);
        }
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.PLAYER)) {
            qx player = (qx)tickData[0];
            ExoCore.tickPlayer(player);
        }
        if (type.contains(TickType.WORLD)) {
            ExoCore.updatePlayerStates();
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return myTicks;
    }

    public String getLabel() {
        return "exo";
    }

    public static class ExoPlayerState {
        private ExoStateActivation[] state = new ExoStateActivation[ExoStateType.values().length];
        private boolean[] toggle = new boolean[ExoStateType.values().length];
        private qx player;

        private ExoPlayerState(qx player) {
            this.player = player;
            for (int i = 0; i < this.state.length; ++i) {
                this.state[i] = ExoStateActivation.OFF;
            }
            playerMap.put(player.bR, this);
        }

        private void update() {
            for (int i = 0; i < this.state.length; ++i) {
                if (this.state[i] == ExoStateActivation.FIRSTON) {
                    this.state[i] = ExoStateActivation.ON;
                    continue;
                }
                if (this.state[i] != ExoStateActivation.FIRSTOFF) continue;
                this.state[i] = ExoStateActivation.OFF;
            }
            this.touchState(ExoStateType.HURT, this.player.ae > 0);
            this.touchState(ExoStateType.WOUNDED, (float)this.player.aU() / (float)this.player.aT() <= 0.333f);
            this.touchState(ExoStateType.MOVING, Math.abs(this.player.w) + Math.abs(this.player.x) + Math.abs(this.player.y) > 0.1);
            this.touchState(ExoStateType.ONFIRE, this.player.af());
            this.touchState(ExoStateType.SNEAKING, this.player.ah());
            this.touchState(ExoStateType.RIDING, this.player.ag());
            this.touchState(ExoStateType.SPRINTING, this.player.ah());
            this.touchState(ExoStateType.ONGROUND, this.player.E);
            this.touchState(ExoStateType.INWATER, this.player.H());
        }

        private void touchState(ExoStateType type, boolean isOn) {
            int i = type.ordinal();
            ExoStateActivation origState = this.state[i];
            if (isOn != origState.on) {
                if (isOn && !origState.on) {
                    this.state[i] = ExoStateActivation.FIRSTON;
                    this.toggle[i] = !this.toggle[i];
                } else if (!isOn && origState.on) {
                    this.state[i] = ExoStateActivation.FIRSTOFF;
                }
            }
        }

        public ExoStateActivation getStateActivation(ExoStateType type) {
            return this.state[type.ordinal()];
        }

        public boolean getIsActive(ExoStateType mst, ExoStateShader mss) {
            ExoStateActivation msa = this.getStateActivation(mst);
            switch (mss) {
                default: {
                    return msa.on;
                }
                case INVERSE: {
                    return !msa.on;
                }
                case RISINGEDGE: {
                    return msa == ExoStateActivation.FIRSTON;
                }
                case FALLINGEDGE: {
                    return msa == ExoStateActivation.FIRSTOFF;
                }
                case TOGGLE: {
                    return this.toggle[mst.ordinal()];
                }
                case INVTOGGLE: 
            }
            return !this.toggle[mst.ordinal()];
        }
    }
}

