/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.ExoStateShader;
import factorization.api.ExoStateType;
import factorization.api.IExoUpgrade;
import factorization.common.Core;
import factorization.common.ExoCore;
import factorization.common.FactorizationUtil;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.IArmorTextureProvider;
import net.minecraftforge.common.ISpecialArmor;

public class ExoArmor
extends su
implements ISpecialArmor,
IArmorTextureProvider {
    public int slotCount = 2;
    static Random rand = new Random();

    public ExoArmor(int par1, int armorType) {
        super(par1, sv.b, 0, armorType);
        this.e(0);
        this.b("item.exoArmor" + armorType);
    }

    ExoArmor setSlotCount(int count) {
        this.slotCount = count;
        return this;
    }

    public ur getStackInSlot(ur is, int slot) {
        if (slot < 0 || slot >= this.slotCount) {
            return null;
        }
        bq tag = is.p();
        if (tag == null) {
            return null;
        }
        String index = "slot" + slot;
        if (!tag.b(index)) {
            return null;
        }
        return ur.a((bq)tag.l(index));
    }

    public IExoUpgrade getUpgradeInSlot(ur is, int slot) {
        return this.getUpgrade(this.getStackInSlot(is, slot));
    }

    public IExoUpgrade getUpgrade(ur i) {
        if (i == null || !(i.b() instanceof IExoUpgrade)) {
            return null;
        }
        if (i.a == 0) {
            return null;
        }
        return (IExoUpgrade)i.b();
    }

    public void setStackInSlot(ur is, int slot, ur stack) {
        if (slot < 0 || slot >= this.slotCount) {
            return;
        }
        if (is.p() == null) {
            is.d(new bq());
        }
        if (stack == null) {
            is.p().a("slot" + slot, (cd)new bq());
            return;
        }
        bq itemTag = new bq();
        stack.b(itemTag);
        is.p().a("slot" + slot, itemTag);
    }

    public boolean isValidUpgrade(ur theArmor, ur is) {
        if (is == null) {
            return false;
        }
        up item2 = is.b();
        if (item2 instanceof IExoUpgrade) {
            IExoUpgrade upgrade = (IExoUpgrade)is.b();
            return upgrade.canUpgradeArmor(theArmor, this.a);
        }
        return ExoArmor.isStandardArmor(is) && ((su)is.b()).a == this.a;
    }

    public static boolean isStandardArmor(ur is) {
        if (is == null) {
            return false;
        }
        up it = is.b();
        return it instanceof su && !(it instanceof ISpecialArmor);
    }

    public void setExoStateType(ur is, int slot, ExoStateType mst) {
        bq tag = FactorizationUtil.getTag(is);
        tag.a("MST" + slot, mst.ordinal());
    }

    public ExoStateType getExoStateType(ur is, int slot) {
        bq tag = FactorizationUtil.getTag(is);
        int typeOrdinal = tag.e("MST" + slot);
        try {
            return ExoStateType.values()[typeOrdinal];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.setExoStateType(is, slot, ExoStateType.NEVER);
            return ExoStateType.NEVER;
        }
    }

    public void setExoStateShader(ur is, int slot, ExoStateShader mss) {
        bq tag = FactorizationUtil.getTag(is);
        tag.a("MSS" + slot, mss.ordinal());
    }

    public ExoStateShader getExoStateShader(ur is, int slot) {
        bq tag = FactorizationUtil.getTag(is);
        int typeOrdinal = tag.e("MSS" + slot);
        try {
            return ExoStateShader.values()[typeOrdinal];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.setExoStateShader(is, slot, ExoStateShader.NORMAL);
            return ExoStateShader.NORMAL;
        }
    }

    static void onTickPlayer(qx player, ExoCore.ExoPlayerState mps) {
        for (ur armorStack : player.bJ.b) {
            if (armorStack == null || !(armorStack.b() instanceof ExoArmor)) continue;
            ((ExoArmor)armorStack.b()).tickArmor(player, mps, armorStack);
        }
    }

    void tickArmor(qx player, ExoCore.ExoPlayerState mps, ur armorStack) {
        for (int slot = 0; slot < this.slotCount; ++slot) {
            IExoUpgrade up2;
            ur is = this.getStackInSlot(armorStack, slot);
            if (is == null || (up2 = this.getUpgrade(is)) == null) continue;
            ExoStateShader mss = this.getExoStateShader(armorStack, slot);
            ExoStateType mst = this.getExoStateType(armorStack, slot);
            boolean active = mps.getIsActive(mst, mss);
            ur ret = up2.tickUpgrade(player, armorStack, is, active);
            if (ret == null) continue;
            this.setStackInSlot(armorStack, slot, FactorizationUtil.normalize(ret));
        }
    }

    double randDelta() {
        return (rand.nextGaussian() - 0.5) / 4.0;
    }

    public int c() {
        return -1;
    }

    public String getArmorTextureFile(ur itemstack) {
        if (this.a == 2) {
            return "/factorization/texture/exo_armor_2.png";
        }
        return "/factorization/texture/exo_armor_1.png";
    }

    public boolean q() {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(md player, ur armor, lh source, double damage, int slot) {
        ISpecialArmor.ArmorProperties prop = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        ExoArmor ma = (ExoArmor)armor.b();
        boolean found_vanilla_armor = false;
        for (int i = 0; i < this.slotCount; ++i) {
            IExoUpgrade up2;
            ur is = ma.getStackInSlot(armor, i);
            if (is == null) continue;
            if (ExoArmor.isStandardArmor(is)) {
                if (found_vanilla_armor) continue;
                found_vanilla_armor = true;
                su ar = (su)is.b();
                prop.AbsorbRatio += (double)ar.b / 25.0;
                prop.AbsorbMax += ar.m() + 1 - is.j();
            }
            if ((up2 = this.getUpgrade(is)) == null) continue;
            up2.addArmorProperties(is, prop);
        }
        return prop;
    }

    public int getArmorDisplay(qx player, ur armor, int slot) {
        int ret = 0;
        ExoArmor ma = (ExoArmor)armor.b();
        boolean found_vanilla_armor = false;
        for (int i = 0; i < this.slotCount; ++i) {
            ur is = ma.getStackInSlot(armor, i);
            if (is == null) continue;
            if (ExoArmor.isStandardArmor(is)) {
                if (found_vanilla_armor) continue;
                found_vanilla_armor = true;
                ret += ((su)is.b()).b;
                continue;
            }
            IExoUpgrade up2 = this.getUpgrade(is);
            if (up2 == null) continue;
            ret += up2.getArmorDisplay(is);
        }
        return ret;
    }

    public void damageArmor(md entity, ur armor, lh source, int damage, int slot) {
        ExoArmor ma = (ExoArmor)armor.b();
        boolean found_vanilla_armor = false;
        for (int i = 0; i < this.slotCount; ++i) {
            ur is = ma.getStackInSlot(armor, i);
            if (is == null) continue;
            if (ExoArmor.isStandardArmor(is)) {
                if (found_vanilla_armor) continue;
                found_vanilla_armor = true;
                is.a(damage, entity);
                if (is.a <= 0) {
                    is = null;
                }
                ma.setStackInSlot(armor, i, is);
                continue;
            }
            IExoUpgrade up2 = this.getUpgrade(is);
            if (up2 == null || !up2.damageArmor(entity, is, source, damage, slot)) continue;
            ma.setStackInSlot(armor, i, is);
        }
    }

    public String getTextureFile() {
        return "/factorization/texture/items.png";
    }

    public int b(int par1) {
        return (4 + this.a) * 16;
    }

    public void a(ur is, qx player, List infoList, boolean verbose) {
        super.a(is, player, infoList, verbose);
        for (int i = 0; i < this.slotCount; ++i) {
            String s2;
            ur upgrade = this.getStackInSlot(is, i);
            if (upgrade == null || (s2 = upgrade.b().l(upgrade)) == null || s2.length() <= 0) continue;
            if (upgrade.b() instanceof IExoUpgrade) {
                ExoStateType mst = this.getExoStateType(is, i);
                ExoStateShader mss = this.getExoStateShader(is, i);
                s2 = s2 + "  " + mss.brief() + mst.brief();
            }
            infoList.add(s2);
        }
        Core.brand(infoList);
    }
}

