/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.client.gui.FactorizationNotify;
import factorization.common.ExoCore;
import factorization.common.FactorizationOreProcessingHandler;
import factorization.common.FactorizationProxy;
import factorization.common.NameClayCommand;
import factorization.common.NetworkFactorization;
import factorization.common.Registry;
import factorization.common.TileEntitySolarBoiler;
import factorization.common.TileEntityWrathFire;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

@Mod(modid="factorization", name="Factorization", version="0.7.21")
@NetworkMod(clientSideRequired=true, tinyPacketHandler=NetworkFactorization.class)
public class Core {
    public static final String modId = "factorization";
    public static final String name = "Factorization";
    public static final String version = "0.7.21";
    @Mod.Instance(value="factorization")
    public static Core instance;
    public static Registry registry;
    public static ExoCore exoCore;
    public static FactorizationOreProcessingHandler foph;
    @SidedProxy(clientSide="factorization.client.FactorizationClientProxy", serverSide="factorization.common.FactorizationServerProxy")
    public static FactorizationProxy proxy;
    public static NetworkFactorization network;
    public static int factory_rendertype;
    public static Configuration config;
    static int factory_block_id;
    static int lightair_id;
    static int resource_id;
    public static Pattern routerBan;
    public static boolean render_barrel_item;
    public static boolean render_barrel_text;
    public static boolean render_barrel_close;
    public static boolean notify_in_chat;
    public static int entity_relight_task_id;
    public static boolean gen_silver_ore;
    public static int silver_ore_node_size;
    public static boolean enable_dimension_slice;
    public static int dimension_slice_dimid;
    public static int force_max_entity_radius;
    public static boolean spread_wrathfire;
    public static boolean pocket_craft_anywhere;
    public static boolean bag_swap_anywhere;
    public static String pocketActions;
    public static boolean renderTEs;
    public static boolean renderAO;
    public static boolean add_branding;
    public static boolean cheat;
    public static boolean debug_light_air;
    public static boolean debug_network;
    public static boolean dimension_slice_allow_smooth;
    public static boolean show_fine_logging;
    public static boolean serverside_translate;
    public static boolean dev_environ;
    public static boolean boilers_suck_water;
    public static double steam_output_adjust;
    public static boolean enable_sketchy_client_commands;
    public static int max_rocket_base_size;
    public static int max_rocket_height;
    public static final String texture_dir = "/factorization/texture/";
    public static final String texture_file_block = "/factorization/texture/blocks.png";
    public static final String texture_file_item = "/factorization/texture/items.png";
    public static Logger FZLogger;
    static ThreadLocal isMainClientThread;
    static ThreadLocal isMainServerThread;
    public static tj tabFactorization;

    public Core() {
        registry = new Registry();
        exoCore = new ExoCore();
        foph = new FactorizationOreProcessingHandler();
        MinecraftForge.EVENT_BUS.register((Object)registry);
        MinecraftForge.EVENT_BUS.register((Object)exoCore);
    }

    private int getBlockConfig(String name2, int defaultId, String comment) {
        Property prop = null;
        if (dev_environ) {
            return defaultId;
        }
        prop = config.getBlock(name2, defaultId);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getInt(defaultId);
    }

    private int getIntConfig(String name2, String category, int defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getInt(defaultValue);
    }

    private boolean getBoolConfig(String name2, String category, boolean defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getBoolean(defaultValue);
    }

    private double getDoubleConfig(String name2, String category, double defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getDouble(defaultValue);
    }

    private String getStringConfig(String name2, String category, String defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.value;
    }

    private void loadConfig(File configFile) {
        String p;
        config = new Configuration(configFile);
        try {
            config.load();
        }
        catch (Exception e) {
            Core.logWarning("Error loading config: %s", e.toString());
            e.printStackTrace();
        }
        factory_block_id = this.getBlockConfig("factoryBlockId", factory_block_id, "Factorization Machines.");
        lightair_id = this.getBlockConfig("lightAirBlockId", lightair_id, "WrathFire and invisible lamp-air made by WrathLamps");
        resource_id = this.getBlockConfig("resourceBlockId", resource_id, "Ores and metal blocks mostly");
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            debug_light_air = this.getBoolConfig("debugLightAir", "client", debug_light_air, "Show invisible lamp-air");
            pocket_craft_anywhere = this.getBoolConfig("anywherePocketCraft", "client", pocket_craft_anywhere, "Lets you open the pocket crafting table from GUIs");
            bag_swap_anywhere = this.getBoolConfig("anywhereBagSwap", "client", bag_swap_anywhere, "Lets you use the bag from GUIs");
            render_barrel_item = this.getBoolConfig("renderBarrelItem", "client", render_barrel_item, null);
            render_barrel_item = this.getBoolConfig("renderBarrelText", "client", render_barrel_text, null);
            render_barrel_close = this.getBoolConfig("renderBarrelClose", "client", render_barrel_close, "If true, render barrel info only when nearby");
            notify_in_chat = this.getBoolConfig("notifyInChat", "client", notify_in_chat, "If true, notifications are put in the chat log instead in the world");
            renderTEs = this.getBoolConfig("renderOtherTileEntities", "client", renderTEs, "If false, most TEs won't draw, making everything look broken but possibly improving FPS");
            renderAO = this.getBoolConfig("renderAmbientOcclusion", "client", renderAO, "If false, never use smooth lighting for drawing sculptures");
            String attempt = this.getStringConfig("pocketCraftingActionKeys", "client", pocketActions, "3 keys for: removing (x), cycling (c), balancing (b)");
            if (attempt.length() == 3) {
                pocketActions = attempt;
            } else {
                p = config.get("pocketCraftingActionKeys", "client", pocketActions);
                ((Property)p).value = pocketActions;
                ((Property)p).comment = "3 keys for: removing (x), cycling (c), balancing (b)";
            }
            enable_sketchy_client_commands = this.getBoolConfig("allowUnpureCommands", "client", enable_sketchy_client_commands, null);
        }
        gen_silver_ore = this.getBoolConfig("generateSilverOre", "general", gen_silver_ore, "This disables silver ore generation");
        int config_silver_size = this.getIntConfig("silverOreNodeSize", "general", silver_ore_node_size, "The size of silver ore nodes. Between 5 & 35. Default is 25");
        silver_ore_node_size = Math.max(5, Math.min(config_silver_size, 35));
        add_branding = this.getBoolConfig("addBranding", "general", add_branding, null);
        enable_dimension_slice = dev_environ;
        enable_dimension_slice = this.getBoolConfig("enableDimensionSlices", "dimensionSlices", enable_dimension_slice, "work in progress; may be unstable");
        spread_wrathfire = this.getBoolConfig("spreadWrathFire", "server", spread_wrathfire, null);
        p = this.getStringConfig("bannedRouterInventoriesRegex", "server", "", "This is a Java Regex to blacklist router access");
        if (p != null && p.length() != 0) {
            try {
                routerBan = Pattern.compile(p);
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
                Core.logWarning("Factorization: config has invalid Java Regex for banned_router_inventories: " + p, new Object[0]);
            }
        }
        if ((entity_relight_task_id = config.get("general", "entityRelightTask", -1).getInt()) == -1) {
            entity_relight_task_id = EntityRegistry.findGlobalUniqueEntityId();
            Property prop = config.get("general", "entityRelightTask", entity_relight_task_id);
            prop.value = "" + entity_relight_task_id;
        }
        serverside_translate = this.getBoolConfig("serversideTranslate", "server", serverside_translate, "If false, notifications will be translated by the client");
        boilers_suck_water = this.getBoolConfig("boilersSuckWater", "server", boilers_suck_water, "If false, water must be piped in");
        steam_output_adjust = this.getDoubleConfig("steamOutputAdjustment", "server", steam_output_adjust, "Scale how much steam is produced by the solar boiler");
        config.save();
    }

    @Mod.PreInit
    public void load(FMLPreInitializationEvent event) {
        this.loadConfig(event.getSuggestedConfigurationFile());
        registry.makeBlocks();
        TickRegistry.registerTickHandler((ITickHandler)registry, (Side)Side.SERVER);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        registry.registerSimpleTileEntities();
        registry.makeItems();
        config.save();
        registry.makeOther();
        registry.makeRecipes();
        registry.setToolEffectiveness();
        proxy.registerKeys();
        proxy.registerRenderers();
        config.save();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            isMainClientThread.set(true);
        }
        proxy.addNameDirect("itemGroup.factorizationTab", name);
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        TileEntityWrathFire.setupBurning();
        TileEntitySolarBoiler.setupSteam();
        foph.addDictOres();
    }

    @Mod.ServerStarting
    public void registerServerCommands(FMLServerStartingEvent event) {
        isMainServerThread.set(true);
        event.registerServerCommand((y)new NameClayCommand());
    }

    ur getExternalItem(String className, String classField, String description) {
        try {
            Class<?> c = Class.forName(className);
            return (ur)c.getField(classField).get(null);
        }
        catch (Exception err) {
            Core.logWarning("Could not get %s (from %s.%s)", description, className, classField);
            return null;
        }
    }

    public static void logWarning(String format, Object ... formatParameters) {
        FZLogger.log(Level.WARNING, String.format(format, formatParameters));
    }

    public static void logInfo(String format, Object ... formatParameters) {
        FZLogger.log(Level.INFO, String.format(format, formatParameters));
    }

    public static void logFine(String format, Object ... formatParameters) {
        FZLogger.log(dev_environ ? Level.INFO : Level.FINE, String.format(format, formatParameters));
    }

    public static void logSevere(String format, Object ... formatParameters) {
        FZLogger.log(Level.SEVERE, String.format(format, formatParameters));
    }

    public static void addBlockToCreativeList(List tab, amq block2) {
        ArrayList a = new ArrayList();
        block2.addCreativeItems(a);
        for (Object o : a) {
            tab.add(o);
        }
    }

    public static void profileStart(String section) {
        if (((Boolean)isMainClientThread.get()).booleanValue()) {
            proxy.getProfiler().a(section);
        }
    }

    public static void profileEnd() {
        if (((Boolean)isMainClientThread.get()).booleanValue()) {
            proxy.getProfiler().b();
        }
    }

    public static void profileStartRender(String section) {
        Core.profileStart(modId);
        Core.profileStart(section);
    }

    public static void profileEndRender() {
        Core.profileEnd();
        Core.profileEnd();
    }

    public static void brand(List list) {
        if (add_branding) {
            list.add(name);
        }
        if (cheat) {
            list.add("Cheat mode!");
        }
        if (dev_environ) {
            list.add("Development!");
        }
    }

    public static void notify(qx player, Coord where, String format, String ... args) {
        if (player != null && player.p.I) {
            FactorizationNotify.addMessage(where, format, args);
        } else {
            network.broadcastPacket(player, where, network.notifyPacket(where, format, args));
        }
    }

    public static void notify(qx player, Coord where, NotifyStyle style, String format, String ... args) {
        if (style == NotifyStyle.FORCE || style == NotifyStyle.FORCELONG) {
            format = "\b" + format;
        }
        if (style == NotifyStyle.LONG || style == NotifyStyle.FORCELONG) {
            format = "\t" + format;
        }
        Core.notify(player, where, format, args);
    }

    public static void clearNotifications(qx player) {
        if (player != null) {
            Core.notify(player, new Coord((lq)player), "!clear", new String[0]);
        }
    }

    public static up tab(up item2, TabType tabType) {
        tj tab = tabType.type;
        item2.a(tabFactorization);
        return item2;
    }

    public static amq tab(amq block2, TabType tabType) {
        tj tab = tabType.type;
        block2.a(tabFactorization);
        return block2;
    }

    public static String getProperKey(ur is) {
        String n = is.b().d(is);
        if (n == null || n.length() == 0) {
            n = is.b().a();
        }
        if (n == null || n.length() == 0) {
            n = is.a();
        }
        if (n == null || n.length() == 0) {
            n = "???";
        }
        return n;
    }

    public static String getTranslationKey(ur is) {
        if (is == null) {
            return "<null itemstack; bug?>";
        }
        try {
            String s2 = is.r();
            if (s2 != null && s2.length() > 0) {
                return s2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String key = Core.getProperKey(is);
        if (Core.canTranslate(key + ".name")) {
            return key + ".name";
        }
        if (Core.canTranslate(key)) {
            return key;
        }
        return key + ".name";
    }

    static boolean canTranslate(String str) {
        String ret = bm.a((String)str);
        if (ret == null || ret.length() == 0) {
            return false;
        }
        return !ret.equals(str);
    }

    public static String getTranslationKey(up i) {
        if (i == null) {
            return "<null item; bug?>";
        }
        return i.a() + ".name";
    }

    static {
        factory_rendertype = -1;
        factory_block_id = 1000;
        lightair_id = 1001;
        resource_id = 1002;
        render_barrel_item = true;
        render_barrel_text = true;
        render_barrel_close = false;
        notify_in_chat = false;
        entity_relight_task_id = -1;
        gen_silver_ore = true;
        silver_ore_node_size = 25;
        enable_dimension_slice = false;
        dimension_slice_dimid = -7;
        force_max_entity_radius = -1;
        spread_wrathfire = true;
        pocket_craft_anywhere = true;
        bag_swap_anywhere = true;
        pocketActions = "xcb";
        renderTEs = true;
        renderAO = true;
        add_branding = false;
        cheat = false;
        debug_light_air = false;
        debug_network = false;
        dimension_slice_allow_smooth = true;
        show_fine_logging = false;
        serverside_translate = true;
        dev_environ = System.getProperty("user.dir", "").startsWith("/home/poseidon/Development/");
        boilers_suck_water = true;
        steam_output_adjust = 1.0;
        enable_sketchy_client_commands = true;
        max_rocket_base_size = 400;
        max_rocket_height = 64;
        FZLogger = Logger.getLogger("FZ");
        FZLogger.setParent(FMLLog.getLogger());
        Core.logInfo("This is Factorization 0.7.21", new Object[0]);
        isMainClientThread = new ThreadLocal(){

            protected Boolean initialValue() {
                return false;
            }
        };
        isMainServerThread = new ThreadLocal(){

            protected Boolean initialValue() {
                return false;
            }
        };
        tabFactorization = new tj("factorizationTab"){

            public up d() {
                return Core.registry.pocket_table;
            }
        };
    }

    static enum TabType {
        REDSTONE(tj.d),
        TOOLS(tj.i),
        MISC(tj.f),
        MATERIALS(tj.l);

        tj type;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private TabType() {
            void type;
            this.type = type;
        }
    }

    public static enum NotifyStyle {
        FORCE,
        LONG,
        FORCELONG;

    }
}

