/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.ExoStateShader;
import factorization.api.ExoStateType;
import factorization.common.ContainerExoModder;
import factorization.common.ContainerPocket;
import factorization.common.Core;
import factorization.common.ExoArmor;
import factorization.common.ExoCore;
import factorization.common.FactorizationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public enum Command {
    bagShuffle(1),
    craftClear(2),
    craftMove(3),
    craftBalance(4),
    craftOpen(5, true),
    bagShuffleReverse(6),
    exoKeyOn(7, true),
    exoKeyOff(8, true),
    exoModLeftClick(9),
    exoModRightClick(10);

    public byte id;
    boolean executeLocally = false;
    public Command reverse = this;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Command() {
        void id;
        this.id = (byte)id;
        name.map.put(this.id, this);
    }

    /*
     * WARNING - void declaration
     */
    private Command() {
        this((String)var1_-1, (int)var2_-1, (int)id);
        void executeLocally;
        void id;
        void var2_-1;
        void var1_-1;
        this.executeLocally = executeLocally;
    }

    void setReverse(Command rev) {
        rev.reverse = this;
        this.reverse = rev;
    }

    static void fromNetwork(qx player, byte s2, byte arg) {
        Command c = (Command)((Object)name.map.get(s2));
        if (c == null) {
            System.err.println("Received invalid command #" + s2);
            return;
        }
        c.call(player, arg);
    }

    public void call(qx player) {
        this.call(player, (byte)0);
    }

    public void call(qx player, byte arg) {
        if (player == null) {
            return;
        }
        if (player.p.I) {
            Core.network.sendCommand(player, this, arg);
            if (!this.executeLocally) {
                return;
            }
        }
        switch (this) {
            case bagShuffle: {
                Core.registry.bag_of_holding.useBag(player, false);
                break;
            }
            case bagShuffleReverse: {
                Core.registry.bag_of_holding.useBag(player, true);
                break;
            }
            case craftClear: {
                this.craftClear(player);
                break;
            }
            case craftMove: {
                this.craftMove(player);
                break;
            }
            case craftBalance: {
                this.craftBalance(player);
                break;
            }
            case craftOpen: {
                Core.registry.pocket_table.tryOpen(player);
                break;
            }
            case exoKeyOff: 
            case exoKeyOn: {
                ExoCore.buttonPressed(player, arg, this == exoKeyOn);
                break;
            }
            case exoModLeftClick: 
            case exoModRightClick: {
                if (!(player.bL instanceof ContainerExoModder)) break;
                ContainerExoModder cont = (ContainerExoModder)player.bL;
                ur armor = cont.upgrader.armor;
                ExoArmor m = (ExoArmor)armor.b();
                int slot = arg / 2;
                boolean changeExoType = 0 == arg % 2;
                int deltaDirection = this == exoModLeftClick ? 1 : -1;
                ExoStateType mst = m.getExoStateType(armor, slot);
                ExoStateShader mss = m.getExoStateShader(armor, slot);
                if (changeExoType) {
                    do {
                        mst = (ExoStateType)FactorizationUtil.shiftEnum(mst, ExoStateType.values(), deltaDirection);
                    } while (!mst.armorRestriction.canUse(m.a));
                    m.setExoStateType(armor, slot, mst);
                    break;
                }
                mss = mst == ExoStateType.NEVER ? (mss != ExoStateShader.NORMAL ? ExoStateShader.NORMAL : ExoStateShader.INVERSE) : (ExoStateShader)FactorizationUtil.shiftEnum(mss, ExoStateShader.values(), deltaDirection);
                m.setExoStateShader(armor, slot, mss);
                break;
            }
            default: {
                throw new RuntimeException("Command " + (Object)((Object)this) + " is missing handler");
            }
        }
    }

    void craftClear(qx player) {
        if (!(player.bL instanceof ContainerPocket)) {
            return;
        }
        ContainerPocket pocket = (ContainerPocket)player.bL;
        Iterator i$ = ContainerPocket.craftArea.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            pocket.b(player, i);
        }
    }

    private boolean rotateAll(qw inv, int[] slots) {
        int empty = 0;
        for (int slot : slots) {
            if (FactorizationUtil.normalize(inv.a(slot)) != null) continue;
            ++empty;
        }
        if (empty >= 2) {
            return false;
        }
        ArrayList<Object> buffer = new ArrayList<Object>(8);
        for (int slot : slots) {
            ur toAdd = inv.a(slot);
            buffer.add(buffer.size(), toAdd);
        }
        buffer.add(0, buffer.remove(buffer.size() - 1));
        for (int slot : slots) {
            ur toSet = (ur)buffer.remove(0);
            inv.a(slot, toSet);
        }
        return true;
    }

    private boolean smear(qw inv, int[] slots) {
        int stackSrcSlotIndex = 0;
        boolean foundNonEmpty = false;
        for (int slot : slots) {
            if (inv.a(slot) != null) {
                foundNonEmpty = true;
                continue;
            }
            if (!foundNonEmpty) continue;
            ur toDrop = null;
            for (int count = 0; count < slots.length; ++count) {
                ur here = inv.a(slots[stackSrcSlotIndex]);
                if (++stackSrcSlotIndex == slots.length) {
                    stackSrcSlotIndex = 0;
                }
                if (here == null || here.a <= 1) continue;
                toDrop = here;
                break;
            }
            if (toDrop == null) {
                return true;
            }
            inv.a(slot, toDrop.a(1));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void craftMove(qx player) {
        qw inv = player.bJ;
        int[] slots = new int[]{15, 16, 17, 26, 35, 34, 33, 24};
        try {
            if (this.rotateAll(inv, slots)) {
                return;
            }
            if (this.smear(inv, slots)) {
                return;
            }
        }
        finally {
            if (player.bL instanceof ContainerPocket) {
                ((ContainerPocket)player.bL).updateMatrix();
            }
        }
    }

    void craftBalance(qx player) {
        qw inv = player.bJ;
        int[] slots = new int[]{15, 16, 17, 24, 25, 26, 33, 34, 35};
        class Accumulator {
            ur toMatch;
            int stackCount = 0;
            ArrayList matchingSlots = new ArrayList(9);

            public Accumulator(ur toMatch, int slot) {
                this.toMatch = toMatch;
                this.stackCount = toMatch.a;
                toMatch.a = 0;
                this.matchingSlots.add(slot);
            }

            boolean add(ur ta, int slot) {
                if (FactorizationUtil.identical(this.toMatch, ta)) {
                    this.stackCount += ta.a;
                    ta.a = 0;
                    this.matchingSlots.add(slot);
                    return true;
                }
                return false;
            }
        }
        ArrayList<Accumulator> list = new ArrayList<Accumulator>(9);
        for (int slot : slots) {
            ur here = inv.a(slot);
            if (here == null || here.a == 0) continue;
            boolean found = false;
            for (Accumulator acc : list) {
                if (!acc.add(here, slot)) continue;
                found = true;
            }
            if (found) continue;
            list.add(new Accumulator(here, slot));
        }
        for (Accumulator acc : list) {
            int slot;
            int delta = acc.stackCount / acc.matchingSlots.size();
            delta = Math.min(delta, 1);
            Iterator i$ = acc.matchingSlots.iterator();
            while (i$.hasNext()) {
                slot = (Integer)i$.next();
                if (acc.stackCount <= 0) break;
                inv.a((int)slot).a = delta;
                acc.stackCount -= delta;
            }
            block4: while (acc.stackCount > 0) {
                i$ = acc.matchingSlots.iterator();
                while (i$.hasNext()) {
                    slot = (Integer)i$.next();
                    if (acc.stackCount <= 0) continue block4;
                    ++inv.a((int)slot).a;
                    --acc.stackCount;
                }
            }
        }
        if (player.bL instanceof ContainerPocket) {
            ((ContainerPocket)player.bL).updateMatrix();
        }
    }

    static {
        bagShuffle.setReverse(bagShuffleReverse);
        exoModLeftClick.setReverse(exoModRightClick);
    }

    static class name {
        static HashMap map = new HashMap();

        name() {
        }
    }
}

