/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.Core;
import net.minecraftforge.common.MinecraftForge;

public enum BlockClass {
    Default(0, true, 0, 0, 1.0f),
    DarkIron(1, true, 0, 0, 4.0f),
    Barrel(2, true, 25, 0, 2.0f),
    Cage(3, false, 0, 0, 5.0f),
    Lamp(4, false, 0, 15, 6.0f),
    LightAir(5, false, 0, 15, 0.0f),
    WrathFire(6, false, 0, 4, 0.0f),
    Machine(7, true, 0, 0, 3.5f),
    MachineLightable(8, true, 0, 13, 3.5f),
    Wire(9, false, 0, 0, 0.25f),
    Ceramic(10, false, 0, 0, 1.0f);

    amq block;
    int md;
    boolean normalCube;
    int flamability;
    boolean isFlamable;
    int lightValue;
    float hardness;
    boolean normal_cube = true;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BlockClass(boolean block2, int md2, int normalCube, float flamability) {
        void hardness;
        void lightValue;
        this.block = (amq)block2;
        this.md = md2;
        this.normalCube = normalCube;
        this.flamability = (int)flamability;
        this.isFlamable = flamability > 0;
        this.lightValue = lightValue;
        this.hardness = hardness;
        if (Md.map[this.md] != null) {
            throw new RuntimeException("Duplicate BlockProperty metadata ID");
        }
        Md.map[this.md] = this;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BlockClass(int md2, int normalCube, float flamability) {
        this((String)var1_-1, (int)var2_-1, (amq)Core.registry.factory_block, md2, normalCube != 0, (int)flamability, (int)lightValue, (float)hardness);
        void hardness;
        void lightValue;
        void var2_-1;
        void var1_-1;
    }

    BlockClass setAbnormal() {
        this.normal_cube = false;
        return this;
    }

    static BlockClass get(int md2) {
        BlockClass ret = Md.map[md2];
        if (ret == null) {
            return Md.map[0];
        }
        return ret;
    }

    void enforce(Coord c) {
        if (c.getBlock() != this.block || c.setMd(this.md, false)) {
            // empty if block
        }
    }

    void enforceQuiet(Coord c) {
        if (c.getBlock() == this.block) {
            c.setMd(this.md, false);
        }
    }

    BlockClass harvest(String tool, int level) {
        MinecraftForge.setBlockHarvestLevel((amq)this.block, (int)this.md, (String)tool, (int)level);
        return this;
    }

    boolean isNormal() {
        return this.normal_cube;
    }

    static {
        Wire.setAbnormal();
        Machine.setAbnormal();
    }

    static class Md {
        static BlockClass[] map = new BlockClass[16];

        Md() {
        }
    }
}

