/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.render;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoord;
import factorization.api.VectorUV;
import factorization.common.BlockFactorization;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.RenderingCube;
import factorization.common.Texture;
import factorization.common.WireRenderingCube;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class FactorizationBlockRender
implements ICoord {
    static amq metal = amq.as;
    static amq glass = amq.bg;
    protected boolean world_mode;
    protected boolean use_vertex_offset;
    protected ym w;
    protected int x;
    protected int y;
    protected int z;
    protected int metadata;
    protected any te;
    private static FactorizationBlockRender[] renderMap = new FactorizationBlockRender[255];
    private static FactorizationBlockRender defaultRender;
    protected String cubeTexture = "/factorization/texture/blocks.png";
    private static bbb rb;
    static float[] directionLighting;
    float vertexColorResult;
    int vertexBrightnessResult;
    DeltaCoord outward = new DeltaCoord();
    DeltaCoord corner = new DeltaCoord();
    int[] mixedBrightness = new int[3];
    float[] aoLightValue = new float[3];
    boolean[] aoGrass = new boolean[3];
    float faceColor;
    boolean isDebugVertex = false;
    static boolean force_inv;
    private static int[] allFaces;

    public static void setDefaultRender(FactoryType ft) {
        assert (defaultRender != null);
        FactorizationBlockRender.renderMap[ft.md] = defaultRender;
    }

    public static FactorizationBlockRender getRenderer(int md) {
        FactorizationBlockRender ret = renderMap[md];
        if (ret == null) {
            FactorizationBlockRender.renderMap[md] = defaultRender;
            Core.logFine("No renderer for ID " + md, new Object[0]);
            return defaultRender;
        }
        return ret;
    }

    public FactorizationBlockRender() {
        if (this.getFactoryType() != null) {
            int md = this.getFactoryType().md;
            if (renderMap[md] != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            FactorizationBlockRender.renderMap[md] = this;
        } else {
            if (defaultRender != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            defaultRender = this;
        }
    }

    public FactorizationBlockRender(FactoryType ft) {
        if (ft != null) {
            int md = ft.md;
            if (renderMap[md] != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            FactorizationBlockRender.renderMap[md] = this;
        } else {
            if (defaultRender != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            defaultRender = this;
        }
    }

    abstract void render(bbb var1);

    abstract FactoryType getFactoryType();

    void renderSecondPass(bbb rb) {
    }

    @Override
    public Coord getCoord() {
        if (!this.world_mode) {
            if (this.te != null) {
                return new Coord(this.te);
            }
            return null;
        }
        return new Coord((yc)Minecraft.x().e, this.x, this.y, this.z);
    }

    public final void renderInWorld(ym w2, int wx, int wy, int wz) {
        this.world_mode = true;
        this.w = w2;
        this.x = wx;
        this.y = wy;
        this.z = wz;
        this.use_vertex_offset = true;
        this.te = null;
    }

    public final void renderInInventory() {
        this.world_mode = false;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.use_vertex_offset = true;
        this.te = null;
    }

    public final void setTileEntity(any t) {
        this.te = t;
    }

    public final void setMetadata(int md) {
        this.metadata = md;
    }

    protected void renderNormalBlock(bbb rb, int md) {
        BlockFactorization b = Core.registry.factory_rendering_block;
        rb.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (this.world_mode) {
            rb.q((amq)b, this.x, this.y, this.z);
        } else {
            Core.registry.factory_rendering_block.fake_normal_render = true;
            rb.a((amq)b, md, 1.0f);
            Core.registry.factory_rendering_block.fake_normal_render = false;
        }
    }

    protected void renderCauldron(bbb rb, int metal, int lid) {
        BlockFactorization block2 = Core.registry.factory_rendering_block;
        baz tessellator = baz.a;
        rb.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        block2.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (this.world_mode) {
            rb.q((amq)block2, this.x, this.y, this.z);
        } else {
            GL11.glPushAttrib((int)8);
            GL11.glDisable((int)2884);
            bbb renderblocks = rb;
            int texture = metal;
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.b();
            tessellator.b(0.0f, -1.0f, 0.0f);
            renderblocks.a((amq)block2, 0.0, 0.0, 0.0, texture);
            tessellator.b(0.0f, 1.0f, 0.0f);
            renderblocks.b((amq)block2, 0.0, 0.0, 0.0, lid);
            tessellator.b(0.0f, 0.0f, -1.0f);
            renderblocks.c((amq)block2, 0.0, 0.0, 0.0, texture);
            tessellator.b(0.0f, 0.0f, 1.0f);
            renderblocks.d((amq)block2, 0.0, 0.0, 0.0, texture);
            tessellator.b(-1.0f, 0.0f, 0.0f);
            renderblocks.e((amq)block2, 0.0, 0.0, 0.0, texture);
            tessellator.b(1.0f, 0.0f, 0.0f);
            renderblocks.f((amq)block2, 0.0, 0.0, 0.0, texture);
            tessellator.a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glPopAttrib();
        }
        if (this.world_mode) {
            float d = 0.125f;
            boolean origAO = rb.t;
            rb.a((double)d, (double)d, (double)d, (double)(1.0f - d), 1.0, (double)(1.0f - d));
            block2.a(d, d, d, 1.0f - d, 1.0f - d, 1.0f - d);
            rb.t = false;
            rb.e((amq)block2, (double)((float)(this.x + 1) - 2.0f * d), (double)this.y, (double)this.z, metal);
            rb.c((amq)block2, (double)this.x, (double)this.y, (double)((float)(this.z + 1) - 2.0f * d), metal);
            rb.f((amq)block2, (double)((float)(this.x - 1) + 2.0f * d), (double)this.y, (double)this.z, metal);
            rb.d((amq)block2, (double)this.x, (double)this.y, (double)((float)(this.z - 1) + 2.0f * d), metal);
            rb.b((amq)block2, (double)this.x, (double)((float)(this.y - 1) + 1.0f * d), (double)this.z, metal);
            rb.t = origAO;
            rb.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            block2.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void renderPart(bbb rb, int texture, float b1, float b2, float b3, float b4, float b5, float b6) {
        BlockFactorization block2 = Core.registry.factory_rendering_block;
        rb.a((double)b1, (double)b2, (double)b3, (double)b4, (double)b5, (double)b6);
        block2.a(b1, b2, b3, b4, b5, b6);
        if (this.world_mode) {
            Texture.force_texture = texture;
            rb.q((amq)block2, this.x, this.y, this.z);
            Texture.force_texture = -1;
        } else {
            this.renderPartInvTexture(rb, (amq)block2, texture);
        }
        rb.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        block2.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderPartInvTexture(bbb renderblocks, amq block2, int texture) {
        baz tessellator = baz.a;
        block2.f();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.b();
        tessellator.b(0.0f, -1.0f, 0.0f);
        renderblocks.a(block2, 0.0, 0.0, 0.0, texture);
        tessellator.b(0.0f, 1.0f, 0.0f);
        renderblocks.b(block2, 0.0, 0.0, 0.0, texture);
        tessellator.b(0.0f, 0.0f, -1.0f);
        renderblocks.c(block2, 0.0, 0.0, 0.0, texture);
        tessellator.b(0.0f, 0.0f, 1.0f);
        renderblocks.d(block2, 0.0, 0.0, 0.0, texture);
        tessellator.b(-1.0f, 0.0f, 0.0f);
        renderblocks.e(block2, 0.0, 0.0, 0.0, texture);
        tessellator.b(1.0f, 0.0f, 0.0f);
        renderblocks.f(block2, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private int getMixedBrightnessForBlock(ym w2, int x, int y2, int z) {
        return w2.i(x, y2, z, amq.t[w2.a(x, y2, z)]);
    }

    private int getAoBrightness(int a, int b, int c, int d) {
        return rb.a(a, b, c, d);
    }

    private float getAmbientOcclusionLightValue(ym w2, int x, int y2, int z) {
        return amq.w.j(w2, x, y2, z);
    }

    private static ForgeDirection getFaceDirection(VectorUV[] vecs, VectorUV center) {
        VectorUV here = vecs[0].add(vecs[2]);
        here.scale(0.5f);
        here = here.add(center);
        float x = Math.abs(here.x);
        float y2 = Math.abs(here.y);
        float z = Math.abs(here.z);
        if (x >= y2 && x >= z) {
            return here.x >= 0.0f ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (y2 >= x && y2 >= z) {
            return here.y >= 0.0f ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        if (z >= x && z >= y2) {
            return here.z >= 0.0f ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return ForgeDirection.UP;
    }

    private static float getNormalizedLighting(VectorUV[] vecs, VectorUV center) {
        return directionLighting[FactorizationBlockRender.getFaceDirection(vecs, center).ordinal()];
    }

    private float interpolate(float a, float b, float scale) {
        return a * scale + b * (1.0f - scale);
    }

    private void vectorAO(RenderingCube rc, VectorUV vec, ForgeDirection face) {
        this.outward.init(face.offsetX, face.offsetY, face.offsetZ);
        this.corner.init((int)vec.x, (int)vec.y, (int)vec.z);
        Coord here = this.getCoord();
        int normalAxis = -1;
        for (int i = 0; i < 3; ++i) {
            int caxis = this.corner.get(i);
            if (Math.abs(caxis) > 8) {
                here.set(i, (int)((float)here.get(i) + Math.signum(caxis)));
            }
            if (Math.abs(this.outward.get(i)) == 1) {
                this.corner.set(i, this.outward.get(i));
                normalAxis = i;
                continue;
            }
            float sig = Math.signum(caxis);
            this.corner.set(i, (int)sig);
        }
        this.calculateAO(face, this.corner, here, normalAxis);
        baz.a.c(this.vertexBrightnessResult);
        baz.a.a(this.vertexColorResult, this.vertexColorResult, this.vertexColorResult);
        this.vertex(rc, vec);
    }

    private void calculateAO(ForgeDirection face, DeltaCoord corner, Coord here, int normalAxis) {
        int array_index = 1;
        for (int i = 0; i < 3; ++i) {
            if (i == normalAxis) {
                int px2 = here.x + corner.x;
                int py = here.y + corner.y;
                int pz = here.z + corner.z;
                int ai = 0;
                this.mixedBrightness[ai] = this.getMixedBrightnessForBlock((ym)here.w, px2, py, pz);
                this.aoLightValue[ai] = this.getAmbientOcclusionLightValue((ym)here.w, px2, py, pz);
                this.aoGrass[ai] = amq.s[here.w.a(px2, py, pz)];
                continue;
            }
            int store = corner.get(i);
            corner.set(i, 0);
            int px3 = here.x + corner.x;
            int py = here.y + corner.y;
            int pz = here.z + corner.z;
            int ai = array_index++;
            this.mixedBrightness[ai] = this.getMixedBrightnessForBlock((ym)here.w, px3, py, pz);
            this.aoLightValue[ai] = this.getAmbientOcclusionLightValue((ym)here.w, px3, py, pz);
            this.aoGrass[ai] = amq.s[here.w.a(px3, py, pz)];
            corner.set(i, store);
        }
        int here_mixed = amq.w.e((ym)here.w, here.x + face.offsetX, here.y + face.offsetY, here.z + face.offsetZ);
        float hereAmbient = this.getAmbientOcclusionLightValue((ym)here.w, here.x, here.y, here.z);
        if (!this.aoGrass[1] && !this.aoGrass[2]) {
            this.mixedBrightness[0] = here_mixed;
            this.aoLightValue[0] = hereAmbient;
            this.aoLightValue[0] = 1.0f;
        }
        this.vertexBrightnessResult = this.getAoBrightness(this.mixedBrightness[0], this.mixedBrightness[1], this.mixedBrightness[2], here_mixed);
        float color = this.aoLightValue[0] + this.aoLightValue[1] + this.aoLightValue[2] + hereAmbient;
        color /= 3.0f;
        color = Math.max(color, hereAmbient);
        this.vertexColorResult = color * this.faceColor;
    }

    protected void renderCube(RenderingCube rc) {
        this.renderCube(rc, allFaces);
    }

    protected void renderCube(RenderingCube rc, int[] facesToDraw) {
        if (!this.world_mode) {
            baz.a.b();
            ForgeHooksClient.bindTexture((String)this.cubeTexture, (int)0);
            GL11.glDisable((int)2896);
        }
        force_inv = false;
        float delta = 0.00390625f;
        float zfight = rc.corner.x * delta;
        zfight *= rc.corner.y * delta;
        zfight *= rc.corner.z * delta;
        zfight = 1.0025f;
        VectorUV center = rc.trans.apply(new VectorUV(0.0f, 0.0f, 0.0f));
        if ((this.te != null || this.world_mode) && !force_inv) {
            Coord here = this.getCoord();
            if (Minecraft.u() && Core.renderAO) {
                for (int face : facesToDraw) {
                    VectorUV[] vecs = rc.faceVerts(face);
                    this.faceColor = FactorizationBlockRender.getNormalizedLighting(vecs, center);
                    for (int i = 0; i < vecs.length; ++i) {
                        this.isDebugVertex = i == 1;
                        this.vectorAO(rc, vecs[i], ForgeDirection.values()[face]);
                    }
                }
            } else {
                for (int face : facesToDraw) {
                    VectorUV[] vecs = rc.faceVerts(face);
                    float color = FactorizationBlockRender.getNormalizedLighting(vecs, center);
                    baz.a.a(color, color, color);
                    int cx = here.x;
                    int cy = here.y;
                    int cz = here.z;
                    cx = (int)((float)cx + Math.signum((vecs[0].x + vecs[2].x) / 2.0f));
                    cy = (int)((float)cy + Math.signum((vecs[0].y + vecs[2].y) / 2.0f));
                    cz = (int)((float)cz + Math.signum((vecs[0].z + vecs[2].z) / 2.0f));
                    int brightness = 0;
                    amq block2 = amq.w;
                    if (block2 != null) {
                        brightness = block2.e((ym)here.w, cx, cy, cz);
                    }
                    baz.a.c(brightness);
                    for (int i = 0; i < vecs.length; ++i) {
                        this.vertex(rc, vecs[i]);
                    }
                }
            }
        } else {
            for (int face : facesToDraw) {
                VectorUV[] vecs = rc.faceVerts(face);
                float color = FactorizationBlockRender.getNormalizedLighting(vecs, center);
                baz.a.a(color, color, color);
                for (int i = 0; i < vecs.length; ++i) {
                    this.vertex(rc, vecs[i]);
                }
            }
        }
        if (!this.world_mode) {
            baz.a.a();
            ForgeHooksClient.unbindTexture();
            GL11.glEnable((int)2896);
        }
    }

    protected void renderCube(WireRenderingCube rc) {
        if (!this.world_mode) {
            baz.a.b();
            ForgeHooksClient.bindTexture((String)this.cubeTexture, (int)0);
            GL11.glDisable((int)2896);
        }
        float delta = 0.00390625f;
        float zfight = rc.corner.x * delta;
        zfight *= rc.corner.y * delta;
        zfight *= rc.corner.z * delta;
        zfight = 1.0025f;
        for (int face = 0; face < 6; ++face) {
            VectorUV[] vecs = rc.faceVerts(face);
            float color = directionLighting[face];
            baz.a.a(color, color, color);
            for (int i = 0; i < vecs.length; ++i) {
                VectorUV vec = vecs[i];
                this.vertex(rc, vec.x * zfight, vec.y * zfight, vec.z * zfight, vec.u, vec.v);
            }
        }
        if (!this.world_mode) {
            baz.a.a();
            ForgeHooksClient.unbindTexture();
            GL11.glEnable((int)2896);
        }
    }

    protected void vertex(RenderingCube rc, VectorUV vec) {
        int u = (int)vec.u;
        int v = (int)vec.v;
        if (this.use_vertex_offset) {
            baz.a.a((double)this.x + 0.5 + (double)(vec.x / 16.0f), (double)this.y + 0.5 + (double)(vec.y / 16.0f), (double)this.z + 0.5 + (double)(vec.z / 16.0f), rc.ul + (double)((float)u / 256.0f), rc.vl + (double)((float)v / 256.0f));
        } else {
            baz.a.a(0.5 + (double)(vec.x / 16.0f), 0.5 + (double)(vec.y / 16.0f), 0.5 + (double)(vec.z / 16.0f), rc.ul + (double)((float)u / 256.0f), rc.vl + (double)((float)v / 256.0f));
        }
    }

    protected void vertex(WireRenderingCube rc, float x, float y2, float z, float u, float v) {
        u = (int)u;
        v = (int)v;
        baz.a.a((double)this.x + 0.5 + (double)(x / 16.0f), (double)this.y + 0.5 + (double)(y2 / 16.0f), (double)this.z + 0.5 + (double)(z / 16.0f), rc.ul + (double)(u / 256.0f), rc.vl + (double)(v / 256.0f));
    }

    public static void renderItemIn2D(int icon_index) {
        float var6 = ((float)(icon_index % 16 * 16) + 0.0f) / 256.0f;
        float var7 = ((float)(icon_index % 16 * 16) + 15.9999f) / 256.0f;
        float var8 = ((float)(icon_index / 16 * 16) + 0.0f) / 256.0f;
        float var9 = ((float)(icon_index / 16 * 16) + 15.9999f) / 256.0f;
        FactorizationBlockRender.renderItemIn2D_DO(baz.a, var7, var8, var6, var9);
    }

    static void renderItemIn2D_DO(baz par1Tessellator, float par2, float par3, float par4, float par5) {
        float var11;
        float var10;
        float var9;
        int var8;
        float var6 = 1.0f;
        float var7 = 0.0625f;
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 0.0f, 1.0f);
        par1Tessellator.a(0.0, 0.0, 0.0, (double)par2, (double)par5);
        par1Tessellator.a((double)var6, 0.0, 0.0, (double)par4, (double)par5);
        par1Tessellator.a((double)var6, 1.0, 0.0, (double)par4, (double)par3);
        par1Tessellator.a(0.0, 1.0, 0.0, (double)par2, (double)par3);
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 0.0f, -1.0f);
        par1Tessellator.a(0.0, 1.0, (double)(0.0f - var7), (double)par2, (double)par3);
        par1Tessellator.a((double)var6, 1.0, (double)(0.0f - var7), (double)par4, (double)par3);
        par1Tessellator.a((double)var6, 0.0, (double)(0.0f - var7), (double)par4, (double)par5);
        par1Tessellator.a(0.0, 0.0, (double)(0.0f - var7), (double)par2, (double)par5);
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(-1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
            par1Tessellator.a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, -1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
        }
        par1Tessellator.a();
    }

    void renderMotor(bbb rb, float yoffset) {
        int metal = Core.registry.lead_block_item.c();
        metal = 11;
        float d = 0.25f;
        float yd = -d + 0.003f;
        this.renderPart(rb, metal, d, d + yd + yoffset, d, 1.0f - d, 1.0f - (d + 0.0f) + yd + yoffset, 1.0f - d);
    }

    static {
        rb = new bbb();
        directionLighting = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
        force_inv = true;
        allFaces = new int[]{0, 1, 2, 3, 4, 5};
    }
}

